/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.WorkflowService;
import org.opensearch.alerting.WorkflowServiceKt;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lorg/opensearch/alerting/WorkflowService;", "", "client", "Lorg/opensearch/client/Client;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/client/Client;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getFindingDocIdsByExecutionId", "", "", "", "chainedMonitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "workflowExecutionId", "(Lorg/opensearch/commons/alerting/model/Monitor;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMonitorsById", "monitors", "size", "", "(Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseMonitors", "response", "Lorg/opensearch/action/search/SearchResponse;", "opensearch-alerting"})
public final class WorkflowService {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;

    public WorkflowService(@NotNull Client client, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object getFindingDocIdsByExecutionId(@NotNull Monitor var1_1, @NotNull String var2_2, @NotNull Continuation<? super Map<String, ? extends List<String>>> var3_3) {
        if (!(var3_3 instanceof getFindingDocIdsByExecutionId.1)) ** GOTO lbl-1000
        var18_4 = var3_3;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getFindingDocIdsByExecutionId(null, null, (Continuation<? super Map<String, ? extends List<String>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = chainedMonitor;
                $continuation.L$2 = workflowExecutionId;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient().admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<IndicesExistsResponse>, Unit>(chainedMonitor){
                    final /* synthetic */ Monitor $chainedMonitor;
                    {
                        this.$chainedMonitor = $chainedMonitor;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesExistsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String[] stringArray = new String[]{this.$chainedMonitor.getDataSources().getFindingsIndex()};
                        $this$suspendUntil.exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var19_6) goto lbl21
lbl20:
                // 1 sources

                return var19_6;
lbl21:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                workflowExecutionId = (String)$continuation.L$2;
                chainedMonitor = (Monitor)$continuation.L$1;
                this = (WorkflowService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if (!(existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return MapsKt.emptyMap();
                }
                bqb = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor_id", (String)chainedMonitor.getId())).filter((QueryBuilder)QueryBuilders.termQuery((String)"execution_id", (String)workflowExecutionId));
                var7_10 = new String[]{chainedMonitor.getDataSources().getFindingsIndex()};
                searchRequest = new SearchRequest().source(new SearchSourceBuilder().query((QueryBuilder)bqb).version(Boxing.boxBoolean((boolean)true)).seqNoAndPrimaryTerm(Boxing.boxBoolean((boolean)true))).indices(var7_10);
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this, searchRequest){
                    final /* synthetic */ WorkflowService this$0;
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.this$0 = $receiver;
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.this$0.getClient().search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var19_6) goto lbl42
lbl41:
                // 1 sources

                return var19_6;
lbl42:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                this = (WorkflowService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    searchResponse = (SearchResponse)v1;
                    findings = new ArrayList<E>();
                    for (SearchHit hit : searchResponse.getHits()) {
                        xcp = XContentFactory.xContent((MediaType)((MediaType)XContentType.JSON)).createParser(this.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                        finding = Finding.Companion.parse(xcp);
                        findings.add(finding);
                    }
                    indexToRelatedDocIdsMap = new LinkedHashMap<K, V>();
                    for (Finding finding : findings) {
                        finding = indexToRelatedDocIdsMap;
                        key$iv = finding.getIndex();
                        $i$f$getOrPut = false;
                        value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            $i$a$-getOrPut-WorkflowService$getFindingDocIdsByExecutionId$2 = false;
                            answer$iv = new ArrayList<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            v2 /* !! */  = answer$iv;
                        } else {
                            v2 /* !! */  = value$iv;
                        }
                        ((List)v2 /* !! */ ).addAll(finding.getRelatedDocIds());
                    }
                    return indexToRelatedDocIdsMap;
                }
                catch (Exception t) {
                    WorkflowServiceKt.access$getLog$p().error("Error getting finding doc ids: " + t.getMessage(), (Throwable)t);
                    throw AlertingException.Companion.wrap(t);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getMonitorsById(@NotNull List<String> var1_1, int var2_2, @NotNull Continuation<? super List<Monitor>> var3_3) {
        if (!(var3_3 instanceof getMonitorsById.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ WorkflowService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getMonitorsById(null, 0, (Continuation<? super List<Monitor>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bqb = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)((Collection)monitors)));
                var6_9 = new String[]{".opendistro-alerting-config"};
                searchRequest = new SearchRequest().source(new SearchSourceBuilder().query((QueryBuilder)bqb).version(Boxing.boxBoolean((boolean)true)).seqNoAndPrimaryTerm(Boxing.boxBoolean((boolean)true)).size((int)size)).indices(var6_9);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.getClient()), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this, searchRequest){
                    final /* synthetic */ WorkflowService this$0;
                    final /* synthetic */ SearchRequest $searchRequest;
                    {
                        this.this$0 = $receiver;
                        this.$searchRequest = $searchRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.this$0.getClient().search(this.$searchRequest, it);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var9_6) goto lbl22
lbl21:
                // 1 sources

                return var9_6;
lbl22:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                this = (WorkflowService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    searchResponse = (SearchResponse)v0;
                    return this.parseMonitors(searchResponse);
                }
                catch (Exception e) {
                    WorkflowServiceKt.access$getLog$p().error("Error getting monitors: " + e.getMessage(), (Throwable)e);
                    throw AlertingException.Companion.wrap(e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Monitor> parseMonitors(SearchResponse response2) {
        if (response2.isTimedOut()) {
            WorkflowServiceKt.access$getLog$p().error("Request for getting monitors timeout");
            throw new OpenSearchException("Cannot determine that the .opendistro-alerting-config index is healthy", new Object[0]);
        }
        List monitors = new ArrayList();
        try {
            for (SearchHit hit : response2.getHits()) {
                Closeable closeable = (Closeable)XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                Throwable throwable = null;
                try {
                    XContentParser hitsParser = (XContentParser)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)hitsParser, (String)"hitsParser");
                    String string = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hit.id");
                    Monitor monitor = (Monitor)ScheduledJob.Companion.parse(hitsParser, string, hit.getVersion());
                    boolean bl2 = monitors.add(monitor);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        catch (Exception e) {
            WorkflowServiceKt.access$getLog$p().error("Error parsing monitors: " + e.getMessage(), (Throwable)e);
            throw AlertingException.Companion.wrap(e);
        }
        return monitors;
    }
}

