/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestAcknowledgeChainedAlertsActionKt;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.action.AcknowledgeChainedAlertRequest;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/resthandler/RestAcknowledgeChainedAlertAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getAlertIds", "", "", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "getName", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestAcknowledgeChainedAlertAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "acknowledge_chained_alert_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}/_acknowledge/alerts")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestAcknowledgeChainedAlertsActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}/_acknowledge/alerts");
        String workflowId = request.param("workflowID");
        CharSequence charSequence = workflowId;
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean $i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32 = false;
            String $i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32 = "Missing workflow id.";
            throw new IllegalArgumentException($i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32.toString());
        }
        XContentParser $i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32 = request.contentParser();
        Intrinsics.checkNotNullExpressionValue((Object)$i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32, (String)"request.contentParser()");
        List<String> alertIds = this.getAlertIds($i$a$-require-RestAcknowledgeChainedAlertAction$prepareRequest$32);
        if (!(!((Collection)alertIds).isEmpty())) {
            boolean bl = false;
            String string = "You must provide at least one alert id.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)workflowId, (String)"workflowId");
        AcknowledgeChainedAlertRequest acknowledgeAlertRequest = new AcknowledgeChainedAlertRequest(workflowId, alertIds);
        return arg_0 -> RestAcknowledgeChainedAlertAction.prepareRequest$lambda-2(client, acknowledgeAlertRequest, arg_0);
    }

    private final List<String> getAlertIds(XContentParser xcp) {
        List ids = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!Intrinsics.areEqual((Object)fieldName, (Object)"alerts")) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                String string = xcp.text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.text()");
                ids.add(string);
            }
        }
        return ids;
    }

    private static final void prepareRequest$lambda-2(NodeClient $client, AcknowledgeChainedAlertRequest $acknowledgeAlertRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$acknowledgeAlertRequest, (String)"$acknowledgeAlertRequest");
        $client.execute(AlertingActions.ACKNOWLEDGE_CHAINED_ALERTS_ACTION_TYPE, (ActionRequest)$acknowledgeAlertRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

