/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.resthandler;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsAction;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsRequest;
import org.opensearch.alerting.core.resthandler.RestScheduledJobStatsHandler;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/alerting/core/resthandler/RestScheduledJobStatsHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "path", "", "(Ljava/lang/String;)V", "getName", "getRequest", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "request", "Lorg/opensearch/rest/RestRequest;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "alerting-core"})
public final class RestScheduledJobStatsHandler
extends BaseRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @NotNull
    public static final String JOB_SCHEDULING_METRICS = "job_scheduling_metrics";
    @NotNull
    public static final String JOBS_INFO = "jobs_info";
    @NotNull
    private static final Map<String, Function1<ScheduledJobsStatsRequest, Unit>> METRICS;

    public RestScheduledJobStatsHandler(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public String getName() {
        return this.path + "_jobs_stats";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/{nodeId}/stats/", RestRequest.Method.GET, "/_opendistro/" + this.path + "/{nodeId}/stats/"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/{nodeId}/stats/{metric}", RestRequest.Method.GET, "/_opendistro/" + this.path + "/{nodeId}/stats/{metric}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/stats/", RestRequest.Method.GET, "/_opendistro/" + this.path + "/stats/"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/stats/{metric}", RestRequest.Method.GET, "/_opendistro/" + this.path + "/stats/{metric}")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ScheduledJobsStatsRequest scheduledJobNodesStatsRequest = this.getRequest(request);
        return arg_0 -> RestScheduledJobStatsHandler.prepareRequest$lambda-0(client, scheduledJobNodesStatsRequest, arg_0);
    }

    private final ScheduledJobsStatsRequest getRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        Set metrics = Strings.tokenizeByCommaToSet((String)request.param("metric"));
        Intrinsics.checkNotNullExpressionValue((Object)nodesIds, (String)"nodesIds");
        ScheduledJobsStatsRequest scheduledJobsStatsRequest = new ScheduledJobsStatsRequest(nodesIds);
        scheduledJobsStatsRequest.timeout(request.param("timeout"));
        if (metrics.isEmpty()) {
            return scheduledJobsStatsRequest;
        }
        if (metrics.size() == 1 && metrics.contains("_all")) {
            scheduledJobsStatsRequest.all();
        } else {
            if (metrics.contains("_all")) {
                Locale locale = Locale.ROOT;
                String string = "request [%s] contains _all and individual metrics [%s]";
                Object[] objectArray = new Object[]{request.path(), request.param("metric")};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                throw new IllegalArgumentException(string2);
            }
            scheduledJobsStatsRequest.clear();
            TreeSet<String> invalidMetrics = new TreeSet<String>();
            for (String metric : metrics) {
                Function1<ScheduledJobsStatsRequest, Unit> handler = METRICS.get(metric);
                if (handler != null) {
                    handler.invoke((Object)scheduledJobsStatsRequest);
                    continue;
                }
                invalidMetrics.add(metric);
            }
            if (!invalidMetrics.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidMetrics, METRICS.keySet(), "metric"));
            }
        }
        return scheduledJobsStatsRequest;
    }

    private static final void prepareRequest$lambda-0(NodeClient $client, ScheduledJobsStatsRequest $scheduledJobNodesStatsRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$scheduledJobNodesStatsRequest), (String)"$scheduledJobNodesStatsRequest");
        $client.execute((ActionType)ScheduledJobsStatsAction.Companion.getINSTANCE(), (ActionRequest)$scheduledJobNodesStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JOB_SCHEDULING_METRICS, (Object)((Object)Companion.METRICS.1.INSTANCE)), TuplesKt.to((Object)JOBS_INFO, (Object)((Object)Companion.METRICS.2.INSTANCE))};
        METRICS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/core/resthandler/RestScheduledJobStatsHandler$Companion;", "", "()V", "JOBS_INFO", "", "JOB_SCHEDULING_METRICS", "METRICS", "", "Lkotlin/Function1;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

