/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.transport.AnomalyDetectorJobAction;
import org.opensearch.ad.transport.AnomalyDetectorJobRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestAnomalyDetectorJobAction
extends BaseRestHandler {
    public static final String AD_JOB_ACTION = "anomaly_detector_job_action";
    private volatile TimeValue requestTimeout;

    public RestAnomalyDetectorJobAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)AnomalyDetectorSettings.REQUEST_TIMEOUT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
    }

    public String getName() {
        return AD_JOB_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!EnabledSetting.isADPluginEnabled()) {
            throw new IllegalStateException("AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String detectorId = request.param("detectorID");
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        boolean historical = request.paramAsBoolean("historical", false);
        String rawPath = request.rawPath();
        DetectionDateRange detectionDateRange = this.parseDetectionDateRange(request);
        AnomalyDetectorJobRequest anomalyDetectorJobRequest = new AnomalyDetectorJobRequest(detectorId, detectionDateRange, historical, seqNo, primaryTerm, rawPath);
        return channel -> client.execute((ActionType)AnomalyDetectorJobAction.INSTANCE, (ActionRequest)anomalyDetectorJobRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private DetectionDateRange parseDetectionDateRange(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            return null;
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        DetectionDateRange dateRange = DetectionDateRange.parse(parser);
        return dateRange;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_start"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_start")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_stop"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_stop")));
    }
}

