/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.common.exception.ADValidationException;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectorValidationIssue;
import org.opensearch.ad.model.ValidationAspect;
import org.opensearch.ad.rest.AbstractAnomalyDetectorAction;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorRequest;
import org.opensearch.ad.transport.ValidateAnomalyDetectorResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestToXContentListener;

public class RestValidateAnomalyDetectorAction
extends AbstractAnomalyDetectorAction {
    private static final String VALIDATE_ANOMALY_DETECTOR_ACTION = "validate_anomaly_detector_action";
    public static final Set<String> ALL_VALIDATION_ASPECTS_STRS = Arrays.asList(ValidationAspect.values()).stream().map(aspect -> aspect.getName()).collect(Collectors.toSet());

    public RestValidateAnomalyDetectorAction(Settings settings, ClusterService clusterService) {
        super(settings, clusterService);
    }

    public String getName() {
        return VALIDATE_ANOMALY_DETECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s", "/_plugins/_anomaly_detection/detectors", "_validate")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "_validate", "type")));
    }

    protected void sendAnomalyDetectorValidationParseResponse(DetectorValidationIssue issue, RestChannel channel) throws IOException {
        try {
            BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, new ValidateAnomalyDetectorResponse(issue).toXContent(channel.newBuilder()));
            channel.sendResponse((RestResponse)restResponse);
        }
        catch (Exception e) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }

    private Boolean validationTypesAreAccepted(String validationType) {
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(validationType.split(",")));
        return !Collections.disjoint(typesInRequest, ALL_VALIDATION_ASPECTS_STRS);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!EnabledSetting.isADPluginEnabled()) {
            throw new IllegalStateException("AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String typesStr = request.param("type");
        if (!StringUtils.isBlank((CharSequence)typesStr) && !this.validationTypesAreAccepted(typesStr).booleanValue()) {
            throw new IllegalStateException("The given validation type doesn't exist");
        }
        return channel -> {
            AnomalyDetector detector;
            try {
                detector = AnomalyDetector.parse(parser);
            }
            catch (Exception ex) {
                if (ex instanceof ADValidationException) {
                    ADValidationException ADException = (ADValidationException)ex;
                    DetectorValidationIssue issue = new DetectorValidationIssue(ADException.getAspect(), ADException.getType(), ADException.getMessage());
                    this.sendAnomalyDetectorValidationParseResponse(issue, (RestChannel)channel);
                    return;
                }
                throw ex;
            }
            ValidateAnomalyDetectorRequest validateAnomalyDetectorRequest = new ValidateAnomalyDetectorRequest(detector, typesStr, this.maxSingleEntityDetectors, this.maxMultiEntityDetectors, this.maxAnomalyFeatures, this.requestTimeout);
            client.execute((ActionType)ValidateAnomalyDetectorAction.INSTANCE, (ActionRequest)validateAnomalyDetectorRequest, (ActionListener)new RestToXContentListener(channel));
        };
    }
}

