/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.ad.cluster.ADVersionUtil;
import org.opensearch.ad.model.ADTaskProfile;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class ADTaskProfileNodeResponse
extends BaseNodeResponse {
    private static final Logger logger = LogManager.getLogger(ADTaskProfileNodeResponse.class);
    private ADTaskProfile adTaskProfile;
    private Version remoteAdVersion;

    public ADTaskProfileNodeResponse(DiscoveryNode node, ADTaskProfile adTaskProfile, Version remoteAdVersion) {
        super(node);
        this.adTaskProfile = adTaskProfile;
        this.remoteAdVersion = remoteAdVersion;
    }

    public ADTaskProfileNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.adTaskProfile = in.readBoolean() ? new ADTaskProfile(in) : null;
    }

    public ADTaskProfile getAdTaskProfile() {
        return this.adTaskProfile;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.adTaskProfile != null && (ADVersionUtil.compatibleWithVersionOnOrAfter1_1(this.remoteAdVersion) || this.adTaskProfile.getNodeId() != null)) {
            out.writeBoolean(true);
            this.adTaskProfile.writeTo(out, this.remoteAdVersion);
        } else {
            out.writeBoolean(false);
        }
    }

    public static ADTaskProfileNodeResponse readNodeResponse(StreamInput in) throws IOException {
        return new ADTaskProfileNodeResponse(in);
    }
}

