/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.caching.CacheProvider;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.model.DetectorProfileName;
import org.opensearch.ad.model.ModelProfile;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.ProfileAction;
import org.opensearch.ad.transport.ProfileNodeRequest;
import org.opensearch.ad.transport.ProfileNodeResponse;
import org.opensearch.ad.transport.ProfileRequest;
import org.opensearch.ad.transport.ProfileResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class ProfileTransportAction
extends TransportNodesAction<ProfileRequest, ProfileResponse, ProfileNodeRequest, ProfileNodeResponse> {
    private static final Logger LOG = LogManager.getLogger(ProfileTransportAction.class);
    private ModelManager modelManager;
    private FeatureManager featureManager;
    private CacheProvider cacheProvider;
    private volatile int numModelsToReturn;

    @Inject
    public ProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ModelManager modelManager, FeatureManager featureManager, CacheProvider cacheProvider, Settings settings) {
        super(ProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, ProfileRequest::new, ProfileNodeRequest::new, "management", ProfileNodeResponse.class);
        this.modelManager = modelManager;
        this.featureManager = featureManager;
        this.cacheProvider = cacheProvider;
        this.numModelsToReturn = (Integer)AnomalyDetectorSettings.MAX_MODEL_SIZE_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_MODEL_SIZE_PER_NODE, it -> {
            this.numModelsToReturn = it;
        });
    }

    protected ProfileResponse newResponse(ProfileRequest request, List<ProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new ProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ProfileNodeRequest newNodeRequest(ProfileRequest request) {
        return new ProfileNodeRequest(request);
    }

    protected ProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ProfileNodeResponse(in);
    }

    protected ProfileNodeResponse nodeOperation(ProfileNodeRequest request) {
        String detectorId = request.getDetectorId();
        Set<DetectorProfileName> profiles = request.getProfilesToBeRetrieved();
        int shingleSize = -1;
        long activeEntity = 0L;
        long totalUpdates = 0L;
        Map<String, Long> modelSize = null;
        List<ModelProfile> modelProfiles = null;
        int modelCount = 0;
        if (request.isForMultiEntityDetector()) {
            int limit;
            if (profiles.contains(DetectorProfileName.ACTIVE_ENTITIES)) {
                activeEntity = this.cacheProvider.get().getActiveEntities(detectorId);
            }
            if (profiles.contains(DetectorProfileName.INIT_PROGRESS)) {
                totalUpdates = this.cacheProvider.get().getTotalUpdates(detectorId);
            }
            if (profiles.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES)) {
                modelSize = this.cacheProvider.get().getModelSize(detectorId);
            }
            if (profiles.contains(DetectorProfileName.MODELS) && (limit = Math.min(this.numModelsToReturn, modelCount = (modelProfiles = this.cacheProvider.get().getAllModelProfile(detectorId)).size())) != modelCount) {
                LOG.info("model number limit reached");
                modelProfiles = modelProfiles.subList(0, limit);
            }
        } else {
            if (profiles.contains(DetectorProfileName.COORDINATING_NODE) || profiles.contains(DetectorProfileName.SHINGLE_SIZE)) {
                shingleSize = this.featureManager.getShingleSize(detectorId);
            }
            if (profiles.contains(DetectorProfileName.TOTAL_SIZE_IN_BYTES) || profiles.contains(DetectorProfileName.MODELS)) {
                modelSize = this.modelManager.getModelSize(detectorId);
            }
        }
        return new ProfileNodeResponse(this.clusterService.localNode(), modelSize, shingleSize, activeEntity, totalUpdates, modelProfiles, modelCount);
    }
}

