/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.autofollow;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.ValidationException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.replication.action.autofollow.UpdateAutoFollowPatternRequest;
import org.opensearch.replication.action.index.ReplicateIndexRequest;
import org.opensearch.replication.util.ValidationUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u000223B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0003B1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR:\u0010 \u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010!j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00064"}, d2={"Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest;", "Lorg/opensearch/action/support/master/AcknowledgedRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "()V", "connection", "", "patternName", "pattern", "action", "Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Action;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Action;Lorg/opensearch/common/settings/Settings;)V", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "getAction", "()Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Action;", "setAction", "(Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Action;)V", "getConnection", "()Ljava/lang/String;", "setConnection", "(Ljava/lang/String;)V", "getPattern", "setPattern", "getPatternName", "setPatternName", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "setSettings", "(Lorg/opensearch/common/settings/Settings;)V", "useRoles", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getUseRoles", "()Ljava/util/HashMap;", "setUseRoles", "(Ljava/util/HashMap;)V", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Action", "Companion", "opensearch-cross-cluster-replication"})
public final class UpdateAutoFollowPatternRequest
extends AcknowledgedRequest<UpdateAutoFollowPatternRequest>
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public String connection;
    public String patternName;
    @Nullable
    private String pattern;
    @Nullable
    private HashMap<String, String> useRoles;
    @NotNull
    private Settings settings;
    public Action action;
    @NotNull
    private static final ObjectParser<UpdateAutoFollowPatternRequest, Void> AUTOFOLLOW_REQ_PARSER = new ObjectParser("AutoFollowRequestParser", UpdateAutoFollowPatternRequest::AUTOFOLLOW_REQ_PARSER$lambda-0);

    @NotNull
    public final String getConnection() {
        String string = this.connection;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
        return null;
    }

    public final void setConnection(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.connection = string;
    }

    @NotNull
    public final String getPatternName() {
        String string = this.patternName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"patternName");
        return null;
    }

    public final void setPatternName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.patternName = string;
    }

    @Nullable
    public final String getPattern() {
        return this.pattern;
    }

    public final void setPattern(@Nullable String string) {
        this.pattern = string;
    }

    @Nullable
    public final HashMap<String, String> getUseRoles() {
        return this.useRoles;
    }

    public final void setUseRoles(@Nullable HashMap<String, String> hashMap) {
        this.useRoles = hashMap;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.settings = settings;
    }

    @NotNull
    public final Action getAction() {
        Action action = this.action;
        if (action != null) {
            return action;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"action");
        return null;
    }

    public final void setAction(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"<set-?>");
        this.action = action;
    }

    private UpdateAutoFollowPatternRequest() {
        Settings settings = Settings.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"EMPTY");
        this.settings = settings;
    }

    public UpdateAutoFollowPatternRequest(@NotNull String connection, @NotNull String patternName, @Nullable String pattern, @NotNull Action action, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)patternName, (String)"patternName");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Settings settings2 = Settings.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"EMPTY");
        this.settings = settings2;
        this.setConnection(connection);
        this.setPatternName(patternName);
        this.pattern = pattern;
        this.setAction(action);
        this.settings = settings;
    }

    public UpdateAutoFollowPatternRequest(@NotNull StreamInput inp) {
        String string;
        Map map;
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        Object object = Settings.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EMPTY");
        this.settings = object;
        object = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inp.readString()");
        this.setConnection((String)object);
        object = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inp.readString()");
        this.setPatternName((String)object);
        this.pattern = inp.readOptionalString();
        object = inp.readEnum(Action.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inp.readEnum(Action::class.java)");
        this.setAction((Action)((Object)object));
        String leaderClusterRole = inp.readOptionalString();
        String followerClusterRole = inp.readOptionalString();
        this.useRoles = new HashMap();
        if (leaderClusterRole != null) {
            HashMap<String, String> hashMap = this.useRoles;
            Intrinsics.checkNotNull(hashMap);
            map = hashMap;
            string = "leader_cluster_role";
            map.put(string, leaderClusterRole);
        }
        if (followerClusterRole != null) {
            HashMap<String, String> hashMap = this.useRoles;
            Intrinsics.checkNotNull(hashMap);
            map = hashMap;
            string = "follower_cluster_role";
            map.put(string, followerClusterRole);
        }
        map = Settings.readSettingsFromStream((StreamInput)inp);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"readSettingsFromStream(inp)");
        this.settings = map;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        block10: {
            block11: {
                validationException = new ActionRequestValidationException();
                if (this.connection == null || this.patternName == null) {
                    validationException.addValidationError("Missing connection or name in the request");
                }
                ValidationUtil.INSTANCE.validateName(this.getPatternName(), (ValidationException)validationException);
                if (this.useRoles == null) break block10;
                HashMap<String, String> hashMap = this.useRoles;
                Intrinsics.checkNotNull(hashMap);
                if (hashMap.size() < 2) break block11;
                HashMap<String, String> hashMap2 = this.useRoles;
                Intrinsics.checkNotNull(hashMap2);
                if (hashMap2.get("leader_cluster_role") == null) break block11;
                HashMap<String, String> hashMap3 = this.useRoles;
                Intrinsics.checkNotNull(hashMap3);
                if (hashMap3.get("follower_cluster_role") != null) break block10;
            }
            validationException.addValidationError("Need roles for leader_cluster_role and follower_cluster_role");
        }
        if (this.getAction() == Action.REMOVE) {
            if (this.pattern != null) {
                validationException.addValidationError("Unexpected pattern");
            }
        } else if (this.pattern == null) {
            validationException.addValidationError("Missing pattern");
        }
        if (validationException.validationErrors().isEmpty()) {
            return null;
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeString(this.getConnection());
        out.writeString(this.getPatternName());
        out.writeOptionalString(this.pattern);
        out.writeEnum((Enum)this.getAction());
        HashMap<String, String> hashMap = this.useRoles;
        out.writeOptionalString(hashMap == null ? null : hashMap.get("leader_cluster_role"));
        HashMap<String, String> hashMap2 = this.useRoles;
        out.writeOptionalString(hashMap2 == null ? null : hashMap2.get("follower_cluster_role"));
        Settings.writeSettingsToStream((Settings)this.settings, (StreamOutput)out);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        builder.field("leader_alias", this.getConnection());
        builder.field("pattern_name", this.getPatternName());
        builder.field("pattern", this.pattern);
        builder.field("action", this.getAction().name());
        if (this.useRoles != null) {
            builder.field("use_roles");
            builder.startObject();
            HashMap<String, String> hashMap = this.useRoles;
            Intrinsics.checkNotNull(hashMap);
            builder.field("leader_cluster_role", hashMap.get("leader_cluster_role"));
            HashMap<String, String> hashMap2 = this.useRoles;
            Intrinsics.checkNotNull(hashMap2);
            builder.field("follower_cluster_role", hashMap2.get("follower_cluster_role"));
            builder.endObject();
        }
        builder.startObject("settings");
        this.settings.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
        builder.endObject();
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endObject()");
        return xContentBuilder;
    }

    private static final UpdateAutoFollowPatternRequest AUTOFOLLOW_REQ_PARSER$lambda-0() {
        return new UpdateAutoFollowPatternRequest();
    }

    private static final void _init_$lambda-1(UpdateAutoFollowPatternRequest reqParser, HashMap roles) {
        Intrinsics.checkNotNullParameter((Object)((Object)reqParser), (String)"reqParser");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        reqParser.useRoles = roles;
    }

    private static final void _init_$lambda-2(UpdateAutoFollowPatternRequest request, Settings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        request.settings = settings;
    }

    private static final Settings _init_$lambda-3(XContentParser p, Void $noName_1) {
        return Settings.fromXContent((XContentParser)p);
    }

    static {
        AUTOFOLLOW_REQ_PARSER.declareString((arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)Companion.2.INSTANCE)).set(arg_0, arg_1), new ParseField("leader_alias", new String[0]));
        AUTOFOLLOW_REQ_PARSER.declareString((arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)Companion.4.INSTANCE)).set(arg_0, arg_1), new ParseField("name", new String[0]));
        AUTOFOLLOW_REQ_PARSER.declareString((arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)Companion.6.INSTANCE)).set(arg_0, arg_1), new ParseField("pattern", new String[0]));
        AUTOFOLLOW_REQ_PARSER.declareObjectOrDefault(UpdateAutoFollowPatternRequest::_init_$lambda-1, (BiFunction)ReplicateIndexRequest.Companion.getFGAC_ROLES_PARSER(), null, new ParseField("use_roles", new String[0]));
        AUTOFOLLOW_REQ_PARSER.declareObjectOrDefault(UpdateAutoFollowPatternRequest::_init_$lambda-2, UpdateAutoFollowPatternRequest::_init_$lambda-3, null, new ParseField("settings", new String[0]));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Action;", "", "(Ljava/lang/String;I)V", "ADD", "REMOVE", "opensearch-cross-cluster-replication"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action ADD = new Action();
        public static final /* enum */ Action REMOVE = new Action();
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            $VALUES = actionArray = new Action[]{Action.ADD, Action.REMOVE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Companion;", "", "()V", "AUTOFOLLOW_REQ_PARSER", "Lorg/opensearch/core/xcontent/ObjectParser;", "Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest;", "Ljava/lang/Void;", "fromXContent", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "action", "Lorg/opensearch/replication/action/autofollow/UpdateAutoFollowPatternRequest$Action;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UpdateAutoFollowPatternRequest fromXContent(@NotNull XContentParser xcp, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            UpdateAutoFollowPatternRequest updateAutofollowReq = (UpdateAutoFollowPatternRequest)((Object)AUTOFOLLOW_REQ_PARSER.parse(xcp, null));
            updateAutofollowReq.setAction(action);
            HashMap<String, String> hashMap = updateAutofollowReq.getUseRoles();
            if (hashMap == null ? false : hashMap.size() == 0) {
                updateAutofollowReq.setUseRoles(null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)updateAutofollowReq), (String)"updateAutofollowReq");
            return updateAutofollowReq;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

