/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.seqno;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.seqno.RetentionLeaseActions;
import org.opensearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.opensearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.opensearch.index.seqno.RetentionLeaseNotFoundException;
import org.opensearch.index.shard.ShardId;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.seqno.RemoteClusterRetentionLeaseHelper;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016J)\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u001e\u0010%\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016J!\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J)\u0010,\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J&\u0010,\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016J!\u0010.\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lorg/opensearch/replication/seqno/RemoteClusterRetentionLeaseHelper;", "", "followerClusterName", "", "followerClusterUUID", "client", "Lorg/opensearch/client/Client;", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/client/Client;)V", "followerClusterNameWithUUID", "(Ljava/lang/String;Lorg/opensearch/client/Client;)V", "getClient", "()Lorg/opensearch/client/Client;", "getFollowerClusterNameWithUUID", "()Ljava/lang/String;", "setFollowerClusterNameWithUUID", "(Ljava/lang/String;)V", "retentionLeaseSource", "addNewRetentionLease", "", "leaderShardId", "Lorg/opensearch/index/shard/ShardId;", "seqNo", "", "followerShardId", "timeout", "(Lorg/opensearch/index/shard/ShardId;JLorg/opensearch/index/shard/ShardId;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addNewRetentionLeaseIfOldExists", "(Lorg/opensearch/index/shard/ShardId;Lorg/opensearch/index/shard/ShardId;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addRetentionLease", "", "attemptRemoveRetentionLease", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "replMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "followerIndexName", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/replication/metadata/store/ReplicationMetadata;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptRetentionLeaseRemoval", "(Lorg/opensearch/index/shard/ShardId;Lorg/opensearch/index/shard/ShardId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLeaderIndexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "leaderAlias", "leaderIndex", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renewRetentionLease", "(Lorg/opensearch/index/shard/ShardId;JLorg/opensearch/index/shard/ShardId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyRetentionLeaseExist", "Companion", "opensearch-cross-cluster-replication"})
public final class RemoteClusterRetentionLeaseHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String followerClusterNameWithUUID;
    @NotNull
    private final Client client;
    @NotNull
    private final String retentionLeaseSource;
    @NotNull
    private String followerClusterUUID;
    @NotNull
    private String followerClusterName;
    private static final Logger log = LogManager.getLogger(RemoteClusterRetentionLeaseHelper.class);
    @NotNull
    public static final String RETENTION_LEASE_PREFIX = "replication:";

    public RemoteClusterRetentionLeaseHelper(@NotNull String followerClusterNameWithUUID, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)followerClusterNameWithUUID, (String)"followerClusterNameWithUUID");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.followerClusterNameWithUUID = followerClusterNameWithUUID;
        this.client = client;
        this.retentionLeaseSource = Companion.retentionLeaseSource(this.followerClusterNameWithUUID);
        this.followerClusterUUID = "";
        this.followerClusterName = "";
    }

    @NotNull
    public final String getFollowerClusterNameWithUUID() {
        return this.followerClusterNameWithUUID;
    }

    public final void setFollowerClusterNameWithUUID(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.followerClusterNameWithUUID = string;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public RemoteClusterRetentionLeaseHelper(@NotNull String followerClusterName, @NotNull String followerClusterUUID, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
        Intrinsics.checkNotNullParameter((Object)followerClusterUUID, (String)"followerClusterUUID");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this(followerClusterName, client);
        this.followerClusterUUID = followerClusterUUID;
        this.followerClusterName = followerClusterName;
        this.followerClusterNameWithUUID = Companion.getFollowerClusterNameWithUUID(followerClusterName, followerClusterUUID);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object verifyRetentionLeaseExist(@NotNull ShardId var1_1, @NotNull ShardId var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        block14: {
            if (!(var3_3 instanceof verifyRetentionLeaseExist.1)) ** GOTO lbl-1000
            var8_4 = var3_3;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.verifyRetentionLeaseExist(null, null, (Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), followerShardId);
                    request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, -1L, this.retentionLeaseSource);
                    v0 = (OpenSearchClient)this.getClient();
                    var6_9 = RetentionLeaseActions.Renew.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"INSTANCE");
                    $continuation.L$0 = this;
                    $continuation.L$1 = leaderShardId;
                    $continuation.L$2 = followerShardId;
                    $continuation.label = 1;
                    v1 = CoroutinesKt.suspendExecute$default(v0, (ActionType)var6_9, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                    ** if (v1 != var9_6) goto lbl26
lbl25:
                    // 1 sources

                    return var9_6;
lbl26:
                    // 1 sources

                    break block14;
                }
                case 1: {
                    followerShardId = (ShardId)$continuation.L$2;
                    leaderShardId = (ShardId)$continuation.L$1;
                    this = (RemoteClusterRetentionLeaseHelper)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                    }
                    catch (RetentionLeaseInvalidRetainingSeqNoException var6_10) {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    catch (RetentionLeaseNotFoundException var6_11) {
                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.label = 2;
                        v2 = this.addNewRetentionLeaseIfOldExists(leaderShardId, followerShardId, -1L, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var9_6) {
                            return var9_6;
                        }
                        ** GOTO lbl50
                    }
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl50:
                    // 2 sources

                    return v2;
                }
            }
            catch (Exception var6_12) {
                return Boxing.boxBoolean((boolean)false);
            }
        }
        return Boxing.boxBoolean((boolean)true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object addNewRetentionLeaseIfOldExists(ShardId var1_1, ShardId var2_2, long var3_3, Continuation<? super Boolean> var5_4) {
        block15: {
            if (!(var5_4 instanceof addNewRetentionLeaseIfOldExists.1)) ** GOTO lbl-1000
            var10_5 = var5_4;
            if ((var10_5.label & -2147483648) != 0) {
                var10_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return RemoteClusterRetentionLeaseHelper.access$addNewRetentionLeaseIfOldExists(this.this$0, null, null, 0L, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    oldRetentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterName, followerShardId);
                    requestForOldId = new RetentionLeaseActions.RenewRequest(leaderShardId, oldRetentionLeaseId, -1L, this.retentionLeaseSource);
                    v0 = (OpenSearchClient)this.getClient();
                    var8_10 = RetentionLeaseActions.Renew.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)var8_10, (String)"INSTANCE");
                    $continuation.L$0 = this;
                    $continuation.L$1 = leaderShardId;
                    $continuation.L$2 = followerShardId;
                    $continuation.L$3 = oldRetentionLeaseId;
                    $continuation.J$0 = seqNo;
                    $continuation.label = 1;
                    v1 = CoroutinesKt.suspendExecute$default(v0, (ActionType)var8_10, (ActionRequest)requestForOldId, false, false, (Continuation)$continuation, 12, null);
                    ** if (v1 != var11_7) goto lbl28
lbl27:
                    // 1 sources

                    return var11_7;
lbl28:
                    // 1 sources

                    break block15;
                }
                case 1: {
                    seqNo = $continuation.J$0;
                    oldRetentionLeaseId = (String)$continuation.L$3;
                    followerShardId = (ShardId)$continuation.L$2;
                    leaderShardId = (ShardId)$continuation.L$1;
                    this = (RemoteClusterRetentionLeaseHelper)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                    }
                    catch (RetentionLeaseInvalidRetainingSeqNoException var8_11) {
                        RemoteClusterRetentionLeaseHelper.log.info("Old retention lease Id " + oldRetentionLeaseId + " present with invalid seq number, adding new retention lease with ID:" + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), followerShardId) + ' ');
                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.label = 2;
                        v2 = this.addNewRetentionLease(leaderShardId, seqNo, followerShardId, 60000L, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var11_7) {
                            return var11_7;
                        }
                        ** GOTO lbl54
                    }
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl54:
                    // 2 sources

                    return v2;
                }
            }
            catch (Exception ex) {
                RemoteClusterRetentionLeaseHelper.log.info(Intrinsics.stringPlus((String)"Encountered Exception while checking for old retention lease: ", (Object)ExtensionsKt.stackTraceToString(ex)));
                return Boxing.boxBoolean((boolean)false);
            }
        }
        RemoteClusterRetentionLeaseHelper.log.info("Old retention lease Id " + oldRetentionLeaseId + ", adding new retention lease with ID:" + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), followerShardId) + ' ');
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.label = 3;
        v3 = this.addNewRetentionLease(leaderShardId, seqNo, followerShardId, 60000L, (Continuation<? super Boolean>)$continuation);
        if (v3 == var11_7) {
            return var11_7;
        }
        ** GOTO lbl72
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl72:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object addNewRetentionLease(ShardId var1_1, long var2_2, ShardId var4_3, long var5_4, Continuation<? super Boolean> var7_5) {
        if (!(var7_5 instanceof addNewRetentionLease.1)) ** GOTO lbl-1000
        var12_6 = var7_5;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_5){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteClusterRetentionLeaseHelper.access$addNewRetentionLease(this.this$0, null, 0L, null, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), (ShardId)followerShardId);
                request = new RetentionLeaseActions.AddRequest((ShardId)leaderShardId, retentionLeaseId, (long)seqNo, this.retentionLeaseSource);
                v0 = (OpenSearchClient)this.getClient();
                var10_11 = RetentionLeaseActions.Add.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)var10_11, (String)"INSTANCE");
                $continuation.L$0 = retentionLeaseId;
                $continuation.label = 1;
                v1 = CoroutinesKt.suspendExecute$default(v0, (ActionType)var10_11, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v1 != var13_8) goto lbl24
lbl23:
                // 1 sources

                return var13_8;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                retentionLeaseId = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    return Boxing.boxBoolean((boolean)true);
                }
                catch (Exception var10_12) {
                    RemoteClusterRetentionLeaseHelper.log.info(Intrinsics.stringPlus((String)"Exception while adding new retention lease with i: ", (Object)retentionLeaseId));
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object renewRetentionLease(@NotNull ShardId var1_1, long var2_2, @NotNull ShardId var4_3, @NotNull Continuation<? super Unit> var5_4) {
        if (!(var5_4 instanceof renewRetentionLease.1)) ** GOTO lbl-1000
        var10_5 = var5_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.renewRetentionLease(null, 0L, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), followerShardId);
                request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
                v0 = (OpenSearchClient)this.getClient();
                var8_10 = RetentionLeaseActions.Renew.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)var8_10, (String)"INSTANCE");
                $continuation.L$0 = this;
                $continuation.L$1 = leaderShardId;
                $continuation.L$2 = followerShardId;
                $continuation.L$3 = retentionLeaseId;
                $continuation.J$0 = seqNo;
                $continuation.label = 1;
                v1 = CoroutinesKt.suspendExecute$default(v0, (ActionType)var8_10, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v1 != var11_7) goto lbl28
lbl27:
                // 1 sources

                return var11_7;
lbl28:
                // 1 sources

                ** GOTO lbl61
            }
            case 1: {
                seqNo = $continuation.J$0;
                retentionLeaseId = (String)$continuation.L$3;
                followerShardId = (ShardId)$continuation.L$2;
                leaderShardId = (ShardId)$continuation.L$1;
                this = (RemoteClusterRetentionLeaseHelper)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl61
                }
                catch (RetentionLeaseNotFoundException e) {
                    RemoteClusterRetentionLeaseHelper.log.info("Retention lease with ID: " + retentionLeaseId + " not found, checking for old retention lease with ID: " + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterName, followerShardId));
                    $continuation.L$0 = this;
                    $continuation.L$1 = followerShardId;
                    $continuation.L$2 = retentionLeaseId;
                    $continuation.L$3 = e;
                    $continuation.label = 2;
                    v2 = this.addNewRetentionLeaseIfOldExists(leaderShardId, followerShardId, seqNo, (Continuation<? super Boolean>)$continuation);
                    if (v2 == var11_7) {
                        return var11_7;
                    }
                    ** GOTO lbl58
                }
            }
            case 2: {
                e = (RetentionLeaseNotFoundException)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                this = (RemoteClusterRetentionLeaseHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl58:
                // 2 sources

                if (!((Boolean)v2).booleanValue()) {
                    RemoteClusterRetentionLeaseHelper.log.info("Both new " + retentionLeaseId + " and old " + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), followerShardId) + " retention lease not found.");
                    throw e;
                }
lbl61:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object attemptRemoveRetentionLease(@NotNull ClusterService var1_1, @NotNull ReplicationMetadata var2_2, @NotNull String var3_3, @NotNull Continuation<? super Unit> var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getLeaderIndexMetadata(String var1_1, String var2_2, Continuation<? super IndexMetadata> var3_3) {
        if (!(var3_3 instanceof getLeaderIndexMetadata.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteClusterRetentionLeaseHelper.access$getLeaderIndexMetadata(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                leaderClusterClient = this.getClient().getRemoteClusterClient(leaderAlias);
                var6_8 = new String[]{leaderIndex};
                clusterStateRequest = (ClusterStateRequest)leaderClusterClient.admin().cluster().prepareState().clear().setIndices(var6_8).setMetadata(true).setIndicesOptions(IndicesOptions.strictSingleIndexNoExpandForbidClosed()).request();
                Intrinsics.checkNotNullExpressionValue((Object)leaderClusterClient, (String)"leaderClusterClient");
                var7_10 = leaderClusterClient.admin().cluster();
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"leaderClusterClient.admin().cluster()");
                $continuation.L$0 = leaderAlias;
                $continuation.L$1 = leaderIndex;
                $continuation.L$2 = clusterStateRequest;
                $continuation.label = 1;
                v0 = CoroutinesKt.suspending$default(leaderClusterClient, (Function2)new Function2<ClusterStateRequest, ActionListener<ClusterStateResponse>, Unit>((Object)var7_10){

                    public final void invoke(ClusterStateRequest p0, ActionListener<ClusterStateResponse> p1) {
                        ((ClusterAdminClient)this.receiver).state(p0, p1);
                    }
                }, false, false, (Continuation)$continuation, 6, null);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                clusterStateRequest = (ClusterStateRequest)$continuation.L$2;
                leaderIndex = (String)$continuation.L$1;
                leaderAlias = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                $continuation.L$0 = leaderAlias;
                $continuation.L$1 = leaderIndex;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = ((Function2)v0).invoke((Object)clusterStateRequest, (Object)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl45
            }
            case 2: {
                leaderIndex = (String)$continuation.L$1;
                leaderAlias = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl45:
                // 2 sources

                leaderState = ((ClusterStateResponse)v1).getState();
                v2 = leaderState.getMetadata().index(leaderIndex);
                if (v2 == null) {
                    throw new IndexNotFoundException(leaderAlias + ':' + leaderIndex);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object attemptRetentionLeaseRemoval(@NotNull ShardId var1_1, @NotNull ShardId var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof attemptRetentionLeaseRemoval.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.attemptRetentionLeaseRemoval(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.getFollowerClusterNameWithUUID(), (ShardId)followerShardId);
                request = new RetentionLeaseActions.RemoveRequest((ShardId)leaderShardId, retentionLeaseId);
                v0 = (OpenSearchClient)this.getClient();
                var6_9 = RetentionLeaseActions.Remove.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"INSTANCE");
                $continuation.L$0 = retentionLeaseId;
                $continuation.label = 1;
                v1 = CoroutinesKt.suspendExecute$default(v0, (ActionType)var6_9, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v1 != var9_6) goto lbl24
lbl23:
                // 1 sources

                return var9_6;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                retentionLeaseId = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    RemoteClusterRetentionLeaseHelper.log.info(Intrinsics.stringPlus((String)"Removed retention lease with id - ", (Object)retentionLeaseId));
                }
                catch (RetentionLeaseNotFoundException e) {
                    RemoteClusterRetentionLeaseHelper.log.error(ExtensionsKt.stackTraceToString(e));
                }
                catch (Exception e) {
                    RemoteClusterRetentionLeaseHelper.log.error("Exception in removing retention lease", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void attemptRetentionLeaseRemoval(@NotNull ShardId leaderShardId, @NotNull ShardId followerShardId, long timeout) {
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        String retentionLeaseId = Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
        RetentionLeaseActions.RemoveRequest request = new RetentionLeaseActions.RemoveRequest(leaderShardId, retentionLeaseId);
        try {
            this.client.execute((ActionType)RetentionLeaseActions.Remove.INSTANCE, (ActionRequest)request).actionGet(timeout);
            log.info(Intrinsics.stringPlus((String)"Removed retention lease with id - ", (Object)retentionLeaseId));
        }
        catch (RetentionLeaseNotFoundException e) {
            log.error(ExtensionsKt.stackTraceToString(e));
        }
        catch (Exception e) {
            log.error("Exception in removing retention lease", (Throwable)e);
        }
    }

    public final void addRetentionLease(@NotNull ShardId leaderShardId, long seqNo, @NotNull ShardId followerShardId, long timeout) {
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        String retentionLeaseId = Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
        RetentionLeaseActions.AddRequest request = new RetentionLeaseActions.AddRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
        boolean canRetry = true;
        while (true) {
            try {
                log.info(Intrinsics.stringPlus((String)"Adding retention lease ", (Object)retentionLeaseId));
                this.client.execute((ActionType)RetentionLeaseActions.Add.INSTANCE, (ActionRequest)request).actionGet(timeout);
            }
            catch (RetentionLeaseAlreadyExistsException e) {
                log.info("Found a stale retention lease " + retentionLeaseId + " on leader.");
                if (canRetry) {
                    canRetry = false;
                    this.attemptRetentionLeaseRemoval(leaderShardId, followerShardId, timeout);
                    log.info("Cleared stale retention lease " + retentionLeaseId + " on leader. Retrying...");
                    continue;
                }
                log.error(ExtensionsKt.stackTraceToString(e));
                throw e;
            }
            break;
        }
    }

    public final void renewRetentionLease(@NotNull ShardId leaderShardId, long seqNo, @NotNull ShardId followerShardId, long timeout) {
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        String retentionLeaseId = Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
        RetentionLeaseActions.RenewRequest request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
        this.client.execute((ActionType)RetentionLeaseActions.Renew.INSTANCE, (ActionRequest)request).actionGet(timeout);
    }

    public static final /* synthetic */ Object access$addNewRetentionLeaseIfOldExists(RemoteClusterRetentionLeaseHelper $this, ShardId leaderShardId, ShardId followerShardId, long seqNo, Continuation $completion) {
        return $this.addNewRetentionLeaseIfOldExists(leaderShardId, followerShardId, seqNo, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$addNewRetentionLease(RemoteClusterRetentionLeaseHelper $this, ShardId leaderShardId, long seqNo, ShardId followerShardId, long timeout, Continuation $completion) {
        return $this.addNewRetentionLease(leaderShardId, seqNo, followerShardId, timeout, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$getLeaderIndexMetadata(RemoteClusterRetentionLeaseHelper $this, String leaderAlias, String leaderIndex, Continuation $completion) {
        return $this.getLeaderIndexMetadata(leaderAlias, leaderIndex, (Continuation<? super IndexMetadata>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/replication/seqno/RemoteClusterRetentionLeaseHelper$Companion;", "", "()V", "RETENTION_LEASE_PREFIX", "", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getFollowerClusterNameWithUUID", "followerClusterName", "followerClusterUUID", "retentionLeaseIdForShard", "followerShardId", "Lorg/opensearch/index/shard/ShardId;", "retentionLeaseSource", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String retentionLeaseSource(@NotNull String followerClusterName) {
            Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
            return Intrinsics.stringPlus((String)RemoteClusterRetentionLeaseHelper.RETENTION_LEASE_PREFIX, (Object)followerClusterName);
        }

        @NotNull
        public final String retentionLeaseIdForShard(@NotNull String followerClusterName, @NotNull ShardId followerShardId) {
            Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
            Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
            String retentionLeaseSource = this.retentionLeaseSource(followerClusterName);
            return retentionLeaseSource + ':' + followerShardId;
        }

        @NotNull
        public final String getFollowerClusterNameWithUUID(@NotNull String followerClusterName, @NotNull String followerClusterUUID) {
            Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
            Intrinsics.checkNotNullParameter((Object)followerClusterUUID, (String)"followerClusterUUID");
            return followerClusterName + ':' + followerClusterUUID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

