/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class UploadGeoJSONResponse
extends ActionResponse
implements ToXContentObject {
    private static final String ERRORS = "errors";
    private static final String FAILURE = "failure";
    private static final String FAILURES = "failures";
    private static final String ID = "id";
    private static final String MESSAGE = "message";
    private static final int NO_FAILURE = 0;
    private static final String STATUS = "status";
    private static final String SUCCESS = "success";
    private static final String TOTAL = "total";
    private static final String TOOK = "took";
    private final BulkResponse bulkResponse;

    public UploadGeoJSONResponse(BulkResponse bulkResponse) {
        this.bulkResponse = bulkResponse;
    }

    public UploadGeoJSONResponse(StreamInput in) throws IOException {
        super(in);
        this.bulkResponse = new BulkResponse(in);
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        this.bulkResponse.writeTo(streamOutput);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOOK, this.bulkResponse.getTook().getMillis());
        builder.field(ERRORS, this.bulkResponse.hasFailures());
        builder.field(TOTAL, this.bulkResponse.getItems().length);
        if (!this.bulkResponse.hasFailures()) {
            this.buildSuccessXContent(builder);
            return builder.endObject();
        }
        this.buildFailureXContent(builder);
        return builder.endObject();
    }

    private void buildSuccessXContent(XContentBuilder builder) throws IOException {
        this.buildResultXContent(builder, this.bulkResponse.getItems().length, 0);
    }

    private void buildResultXContent(XContentBuilder builder, int successCount, int failureCount) throws IOException {
        builder.field(SUCCESS, successCount);
        builder.field(FAILURE, failureCount);
    }

    private void buildFailureXContent(XContentBuilder builder) throws IOException {
        List failedResponses = Arrays.stream(this.bulkResponse.getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toUnmodifiableList());
        int successCount = this.bulkResponse.getItems().length - failedResponses.size();
        this.buildResultXContent(builder, successCount, failedResponses.size());
        builder.startArray(FAILURES);
        for (BulkItemResponse response : failedResponses) {
            builder.startObject();
            builder.field(ID, response.getId());
            builder.field(STATUS, response.getFailure().getStatus().getStatus());
            builder.field(MESSAGE, response.getFailureMessage());
            builder.endObject();
        }
        builder.endArray();
    }
}

