/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.Index;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.indexstatemanagement.MetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.SkipExecution;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.updateindexmetadata.UpdateManagedIndexMetaDataAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.updateindexmetadata.UpdateManagedIndexMetaDataRequest;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.util.IndexManagementException;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.rest.RestStatus;

@OpenForTesting
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(H\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\u00020&2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0(H\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0011\u0010-\u001a\u00020&H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020&H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u00020\fH\u0012J\u0019\u00104\u001a\u00020&2\u0006\u00103\u001a\u00020\fH\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0011X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0092D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n \u001c*\u0004\u0018\u00010\u001f0\u001fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0016X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\f\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/MetadataService;", "", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "skipExecution", "Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;", "imIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "(Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;Lorg/opensearch/indexmanagement/IndexManagementIndices;)V", "counter", "", "failedToCleanIndices", "", "Lorg/opensearch/index/Index;", "failedToIndexIndices", "", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/MetadataDocID;", "Lorg/opensearch/action/bulk/BulkItemResponse$Failure;", "<set-?>", "", "finishFlag", "getFinishFlag", "()Z", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "maxRunTime", "retryPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "runTimeCounter", "getRunTimeCounter", "()I", "runningLock", "successfullyIndexedIndices", "cleanMetadatas", "", "indices", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexMetadatas", "requests", "Lorg/opensearch/action/DocWriteRequest;", "moveMetadata", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reenableMetadataService", "updateSettingListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/admin/cluster/settings/ClusterUpdateSettingsResponse;", "status", "updateStatusSetting", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataService.kt\norg/opensearch/indexmanagement/indexstatemanagement/MetadataService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n125#2:273\n152#2,3:274\n215#2,2:291\n135#2,9:304\n215#2:313\n216#2:315\n144#2:316\n125#2:332\n152#2,3:333\n125#2:343\n152#2,3:344\n766#3:277\n857#3,2:278\n1549#3:283\n1620#3,3:284\n1549#3:296\n1620#3,3:297\n1549#3:317\n1620#3,3:318\n1549#3:328\n1620#3,3:329\n1549#3:347\n1620#3,3:348\n515#4:280\n500#4,2:281\n502#4,4:287\n515#4:293\n500#4,2:294\n502#4,4:300\n467#4,7:321\n515#4:336\n500#4,6:337\n1#5:314\n*S KotlinDebug\n*F\n+ 1 MetadataService.kt\norg/opensearch/indexmanagement/indexstatemanagement/MetadataService\n*L\n102#1:273\n102#1:274,3\n112#1:291,2\n144#1:304,9\n144#1:313\n144#1:315\n144#1:316\n158#1:332\n158#1:333,3\n165#1:343\n165#1:344,3\n104#1:277\n104#1:278,2\n107#1:283\n107#1:284,3\n125#1:296\n125#1:297,3\n144#1:317\n144#1:318,3\n156#1:328\n156#1:329,3\n170#1:347\n170#1:348,3\n107#1:280\n107#1:281,2\n107#1:287,4\n124#1:293\n124#1:294,2\n124#1:300,4\n152#1:321,7\n165#1:336\n165#1:337,6\n144#1:314\n*E\n"})
public class MetadataService {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final SkipExecution skipExecution;
    @NotNull
    private final IndexManagementIndices imIndices;
    private final Logger logger;
    private volatile boolean runningLock;
    @NotNull
    private final Set<String> successfullyIndexedIndices;
    @NotNull
    private Map<String, BulkItemResponse.Failure> failedToIndexIndices;
    @NotNull
    private Set<Index> failedToCleanIndices;
    private int counter;
    private int runTimeCounter;
    private final int maxRunTime;
    private volatile boolean finishFlag;
    private volatile BackoffPolicy retryPolicy;

    public MetadataService(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull SkipExecution skipExecution, @NotNull IndexManagementIndices imIndices) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)skipExecution, (String)"skipExecution");
        Intrinsics.checkNotNullParameter((Object)imIndices, (String)"imIndices");
        this.client = client;
        this.clusterService = clusterService;
        this.skipExecution = skipExecution;
        this.imIndices = imIndices;
        this.logger = LogManager.getLogger(this.getClass());
        this.successfullyIndexedIndices = new LinkedHashSet();
        this.failedToIndexIndices = new LinkedHashMap();
        this.failedToCleanIndices = new LinkedHashSet();
        this.runTimeCounter = 1;
        this.maxRunTime = 10;
        this.retryPolicy = BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueMillis((long)50L), (int)3);
    }

    public final int getRunTimeCounter() {
        return this.runTimeCounter;
    }

    public final boolean getFinishFlag() {
        return this.finishFlag;
    }

    public void reenableMetadataService() {
        this.finishFlag = false;
    }

    @Nullable
    public Object moveMetadata(@NotNull Continuation<? super Unit> $completion) {
        return MetadataService.moveMetadata$suspendImpl(this, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static /* synthetic */ Object moveMetadata$suspendImpl(MetadataService var0, Continuation<? super Unit> var1_1) {
        block49: {
            block50: {
                if (!(var1_1 instanceof moveMetadata.1)) ** GOTO lbl-1000
                var29_2 = var1_1;
                if ((var29_2.label & -2147483648) != 0) {
                    var29_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, var1_1){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ MetadataService this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return MetadataService.moveMetadata$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var30_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if ($this.runningLock) {
                            $this.logger.info("There is a move metadata process running...");
                            return Unit.INSTANCE;
                        }
                        if ($this.finishFlag) {
                            $this.logger.info("Move metadata has finished.");
                            return Unit.INSTANCE;
                        }
                        $this.runningLock = true;
                        if (!$this.skipExecution.getFlag()) ** GOTO lbl28
                        $this.logger.info("Cluster still has nodes running old version of ISM plugin, skip ping execution on new nodes until all nodes upgraded");
                        $this.runningLock = false;
                        var2_5 = Unit.INSTANCE;
                        $this.runningLock = false;
                        return var2_5;
lbl28:
                        // 2 sources

                        if ($this.imIndices.indexManagementIndexExists()) ** GOTO lbl37
                        $this.logger.info("ISM config index not exist, so we cancel the metadata migration job.");
                        $this.finishFlag = true;
                        $this.runningLock = false;
                        $this.runTimeCounter = 0;
                        var2_6 = Unit.INSTANCE;
                        $this.runningLock = false;
                        return var2_6;
lbl37:
                        // 2 sources

                        if ($this.runTimeCounter <= $this.maxRunTime) break;
                        $continuation.L$0 = $this;
                        $continuation.label = 1;
                        v0 = $this.updateStatusSetting(-1, (Continuation<? super Unit>)$continuation);
                        ** if (v0 != var30_4) goto lbl43
lbl42:
                        // 1 sources

                        return var30_4;
lbl43:
                        // 1 sources

                        ** GOTO lbl50
                    }
                    case 1: {
                        $this = (MetadataService)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl50:
                        // 2 sources

                        $this.finishFlag = true;
                        $this.runningLock = false;
                        $this.runTimeCounter = 0;
                        var2_7 = Unit.INSTANCE;
                        return var2_7;
                    }
                }
                $this.logger.info("Doing metadata migration " + $this.runTimeCounter + " time.");
                indicesMetadata = $this.clusterService.state().getMetadata().getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)indicesMetadata, (String)"indicesMetadata");
                $this$map$iv = indicesMetadata;
                $i$f$map = false;
                var6_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                var9_27 = $this$mapTo$iv$iv.entrySet().iterator();
                while (var9_27.hasNext()) {
                    var11_32 = item$iv$iv = var9_27.next();
                    var26_44 = destination$iv$iv;
                    $i$a$-map-MetadataService$moveMetadata$clusterStateManagedIndexMetadata$1 = false;
                    v1 = it.getKey();
                    v2 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"it.value");
                    var26_44.add(TuplesKt.to(v1, (Object)OpenSearchExtensionsKt.getManagedIndexMetadata((IndexMetadata)v2)));
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var9_27 = $this$filterTo$iv$iv.iterator();
                while (var9_27.hasNext()) {
                    element$iv$iv = var9_27.next();
                    it = (Pair)element$iv$iv;
                    $i$a$-filter-MetadataService$moveMetadata$clusterStateManagedIndexMetadata$2 = false;
                    if (!(it.getSecond() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = clusterStateManagedIndexMetadata = MapsKt.toMap((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                    it = element$iv$iv;
                    $i$a$-filter-MetadataService$moveMetadata$2 = false;
                    $this$map$iv = $this.failedToCleanIndices;
                    $i$f$map = false;
                    var15_62 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var20_80 = (Index)item$iv$iv;
                        var21_83 = destination$iv$iv;
                        $i$a$-map-MetadataService$moveMetadata$2$1 = false;
                        var21_83.add(index.getName());
                    }
                    if (!(((List)destination$iv$iv).contains(it.getKey()) == false)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                clusterStateManagedIndexMetadata = destination$iv$iv;
                corruptManagedIndices = new ArrayList<E>();
                indexUuidMap = new LinkedHashMap<K, V>();
                $this$forEach$iv = clusterStateManagedIndexMetadata;
                $i$f$forEach = false;
                for (Map.Entry<K, V> element$iv : $this$forEach$iv.entrySet()) {
                    element$iv$iv = element$iv;
                    $i$a$-forEach-MetadataService$moveMetadata$3 = false;
                    indexName = (String)element$iv$iv.getKey();
                    metadata = (ManagedIndexMetaData)element$iv$iv.getValue();
                    indexMetadata = (IndexMetadata)indicesMetadata.get(indexName);
                    if (indexMetadata != null) {
                        $i$a$-let-MetadataService$moveMetadata$3$1 = false;
                        currentIndexUuid = it.getIndexUUID();
                        v3 = metadata;
                        if (!Intrinsics.areEqual((Object)currentIndexUuid, (Object)(v3 != null ? v3.getIndexUuid() : null))) {
                            v4 = it.getIndex();
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it.index");
                            corruptManagedIndices.add(v4);
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)currentIndexUuid, (String)"currentIndexUuid");
                            Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"indexName");
                            indexUuidMap.put(currentIndexUuid, indexName);
                        }
                        v5 = Unit.INSTANCE;
                        continue;
                    }
                    v5 = null;
                }
                $this.logger.info("Corrupt managed indices with outdated index uuid in metadata: " + corruptManagedIndices);
                $this$filter$iv = clusterStateManagedIndexMetadata;
                $i$f$filter = false;
                $i$f$filterTo = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                    metadata = element$iv$iv;
                    $i$a$-filter-MetadataService$moveMetadata$4 = false;
                    indexName = (String)metadata.getKey();
                    $this$map$iv = corruptManagedIndices;
                    $i$f$map = false;
                    var18_77 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        var23_87 = (Index)item$iv$iv;
                        var24_88 = destination$iv$iv;
                        $i$a$-map-MetadataService$moveMetadata$4$1 = false;
                        var24_88.add(it.getName());
                    }
                    if (!(((List)destination$iv$iv).contains(indexName) == false)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                clusterStateManagedIndexMetadata = destination$iv$iv;
                if (!clusterStateManagedIndexMetadata.isEmpty()) break block49;
                $this$filter$iv = $this.counter;
                $this.counter = $this$filter$iv + 1;
                if ($this$filter$iv <= 2 || !corruptManagedIndices.isEmpty()) break block50;
                $this.logger.info("Move Metadata succeed, set finish flag to true. Indices failed to get indexed: " + $this.failedToIndexIndices);
                $continuation.L$0 = $this;
                $continuation.label = 2;
                v6 = $this.updateStatusSetting(1, (Continuation<? super Unit>)$continuation);
                ** if (v6 != var30_4) goto lbl181
lbl180:
                // 1 sources

                return var30_4;
lbl181:
                // 1 sources

                ** GOTO lbl188
                {
                    case 2: {
                        $this = (MetadataService)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl188:
                        // 2 sources

                        $this.finishFlag = true;
                        $this.runningLock = false;
                        $this.runTimeCounter = 0;
                        $this$filter$iv = Unit.INSTANCE;
                        $this.runningLock = false;
                        return $this$filter$iv;
                    }
                }
            }
            if (!(((Collection)$this.failedToCleanIndices).isEmpty() == false)) ** GOTO lbl312
            $this.logger.info("Failed to clean indices: " + $this.failedToCleanIndices + ". Only clean cluster state metadata in this run.");
            $continuation.L$0 = $this;
            $continuation.label = 3;
            v7 = $this.cleanMetadatas(CollectionsKt.toList((Iterable)$this.failedToCleanIndices), (Continuation<? super Unit>)$continuation);
            ** if (v7 != var30_4) goto lbl204
lbl203:
            // 1 sources

            return var30_4;
lbl204:
            // 1 sources

            ** GOTO lbl211
            {
                case 3: {
                    $this = (MetadataService)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl211:
                    // 2 sources

                    $this.finishFlag = false;
                    $this.runningLock = false;
                    $this$filter$iv = Unit.INSTANCE;
                    $this.runningLock = false;
                    return $this$filter$iv;
                }
            }
        }
        $this.counter = 0;
        $this.finishFlag = false;
        $this$mapNotNull$iv = clusterStateManagedIndexMetadata;
        $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        $i$a$-filter-MetadataService$moveMetadata$4 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while ($i$a$-filter-MetadataService$moveMetadata$4.hasNext()) {
            element$iv$iv = element$iv$iv$iv = $i$a$-filter-MetadataService$moveMetadata$4.next();
            $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = false;
            it = element$iv$iv;
            $i$a$-mapNotNull-MetadataService$moveMetadata$bulkIndexReq$1 = false;
            if ((ManagedIndexMetaData)it.getValue() == null) continue;
            $i$a$-let-MapsKt___MapsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        $this$forEach$iv$iv$iv = $this$mapTo$iv$iv.iterator();
        while ($this$forEach$iv$iv$iv.hasNext()) {
            item$iv$iv = $this$forEach$iv$iv$iv.next();
            $i$a$-filter-MetadataService$moveMetadata$4 = (ManagedIndexMetaData)item$iv$iv;
            var26_44 = destination$iv$iv;
            $i$a$-map-MetadataService$moveMetadata$bulkIndexReq$2 = false;
            var26_44.add(ManagedIndexUtils.managedIndexMetadataIndexRequest((ManagedIndexMetaData)it, false, true));
        }
        bulkIndexReq = (List)destination$iv$iv;
        $this$map$iv = $this.failedToIndexIndices;
        var26_44 = $this;
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            it = (String)entry$iv.getKey();
            $i$a$-filterKeys-MetadataService$moveMetadata$5 = false;
            if (!(indexUuidMap.keySet().contains(it) == false)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        var26_44.failedToIndexIndices = MapsKt.toMutableMap((Map)result$iv);
        $this.successfullyIndexedIndices.clear();
        $continuation.L$0 = $this;
        $continuation.L$1 = corruptManagedIndices;
        $continuation.L$2 = indexUuidMap;
        $continuation.label = 4;
        v8 = $this.indexMetadatas(bulkIndexReq, (Continuation<? super Unit>)$continuation);
        ** if (v8 != var30_4) goto lbl273
lbl272:
        // 1 sources

        return var30_4;
lbl273:
        // 1 sources

        ** GOTO lbl282
        {
            case 4: {
                indexUuidMap = (Map)$continuation.L$2;
                corruptManagedIndices = (List)$continuation.L$1;
                $this = (MetadataService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl282:
                // 2 sources

                $this$filterKeys$iv = $this.successfullyIndexedIndices;
                var26_44 = $this.logger;
                $i$f$map = false;
                result$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var12_42 = $this$mapTo$iv$iv.iterator();
                while (var12_42.hasNext()) {
                    item$iv$iv = var12_42.next();
                    it = (String)item$iv$iv;
                    var27_90 = destination$iv$iv;
                    $i$a$-map-MetadataService$moveMetadata$6 = false;
                    var27_90.add((String)indexUuidMap.get(it));
                }
                var26_44.info("success indexed: " + (List)destination$iv$iv);
                $this$map$iv = $this.failedToIndexIndices;
                var26_44 = $this.logger;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    it = item$iv$iv;
                    var27_90 = destination$iv$iv;
                    $i$a$-map-MetadataService$moveMetadata$7 = false;
                    var27_90.add((String)indexUuidMap.get(it.getKey()));
                }
                var26_44.info("failed indexed: " + (List)destination$iv$iv + ";failed reason: " + CollectionsKt.distinct((Iterable)$this.failedToIndexIndices.values()));
lbl312:
                // 2 sources

                $this$filter$iv = indexUuidMap;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                var12_43 = $this$filterTo$iv$iv.entrySet().iterator();
                while (var12_43.hasNext()) {
                    it = element$iv$iv = (Map.Entry)var12_43.next();
                    $i$a$-filter-MetadataService$moveMetadata$indicesToCleanMetadata$1 = false;
                    if (!$this.successfullyIndexedIndices.contains(it.getKey())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$map$iv = destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                var12_43 = $this$mapTo$iv$iv.entrySet().iterator();
                while (var12_43.hasNext()) {
                    it = item$iv$iv = (Map.Entry)var12_43.next();
                    var26_44 = destination$iv$iv;
                    $i$a$-map-MetadataService$moveMetadata$indicesToCleanMetadata$2 = false;
                    var26_44.add(new Index((String)it.getValue(), (String)it.getKey()));
                }
                indicesToCleanMetadata = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((List)destination$iv$iv)), (Iterable)$this.failedToCleanIndices), (Iterable)corruptManagedIndices);
                $continuation.L$0 = $this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 5;
                v9 = $this.cleanMetadatas(indicesToCleanMetadata, (Continuation<? super Unit>)$continuation);
                ** if (v9 != var30_4) goto lbl346
lbl345:
                // 1 sources

                return var30_4;
lbl346:
                // 1 sources

                ** GOTO lbl353
            }
            case 5: {
                $this = (MetadataService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl353:
                // 2 sources

                if (((Collection)$this.failedToCleanIndices).isEmpty() == false) {
                    $this$map$iv = $this.failedToCleanIndices;
                    var26_44 = $this.logger;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    var12_43 = $this$mapTo$iv$iv.iterator();
                    while (var12_43.hasNext()) {
                        item$iv$iv = var12_43.next();
                        it = (Index)item$iv$iv;
                        var27_90 = destination$iv$iv;
                        $i$a$-map-MetadataService$moveMetadata$8 = false;
                        var27_90.add(it.getName());
                    }
                    var26_44.info("Failed to clean cluster metadata for: " + (List)destination$iv$iv);
                }
                var7_22 = $this.runTimeCounter;
                $this.runTimeCounter = var7_22 + 1;
                $this.runningLock = false;
            }
            {
                finally {
                    $this.runningLock = false;
                }
            }
            return Unit.INSTANCE;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private Object updateStatusSetting(int status, Continuation<? super Unit> $completion) {
        Settings.Builder newSetting = Settings.builder().put(ManagedIndexSettings.Companion.getMETADATA_SERVICE_STATUS().getKey(), status);
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest().persistentSettings(newSetting);
        BackoffPolicy backoffPolicy = this.retryPolicy;
        Intrinsics.checkNotNullExpressionValue((Object)backoffPolicy, (String)"retryPolicy");
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Object object = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.retry(backoffPolicy, logger, CollectionsKt.listOf((Object)RestStatus.INTERNAL_SERVER_ERROR), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(this, request, status, null){
            int label;
            final /* synthetic */ MetadataService this$0;
            final /* synthetic */ ClusterUpdateSettingsRequest $request;
            final /* synthetic */ int $status;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$status = $status;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MetadataService.access$getClient$p(this.this$0).admin().cluster().updateSettings(this.$request, MetadataService.access$updateSettingListener(this.this$0, this.$status));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private ActionListener<ClusterUpdateSettingsResponse> updateSettingListener(int status) {
        return (ActionListener)new ActionListener<ClusterUpdateSettingsResponse>(this, status){
            final /* synthetic */ MetadataService this$0;
            final /* synthetic */ int $status;
            {
                this.this$0 = $receiver;
                this.$status = $status;
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MetadataService.access$getLogger$p(this.this$0).error("Failed to update template migration setting to " + this.$status, (Throwable)e);
                throw IndexManagementException.Companion.wrap(new Exception("Failed to update template migration setting to " + this.$status));
            }

            public void onResponse(@NotNull ClusterUpdateSettingsResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isAcknowledged()) {
                    MetadataService.access$getLogger$p(this.this$0).error("Update metadata migration setting to " + this.$status + " is not acknowledged");
                    throw IndexManagementException.Companion.wrap(new Exception("Update metadata migration setting to " + this.$status + " is not acknowledged"));
                }
                MetadataService.access$getLogger$p(this.this$0).info("Successfully metadata template migration setting to " + this.$status);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private Object indexMetadatas(List<? extends DocWriteRequest<?>> var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof indexMetadatas.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MetadataService.access$indexMetadatas(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (requests.isEmpty()) {
                    return Unit.INSTANCE;
                }
                requestsToRetry = new Ref.ObjectRef();
                requestsToRetry.element = requests;
                $continuation.L$0 = this;
                $continuation.L$1 = requestsToRetry;
                $continuation.label = 1;
                v0 = this.imIndices.attemptUpdateConfigIndexMapping((Continuation<? super Boolean>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                requestsToRetry = (Ref.ObjectRef)$continuation.L$1;
                this = (MetadataService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.logger.error("Failed to update config index mapping.");
                    return Unit.INSTANCE;
                }
                v1 = this.retryPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"retryPolicy");
                v2 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"logger");
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v3 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.retry(v1, v2, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(requestsToRetry, this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $requestsToRetry;
                    final /* synthetic */ MetadataService this$0;
                    {
                        this.$requestsToRetry = $requestsToRetry;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                bulkRequest = new BulkRequest().add((Iterable)this.$requestsToRetry.element);
                                this.L$0 = bulkRequest;
                                this.label = 1;
                                v0 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)MetadataService.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                                    final /* synthetic */ BulkRequest $bulkRequest;
                                    {
                                        this.$bulkRequest = $bulkRequest;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var19_2) {
                                    return var19_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                bulkRequest = (BulkRequest)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                if ((v1 = (bulkResponse = (BulkResponse)v0).getItems()) == null) {
                                    v1 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv = v1;
                                $i$f$filter = false;
                                var7_8 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = 0;
                                var11_19 = ((void)$this$filterTo$iv$iv).length;
                                for (var10_17 = 0; var10_17 < var11_19; ++var10_17) {
                                    it = element$iv$iv = $this$filterTo$iv$iv[var10_17];
                                    $i$a$-filter-MetadataService$indexMetadatas$2$failedResponses$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                failedResponses = (List)destination$iv$iv;
                                retryIndexUuids = new ArrayList<E>();
                                $i$f$filter /* !! */  = bulkResponse.getItems();
                                Intrinsics.checkNotNullExpressionValue((Object)$i$f$filter /* !! */ , (String)"bulkResponse.items");
                                $i$f$filter /* !! */  = $i$f$filter /* !! */ ;
                                $this$filterTo$iv$iv = this.this$0;
                                $i$f$forEach = false;
                                for (void element$iv : $this$forEach$iv) {
                                    it = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-MetadataService$indexMetadatas$2$1 = false;
                                    v2 = it.getId();
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.id");
                                    indexUuid = ManagedIndexUtils.revertManagedIndexMetadataID(v2);
                                    if (it.isFailed()) {
                                        if (it.status() == RestStatus.TOO_MANY_REQUESTS) {
                                            retryIndexUuids.add(Boxing.boxInt((int)it.getItemId()));
                                            continue;
                                        }
                                        MetadataService.access$getLogger$p($this$filterTo$iv$iv).error("failed reason: " + it.getFailure() + ", " + it.getFailureMessage());
                                        var15_31 = MetadataService.access$getFailedToIndexIndices$p($this$filterTo$iv$iv);
                                        Intrinsics.checkNotNullExpressionValue((Object)it.getFailure(), (String)"it.failure");
                                        var15_31.put(indexUuid, var16_32);
                                        continue;
                                    }
                                    MetadataService.access$getSuccessfullyIndexedIndices$p($this$filterTo$iv$iv).add(indexUuid);
                                    MetadataService.access$getFailedToIndexIndices$p($this$filterTo$iv$iv).remove(indexUuid);
                                }
                                $this$forEach$iv = retryIndexUuids;
                                var17_33 = this.$requestsToRetry;
                                $i$f$map = false;
                                $i$f$forEach = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    $i$a$-forEach-MetadataService$indexMetadatas$2$1 = ((Number)item$iv$iv).intValue();
                                    var18_34 = destination$iv$iv;
                                    $i$a$-map-MetadataService$indexMetadatas$2$2 = false;
                                    var18_34.add((DocWriteRequest)bulkRequest.requests().get((int)it));
                                }
                                var17_33.element = (List)destination$iv$iv;
                                if (!(((Collection)this.$requestsToRetry.element).isEmpty() == false)) ** GOTO lbl88
                                $this$first$iv = failedResponses;
                                $i$f$first = false;
                                for (T element$iv : $this$first$iv) {
                                    it = (BulkItemResponse)element$iv;
                                    $i$a$-first-MetadataService$indexMetadatas$2$retryCause$1 = false;
                                    if (!(it.status() == RestStatus.TOO_MANY_REQUESTS)) continue;
                                    ** GOTO lbl84
                                }
                                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl84:
                                // 1 sources

                                retryCause = ((BulkItemResponse)element$iv).getFailure().getCause();
                                v3 = ExceptionsHelper.convertToOpenSearchException((Exception)retryCause);
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"convertToOpenSearchException(retryCause)");
                                throw (Throwable)v3;
lbl88:
                                // 1 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                if (v3 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl45
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl45:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private Object cleanMetadatas(List<? extends Index> var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof cleanMetadatas.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MetadataService.access$cleanMetadatas(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (indices.isEmpty()) {
                    return Unit.INSTANCE;
                }
                request = new UpdateManagedIndexMetaDataRequest(null, indices, 1, null);
                v0 = this.retryPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"retryPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = indices;
                $continuation.label = 1;
                v2 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.retry$default(v0, v1, null, (Function2)new Function2<TimeValue, Continuation<? super Boolean>, Object>(this, (List<? extends Index>)indices, request, null){
                    int label;
                    final /* synthetic */ MetadataService this$0;
                    final /* synthetic */ List<Index> $indices;
                    final /* synthetic */ UpdateManagedIndexMetaDataRequest $request;
                    {
                        this.this$0 = $receiver;
                        this.$indices = $indices;
                        this.$request = $request;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)MetadataService.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<AcknowledgedResponse>, Unit>(this.$request){
                                    final /* synthetic */ UpdateManagedIndexMetaDataRequest $request;
                                    {
                                        this.$request = $request;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.execute((ActionType)UpdateManagedIndexMetaDataAction.Companion.getINSTANCE(), (ActionRequest)this.$request, it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                                    v1 = MetadataService.access$getFailedToCleanIndices$p(this.this$0).removeAll((Collection)this.$indices);
                                } else {
                                    MetadataService.access$getLogger$p(this.this$0).error("Failed to clean cluster state metadata for indices: [" + this.$indices + "].");
                                    v1 = MetadataService.access$getFailedToCleanIndices$p(this.this$0).addAll((Collection)this.$indices);
                                }
                                return Boxing.boxBoolean((boolean)v1);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v2 != var7_5) goto lbl27
lbl26:
                // 1 sources

                return var7_5;
lbl27:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                indices = (List)$continuation.L$1;
                this = (MetadataService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (Exception e) {
                    this.logger.error("Failed to clean cluster state metadata for indices: [" + indices + "].", (Throwable)e);
                    this.failedToCleanIndices.addAll(indices);
                }
lbl40:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$updateStatusSetting(MetadataService $this, int status, Continuation $completion) {
        return $this.updateStatusSetting(status, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Client access$getClient$p(MetadataService $this) {
        return $this.client;
    }

    public static final /* synthetic */ ActionListener access$updateSettingListener(MetadataService $this, int status) {
        return $this.updateSettingListener(status);
    }

    public static final /* synthetic */ Logger access$getLogger$p(MetadataService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$indexMetadatas(MetadataService $this, List requests, Continuation $completion) {
        return $this.indexMetadatas(requests, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Map access$getFailedToIndexIndices$p(MetadataService $this) {
        return $this.failedToIndexIndices;
    }

    public static final /* synthetic */ Set access$getSuccessfullyIndexedIndices$p(MetadataService $this) {
        return $this.successfullyIndexedIndices;
    }

    public static final /* synthetic */ Object access$cleanMetadatas(MetadataService $this, List indices, Continuation $completion) {
        return $this.cleanMetadatas(indices, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Set access$getFailedToCleanIndices$p(MetadataService $this) {
        return $this.failedToCleanIndices;
    }
}

