/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.Index;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy.AddPolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy.TransportAddPolicyAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.addpolicy.TransportAddPolicyActionKt;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.util.FailedIndex;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.IndexManagementSecurityContext;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.IndexMetadataService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ISMIndexMetadata;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002./B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00022\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\n \u0019*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0018\u0010 \u001a\n \u0019*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00060"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "client", "Lorg/opensearch/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "(Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;)V", "getClient", "()Lorg/opensearch/client/node/NodeClient;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getIndexMetadataProvider", "()Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "jobInterval", "", "Ljava/lang/Integer;", "jobJitter", "", "Ljava/lang/Double;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "AddPolicyHandler", "Companion", "opensearch-index-management"})
public final class TransportAddPolicyAction
extends HandledTransportAction<AddPolicyRequest, ISMStatusResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeClient client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final IndexMetadataProvider indexMetadataProvider;
    private volatile Integer jobInterval;
    private volatile Double jobJitter;
    private volatile Boolean filterByEnabled;
    public static final long ADD_POLICY_TIMEOUT_IN_MILLIS = 30000L;

    @Inject
    public TransportAddPolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        super("cluster:admin/opendistro/ism/managedindex/add", transportService, actionFilters, AddPolicyRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
        this.jobInterval = (Integer)ManagedIndexSettings.Companion.getJOB_INTERVAL().get(this.settings);
        this.jobJitter = (Double)ManagedIndexSettings.Companion.getJITTER().get(this.settings);
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getJOB_INTERVAL(), arg_0 -> TransportAddPolicyAction._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getJITTER(), arg_0 -> TransportAddPolicyAction._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportAddPolicyAction._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final IndexMetadataProvider getIndexMetadataProvider() {
        return this.indexMetadataProvider;
    }

    protected void doExecute(@NotNull Task task, @NotNull AddPolicyRequest request, @NotNull ActionListener<ISMStatusResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new AddPolicyHandler(this, this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda$0(TransportAddPolicyAction this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.jobInterval = it;
    }

    private static final void _init_$lambda$1(TransportAddPolicyAction this$0, Double it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.jobJitter = it;
    }

    private static final void _init_$lambda$2(TransportAddPolicyAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0014\u0010\u001b\u001a\u00020\u00172\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0017H\u0002J\u0006\u0010%\u001a\u00020\u0017J\u001f\u0010&\u001a\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110(H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$AddPolicyHandler;", "", "client", "Lorg/opensearch/client/node/NodeClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction;Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/AddPolicyRequest;Lorg/opensearch/commons/authuser/User;)V", "failedIndices", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/FailedIndex;", "indicesToAdd", "", "", "policy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "startTime", "Ljava/time/Instant;", "createManagedIndices", "", "getClusterState", "getExistingManagedIndices", "getPolicy", "onFailure", "t", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onGetPolicyResponse", "response", "Lorg/opensearch/action/get/GetResponse;", "onUpdateMapping", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "removeClosedIndices", "start", "validateIndexPermissions", "indices", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransportAddPolicyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportAddPolicyAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$AddPolicyHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,377:1\n1855#2,2:378\n37#3,2:380\n215#4,2:382\n215#4,2:384\n*S KotlinDebug\n*F\n+ 1 TransportAddPolicyAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$AddPolicyHandler\n*L\n161#1:378,2\n185#1:380,2\n282#1:382,2\n326#1:384,2\n*E\n"})
    public final class AddPolicyHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<ISMStatusResponse> actionListener;
        @NotNull
        private final AddPolicyRequest request;
        @Nullable
        private final User user;
        private Instant startTime;
        private Policy policy;
        @NotNull
        private final Map<String, String> indicesToAdd;
        @NotNull
        private final List<FailedIndex> failedIndices;
        final /* synthetic */ TransportAddPolicyAction this$0;

        public AddPolicyHandler(@NotNull TransportAddPolicyAction this$0, @NotNull NodeClient client, @NotNull ActionListener<ISMStatusResponse> actionListener, @Nullable AddPolicyRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.indicesToAdd = new LinkedHashMap();
            this.failedIndices = new ArrayList();
        }

        public /* synthetic */ AddPolicyHandler(TransportAddPolicyAction transportAddPolicyAction, NodeClient nodeClient, ActionListener actionListener, AddPolicyRequest addPolicyRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(transportAddPolicyAction, nodeClient, (ActionListener<ISMStatusResponse>)actionListener, addPolicyRequest, user);
        }

        public final void start() {
            TransportAddPolicyActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            Boolean bl = this.this$0.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
            if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl, this.actionListener)) {
                return;
            }
            this.getClusterState();
        }

        public final void getClusterState() {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            this.startTime = instant;
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransportAddPolicyAction this$0;
                final /* synthetic */ AddPolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            indexNameToMetadata = new HashMap<K, V>();
                            var12_4 = indexNameToMetadata;
                            this.L$0 = indexNameToMetadata;
                            this.L$1 = var12_4;
                            this.label = 1;
                            v0 = this.this$0.getIndexMetadataProvider().getISMIndexMetadataByType(AddPolicyHandler.access$getRequest$p(this.this$1).getIndexType(), AddPolicyHandler.access$getRequest$p(this.this$1).getIndices(), (Continuation<? super Map<String, ISMIndexMetadata>>)((Continuation)this));
                            ** if (v0 != var13_2) goto lbl15
lbl14:
                            // 1 sources

                            return var13_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            var12_4 = (Map)this.L$1;
                            indexNameToMetadata = (Map)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                var12_4.putAll((Map)v0);
                            }
                            catch (Exception e) {
                                v1 = AddPolicyHandler.access$getActionListener$p(this.this$1);
                                v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                v1.onFailure((Exception)v2);
                                return Unit.INSTANCE;
                            }
                            e = indexNameToMetadata;
                            var4_7 = this.this$1;
                            $i$f$forEach = false;
                            var6_9 = $this$forEach$iv.entrySet().iterator();
                            while (var6_9.hasNext()) {
                                var8_11 = element$iv = var6_9.next();
                                $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$getClusterState$1$1 = false;
                                indexName = (String)var8_11.getKey();
                                indexMetadata = (ISMIndexMetadata)var8_11.getValue();
                                AddPolicyHandler.access$getIndicesToAdd$p(var4_7).putIfAbsent(indexMetadata.getIndexUuid(), indexName);
                            }
                            if (AddPolicyHandler.access$getIndicesToAdd$p(this.this$1).isEmpty()) {
                                AddPolicyHandler.access$getActionListener$p(this.this$1).onResponse((Object)new ISMStatusResponse(0, AddPolicyHandler.access$getFailedIndices$p(this.this$1)));
                                return Unit.INSTANCE;
                            }
                            if (AddPolicyHandler.access$getUser$p(this.this$1) != null) {
                                v3 = this.this$0.getSettings();
                                v4 = AddPolicyHandler.access$getClient$p(this.this$1).threadPool().getThreadContext();
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"client.threadPool().threadContext");
                                this.L$0 = null;
                                this.L$1 = null;
                                this.label = 2;
                                v5 = OpenSearchExtensionsKt.withClosableContext(new IndexManagementSecurityContext("AddPolicyHandler", v3, v4, AddPolicyHandler.access$getUser$p(this.this$1)), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, null){
                                    int label;
                                    final /* synthetic */ AddPolicyHandler this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = AddPolicyHandler.access$validateIndexPermissions(this.this$0, CollectionsKt.toList((Iterable)AddPolicyHandler.access$getIndicesToAdd$p(this.this$0).values()), (Continuation)this);
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, (Continuation)this);
                                if (v5 == var13_2) {
                                    return var13_2;
                                }
                            }
                            ** GOTO lbl61
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl61:
                            // 2 sources

                            AddPolicyHandler.access$removeClosedIndices(this.this$1);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object validateIndexPermissions(List<String> var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof validateIndexPermissions.1)) ** GOTO lbl-1000
            var12_3 = var2_2;
            if ((var12_3.label & -2147483648) != 0) {
                var12_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ AddPolicyHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AddPolicyHandler.access$validateIndexPermissions(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    permittedIndices = new ArrayList<E>();
                    $this$forEach$iv = (Iterable)indices;
                    $i$f$forEach = false;
                    var6_9 = $this$forEach$iv.iterator();
lbl16:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        element$iv = var6_9.next();
                        index = (String)element$iv;
                        $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$validateIndexPermissions$2 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = permittedIndices;
                        $continuation.L$2 = var6_9;
                        $continuation.L$3 = index;
                        $continuation.label = 1;
                        v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<NodeClient, ActionListener<AcknowledgedResponse>, Unit>(index){
                            final /* synthetic */ String $index;
                            {
                                this.$index = $index;
                                super(2);
                            }

                            public final void invoke(@NotNull NodeClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                String[] stringArray = new String[]{this.$index};
                                $this$suspendUntil.execute((ActionType)ManagedIndexAction.Companion.getINSTANCE(), (ActionRequest)new ManagedIndexRequest(new String[0]).indices(stringArray), it);
                            }
                        }, $continuation);
                        ** if (v0 != var13_5) goto lbl30
lbl29:
                        // 1 sources

                        return var13_5;
lbl30:
                        // 1 sources

                        ** GOTO lbl43
                    }
                    break;
                }
                case 1: {
                    $i$f$forEach = false;
                    $i$a$-forEach-TransportAddPolicyAction$AddPolicyHandler$validateIndexPermissions$2 = false;
                    index = (String)$continuation.L$3;
                    var6_9 = (Iterator<T>)$continuation.L$2;
                    permittedIndices = (List)$continuation.L$1;
                    this = (AddPolicyHandler)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl43:
                        // 2 sources

                        permittedIndices.add(index);
                    }
                    catch (OpenSearchSecurityException var10_13) {
                        TransportAddPolicyActionKt.access$getLog$p().debug("No permissions for index [" + index + "]");
                    }
                    ** GOTO lbl16
                }
            }
            if (permittedIndices.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return Unit.INSTANCE;
            }
            this.indicesToAdd.values().removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, validateIndexPermissions$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)((Function1)new Function1<String, Boolean>((List<String>)permittedIndices){
                final /* synthetic */ List<String> $permittedIndices;
                {
                    this.$permittedIndices = $permittedIndices;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !this.$permittedIndices.contains(it);
                }
            })));
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final void removeClosedIndices() {
            if (Intrinsics.areEqual((Object)this.request.getIndexType(), (Object)"_default")) {
                IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
                Collection<String> $this$toTypedArray$iv = this.indicesToAdd.values();
                boolean $i$f$toTypedArray = false;
                Collection<String> thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(Arrays.copyOf(stringArray, stringArray.length)).metadata(true).local(false)).waitForTimeout(TimeValue.timeValueMillis((long)30000L)).indicesOptions(strictExpandOptions);
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this.this$0, this){
                    final /* synthetic */ TransportAddPolicyAction this$0;
                    final /* synthetic */ AddPolicyHandler this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(@NotNull ClusterStateResponse response2) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, null){
                            int label;
                            final /* synthetic */ AddPolicyHandler this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Collection<Index> collection;
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        ResultKt.throwOnFailure((Object)object);
                                        Client client = (Client)AddPolicyHandler.access$getClient$p(this.this$0);
                                        Logger logger = TransportAddPolicyActionKt.access$getLog$p();
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                                        Map map = AddPolicyHandler.access$getIndicesToAdd$p(this.this$0);
                                        Logger logger2 = logger;
                                        Client client2 = client;
                                        boolean $i$f$map = false;
                                        void var4_7 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                                        boolean $i$f$mapTo = false;
                                        Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                                        while (iterator.hasNext()) {
                                            void it;
                                            Map.Entry<K, V> item$iv$iv;
                                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                                            collection = destination$iv$iv;
                                            boolean bl = false;
                                            collection.add(new Index((String)it.getValue(), (String)it.getKey()));
                                        }
                                        collection = (List)destination$iv$iv;
                                        this.label = 1;
                                        Object object3 = RestHandlerUtilsKt.removeClusterStateMetadatas(client2, logger2, (List<? extends Index>)collection, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        IndexMetadataService indexMetadataService = this.this$0.getIndexMetadataProvider().getServices().get("_default");
                        Intrinsics.checkNotNull((Object)indexMetadataService, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService");
                        DefaultIndexMetadataService defaultIndexMetadataService = (DefaultIndexMetadataService)indexMetadataService;
                        ClusterState clusterState = response2.getState();
                        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"response.state");
                        Iterable iterable = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.getUuidsForClosedIndices(clusterState, defaultIndexMetadataService);
                        AddPolicyHandler addPolicyHandler = this.this$1;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            List list = AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler);
                            V v = AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).get(it);
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                            list.add(new FailedIndex((String)v, it, "This index is closed"));
                            AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).remove(it);
                        }
                        AddPolicyHandler.access$getPolicy(this.this$1);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        ActionListener actionListener = AddPolicyHandler.access$getActionListener$p(this.this$1);
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        actionListener.onFailure((Exception)throwable);
                    }
                });
            } else {
                this.getPolicy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getPolicy() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getPolicyID());
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportAddPolicyAction transportAddPolicyAction = this.this$0;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportAddPolicyAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"filterByEnabled");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                this.client.get(getRequest, ActionListener.wrap(this::onGetPolicyResponse, this::onFailure));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onGetPolicyResponse(GetResponse response2) {
            if (!response2.isExists() || response2.isSourceEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not find policy=" + this.request.getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                this.policy = (Policy)OpenSearchExtensionsKt.parseFromGetResponse(response2, this.this$0.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                    @NotNull
                    public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Could not find policy=" + this.request.getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            Policy policy2 = this.policy;
            if (policy2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"policy");
                policy2 = null;
            }
            User user = policy2.getUser();
            Boolean bl = this.this$0.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, bl, "policy", this.request.getPolicyID(), this.actionListener)) {
                return;
            }
            ClusterState clusterState = this.this$0.getClusterService().state();
            Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
            IndicesAdminClient indicesAdminClient = this.client.admin().indices();
            Intrinsics.checkNotNullExpressionValue((Object)indicesAdminClient, (String)"client.admin().indices()");
            ActionListener actionListener = ActionListener.wrap(this::onUpdateMapping, this::onFailure);
            Intrinsics.checkNotNullExpressionValue((Object)actionListener, (String)"wrap(::onUpdateMapping, ::onFailure)");
            IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)actionListener);
        }

        private final void onUpdateMapping(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportAddPolicyActionKt.access$getLog$p().info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                this.getExistingManagedIndices();
            } else {
                TransportAddPolicyActionKt.access$getLog$p().error("Unable to create or update .opendistro-ism-config with newest mapping.");
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void getExistingManagedIndices() {
            this.indicesToAdd.entrySet().removeIf(arg_0 -> AddPolicyHandler.getExistingManagedIndices$lambda$3((Function1)new Function1<Map.Entry<String, String>, Boolean>(this.this$0, this){
                final /* synthetic */ TransportAddPolicyAction this$0;
                final /* synthetic */ AddPolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Map.Entry<String, String> entry) {
                    Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                    String uuid = entry.getKey();
                    String indexName = entry.getValue();
                    boolean shouldRemove = this.this$0.getIndexMetadataProvider().isUnManageableIndex(indexName);
                    if (shouldRemove) {
                        AddPolicyHandler.access$getFailedIndices$p(this.this$1).add(new FailedIndex(indexName, uuid, "Matches restricted index pattern defined in the cluster setting"));
                    }
                    return shouldRemove;
                }
            }, arg_0));
            if (this.indicesToAdd.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return;
            }
            MultiGetRequest multiGetReq = new MultiGetRequest();
            Map<String, String> $this$forEach$iv = this.indicesToAdd;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl = false;
                multiGetReq.add(".opendistro-ism-config", it.getKey());
            }
            this.client.multiGet(multiGetReq, (ActionListener)new ActionListener<MultiGetResponse>(this){
                final /* synthetic */ AddPolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull MultiGetResponse response2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    Iterable iterable = (Iterable)response2;
                    AddPolicyHandler addPolicyHandler = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
                        boolean bl = false;
                        if (!it.getResponse().isExists()) continue;
                        String docId2 = it.getId();
                        List list = AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler);
                        V v = AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).get(docId2);
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                        String string = (String)v;
                        Intrinsics.checkNotNullExpressionValue((Object)docId2, (String)"docId");
                        list.add(new FailedIndex(string, docId2, "This index already has a policy, use the update policy API to update index policies"));
                        AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).remove(docId2);
                    }
                    AddPolicyHandler.access$createManagedIndices(this.this$0);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ActionListener actionListener = AddPolicyHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void createManagedIndices() {
            if (!this.indicesToAdd.isEmpty()) {
                void $this$forEach$iv;
                Instant instant = this.startTime;
                if (instant == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"startTime");
                    instant = null;
                }
                Duration duration = Duration.between(instant, Instant.now());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(startTime, Instant.now())");
                Duration timeSinceClusterStateRequest = duration;
                long bulkReqTimeout = 30000L - timeSinceClusterStateRequest.toMillis();
                if (bulkReqTimeout < 0L) {
                    this.actionListener.onFailure((Exception)new OpenSearchTimeoutException("Add policy API timed out after ClusterStateResponse", new Object[0]));
                    return;
                }
                BulkRequest bulkReq = new BulkRequest().timeout(TimeValue.timeValueMillis((long)bulkReqTimeout));
                Map<String, String> map = this.indicesToAdd;
                TransportAddPolicyAction transportAddPolicyAction = this.this$0;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    String uuid = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    String string = this.request.getPolicyID();
                    Integer n = transportAddPolicyAction.jobInterval;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"jobInterval");
                    int n2 = ((Number)n).intValue();
                    Policy policy2 = this.policy;
                    if (policy2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"policy");
                        policy2 = null;
                    }
                    bulkReq.add(ManagedIndexUtils.managedIndexConfigIndexRequest(name, uuid, string, n2, Policy.copy$default(policy2, null, 0L, 0L, null, 0L, null, null, null, null, null, this.user, 1023, null), transportAddPolicyAction.jobJitter));
                }
                this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(this){
                    final /* synthetic */ AddPolicyHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(@NotNull BulkResponse response2) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        Iterable iterable = (Iterable)response2;
                        AddPolicyHandler addPolicyHandler = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            BulkItemResponse it = (BulkItemResponse)element$iv;
                            boolean bl = false;
                            String docId2 = it.getId();
                            if (!it.isFailed()) continue;
                            List list = AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler);
                            V v = AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).get(docId2);
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                            String string = (String)v;
                            Intrinsics.checkNotNullExpressionValue((Object)docId2, (String)"docId");
                            list.add(new FailedIndex(string, docId2, "Failed to add policy due to: " + it.getFailureMessage()));
                            AddPolicyHandler.access$getIndicesToAdd$p(addPolicyHandler).remove(docId2);
                        }
                        AddPolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(AddPolicyHandler.access$getIndicesToAdd$p(this.this$0).size(), AddPolicyHandler.access$getFailedIndices$p(this.this$0))));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (t instanceof ClusterBlockException) {
                            void $this$forEach$iv;
                            Map map = AddPolicyHandler.access$getIndicesToAdd$p(this.this$0);
                            AddPolicyHandler addPolicyHandler = this.this$0;
                            boolean $i$f$forEach = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> entry = element$iv = iterator.next();
                                boolean bl = false;
                                String uuid = (String)entry.getKey();
                                String name = (String)entry.getValue();
                                AddPolicyHandler.access$getFailedIndices$p(addPolicyHandler).add(new FailedIndex(name, uuid, "Failed to add policy due to ClusterBlockingException: " + t.getMessage()));
                            }
                            AddPolicyHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(0, AddPolicyHandler.access$getFailedIndices$p(this.this$0))));
                        } else {
                            ActionListener actionListener = AddPolicyHandler.access$getActionListener$p(this.this$0);
                            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                            actionListener.onFailure((Exception)throwable);
                        }
                    }
                });
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        private final void onFailure(Exception t) {
            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
            this.actionListener.onFailure((Exception)throwable);
        }

        private static final boolean validateIndexPermissions$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean getExistingManagedIndices$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ AddPolicyRequest access$getRequest$p(AddPolicyHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(AddPolicyHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ Map access$getIndicesToAdd$p(AddPolicyHandler $this) {
            return $this.indicesToAdd;
        }

        public static final /* synthetic */ List access$getFailedIndices$p(AddPolicyHandler $this) {
            return $this.failedIndices;
        }

        public static final /* synthetic */ User access$getUser$p(AddPolicyHandler $this) {
            return $this.user;
        }

        public static final /* synthetic */ NodeClient access$getClient$p(AddPolicyHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ Object access$validateIndexPermissions(AddPolicyHandler $this, List indices, Continuation $completion) {
            return $this.validateIndexPermissions(indices, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$removeClosedIndices(AddPolicyHandler $this) {
            $this.removeClosedIndices();
        }

        public static final /* synthetic */ void access$getPolicy(AddPolicyHandler $this) {
            $this.getPolicy();
        }

        public static final /* synthetic */ void access$createManagedIndices(AddPolicyHandler $this) {
            $this.createManagedIndices();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/addpolicy/TransportAddPolicyAction$Companion;", "", "()V", "ADD_POLICY_TIMEOUT_IN_MILLIS", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

