/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupAction;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestResponseListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/indexmanagement/rollup/resthandler/RestIndexRollupAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "indexRollupResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-index-management"})
public final class RestIndexRollupAction
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_rollup/jobs", RestRequest.Method.PUT, "/_opendistro/_rollup/jobs"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_rollup/jobs/{rollupID}", RestRequest.Method.PUT, "/_opendistro/_rollup/jobs/{rollupID}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "opendistro_index_rollup_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String id2 = request.param("rollupID", "");
        if (Intrinsics.areEqual((Object)"", (Object)id2)) {
            throw new IllegalArgumentException("Missing rollup ID");
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        XContentParser xcp = request.contentParser();
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"id");
        Rollup rollup2 = (Rollup)OpenSearchExtensionsKt.parseWithType(xcp, id2, seqNo, primaryTerm, (Function4)new Function4<XContentParser, String, Long, Long, Rollup>((Object)Rollup.Companion){

            @NotNull
            public final Rollup invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Rollup.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        });
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        Rollup rollup3 = Rollup.copy$default(rollup2, null, 0L, 0L, false, 0L, null, instant, null, null, null, null, null, null, 0, null, false, null, null, null, 524223, null);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"refreshPolicy");
        IndexRollupRequest indexRollupRequest = new IndexRollupRequest(rollup3, refreshPolicy);
        return arg_0 -> RestIndexRollupAction.prepareRequest$lambda$0(client, indexRollupRequest, this, arg_0);
    }

    private final RestResponseListener<IndexRollupResponse> indexRollupResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<IndexRollupResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            @NotNull
            public RestResponse buildResponse(@NotNull IndexRollupResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                RestStatus restStatus = response2.getStatus();
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"channel.newBuilder()");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                if (response2.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_rollup/jobs/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, IndexRollupRequest $indexRollupRequest, RestIndexRollupAction this$0, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$indexRollupRequest), (String)"$indexRollupRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ActionType actionType = IndexRollupAction.Companion.getINSTANCE();
        ActionRequest actionRequest = (ActionRequest)$indexRollupRequest;
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        $client.execute(actionType, actionRequest, (ActionListener)this$0.indexRollupResponse(channel));
    }
}

