/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.common.ValidationException;
import org.opensearch.core.common.Strings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/util/IndexManagementException;", "Lorg/opensearch/OpenSearchException;", "message", "", "status", "Lorg/opensearch/rest/RestStatus;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Lorg/opensearch/rest/RestStatus;Ljava/lang/Exception;)V", "getStatus", "()Lorg/opensearch/rest/RestStatus;", "Companion", "opensearch-index-management"})
public final class IndexManagementException
extends OpenSearchException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RestStatus status;

    public IndexManagementException(@NotNull String message, @NotNull RestStatus status, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        super(message, (Throwable)ex, new Object[0]);
        this.status = status;
    }

    @NotNull
    public final RestStatus getStatus() {
        return this.status;
    }

    @NotNull
    public RestStatus status() {
        return this.status;
    }

    @JvmStatic
    @NotNull
    public static final OpenSearchException wrap(@NotNull Exception ex) {
        return Companion.wrap(ex);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/util/IndexManagementException$Companion;", "", "()V", "wrap", "Lorg/opensearch/OpenSearchException;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenSearchException wrap(@NotNull Exception ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            String string = ex.getMessage();
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            String friendlyMsg = string;
            RestStatus status = RestStatus.INTERNAL_SERVER_ERROR;
            Exception exception = ex;
            if (exception instanceof IndexNotFoundException) {
                RestStatus restStatus = ((IndexNotFoundException)((Object)ex)).status();
                Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                friendlyMsg = "Configuration index not found";
            } else if (exception instanceof IllegalArgumentException) {
                status = RestStatus.BAD_REQUEST;
                String string2 = ex.getMessage();
                Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string2;
            } else if (exception instanceof ValidationException) {
                status = RestStatus.BAD_REQUEST;
                String string3 = ex.getMessage();
                Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string3;
            } else if (exception instanceof OpenSearchStatusException) {
                RestStatus restStatus = ((OpenSearchStatusException)((Object)ex)).status();
                Intrinsics.checkNotNullExpressionValue((Object)restStatus, (String)"ex.status()");
                status = restStatus;
                String string4 = ex.getMessage();
                Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string4;
            } else if (!Strings.isNullOrEmpty((String)ex.getMessage())) {
                String string5 = ex.getMessage();
                Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type kotlin.String");
                friendlyMsg = string5;
            }
            return new IndexManagementException(friendlyMsg, status, new Exception(ex.getClass().getName() + ": " + ex.getMessage()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

