/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.io.IOException;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.common.Explicit;
import org.opensearch.common.Strings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.util.KNNEngine;

public class MethodFieldMapper
extends KNNVectorFieldMapper {
    MethodFieldMapper(String simpleName, KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, KNNMethodContext knnMethodContext) {
        super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues);
        this.knnMethod = knnMethodContext;
        this.fieldType = new FieldType((IndexableFieldType)KNNVectorFieldMapper.Defaults.FIELD_TYPE);
        this.fieldType.putAttribute("dimension", String.valueOf(this.dimension));
        this.fieldType.putAttribute("spaceType", knnMethodContext.getSpaceType().getValue());
        KNNEngine knnEngine = knnMethodContext.getKnnEngine();
        this.fieldType.putAttribute("engine", knnEngine.getName());
        try {
            this.fieldType.putAttribute("parameters", Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().map(knnEngine.getMethodAsMap(knnMethodContext))));
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Unable to create KNNVectorFieldMapper: %s", ioe));
        }
        this.fieldType.freeze();
    }
}

