/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.plugin.transport.DeleteModelRequest;
import org.opensearch.knn.plugin.transport.DeleteModelResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteModelTransportAction
extends HandledTransportAction<DeleteModelRequest, DeleteModelResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteModelTransportAction.class);
    private final ModelDao modelDao = ModelDao.OpenSearchKNNModelDao.getInstance();

    @Inject
    public DeleteModelTransportAction(TransportService transportService, ActionFilters filters) {
        super("cluster:admin/knn_delete_model_action", transportService, filters, DeleteModelRequest::new);
    }

    protected void doExecute(Task task, DeleteModelRequest request, ActionListener<DeleteModelResponse> listener) {
        String modelID = request.getModelID();
        this.modelDao.delete(modelID, (ActionListener<DeleteModelResponse>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            log.error(e);
            listener.onFailure(e);
        }));
    }
}

