/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.plugin.transport.KNNStatsNodeResponse;

public class KNNStatsResponse
extends BaseNodesResponse<KNNStatsNodeResponse>
implements ToXContentObject {
    private static final String NODES_KEY = "nodes";
    private Map<String, Object> clusterStats;

    public KNNStatsResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(KNNStatsNodeResponse::readStats), in.readList(FailedNodeException::new));
        this.clusterStats = in.readMap();
    }

    public KNNStatsResponse(ClusterName clusterName, List<KNNStatsNodeResponse> nodes, List<FailedNodeException> failures, Map<String, Object> clusterStats) {
        super(clusterName, nodes, failures);
        this.clusterStats = clusterStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.clusterStats);
    }

    public void writeNodesTo(StreamOutput out, List<KNNStatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<KNNStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(KNNStatsNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, Object> clusterStat : this.clusterStats.entrySet()) {
            builder.field(clusterStat.getKey(), clusterStat.getValue());
        }
        builder.startObject(NODES_KEY);
        for (KNNStatsNodeResponse knnStats : this.getNodes()) {
            DiscoveryNode node = knnStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            knnStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

