/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.anomalylocalization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.common.io.stream.NamedWriteable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.ExecuteInput;
import org.opensearch.ml.common.input.Input;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;

@ExecuteInput(algorithms={FunctionName.ANOMALY_LOCALIZATION})
public class AnomalyLocalizationInput
implements Input {
    public static final String FIELD_INDEX_NAME = "index_name";
    public static final String FIELD_ATTTRIBUTE_FIELD_NAMES = "attribute_field_names";
    public static final String FIELD_AGGREGATIONS = "aggregations";
    public static final String FIELD_TIME_FIELD_NAME = "time_field_name";
    public static final String FIELD_START_TIME = "start_time";
    public static final String FIELD_END_TIME = "end_time";
    public static final String FIELD_MIN_TIME_INTERVAL = "min_time_interval";
    public static final String FIELD_NUM_OUTPUTS = "num_outputs";
    public static final String FIELD_ANOMALY_START_TIME = "anomaly_start_time";
    public static final String FIELD_FILTER_QUERY = "filter_query";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY_ENTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField(FunctionName.ANOMALY_LOCALIZATION.name(), new String[0]), parser -> AnomalyLocalizationInput.parse(parser));
    private final String indexName;
    private final List<String> attributeFieldNames;
    private final List<AggregationBuilder> aggregations;
    private final String timeFieldName;
    private final long startTime;
    private final long endTime;
    private final long minTimeInterval;
    private final int numOutputs;
    private final Optional<Long> anomalyStartTime;
    private final Optional<QueryBuilder> filterQuery;

    public static AnomalyLocalizationInput parse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String indexName = null;
        ArrayList<String> attributeFieldNames = new ArrayList<String>();
        ArrayList<AggregationBuilder> aggregations = new ArrayList<AggregationBuilder>();
        String timeFieldName = null;
        long startTime = 0L;
        long endTime = 0L;
        long minTimeInterval = 0L;
        int numOutputs = 0;
        Optional<Long> anomalyStartTime = Optional.empty();
        Optional<QueryBuilder> filterQuery = Optional.empty();
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "index_name": {
                    parser.nextToken();
                    indexName = parser.text();
                    continue block24;
                }
                case "attribute_field_names": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        attributeFieldNames.add(parser.text());
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    continue block24;
                }
                case "aggregations": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        aggregations.addAll(AggregatorFactories.parseAggregators((XContentParser)parser).getAggregatorFactories());
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    continue block24;
                }
                case "time_field_name": {
                    parser.nextToken();
                    timeFieldName = parser.text();
                    continue block24;
                }
                case "start_time": {
                    parser.nextToken();
                    startTime = parser.longValue(false);
                    continue block24;
                }
                case "end_time": {
                    parser.nextToken();
                    endTime = parser.longValue(false);
                    continue block24;
                }
                case "min_time_interval": {
                    parser.nextToken();
                    minTimeInterval = parser.longValue(false);
                    continue block24;
                }
                case "num_outputs": {
                    parser.nextToken();
                    numOutputs = parser.intValue(false);
                    continue block24;
                }
                case "anomaly_start_time": {
                    parser.nextToken();
                    anomalyStartTime = Optional.of(parser.longValue(false));
                    continue block24;
                }
                case "filter_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    filterQuery = Optional.of(AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser));
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return new AnomalyLocalizationInput(indexName, attributeFieldNames, aggregations, timeFieldName, startTime, endTime, minTimeInterval, numOutputs, anomalyStartTime, filterQuery);
    }

    public AnomalyLocalizationInput(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.attributeFieldNames = Arrays.asList(in.readStringArray());
        this.aggregations = in.readNamedWriteableList(AggregationBuilder.class);
        this.timeFieldName = in.readString();
        this.startTime = in.readLong();
        this.endTime = in.readLong();
        this.minTimeInterval = in.readLong();
        this.numOutputs = in.readInt();
        this.anomalyStartTime = Optional.ofNullable(in.readOptionalLong());
        this.filterQuery = Optional.ofNullable((QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class));
    }

    @Override
    public FunctionName getFunctionName() {
        return FunctionName.ANOMALY_LOCALIZATION;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_INDEX_NAME, this.indexName);
        builder.field(FIELD_ATTTRIBUTE_FIELD_NAMES, this.attributeFieldNames);
        builder.startArray(FIELD_AGGREGATIONS);
        for (AggregationBuilder agg : this.aggregations) {
            builder.startObject();
            builder.value((Object)agg);
            builder.endObject();
        }
        builder.endArray();
        builder.field(FIELD_TIME_FIELD_NAME, this.timeFieldName);
        builder.field(FIELD_START_TIME, this.startTime);
        builder.field(FIELD_END_TIME, this.endTime);
        builder.field(FIELD_MIN_TIME_INTERVAL, this.minTimeInterval);
        builder.field(FIELD_NUM_OUTPUTS, this.numOutputs);
        if (this.anomalyStartTime.isPresent()) {
            builder.field(FIELD_ANOMALY_START_TIME, this.anomalyStartTime.get());
        }
        if (this.filterQuery.isPresent()) {
            builder.field(FIELD_FILTER_QUERY, (ToXContent)this.filterQuery.get());
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeStringArray(this.attributeFieldNames.toArray(new String[0]));
        out.writeNamedWriteableList(this.aggregations);
        out.writeString(this.timeFieldName);
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
        out.writeLong(this.minTimeInterval);
        out.writeInt(this.numOutputs);
        out.writeOptionalLong((Long)this.anomalyStartTime.orElse(null));
        out.writeOptionalNamedWriteable((NamedWriteable)this.filterQuery.orElse(null));
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public List<String> getAttributeFieldNames() {
        return this.attributeFieldNames;
    }

    @Generated
    public List<AggregationBuilder> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public String getTimeFieldName() {
        return this.timeFieldName;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public long getMinTimeInterval() {
        return this.minTimeInterval;
    }

    @Generated
    public int getNumOutputs() {
        return this.numOutputs;
    }

    @Generated
    public Optional<Long> getAnomalyStartTime() {
        return this.anomalyStartTime;
    }

    @Generated
    public Optional<QueryBuilder> getFilterQuery() {
        return this.filterQuery;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyLocalizationInput)) {
            return false;
        }
        AnomalyLocalizationInput other = (AnomalyLocalizationInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        if (this.getMinTimeInterval() != other.getMinTimeInterval()) {
            return false;
        }
        if (this.getNumOutputs() != other.getNumOutputs()) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        List<String> this$attributeFieldNames = this.getAttributeFieldNames();
        List<String> other$attributeFieldNames = other.getAttributeFieldNames();
        if (this$attributeFieldNames == null ? other$attributeFieldNames != null : !((Object)this$attributeFieldNames).equals(other$attributeFieldNames)) {
            return false;
        }
        List<AggregationBuilder> this$aggregations = this.getAggregations();
        List<AggregationBuilder> other$aggregations = other.getAggregations();
        if (this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations)) {
            return false;
        }
        String this$timeFieldName = this.getTimeFieldName();
        String other$timeFieldName = other.getTimeFieldName();
        if (this$timeFieldName == null ? other$timeFieldName != null : !this$timeFieldName.equals(other$timeFieldName)) {
            return false;
        }
        Optional<Long> this$anomalyStartTime = this.getAnomalyStartTime();
        Optional<Long> other$anomalyStartTime = other.getAnomalyStartTime();
        if (this$anomalyStartTime == null ? other$anomalyStartTime != null : !((Object)this$anomalyStartTime).equals(other$anomalyStartTime)) {
            return false;
        }
        Optional<QueryBuilder> this$filterQuery = this.getFilterQuery();
        Optional<QueryBuilder> other$filterQuery = other.getFilterQuery();
        return !(this$filterQuery == null ? other$filterQuery != null : !((Object)this$filterQuery).equals(other$filterQuery));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalyLocalizationInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        long $minTimeInterval = this.getMinTimeInterval();
        result = result * 59 + (int)($minTimeInterval >>> 32 ^ $minTimeInterval);
        result = result * 59 + this.getNumOutputs();
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        List<String> $attributeFieldNames = this.getAttributeFieldNames();
        result = result * 59 + ($attributeFieldNames == null ? 43 : ((Object)$attributeFieldNames).hashCode());
        List<AggregationBuilder> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        String $timeFieldName = this.getTimeFieldName();
        result = result * 59 + ($timeFieldName == null ? 43 : $timeFieldName.hashCode());
        Optional<Long> $anomalyStartTime = this.getAnomalyStartTime();
        result = result * 59 + ($anomalyStartTime == null ? 43 : ((Object)$anomalyStartTime).hashCode());
        Optional<QueryBuilder> $filterQuery = this.getFilterQuery();
        result = result * 59 + ($filterQuery == null ? 43 : ((Object)$filterQuery).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalyLocalizationInput(indexName=" + this.getIndexName() + ", attributeFieldNames=" + this.getAttributeFieldNames() + ", aggregations=" + this.getAggregations() + ", timeFieldName=" + this.getTimeFieldName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", minTimeInterval=" + this.getMinTimeInterval() + ", numOutputs=" + this.getNumOutputs() + ", anomalyStartTime=" + this.getAnomalyStartTime() + ", filterQuery=" + this.getFilterQuery() + ")";
    }

    @Generated
    public AnomalyLocalizationInput(String indexName, List<String> attributeFieldNames, List<AggregationBuilder> aggregations, String timeFieldName, long startTime, long endTime, long minTimeInterval, int numOutputs, Optional<Long> anomalyStartTime, Optional<QueryBuilder> filterQuery) {
        this.indexName = indexName;
        this.attributeFieldNames = attributeFieldNames;
        this.aggregations = aggregations;
        this.timeFieldName = timeFieldName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.minTimeInterval = minTimeInterval;
        this.numOutputs = numOutputs;
        this.anomalyStartTime = anomalyStartTime;
        this.filterQuery = filterQuery;
    }
}

