/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.model;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.observability.model.Application;
import org.opensearch.observability.model.BaseObjectData;
import org.opensearch.observability.model.Notebook;
import org.opensearch.observability.model.ObservabilityObjectType;
import org.opensearch.observability.model.OperationalPanel;
import org.opensearch.observability.model.SavedQuery;
import org.opensearch.observability.model.SavedVisualization;
import org.opensearch.observability.model.Timestamp;
import org.opensearch.observability.model.XParser;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/observability/model/ObservabilityObjectDataProperties;", "", "()V", "OBJECT_PROPERTIES_MAP", "", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "Lorg/opensearch/observability/model/ObservabilityObjectDataProperties$ObjectProperty;", "createObjectData", "Lorg/opensearch/observability/model/BaseObjectData;", "objectType", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "getReaderForObjectType", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "validateObjectData", "", "objectData", "ObjectProperty", "opensearch-observability"})
public final class ObservabilityObjectDataProperties {
    @NotNull
    public static final ObservabilityObjectDataProperties INSTANCE = new ObservabilityObjectDataProperties();
    @NotNull
    private static final Map<ObservabilityObjectType, ObjectProperty> OBJECT_PROPERTIES_MAP;

    private ObservabilityObjectDataProperties() {
    }

    @NotNull
    public final Writeable.Reader<? extends BaseObjectData> getReaderForObjectType(@NotNull ObservabilityObjectType objectType) {
        Writeable.Reader<? extends BaseObjectData> reader;
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        ObjectProperty objectProperty = OBJECT_PROPERTIES_MAP.get((Object)objectType);
        Object object = reader = objectProperty == null ? null : objectProperty.getObjectDataReader();
        if (reader == null) {
            throw new IllegalArgumentException("Transport action used with unknown ConfigType:" + objectType);
        }
        return reader;
    }

    public final boolean validateObjectData(@NotNull ObservabilityObjectType objectType, @Nullable BaseObjectData objectData) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        switch (WhenMappings.$EnumSwitchMapping$0[objectType.ordinal()]) {
            case 1: {
                bl = objectData instanceof Notebook;
                break;
            }
            case 2: {
                bl = objectData instanceof SavedQuery;
                break;
            }
            case 3: {
                bl = objectData instanceof SavedVisualization;
                break;
            }
            case 4: {
                bl = objectData instanceof OperationalPanel;
                break;
            }
            case 5: {
                bl = objectData instanceof Application;
                break;
            }
            case 6: {
                bl = objectData instanceof Timestamp;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Nullable
    public final BaseObjectData createObjectData(@NotNull ObservabilityObjectType objectType, @NotNull XContentParser parser) {
        BaseObjectData baseObjectData;
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        ObjectProperty objectProperty = OBJECT_PROPERTIES_MAP.get((Object)objectType);
        if (objectProperty == null) {
            baseObjectData = null;
        } else {
            XParser<? extends BaseObjectData> xParser = objectProperty.getObjectDataParser();
            baseObjectData = xParser == null ? null : xParser.parse(parser);
        }
        return baseObjectData;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)ObservabilityObjectType.NOTEBOOK, (Object)new ObjectProperty(Notebook.Companion.getReader(), Notebook.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.SAVED_QUERY, (Object)new ObjectProperty(SavedQuery.Companion.getReader(), SavedQuery.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.SAVED_VISUALIZATION, (Object)new ObjectProperty(SavedVisualization.Companion.getReader(), SavedVisualization.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.OPERATIONAL_PANEL, (Object)new ObjectProperty(OperationalPanel.Companion.getReader(), OperationalPanel.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.APPLICATION, (Object)new ObjectProperty(Application.Companion.getReader(), Application.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.TIMESTAMP, (Object)new ObjectProperty(Timestamp.Companion.getReader(), Timestamp.Companion.getXParser()))};
        OBJECT_PROPERTIES_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0003J/\u0010\u000e\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/observability/model/ObservabilityObjectDataProperties$ObjectProperty;", "", "objectDataReader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "Lorg/opensearch/observability/model/BaseObjectData;", "objectDataParser", "Lorg/opensearch/observability/model/XParser;", "(Lorg/opensearch/common/io/stream/Writeable$Reader;Lorg/opensearch/observability/model/XParser;)V", "getObjectDataParser", "()Lorg/opensearch/observability/model/XParser;", "getObjectDataReader", "()Lorg/opensearch/common/io/stream/Writeable$Reader;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "opensearch-observability"})
    private static final class ObjectProperty {
        @Nullable
        private final Writeable.Reader<? extends BaseObjectData> objectDataReader;
        @NotNull
        private final XParser<? extends BaseObjectData> objectDataParser;

        public ObjectProperty(@Nullable Writeable.Reader<? extends BaseObjectData> objectDataReader, @NotNull XParser<? extends BaseObjectData> objectDataParser) {
            Intrinsics.checkNotNullParameter(objectDataParser, (String)"objectDataParser");
            this.objectDataReader = objectDataReader;
            this.objectDataParser = objectDataParser;
        }

        @Nullable
        public final Writeable.Reader<? extends BaseObjectData> getObjectDataReader() {
            return this.objectDataReader;
        }

        @NotNull
        public final XParser<? extends BaseObjectData> getObjectDataParser() {
            return this.objectDataParser;
        }

        @Nullable
        public final Writeable.Reader<? extends BaseObjectData> component1() {
            return this.objectDataReader;
        }

        @NotNull
        public final XParser<? extends BaseObjectData> component2() {
            return this.objectDataParser;
        }

        @NotNull
        public final ObjectProperty copy(@Nullable Writeable.Reader<? extends BaseObjectData> objectDataReader, @NotNull XParser<? extends BaseObjectData> objectDataParser) {
            Intrinsics.checkNotNullParameter(objectDataParser, (String)"objectDataParser");
            return new ObjectProperty(objectDataReader, objectDataParser);
        }

        public static /* synthetic */ ObjectProperty copy$default(ObjectProperty objectProperty, Writeable.Reader reader, XParser xParser, int n, Object object) {
            if ((n & 1) != 0) {
                reader = objectProperty.objectDataReader;
            }
            if ((n & 2) != 0) {
                xParser = objectProperty.objectDataParser;
            }
            return objectProperty.copy(reader, xParser);
        }

        @NotNull
        public String toString() {
            return "ObjectProperty(objectDataReader=" + this.objectDataReader + ", objectDataParser=" + this.objectDataParser + ")";
        }

        public int hashCode() {
            int result = this.objectDataReader == null ? 0 : this.objectDataReader.hashCode();
            result = result * 31 + this.objectDataParser.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectProperty)) {
                return false;
            }
            ObjectProperty objectProperty = (ObjectProperty)other;
            if (!Intrinsics.areEqual(this.objectDataReader, objectProperty.objectDataReader)) {
                return false;
            }
            return Intrinsics.areEqual(this.objectDataParser, objectProperty.objectDataParser);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObservabilityObjectType.values().length];
            nArray[ObservabilityObjectType.NOTEBOOK.ordinal()] = 1;
            nArray[ObservabilityObjectType.SAVED_QUERY.ordinal()] = 2;
            nArray[ObservabilityObjectType.SAVED_VISUALIZATION.ordinal()] = 3;
            nArray[ObservabilityObjectType.OPERATIONAL_PANEL.ordinal()] = 4;
            nArray[ObservabilityObjectType.APPLICATION.ordinal()] = 5;
            nArray[ObservabilityObjectType.TIMESTAMP.ordinal()] = 6;
            nArray[ObservabilityObjectType.NONE.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

