/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.AccessController;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.opensearch.common.cache.Cache;
import org.opensearch.indices.IndicesService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class CacheConfigMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(CacheConfigMetricsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;
    private StringBuilder value = new StringBuilder();

    public CacheConfigMetricsCollector() {
        super(SAMPLING_TIME_INTERVAL, "CacheConfigMetrics", (MeasurementSet)StatMetrics.CACHE_CONFIG_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.CACHE_CONFIG_METRICS_COLLECTOR_ERROR);
    }

    public void collectMetrics(long startTime) {
        IndicesService indicesService = OpenSearchResources.INSTANCE.getIndicesService();
        if (indicesService == null) {
            return;
        }
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
        CacheMaxSizeStatus fieldDataCacheMaxSizeStatus = AccessController.doPrivileged(() -> {
            try {
                Cache fieldDataCache = indicesService.getIndicesFieldDataCache().getCache();
                long fieldDataMaxSize = (Long)FieldUtils.readField((Object)fieldDataCache, (String)"maximumWeight", (boolean)true);
                return new CacheMaxSizeStatus(AllMetrics.CacheType.FIELD_DATA_CACHE.toString(), fieldDataMaxSize);
            }
            catch (Exception e) {
                return new CacheMaxSizeStatus(AllMetrics.CacheType.FIELD_DATA_CACHE.toString(), null);
            }
        });
        this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(fieldDataCacheMaxSizeStatus.serialize());
        CacheMaxSizeStatus shardRequestCacheMaxSizeStatus = AccessController.doPrivileged(() -> {
            try {
                Object reqCache = FieldUtils.readField((Object)indicesService, (String)"indicesRequestCache", (boolean)true);
                Cache requestCache = (Cache)FieldUtils.readField((Object)reqCache, (String)"cache", (boolean)true);
                Long requestCacheMaxSize = (Long)FieldUtils.readField((Object)requestCache, (String)"maximumWeight", (boolean)true);
                return new CacheMaxSizeStatus(AllMetrics.CacheType.SHARD_REQUEST_CACHE.toString(), requestCacheMaxSize);
            }
            catch (Exception e) {
                return new CacheMaxSizeStatus(AllMetrics.CacheType.SHARD_REQUEST_CACHE.toString(), null);
            }
        });
        this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(shardRequestCacheMaxSizeStatus.serialize());
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"cache_config"});
    }

    static class CacheMaxSizeStatus
    extends MetricStatus {
        private final String cacheType;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final Long cacheMaxSize;

        CacheMaxSizeStatus(String cacheType, Long cacheMaxSize) {
            this.cacheType = cacheType;
            this.cacheMaxSize = cacheMaxSize;
        }

        @JsonProperty(value="CacheType")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="Cache_MaxSize")
        public long getCacheMaxSize() {
            return this.cacheMaxSize;
        }
    }
}

