/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class ClusterManagerServiceMetrics
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ClusterManagerServiceMetrics.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(ClusterManagerServiceMetrics.class);
    private static final int KEYS_PATH_LENGTH = 2;
    private StringBuilder value = new StringBuilder();

    public ClusterManagerServiceMetrics() {
        super(SAMPLING_TIME_INTERVAL, "ClusterManagerServiceMetrics", (MeasurementSet)StatMetrics.CLUSTER_MANAGER_SERVICE_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.CLUSTER_MANAGER_METRICS_ERROR);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 2) {
            throw new RuntimeException("keys length should be 2");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"pending_tasks", keysPath[0], keysPath[1]});
    }

    public void collectMetrics(long startTime) {
        if (Objects.isNull(OpenSearchResources.INSTANCE.getClusterService()) || Objects.isNull(OpenSearchResources.INSTANCE.getClusterService().getMasterService())) {
            return;
        }
        List pendingTasks = OpenSearchResources.INSTANCE.getClusterService().getMasterService().pendingTasks();
        HashMap<String, Integer> pendingTaskCountPerTaskType = new HashMap<String, Integer>();
        pendingTasks.stream().forEach(pendingTask -> {
            String pendingTaskType = pendingTask.getSource().toString().split(" ", 2)[0];
            pendingTaskCountPerTaskType.put(pendingTaskType, pendingTaskCountPerTaskType.getOrDefault(pendingTaskType, 0) + 1);
        });
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
        pendingTaskCountPerTaskType.forEach((pendingTaskType, PendingTaskValue) -> {
            this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            this.value.append(new ClusterManagerPendingStatus((String)pendingTaskType, (int)PendingTaskValue).serialize());
        });
        this.saveMetricValues(this.value.toString(), startTime, new String[]{"current", "metadata"});
    }

    public static class ClusterManagerPendingStatus
    extends MetricStatus {
        private final String pendingTaskType;
        private final int pendingTasksCount;

        public ClusterManagerPendingStatus(String pendingTaskType, int pendingTasksCount) {
            this.pendingTaskType = pendingTaskType;
            this.pendingTasksCount = pendingTasksCount;
        }

        @JsonProperty(value="ClusterManager_PendingTaskType")
        public String getClusterManagerTaskType() {
            return this.pendingTaskType;
        }

        @JsonProperty(value="ClusterManager_PendingQueueSize")
        public int getPendingTasksCount() {
            return this.pendingTasksCount;
        }
    }
}

