/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.action.admin.indices.stats.IndexShardStats;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.NodeIndicesStats;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.collectors.ValueCalculator;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.util.Utils;

public class NodeStatsAllShardsMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(NodeStatsAllShardsMetricsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 2;
    private static final Logger LOG = LogManager.getLogger(NodeStatsAllShardsMetricsCollector.class);
    private HashMap<ShardId, IndexShard> currentShards = new HashMap();
    private HashMap<ShardId, ShardStats> currentPerShardStats;
    private HashMap<ShardId, ShardStats> prevPerShardStats = new HashMap();
    private final PerformanceAnalyzerController controller;
    private static final Map<String, ValueCalculator> maps = new HashMap<String, ValueCalculator>(){
        {
            this.put(AllMetrics.ShardStatsValue.INDEXING_THROTTLE_TIME.toString(), shardStats -> shardStats.getStats().getIndexing().getTotal().getThrottleTime().millis());
            this.put(AllMetrics.ShardStatsValue.CACHE_QUERY_HIT.toString(), shardStats -> shardStats.getStats().getQueryCache().getHitCount());
            this.put(AllMetrics.ShardStatsValue.CACHE_QUERY_MISS.toString(), shardStats -> shardStats.getStats().getQueryCache().getMissCount());
            this.put(AllMetrics.ShardStatsValue.CACHE_QUERY_SIZE.toString(), shardStats -> shardStats.getStats().getQueryCache().getMemorySizeInBytes());
            this.put(AllMetrics.ShardStatsValue.CACHE_FIELDDATA_EVICTION.toString(), shardStats -> shardStats.getStats().getFieldData().getEvictions());
            this.put(AllMetrics.ShardStatsValue.CACHE_FIELDDATA_SIZE.toString(), shardStats -> shardStats.getStats().getFieldData().getMemorySizeInBytes());
            this.put(AllMetrics.ShardStatsValue.CACHE_REQUEST_HIT.toString(), shardStats -> shardStats.getStats().getRequestCache().getHitCount());
            this.put(AllMetrics.ShardStatsValue.CACHE_REQUEST_MISS.toString(), shardStats -> shardStats.getStats().getRequestCache().getMissCount());
            this.put(AllMetrics.ShardStatsValue.CACHE_REQUEST_EVICTION.toString(), shardStats -> shardStats.getStats().getRequestCache().getEvictions());
            this.put(AllMetrics.ShardStatsValue.CACHE_REQUEST_SIZE.toString(), shardStats -> shardStats.getStats().getRequestCache().getMemorySizeInBytes());
        }
    };
    private static final ImmutableMap<String, ValueCalculator> valueCalculators = ImmutableMap.copyOf(maps);

    public NodeStatsAllShardsMetricsCollector(PerformanceAnalyzerController controller) {
        super(SAMPLING_TIME_INTERVAL, "NodeStatsMetrics", (MeasurementSet)StatMetrics.NODE_STATS_ALL_SHARDS_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.NODESTATS_COLLECTION_ERROR);
        this.currentPerShardStats = new HashMap();
        this.controller = controller;
    }

    private void populateCurrentShards() {
        if (!this.currentShards.isEmpty()) {
            this.prevPerShardStats.putAll(this.currentPerShardStats);
            this.currentPerShardStats.clear();
        }
        this.currentShards.clear();
        this.currentShards = Utils.getShards();
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 2) {
            throw new RuntimeException("keys length should be 2");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"indices", keysPath[0], keysPath[1]});
    }

    public void collectMetrics(long startTime) {
        IndicesService indicesService = OpenSearchResources.INSTANCE.getIndicesService();
        if (indicesService == null) {
            return;
        }
        this.populateCurrentShards();
        this.populatePerShardStats(indicesService);
        for (Map.Entry<ShardId, ShardStats> currentShard : this.currentPerShardStats.entrySet()) {
            ShardId shardId = currentShard.getKey();
            ShardStats currentShardStats = currentShard.getValue();
            if (this.prevPerShardStats.size() == 0) {
                this.populateMetricValue(currentShardStats, startTime, shardId.getIndexName(), shardId.id());
                continue;
            }
            ShardStats prevShardStats = this.prevPerShardStats.get(shardId);
            if (prevShardStats == null) {
                this.populateMetricValue(currentShardStats, startTime, shardId.getIndexName(), shardId.id());
                continue;
            }
            NodeStatsMetricsAllShardsPerCollectionStatus prevValue = new NodeStatsMetricsAllShardsPerCollectionStatus(prevShardStats);
            NodeStatsMetricsAllShardsPerCollectionStatus currValue = new NodeStatsMetricsAllShardsPerCollectionStatus(currentShardStats);
            this.populateDiffMetricValue(prevValue, currValue, startTime, shardId.getIndexName(), shardId.id());
        }
    }

    Field getNodeIndicesStatsByShardField() throws Exception {
        Field field = NodeIndicesStats.class.getDeclaredField("statsByShard");
        field.setAccessible(true);
        return field;
    }

    public void populatePerShardStats(IndicesService indicesService) {
        for (Map.Entry<ShardId, IndexShard> currentShard : this.currentShards.entrySet()) {
            IndexShard currentIndexShard = currentShard.getValue();
            IndexShardStats currentIndexShardStats = Utils.indexShardStats(indicesService, currentIndexShard, new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.RequestCache}));
            for (ShardStats shardStats : currentIndexShardStats.getShards()) {
                this.currentPerShardStats.put(currentIndexShardStats.getShardId(), shardStats);
            }
        }
    }

    public void populateMetricValue(ShardStats shardStats, long startTime, String IndexName, int ShardId2) {
        StringBuilder value = new StringBuilder();
        value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
        value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new NodeStatsMetricsAllShardsPerCollectionStatus(shardStats).serialize());
        this.saveMetricValues(value.toString(), startTime, new String[]{IndexName, String.valueOf(ShardId2)});
    }

    public void populateDiffMetricValue(NodeStatsMetricsAllShardsPerCollectionStatus prevValue, NodeStatsMetricsAllShardsPerCollectionStatus currValue, long startTime, String IndexName, int ShardId2) {
        StringBuilder value = new StringBuilder();
        NodeStatsMetricsAllShardsPerCollectionStatus nodeStatsMetrics = new NodeStatsMetricsAllShardsPerCollectionStatus(Math.max(currValue.queryCacheHitCount - prevValue.queryCacheHitCount, 0L), Math.max(currValue.queryCacheMissCount - prevValue.queryCacheMissCount, 0L), currValue.queryCacheInBytes, Math.max(currValue.fieldDataEvictions - prevValue.fieldDataEvictions, 0L), currValue.fieldDataInBytes, Math.max(currValue.requestCacheHitCount - prevValue.requestCacheHitCount, 0L), Math.max(currValue.requestCacheMissCount - prevValue.requestCacheMissCount, 0L), Math.max(currValue.requestCacheEvictions - prevValue.requestCacheEvictions, 0L), currValue.requestCacheInBytes);
        value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(nodeStatsMetrics.serialize());
        this.saveMetricValues(value.toString(), startTime, new String[]{IndexName, String.valueOf(ShardId2)});
    }

    public static class NodeStatsMetricsAllShardsPerCollectionStatus
    extends MetricStatus {
        @JsonIgnore
        private ShardStats shardStats;
        private final long queryCacheHitCount;
        private final long queryCacheMissCount;
        private final long queryCacheInBytes;
        private final long fieldDataEvictions;
        private final long fieldDataInBytes;
        private final long requestCacheHitCount;
        private final long requestCacheMissCount;
        private final long requestCacheEvictions;
        private final long requestCacheInBytes;

        public NodeStatsMetricsAllShardsPerCollectionStatus(ShardStats shardStats) {
            this.shardStats = shardStats;
            this.queryCacheHitCount = this.calculate(AllMetrics.ShardStatsValue.CACHE_QUERY_HIT);
            this.queryCacheMissCount = this.calculate(AllMetrics.ShardStatsValue.CACHE_QUERY_MISS);
            this.queryCacheInBytes = this.calculate(AllMetrics.ShardStatsValue.CACHE_QUERY_SIZE);
            this.fieldDataEvictions = this.calculate(AllMetrics.ShardStatsValue.CACHE_FIELDDATA_EVICTION);
            this.fieldDataInBytes = this.calculate(AllMetrics.ShardStatsValue.CACHE_FIELDDATA_SIZE);
            this.requestCacheHitCount = this.calculate(AllMetrics.ShardStatsValue.CACHE_REQUEST_HIT);
            this.requestCacheMissCount = this.calculate(AllMetrics.ShardStatsValue.CACHE_REQUEST_MISS);
            this.requestCacheEvictions = this.calculate(AllMetrics.ShardStatsValue.CACHE_REQUEST_EVICTION);
            this.requestCacheInBytes = this.calculate(AllMetrics.ShardStatsValue.CACHE_REQUEST_SIZE);
        }

        public NodeStatsMetricsAllShardsPerCollectionStatus(long queryCacheHitCount, long queryCacheMissCount, long queryCacheInBytes, long fieldDataEvictions, long fieldDataInBytes, long requestCacheHitCount, long requestCacheMissCount, long requestCacheEvictions, long requestCacheInBytes) {
            this.shardStats = null;
            this.queryCacheHitCount = queryCacheHitCount;
            this.queryCacheMissCount = queryCacheMissCount;
            this.queryCacheInBytes = queryCacheInBytes;
            this.fieldDataEvictions = fieldDataEvictions;
            this.fieldDataInBytes = fieldDataInBytes;
            this.requestCacheHitCount = requestCacheHitCount;
            this.requestCacheMissCount = requestCacheMissCount;
            this.requestCacheEvictions = requestCacheEvictions;
            this.requestCacheInBytes = requestCacheInBytes;
        }

        private long calculate(AllMetrics.ShardStatsValue nodeMetric) {
            return ((ValueCalculator)valueCalculators.get((Object)nodeMetric.toString())).calculateValue(this.shardStats);
        }

        @JsonIgnore
        public ShardStats getShardStats() {
            return this.shardStats;
        }

        @JsonProperty(value="Cache_Query_Hit")
        public long getQueryCacheHitCount() {
            return this.queryCacheHitCount;
        }

        @JsonProperty(value="Cache_Query_Miss")
        public long getQueryCacheMissCount() {
            return this.queryCacheMissCount;
        }

        @JsonProperty(value="Cache_Query_Size")
        public long getQueryCacheInBytes() {
            return this.queryCacheInBytes;
        }

        @JsonProperty(value="Cache_FieldData_Eviction")
        public long getFieldDataEvictions() {
            return this.fieldDataEvictions;
        }

        @JsonProperty(value="Cache_FieldData_Size")
        public long getFieldDataInBytes() {
            return this.fieldDataInBytes;
        }

        @JsonProperty(value="Cache_Request_Hit")
        public long getRequestCacheHitCount() {
            return this.requestCacheHitCount;
        }

        @JsonProperty(value="Cache_Request_Miss")
        public long getRequestCacheMissCount() {
            return this.requestCacheMissCount;
        }

        @JsonProperty(value="Cache_Request_Eviction")
        public long getRequestCacheEvictions() {
            return this.requestCacheEvictions;
        }

        @JsonProperty(value="Cache_Request_Size")
        public long getRequestCacheInBytes() {
            return this.requestCacheInBytes;
        }
    }
}

