/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionFuture;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.reportsscheduler.model.ReportInstance;
import org.opensearch.reportsscheduler.model.ReportInstanceDoc;
import org.opensearch.reportsscheduler.model.ReportInstanceSearchResults;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.reportsscheduler.util.HelpersKt;
import org.opensearch.reportsscheduler.util.SecureIndexClient;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010#\u001a\u00020\u0017H\u0002J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lorg/opensearch/reportsscheduler/index/ReportInstancesIndex;", "", "()V", "REPORT_INSTANCES_INDEX_NAME", "", "REPORT_INSTANCES_MAPPING_FILE_NAME", "REPORT_INSTANCES_SETTINGS_FILE_NAME", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createIndex", "", "createReportInstance", "reportInstance", "Lorg/opensearch/reportsscheduler/model/ReportInstance;", "deleteReportInstance", "", "id", "getAllReportInstances", "Lorg/opensearch/reportsscheduler/model/ReportInstanceSearchResults;", "tenant", "access", "", "from", "", "maxItems", "getReportInstance", "initialize", "isIndexExists", "updateReportInstance", "updateReportInstanceDoc", "reportInstanceDoc", "Lorg/opensearch/reportsscheduler/model/ReportInstanceDoc;", "opensearch-reports-scheduler"})
public final class ReportInstancesIndex {
    @NotNull
    public static final ReportInstancesIndex INSTANCE = new ReportInstancesIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ReportInstancesIndex.class);
    @NotNull
    private static final String REPORT_INSTANCES_INDEX_NAME = ".opendistro-reports-instances";
    @NotNull
    private static final String REPORT_INSTANCES_MAPPING_FILE_NAME = "report-instances-mapping.yml";
    @NotNull
    private static final String REPORT_INSTANCES_SETTINGS_FILE_NAME = "report-instances-settings.yml";
    private static Client client;
    private static ClusterService clusterService;

    private ReportInstancesIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ReportInstancesIndex.client = new SecureIndexClient(client);
        ReportInstancesIndex.clusterService = clusterService;
    }

    private final void createIndex() {
        block10: {
            if (!this.isIndexExists()) {
                String string;
                Object object;
                Object object2;
                String string2;
                ClassLoader classLoader = ReportInstancesIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(REPORT_INSTANCES_MAPPING_FILE_NAME);
                if (uRL == null) {
                    string2 = null;
                } else {
                    URL uRL2 = uRL;
                    object2 = Charsets.UTF_8;
                    object = TextStreamsKt.readBytes((URL)uRL2);
                    string2 = new String((byte[])object, (Charset)object2);
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(REPORT_INSTANCES_SETTINGS_FILE_NAME);
                if (uRL3 == null) {
                    string = null;
                } else {
                    object2 = uRL3;
                    object = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object2);
                    string = new String(byArray, (Charset)object);
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(REPORT_INSTANCES_INDEX_NAME).mapping(indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    ActionFuture actionFuture;
                    CreateIndexResponse response;
                    Client client = ReportInstancesIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (CreateIndexResponse)(actionFuture = client.admin().indices().create(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        throw new IllegalStateException("reports:Index .opendistro-reports-instances creation not Acknowledged".toString());
                    }
                    this.getLog().info("reports:Index .opendistro-reports-instances creation Acknowledged");
                }
                catch (ResourceAlreadyExistsException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceAlreadyExistsException) break block10;
                    throw exception;
                }
            }
        }
    }

    private final boolean isIndexExists() {
        ClusterService clusterService = ReportInstancesIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(REPORT_INSTANCES_INDEX_NAME);
    }

    @Nullable
    public final String createReportInstance(@NotNull ReportInstance reportInstance) {
        String string;
        ActionFuture actionFuture;
        IndexResponse response;
        Intrinsics.checkNotNullParameter((Object)reportInstance, (String)"reportInstance");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(REPORT_INSTANCES_INDEX_NAME).source(ReportInstance.toXContent$default(reportInstance, null, 1, null)).create(true);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.CREATED) {
            this.getLog().warn("reports:createReportInstance - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    @Nullable
    public final ReportInstance getReportInstance(@NotNull String id) {
        ReportInstance reportInstance;
        ActionFuture actionFuture;
        GetResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(REPORT_INSTANCES_INDEX_NAME).id(id);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (GetResponse)(actionFuture = client.get(getRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getSourceAsString() == null) {
            this.getLog().warn("reports:getReportInstance - " + id + " not found; response:" + response);
            reportInstance = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            reportInstance = ReportInstance.Companion.parse(parser, id);
        }
        return reportInstance;
    }

    @NotNull
    public final ReportInstanceSearchResults getAllReportInstances(@NotNull String tenant, @NotNull List<String> access, int from, int maxItems) {
        String[] query;
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.createIndex();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).sort("lastUpdatedTimeMs").size(maxItems).from(from);
        String[] stringArray = new String[]{tenant};
        TermsQueryBuilder tenantQuery = QueryBuilders.termsQuery((String)"tenant", (String[])stringArray);
        if (!((Collection)access).isEmpty()) {
            TermsQueryBuilder accessQuery = QueryBuilders.termsQuery((String)"access", (Collection)access);
            query = QueryBuilders.boolQuery();
            query.filter((QueryBuilder)tenantQuery);
            query.filter((QueryBuilder)accessQuery);
            sourceBuilder.query((QueryBuilder)query);
        } else {
            sourceBuilder.query((QueryBuilder)tenantQuery);
        }
        query = new String[]{REPORT_INSTANCES_INDEX_NAME};
        SearchRequest searchRequest = new SearchRequest().indices(query).source(sourceBuilder);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = from;
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        ReportInstanceSearchResults result = new ReportInstanceSearchResults(l, response);
        this.getLog().info("reports:getAllReportInstances from:" + from + ", maxItems:" + maxItems + ", retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateReportInstance(@NotNull ReportInstance reportInstance) {
        ActionFuture actionFuture;
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)reportInstance, (String)"reportInstance");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_INSTANCES_INDEX_NAME)).id(reportInstance.getId()).doc(ReportInstance.toXContent$default(reportInstance, null, 1, null)).fetchSource(true);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (UpdateResponse)(actionFuture = client.update(updateRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("reports:updateReportInstance failed for " + reportInstance.getId() + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean updateReportInstanceDoc(@NotNull ReportInstanceDoc reportInstanceDoc) {
        ActionFuture actionFuture;
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)reportInstanceDoc, (String)"reportInstanceDoc");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_INSTANCES_INDEX_NAME)).id(reportInstanceDoc.getReportInstance().getId()).setIfSeqNo(reportInstanceDoc.getSeqNo()).setIfPrimaryTerm(reportInstanceDoc.getPrimaryTerm()).doc(ReportInstance.toXContent$default(reportInstanceDoc.getReportInstance(), null, 1, null)).fetchSource(true);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (UpdateResponse)(actionFuture = client.update(updateRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("reports:updateReportInstanceDoc failed for " + reportInstanceDoc.getReportInstance().getId() + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteReportInstance(@NotNull String id) {
        ActionFuture actionFuture;
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(REPORT_INSTANCES_INDEX_NAME)).id(id);
        Client client = ReportInstancesIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (DeleteResponse)(actionFuture = client.delete(deleteRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.DELETED) {
            this.getLog().warn("reports:deleteReportInstance failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }
}

