/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.WeakKeyException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.user.AuthCredentials;

public class HTTPJwtAuthenticator
implements HTTPAuthenticator {
    protected final Logger log;
    private static final Pattern BASIC = Pattern.compile("^\\s*Basic\\s.*", 2);
    private static final String BEARER = "bearer ";
    private final JwtParser jwtParser;
    private final String jwtHeaderName;
    private final boolean isDefaultAuthHeader;
    private final String jwtUrlParameter;
    private final String rolesKey;
    private final String subjectKey;
    private final String requireAudience;
    private final String requireIssuer;

    public HTTPJwtAuthenticator(Settings settings, Path configPath) {
        JwtParser _jwtParser;
        block9: {
            this.log = LogManager.getLogger(this.getClass());
            _jwtParser = null;
            try {
                String signingKey = settings.get("signing_key");
                if (signingKey == null || signingKey.length() == 0) {
                    this.log.error("signingKey must not be null or empty. JWT authentication will not work");
                    break block9;
                }
                signingKey = signingKey.replace("-----BEGIN PUBLIC KEY-----\n", "");
                signingKey = signingKey.replace("-----END PUBLIC KEY-----", "");
                byte[] decoded = (byte[])Decoders.BASE64.decode((Object)signingKey);
                PublicKey key = null;
                try {
                    key = HTTPJwtAuthenticator.getPublicKey(decoded, "RSA");
                }
                catch (Exception e) {
                    this.log.debug("No public RSA key, try other algos ({})", (Object)e.toString());
                }
                try {
                    key = HTTPJwtAuthenticator.getPublicKey(decoded, "EC");
                }
                catch (Exception e) {
                    this.log.debug("No public ECDSA key, try other algos ({})", (Object)e.toString());
                }
                _jwtParser = key != null ? Jwts.parser().setSigningKey((Key)key) : Jwts.parser().setSigningKey(decoded);
            }
            catch (Throwable e) {
                this.log.error("Error creating JWT authenticator. JWT authentication will not work", e);
                throw new RuntimeException(e);
            }
        }
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.isDefaultAuthHeader = "Authorization".equalsIgnoreCase(this.jwtHeaderName);
        this.rolesKey = settings.get("roles_key");
        this.subjectKey = settings.get("subject_key");
        this.requireAudience = settings.get("required_audience");
        this.requireIssuer = settings.get("required_issuer");
        if (this.requireAudience != null) {
            _jwtParser.requireAudience(this.requireAudience);
        }
        if (this.requireIssuer != null) {
            _jwtParser.requireIssuer(this.requireIssuer);
        }
        this.jwtParser = _jwtParser;
    }

    @Override
    public AuthCredentials extractCredentials(final RestRequest request, ThreadContext context) throws OpenSearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(new PrivilegedAction<AuthCredentials>(){

            @Override
            public AuthCredentials run() {
                return HTTPJwtAuthenticator.this.extractCredentials0(request);
            }
        });
        return creds;
    }

    private AuthCredentials extractCredentials0(RestRequest request) {
        if (this.jwtParser == null) {
            this.log.error("Missing Signing Key. JWT authentication will not work");
            return null;
        }
        String jwtToken = request.header(this.jwtHeaderName);
        if (this.isDefaultAuthHeader && jwtToken != null && BASIC.matcher(jwtToken).matches()) {
            jwtToken = null;
        }
        if ((jwtToken == null || jwtToken.isEmpty()) && this.jwtUrlParameter != null) {
            jwtToken = request.param(this.jwtUrlParameter);
        } else {
            request.param(this.jwtUrlParameter);
        }
        if (jwtToken == null || jwtToken.length() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No JWT token found in '{}' {} header", (Object)(this.jwtUrlParameter == null ? this.jwtHeaderName : this.jwtUrlParameter), (Object)(this.jwtUrlParameter == null ? "header" : "url parameter"));
            }
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("No Bearer scheme found in header");
        }
        try {
            Claims claims = (Claims)this.jwtParser.parseClaimsJws(jwtToken).getBody();
            String subject = this.extractSubject(claims, request);
            if (subject == null) {
                this.log.error("No subject found in JWT token");
                return null;
            }
            String[] roles = this.extractRoles(claims, request);
            AuthCredentials ac = new AuthCredentials(subject, roles).markComplete();
            for (Map.Entry claim : claims.entrySet()) {
                ac.addAttribute("attr.jwt." + (String)claim.getKey(), String.valueOf(claim.getValue()));
            }
            return ac;
        }
        catch (WeakKeyException e) {
            this.log.error("Cannot authenticate user with JWT because of ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Invalid or expired JWT token.", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        BytesRestResponse wwwAuthenticateResponse = new BytesRestResponse(RestStatus.UNAUTHORIZED, "");
        wwwAuthenticateResponse.addHeader("WWW-Authenticate", "Bearer realm=\"OpenSearch Security\"");
        channel.sendResponse((RestResponse)wwwAuthenticateResponse);
        return true;
    }

    @Override
    public String getType() {
        return "jwt";
    }

    protected String extractSubject(Claims claims, RestRequest request) {
        String subject = claims.getSubject();
        if (this.subjectKey != null) {
            Object subjectObject = claims.get(this.subjectKey, Object.class);
            if (subjectObject == null) {
                this.log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                this.log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
            }
            subject = String.valueOf(subjectObject);
        }
        return subject;
    }

    protected String[] extractRoles(Claims claims, RestRequest request) {
        if (this.rolesKey == null) {
            return new String[0];
        }
        Object rolesObject = claims.get(this.rolesKey, Object.class);
        if (rolesObject == null) {
            this.log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", (Object)this.rolesKey);
            return new String[0];
        }
        String[] roles = String.valueOf(rolesObject).split(",");
        if (!(rolesObject instanceof String) && !(rolesObject instanceof Collection)) {
            this.log.warn("Expected type String or Collection for roles in the JWT for roles_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.rolesKey, rolesObject, rolesObject.getClass());
        } else if (rolesObject instanceof Collection) {
            roles = ((Collection)rolesObject).toArray(new String[0]);
        }
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = roles[i].trim();
        }
        return roles;
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(spec);
    }
}

