/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.PatchableResourceApiAction;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.InternalUsersValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.Hashed;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.support.SecurityJsonNode;
import org.opensearch.security.user.UserService;
import org.opensearch.security.user.UserServiceException;
import org.opensearch.threadpool.ThreadPool;

public class InternalUsersApiAction
extends PatchableResourceApiAction {
    static final List<String> RESTRICTED_FROM_USERNAME = ImmutableList.of((Object)":");
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/user/"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/user/{name}/authtoken"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/internalusers/"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/internalusers/{name}/authtoken"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/internalusers/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/internalusers/{name}"), (Object[])new RestHandler.Route[0]));
    UserService userService;

    @Inject
    public InternalUsersApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, UserService userService, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
        this.userService = userService;
    }

    @Override
    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfigFactory, Object content, String resourceName) {
        return true;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.INTERNALUSERS;
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        final String username = request.param("name");
        SecurityDynamicConfiguration<?> internalUsersConfiguration = this.load(this.getConfigName(), false);
        if (!this.isWriteable(channel, internalUsersConfiguration, username)) {
            return;
        }
        ObjectNode contentAsNode = (ObjectNode)content;
        SecurityJsonNode securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
        List<String> securityRoles = securityJsonNode.get("opendistro_security_roles").asList();
        if (securityRoles != null) {
            for (String role : securityRoles) {
                if (this.isValidRolesMapping(channel, role)) continue;
                return;
            }
        }
        final boolean userExisted = internalUsersConfiguration.exists(username);
        try {
            if (request.hasParam("service")) {
                ((ObjectNode)content).put("service", request.param("service"));
            }
            if (request.hasParam("enabled")) {
                ((ObjectNode)content).put("enabled", request.param("enabled"));
            }
            ((ObjectNode)content).put("name", username);
            internalUsersConfiguration = this.userService.createOrUpdateAccount((ObjectNode)content);
        }
        catch (UserServiceException ex) {
            this.badRequestResponse(channel, ex.getMessage());
            return;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
        if (userExisted && securityJsonNode.get("hash").asString() == null) {
            String hash = ((Hashed)internalUsersConfiguration.getCEntry(username)).getHash();
            if (hash == null || hash.length() == 0) {
                this.internalErrorResponse(channel, "Existing user " + username + " has no password, and no new password or hash was specified.");
                return;
            }
            contentAsNode.put("hash", hash);
        }
        internalUsersConfiguration.remove(username);
        Object userData = DefaultObjectMapper.readTree((JsonNode)contentAsNode, internalUsersConfiguration.getImplementingClass());
        internalUsersConfiguration.putCObject(username, userData);
        InternalUsersApiAction.saveAndUpdateConfigs(this.securityIndexName, client, CType.INTERNALUSERS, internalUsersConfiguration, (ActionListener<IndexResponse>)new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse response) {
                if (userExisted) {
                    InternalUsersApiAction.this.successResponse(channel, "'" + username + "' updated.");
                } else {
                    InternalUsersApiAction.this.createdResponse(channel, "'" + username + "' created.");
                }
            }
        });
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        String username = request.param("name");
        SecurityDynamicConfiguration<?> internalUsersConfiguration = this.load(this.getConfigName(), true);
        this.filter(internalUsersConfiguration);
        if (username == null || username.length() == 0) {
            this.notImplemented(channel, RestRequest.Method.POST);
            return;
        }
        boolean userExisted = internalUsersConfiguration.exists(username);
        if (!userExisted) {
            this.notFound(channel, "Resource '" + username + "' not found.");
            return;
        }
        String authToken = "";
        try {
            if (!request.uri().contains("/internalusers/" + username + "/authtoken") || !request.uri().endsWith("/authtoken")) {
                this.notImplemented(channel, RestRequest.Method.POST);
                return;
            }
            authToken = this.userService.generateAuthToken(username);
        }
        catch (UserServiceException ex) {
            this.badRequestResponse(channel, ex.getMessage());
            return;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
        if (!authToken.isEmpty()) {
            this.createdResponse(channel, "'" + username + "' authtoken generated " + authToken);
        } else {
            this.badRequestResponse(channel, "'" + username + "' authtoken failed to be created.");
        }
    }

    @Override
    protected void filter(SecurityDynamicConfiguration<?> builder) {
        super.filter(builder);
        builder.clearHashes();
    }

    @Override
    protected AbstractConfigurationValidator postProcessApplyPatchResult(RestChannel channel, RestRequest request, JsonNode existingResourceAsJsonNode, JsonNode updatedResourceAsJsonNode, String resourceName) {
        AbstractConfigurationValidator retVal = null;
        JsonNode passwordNode = updatedResourceAsJsonNode.get("password");
        if (passwordNode != null) {
            String plainTextPassword = passwordNode.asText();
            try {
                XContentBuilder builder = channel.newBuilder();
                builder.startObject();
                builder.field("password", plainTextPassword);
                builder.endObject();
                retVal = this.getValidator(request, BytesReference.bytes((XContentBuilder)builder), resourceName);
            }
            catch (IOException e) {
                this.log.error(e.toString());
            }
            ((ObjectNode)updatedResourceAsJsonNode).remove("password");
            ((ObjectNode)updatedResourceAsJsonNode).set("hash", (JsonNode)new TextNode(Utils.hash(plainTextPassword.toCharArray())));
            return retVal;
        }
        return null;
    }

    @Override
    protected String getResourceName() {
        return "user";
    }

    @Override
    protected CType getConfigName() {
        return CType.INTERNALUSERS;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return new InternalUsersValidator(request, this.isSuperAdmin(), ref, this.settings, params);
    }
}

