/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.PatchableResourceApiAction;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.dlic.rest.validation.RolesValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class RolesApiAction
extends PatchableResourceApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/roles/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/roles/{name}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/roles/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/roles/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/roles/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/roles/{name}")));

    @Inject
    public RolesApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, evaluator, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.ROLES;
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new RolesValidator(request, this.isSuperAdmin(), ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return "role";
    }

    @Override
    protected CType getConfigName() {
        return CType.ROLES;
    }

    @Override
    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfiguration, Object content, String resourceName) throws IOException {
        if (this.restApiAdminPrivilegesEvaluator.containsRestApiAdminPermissions(content)) {
            return this.isSuperAdmin();
        }
        return true;
    }

    @Override
    protected boolean isReadOnly(SecurityDynamicConfiguration<?> existingConfiguration, String name) {
        if (this.restApiAdminPrivilegesEvaluator.containsRestApiAdminPermissions(existingConfiguration.getCEntry(name))) {
            return !this.isSuperAdmin();
        }
        return super.isReadOnly(existingConfiguration, name);
    }
}

