/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.threadpool.ThreadPool;

public class SecuritySSLCertsAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> ROUTES = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/ssl/certs"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/ssl/{certType}/reloadcerts")));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final SecurityKeyStore securityKeyStore;
    private final boolean certificatesReloadEnabled;
    private final boolean httpsEnabled;

    public SecuritySSLCertsAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator privilegesEvaluator, ThreadPool threadPool, AuditLog auditLog, SecurityKeyStore securityKeyStore, boolean certificatesReloadEnabled) {
        super(settings, configPath, controller, client, adminDNs, cl, cs, principalExtractor, privilegesEvaluator, threadPool, auditLog);
        this.securityKeyStore = securityKeyStore;
        this.certificatesReloadEnabled = certificatesReloadEnabled;
        this.httpsEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(true));
    }

    @Override
    protected boolean hasPermissionsToCreate(SecurityDynamicConfiguration<?> dynamicConfigFactory, Object content, String resourceName) {
        return true;
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    @Override
    protected void handleApiRequest(RestChannel channel, RestRequest request, Client client) throws IOException {
        switch (request.method()) {
            case GET: {
                if (!this.restApiAdminPrivilegesEvaluator.isCurrentUserRestApiAdminFor(this.getEndpoint(), "certs")) {
                    this.forbidden(channel, "");
                    return;
                }
                this.handleGet(channel, request, client, null);
                break;
            }
            case PUT: {
                if (!this.restApiAdminPrivilegesEvaluator.isCurrentUserRestApiAdminFor(this.getEndpoint(), "reloadcerts")) {
                    this.forbidden(channel, "");
                    return;
                }
                if (!this.certificatesReloadEnabled) {
                    this.badRequestResponse(channel, String.format("no handler found for uri [%s] and method [%s]. In order to use SSL reload functionality set %s to true", request.path(), request.method(), "plugins.security.ssl_cert_reload_enabled"));
                    return;
                }
                this.handlePut(channel, request, client, null);
                break;
            }
            default: {
                this.notImplemented(channel, request.method());
            }
        }
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        if (this.securityKeyStore == null) {
            this.noKeyStoreResponse(channel);
            return;
        }
        try (XContentBuilder contentBuilder = channel.newBuilder();){
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, contentBuilder.startObject().field("http_certificates_list", this.httpsEnabled ? this.generateCertDetailList(this.securityKeyStore.getHttpCerts()) : null).field("transport_certificates_list", this.generateCertDetailList(this.securityKeyStore.getTransportCerts())).endObject()));
        }
        catch (Exception e) {
            this.internalErrorResponse(channel, e.getMessage());
            this.log.error("Error handle request ", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, JsonNode content) throws IOException {
        if (this.securityKeyStore == null) {
            this.noKeyStoreResponse(channel);
            return;
        }
        String certType = request.param("certType").toLowerCase().trim();
        try (XContentBuilder contentBuilder = channel.newBuilder();){
            switch (certType) {
                case "http": {
                    if (!this.httpsEnabled) {
                        this.badRequestResponse(channel, "SSL for HTTP is disabled");
                        return;
                    }
                    this.securityKeyStore.initHttpSSLConfig();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, contentBuilder.startObject().field("message", "updated http certs").endObject()));
                    return;
                }
                case "transport": {
                    this.securityKeyStore.initTransportSSLConfig();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, contentBuilder.startObject().field("message", "updated transport certs").endObject()));
                    return;
                }
                default: {
                    this.forbidden(channel, "invalid uri path, please use /_plugins/_security/api/ssl/http/reload or /_plugins/_security/api/ssl/transport/reload");
                    return;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Reload of certificates for {} failed", (Object)certType, (Object)e);
            try (XContentBuilder contentBuilder2 = channel.newBuilder();){
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, contentBuilder2.startObject().field("error", e.toString()).endObject()));
                return;
            }
        }
    }

    private List<Map<String, String>> generateCertDetailList(X509Certificate[] certs) {
        if (certs == null) {
            return null;
        }
        return Arrays.stream(certs).map(cert -> {
            String issuerDn = cert != null && cert.getIssuerX500Principal() != null ? cert.getIssuerX500Principal().getName() : "";
            String subjectDn = cert != null && cert.getSubjectX500Principal() != null ? cert.getSubjectX500Principal().getName() : "";
            String san = this.securityKeyStore.getSubjectAlternativeNames((X509Certificate)cert);
            String notBefore = cert != null && cert.getNotBefore() != null ? cert.getNotBefore().toInstant().toString() : "";
            String notAfter = cert != null && cert.getNotAfter() != null ? cert.getNotAfter().toInstant().toString() : "";
            return ImmutableMap.of((Object)"issuer_dn", (Object)issuerDn, (Object)"subject_dn", (Object)subjectDn, (Object)"san", (Object)san, (Object)"not_before", (Object)notBefore, (Object)"not_after", (Object)notAfter);
        }).collect(Collectors.toList());
    }

    private void noKeyStoreResponse(RestChannel channel) throws IOException {
        this.response(channel, RestStatus.OK, "keystore is not initialized");
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.SSL;
    }

    @Override
    public String getName() {
        return "SSL Certificates Action";
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... params) {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("certType");
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType getConfigName() {
        return null;
    }
}

