# _IsPrimeTestBuilder\[A: ([UnsignedInteger](builtin-UnsignedInteger.md)\[A\] val & ([U8](builtin-U8.md) val | [U16](builtin-U16.md) val | [U32](builtin-U32.md) val | [U64](builtin-U64.md) val | [U128](builtin-U128.md) val | [ULong](builtin-ULong.md) val | [USize](builtin-USize.md) val))\]
<span class="source-link">[[Source]](src/math/_test.md#L23)</span>

All integers (excluding 2 and 3), can be expressed as (6k + i),
where i = −1, 0, 1, 2, 3, or 4 and k is greater than 0.
Since 2 divides (6k + 0), (6k + 2),
and (6k + 4), while 3 divides (6k + 3) that leaves only (6k - 1) and (6k + 1)
for expressing primes.

Given the above, (6k + 0), (6k + 2), 6k + 4), (6k + 3) should always express composites.


```pony
primitive val _IsPrimeTestBuilder[A: (UnsignedInteger[A] val & (U8 val | U16 val | U32 val | 
    U64 val | U128 val | ULong val | 
    USize val))]
```

## Constructors

### create
<span class="source-link">[[Source]](src/math/_test.md#L23)</span>


```pony
new val create()
: _IsPrimeTestBuilder[A] val^
```

#### Returns

* [_IsPrimeTestBuilder](math-_IsPrimeTestBuilder.md)\[A\] val^

---

## Public Functions

### eq
<span class="source-link">[[Source]](src/math/_test.md#L33)</span>


```pony
fun box eq(
  that: _IsPrimeTestBuilder[A] val)
: Bool val
```
#### Parameters

*   that: [_IsPrimeTestBuilder](math-_IsPrimeTestBuilder.md)\[A\] val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/math/_test.md#L33)</span>


```pony
fun box ne(
  that: _IsPrimeTestBuilder[A] val)
: Bool val
```
#### Parameters

*   that: [_IsPrimeTestBuilder](math-_IsPrimeTestBuilder.md)\[A\] val

#### Returns

* [Bool](builtin-Bool.md) val

---

