# _ProcessClient
<span class="source-link">[[Source]](src/process/_test.md#L681)</span>

Notifications for Process connections.


```pony
class ref _ProcessClient is
  ProcessNotify ref
```

#### Implements

* [ProcessNotify](process-ProcessNotify.md) ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/process/_test.md#L695)</span>


```pony
new iso create(
  out: USize val,
  err: String val,
  exit_code: I32 val,
  h: TestHelper val,
  expected_err: (ProcessError val | None val) = reference)
: _ProcessClient iso^
```
#### Parameters

*   out: [USize](builtin-USize.md) val
*   err: [String](builtin-String.md) val
*   exit_code: [I32](builtin-I32.md) val
*   h: [TestHelper](ponytest-TestHelper.md) val
*   expected_err: ([ProcessError](process-ProcessError.md) val | [None](builtin-None.md) val) = reference

#### Returns

* [_ProcessClient](process-_ProcessClient.md) iso^

---

## Public Functions

### stdout
<span class="source-link">[[Source]](src/process/_test.md#L709)</span>


Called when new data is received on STDOUT of the forked process


```pony
fun ref stdout(
  process: ProcessMonitor ref,
  data: Array[U8 val] iso)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   data: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso

#### Returns

* [None](builtin-None.md) val

---

### stderr
<span class="source-link">[[Source]](src/process/_test.md#L725)</span>


Called when new data is received on STDERR of the forked process


```pony
fun ref stderr(
  process: ProcessMonitor ref,
  data: Array[U8 val] iso)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   data: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso

#### Returns

* [None](builtin-None.md) val

---

### failed
<span class="source-link">[[Source]](src/process/_test.md#L732)</span>


ProcessMonitor calls this if we run into errors with the
forked process.


```pony
fun ref failed(
  process: ProcessMonitor ref,
  actual: ProcessError val)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   actual: [ProcessError](process-ProcessError.md) val

#### Returns

* [None](builtin-None.md) val

---

### dispose
<span class="source-link">[[Source]](src/process/_test.md#L749)</span>


Called when ProcessMonitor terminates to cleanup ProcessNotify
We receive the exit code of the child process from ProcessMonitor.


```pony
fun ref dispose(
  process: ProcessMonitor ref,
  child_exit_status: (Exited val | Signaled val))
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   child_exit_status: ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val)

#### Returns

* [None](builtin-None.md) val

---

### created
<span class="source-link">[[Source]](src/process/process_notify.md#L6)</span>


```pony
fun ref created(
  process: ProcessMonitor ref)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref

#### Returns

* [None](builtin-None.md) val

---

### expect
<span class="source-link">[[Source]](src/process/process_notify.md#L29)</span>


```pony
fun ref expect(
  process: ProcessMonitor ref,
  qty: USize val)
: USize val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   qty: [USize](builtin-USize.md) val

#### Returns

* [USize](builtin-USize.md) val

---

