#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-1WYSShlQg4xDvXy0KRYErF
key:                  postgrest-10.0.0-1WYSShlQg4xDvXy0KRYErF
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  c418d630918f73724a265f2f49e344c3
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.0.2/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-1WYSShlQg4xDvXy0KRYErF
depends:
    HTTP-4000.4.1-CGMk1ujieP5JvNiGE0lpCE
    Ranged-sets-0.4.0-129hiQ3M4OoKpJzGcJ6oy4
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    auto-update-0.1.6-CUHow5dMgZ4JjwZuLH21Cr base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En
    bytestring-0.10.12.1 case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    cassava-0.5.3.0-DaeORGwa1jTJG3fJgGTNJD
    configurator-pg-0.2.7-GV8ZufUt1nNLwLE1WqQzdB containers-0.6.4.1
    contravariant-extras-0.3.5.3-LpchVnShsLR7WYk4qtOxKD
    cookie-0.4.6-AQamA5QJzxUGLdn7cmcakq directory-1.3.6.2
    either-5.0.2-JoRjkhpzqttAh5qInyhDDp
    gitrev-1.3.1-1rbGTqrAtYS9ErCWqXvHZK
    hasql-1.5.0.4-KdBVAxgAYR6G6If1ITuept
    hasql-dynamic-statements-0.3.1.1-IqiQGU8klRK2nenHm24kZM
    hasql-notifications-0.2.0.3-A4f22VZGsTb2XFdxdjBifv
    hasql-pool-0.5.2.2-3SSoi1jOIvhLgDbIqK9Vm2
    hasql-transaction-1.0.1.1-BqHpinGQPGZJuRb41Xa5eL
    heredoc-0.2.0.0-Vg50v7MniO6qfzQgR2euT
    http-types-0.12.3-GFhxs6XVQ6bETbOR4vEFmW
    insert-ordered-containers-0.2.5.3-fy1ZhoMisy8g1SG1UtVjf
    interpolatedstring-perl6-1.0.2-HKeHZ4b3cMJCn3YPIhABb3
    jose-0.10-8HTkw3tW38I5qgTiAz8vef lens-5.2.2-4uj1AepANiF2ook39zjsmk
    lens-aeson-1.2.3-LAy5cNRhydfRAdHw4Pw8O mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb parsec-3.1.14.0
    protolude-0.3.3-2V5ngX7wFCtAxkfsFeWf5o
    regex-tdfa-1.3.2.2-9R5AJXd71FKmHTeEzzCL9
    retry-0.9.3.1-KZXo7p1VLZ8IocFlJJiNuQ
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR
    swagger2-2.8.7-Cnq1cVZ6cc0KNRoae4I6Zw text-1.2.5.0 time-1.9.3
    unix-2.7.2.2 unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vault-0.3.1.5-KrUyCBjiBj452iqy9eE8Dc
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    wai-3.2.3-BDPWmqf0MooISXwouhUuyf
    wai-cors-0.2.7-AzQs3rH7mRFHrvnAE7oLty
    wai-extra-3.1.13.0-DO2SbcVgl4E2TEZUzH4p9Q
    wai-logger-2.4.0-4MFhd5ohqyW5mpqweZYimp
    warp-3.3.29-9OttiYt9mWD7bTfEHENUMa

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

