// !!! This is a file automatically generated by hipify!!!
#pragma once

#include <c10/core/ScalarType.h>

#include <hip/hip_runtime.h>
#include <hip/library_types.h>

namespace at {
namespace cuda {

template <typename scalar_t>
hipDataType getCudaDataType() {
  TORCH_INTERNAL_ASSERT(false, "Cannot convert type ", typeid(scalar_t).name(), " to hipDataType.")
}

template<> inline hipDataType getCudaDataType<at::Half>() {
  return HIP_R_16F;
}
template<> inline hipDataType getCudaDataType<float>() {
  return HIP_R_32F;
}
template<> inline hipDataType getCudaDataType<double>() {
  return HIP_R_64F;
}
template<> inline hipDataType getCudaDataType<c10::complex<c10::Half>>() {
  return HIP_C_16F;
}
template<> inline hipDataType getCudaDataType<c10::complex<float>>() {
  return HIP_C_32F;
}
template<> inline hipDataType getCudaDataType<c10::complex<double>>() {
  return HIP_C_64F;
}

// HIP doesn't define integral types
#ifndef USE_ROCM
template<> inline hipDataType getCudaDataType<uint8_t>() {
  return HIP_R_8U;
}
template<> inline hipDataType getCudaDataType<int8_t>() {
  return HIP_R_8I;
}
template<> inline hipDataType getCudaDataType<int>() {
  return HIP_R_32I;
}
#endif

#if !defined(USE_ROCM)
template<> inline hipDataType getCudaDataType<int16_t>() {
  return CUDA_R_16I;
}
template<> inline hipDataType getCudaDataType<int64_t>() {
  return CUDA_R_64I;
}
template<> inline hipDataType getCudaDataType<at::BFloat16>() {
  return CUDA_R_16BF;
}
#endif

inline hipDataType ScalarTypeToCudaDataType(const c10::ScalarType& scalar_type) {
  switch (scalar_type) {
// HIP doesn't define integral types
#ifndef USE_ROCM
    case c10::ScalarType::Byte:
      return HIP_R_8U;
    case c10::ScalarType::Char:
      return HIP_R_8I;
    case c10::ScalarType::Int:
      return HIP_R_32I;
#endif
    case c10::ScalarType::Half:
      return HIP_R_16F;
    case c10::ScalarType::Float:
      return HIP_R_32F;
    case c10::ScalarType::Double:
      return HIP_R_64F;
    case c10::ScalarType::ComplexHalf:
      return HIP_C_16F;
    case c10::ScalarType::ComplexFloat:
      return HIP_C_32F;
    case c10::ScalarType::ComplexDouble:
      return HIP_C_64F;
#if !defined(USE_ROCM)
    case c10::ScalarType::Short:
      return CUDA_R_16I;
    case c10::ScalarType::Long:
      return CUDA_R_64I;
    case c10::ScalarType::BFloat16:
      return CUDA_R_16BF;
#endif
    default:
      TORCH_INTERNAL_ASSERT(false, "Cannot convert ScalarType ", scalar_type, " to hipDataType.")
  }
}

} // namespace cuda
} // namespace at
