// !!! This is a file automatically generated by hipify!!!
#pragma once

#include <c10/hip/HIPStream.h>
#include <utility>

// HIP Graphs utils used by c10 and aten.
// aten/cuda/HIPGraphsUtils.cuh adds utils used by aten only.

namespace c10 {
namespace hip {

using CaptureId_t = unsigned long long;

// first is set if the instance is created by HIPGraph::capture_begin.
// second is set if the instance is created by at::cuda::graph_pool_handle.
using MempoolId_t = std::pair<CaptureId_t, CaptureId_t>;

// RAII guard for "hipStreamCaptureMode", a thread-local value
// that controls the error-checking strictness of a capture.
#if !defined(USE_ROCM) || ROCM_VERSION >= 50300
struct C10_HIP_API HIPStreamCaptureModeGuard {
  HIPStreamCaptureModeGuard(hipStreamCaptureMode desired) {
    strictness_ = desired;
    C10_HIP_CHECK(hipThreadExchangeStreamCaptureMode(&strictness_));
  }
  ~HIPStreamCaptureModeGuard() {
    C10_HIP_CHECK_WARN(hipThreadExchangeStreamCaptureMode(&strictness_));
  }

 private:
  hipStreamCaptureMode strictness_;
};
#endif

#if !defined(USE_ROCM) || ROCM_VERSION >= 50300
// Protects against enum hipStreamCaptureStatus implementation changes.
// Some compilers seem not to like static_assert without the messages.
static_assert(
    int(hipStreamCaptureStatus::hipStreamCaptureStatusNone) == 0,
    "unexpected int(hipStreamCaptureStatusNone) value");
static_assert(
    int(hipStreamCaptureStatus::hipStreamCaptureStatusActive) == 1,
    "unexpected int(hipStreamCaptureStatusActive) value");
static_assert(
    int(hipStreamCaptureStatus::hipStreamCaptureStatusInvalidated) == 2,
    "unexpected int(hipStreamCaptureStatusInvalidated) value");
#endif

enum class CaptureStatus : int {
#if !defined(USE_ROCM) || ROCM_VERSION >= 50300
  None = int(hipStreamCaptureStatus::hipStreamCaptureStatusNone),
  Active = int(hipStreamCaptureStatus::hipStreamCaptureStatusActive),
  Invalidated = int(hipStreamCaptureStatus::hipStreamCaptureStatusInvalidated)
#else
  None = 0
#endif
};

inline std::ostream& operator<<(std::ostream& os, CaptureStatus status) {
  switch (status) {
    case CaptureStatus::None:
      os << "hipStreamCaptureStatusNone";
      break;
#if !defined(USE_ROCM) || ROCM_VERSION >= 50300
    case CaptureStatus::Active:
      os << "hipStreamCaptureStatusActive";
      break;
    case CaptureStatus::Invalidated:
      os << "hipStreamCaptureStatusInvalidated";
      break;
#endif
    default:
      TORCH_INTERNAL_ASSERT(
          false, "Unknown HIP graph CaptureStatus", int(status));
  }
  return os;
}

// Use this version where you're sure a HIP context exists already.
inline CaptureStatus currentStreamCaptureStatusMayInitCtx() {
#if !defined(USE_ROCM) || ROCM_VERSION >= 50300
  hipStreamCaptureStatus is_capturing;
  C10_HIP_CHECK(
      hipStreamIsCapturing(c10::hip::getCurrentHIPStream(), &is_capturing));
  return CaptureStatus(is_capturing);
#else
  return CaptureStatus::None;
#endif
}

} // namespace hip
} // namespace c10
