// !!! This is a file automatically generated by hipify!!!
#pragma once

#include <c10/core/DeviceType.h>
#include <c10/core/impl/InlineDeviceGuard.h>
#include <c10/core/impl/InlineStreamGuard.h>
#include <c10/hip/HIPMacros.h>
#include <c10/hip/impl/HIPGuardImpl.h>

#include <cstddef>

namespace c10 {
namespace hip {

// This code is kind of boilerplatey.  See Note [Whither the DeviceGuard
// boilerplate]

/// A variant of DeviceGuard that is specialized for HIP.  It accepts
/// integer indices (interpreting them as HIP devices) and is a little
/// more efficient than DeviceGuard (it compiles to straight line
/// hipSetDevice/hipGetDevice calls); however, it can only be used
/// from code that links against HIP directly.
struct HIPGuard {
  /// No default constructor; see Note [Omitted default constructor from RAII]
  explicit HIPGuard() = delete;

  /// Set the current HIP device to the passed device index.
  explicit HIPGuard(DeviceIndex device_index) : guard_(device_index) {}

  /// Sets the current HIP device to the passed device.  Errors if the passed
  /// device is not a HIP device.
  explicit HIPGuard(Device device) : guard_(device) {}

  // Copy is not allowed
  HIPGuard(const HIPGuard&) = delete;
  HIPGuard& operator=(const HIPGuard&) = delete;

  // Move is not allowed (there is no uninitialized state)
  HIPGuard(HIPGuard&& other) = delete;
  HIPGuard& operator=(HIPGuard&& other) = delete;

  /// Sets the HIP device to the given device.  Errors if the given device
  /// is not a HIP device.
  void set_device(Device device) {
    guard_.set_device(device);
  }

  /// Sets the HIP device to the given device.  Errors if the given device
  /// is not a HIP device.  (This method is provided for uniformity with
  /// DeviceGuard).
  void reset_device(Device device) {
    guard_.reset_device(device);
  }

  /// Sets the HIP device to the given device index.
  void set_index(DeviceIndex device_index) {
    guard_.set_index(device_index);
  }

  /// Returns the device that was set upon construction of the guard
  Device original_device() const {
    return guard_.original_device();
  }

  /// Returns the last device that was set via `set_device`, if any, otherwise
  /// the device passed during construction.
  Device current_device() const {
    return guard_.current_device();
  }

 private:
  /// The guard for the current device.
  c10::impl::InlineDeviceGuard<impl::HIPGuardImpl> guard_;
};

/// A variant of OptionalDeviceGuard that is specialized for HIP.  See
/// HIPGuard for when you can use this.
struct OptionalHIPGuard {
  /// Create an uninitialized OptionalHIPGuard.
  explicit OptionalHIPGuard() : guard_() {}

  /// Set the current HIP device to the passed Device, if it is not nullopt.
  explicit OptionalHIPGuard(optional<Device> device_opt)
      : guard_(device_opt) {}

  /// Set the current HIP device to the passed device index, if it is not
  /// nullopt
  explicit OptionalHIPGuard(optional<DeviceIndex> device_index_opt)
      : guard_(device_index_opt) {}

  // Copy is not allowed
  OptionalHIPGuard(const OptionalHIPGuard&) = delete;
  OptionalHIPGuard& operator=(const OptionalHIPGuard&) = delete;

  // See Note [Move construction for RAII guards is tricky]
  OptionalHIPGuard(OptionalHIPGuard&& other) = delete;

  // See Note [Move assignment for RAII guards is tricky]
  OptionalHIPGuard& operator=(OptionalHIPGuard&& other) = delete;

  /// Sets the HIP device to the given device, initializing the guard if it
  /// is not already initialized.  Errors if the given device is not a HIP
  /// device.
  void set_device(Device device) {
    guard_.set_device(device);
  }

  /// Sets the HIP device to the given device, initializing the guard if it is
  /// not already initialized.  Errors if the given device is not a HIP device.
  /// (This method is provided for uniformity with OptionalDeviceGuard).
  void reset_device(Device device) {
    guard_.reset_device(device);
  }

  /// Sets the HIP device to the given device index, initializing the guard if
  /// it is not already initialized.
  void set_index(DeviceIndex device_index) {
    guard_.set_index(device_index);
  }

  /// Returns the device that was set immediately prior to initialization of the
  /// guard, or nullopt if the guard is uninitialized.
  optional<Device> original_device() const {
    return guard_.original_device();
  }

  /// Returns the most recent device that was set using this device guard,
  /// either from construction, or via set_device, if the guard is initialized,
  /// or nullopt if the guard is uninitialized.
  optional<Device> current_device() const {
    return guard_.current_device();
  }

  /// Restore the original HIP device, resetting this guard to uninitialized
  /// state.
  void reset() {
    guard_.reset();
  }

 private:
  c10::impl::InlineOptionalDeviceGuard<impl::HIPGuardImpl> guard_;
};

/// A variant of StreamGuard that is specialized for HIP.  See HIPGuard
/// for when you can use this.
struct HIPStreamGuard {
  /// No default constructor, see Note [Omitted default constructor from RAII]
  explicit HIPStreamGuard() = delete;

  /// Set the current HIP device to the device associated with the passed
  /// stream, and set the current HIP stream on that device to the passed
  /// stream. Errors if the Stream is not a HIP stream.
  explicit HIPStreamGuard(Stream stream) : guard_(stream) {}

  /// Copy is disallowed
  HIPStreamGuard(const HIPStreamGuard&) = delete;
  HIPStreamGuard& operator=(const HIPStreamGuard&) = delete;

  /// Move is disallowed, as HIPStreamGuard does not have an uninitialized
  /// state, which is required for moves on types with nontrivial destructors.
  HIPStreamGuard(HIPStreamGuard&& other) = delete;
  HIPStreamGuard& operator=(HIPStreamGuard&& other) = delete;

  /// Resets the currently set stream to the original stream and
  /// the currently set device to the original device.  Then,
  /// set the current device to the device associated with the passed stream,
  /// and set the current stream on that device to the passed stream.
  /// Errors if the stream passed is not a HIP stream.
  ///
  /// NOTE: this implementation may skip some stream/device setting if
  /// it can prove that it is unnecessary.
  ///
  /// WARNING: reset_stream does NOT preserve previously set streams on
  /// different devices.  If you need to set streams on multiple devices
  /// on HIP, use HIPMultiStreamGuard instead.
  void reset_stream(Stream stream) {
    guard_.reset_stream(stream);
  }

  /// Returns the HIP stream that was set at the time the guard was
  /// constructed.
  HIPStream original_stream() const {
    return HIPStream(HIPStream::UNCHECKED, guard_.original_stream());
  }

  /// Returns the most recent HIP stream that was set using this device guard,
  /// either from construction, or via set_stream.
  HIPStream current_stream() const {
    return HIPStream(HIPStream::UNCHECKED, guard_.current_stream());
  }

  /// Returns the most recent HIP device that was set using this device guard,
  /// either from construction, or via set_device/reset_device/set_index.
  Device current_device() const {
    return guard_.current_device();
  }

  /// Returns the HIP device that was set at the most recent reset_stream(),
  /// or otherwise the device at construction time.
  Device original_device() const {
    return guard_.original_device();
  }

 private:
  c10::impl::InlineStreamGuard<impl::HIPGuardImpl> guard_;
};

/// A variant of OptionalStreamGuard that is specialized for HIP.  See
/// HIPGuard for when you can use this.
struct OptionalHIPStreamGuard {
  /// Create an uninitialized guard.
  explicit OptionalHIPStreamGuard() : guard_() {}

  /// Set the current HIP device to the device associated with the passed
  /// stream, and set the current HIP stream on that device to the passed
  /// stream. Errors if the Stream is not a HIP stream.
  explicit OptionalHIPStreamGuard(Stream stream) : guard_(stream) {}

  /// Set the current device to the device associated with the passed stream,
  /// and set the current stream on that device to the passed stream,
  /// if the passed stream is not nullopt.
  explicit OptionalHIPStreamGuard(optional<Stream> stream_opt)
      : guard_(stream_opt) {}

  /// Copy is disallowed
  OptionalHIPStreamGuard(const OptionalHIPStreamGuard&) = delete;
  OptionalHIPStreamGuard& operator=(const OptionalHIPStreamGuard&) = delete;

  // See Note [Move construction for RAII guards is tricky]
  OptionalHIPStreamGuard(OptionalHIPStreamGuard&& other) = delete;

  // See Note [Move assignment for RAII guards is tricky]
  OptionalHIPStreamGuard& operator=(OptionalHIPStreamGuard&& other) = delete;

  /// Resets the currently set HIP stream to the original stream and
  /// the currently set device to the original device.  Then,
  /// set the current device to the device associated with the passed stream,
  /// and set the current stream on that device to the passed stream.
  /// Initializes the guard if it was not previously initialized.
  void reset_stream(Stream stream) {
    guard_.reset_stream(stream);
  }

  /// Returns the HIP stream that was set at the time the guard was most
  /// recently initialized, or nullopt if the guard is uninitialized.
  optional<HIPStream> original_stream() const {
    auto r = guard_.original_stream();
    if (r.has_value()) {
      return make_optional(HIPStream(HIPStream::UNCHECKED, r.value()));
    } else {
      return nullopt;
    }
  }

  /// Returns the most recent HIP stream that was set using this stream guard,
  /// either from construction, or via reset_stream, if the guard is
  /// initialized, or nullopt if the guard is uninitialized.
  optional<HIPStream> current_stream() const {
    auto r = guard_.current_stream();
    if (r.has_value()) {
      return make_optional(HIPStream(HIPStream::UNCHECKED, r.value()));
    } else {
      return nullopt;
    }
  }

  /// Restore the original HIP device and stream, resetting this guard to
  /// uninitialized state.
  void reset() {
    guard_.reset();
  }

 private:
  c10::impl::InlineOptionalStreamGuard<impl::HIPGuardImpl> guard_;
};

/// A variant of MultiStreamGuard that is specialized for HIP.
struct HIPMultiStreamGuard {
  explicit HIPMultiStreamGuard(ArrayRef<HIPStream> streams)
      : guard_(unwrapStreams(streams)) {}

  /// Copy is disallowed
  HIPMultiStreamGuard(const HIPMultiStreamGuard&) = delete;
  HIPMultiStreamGuard& operator=(const HIPMultiStreamGuard&) = delete;

  // See Note [Move construction for RAII guards is tricky]
  HIPMultiStreamGuard(HIPMultiStreamGuard&& other) = delete;

  // See Note [Move assignment for RAII guards is tricky]
  HIPMultiStreamGuard& operator=(HIPMultiStreamGuard&& other) = delete;

 private:
  c10::impl::InlineMultiStreamGuard<impl::HIPGuardImpl> guard_;

  static std::vector<Stream> unwrapStreams(ArrayRef<HIPStream> cudaStreams) {
    std::vector<Stream> streams;
    streams.reserve(cudaStreams.size());
    for (const HIPStream& cudaStream : cudaStreams) {
      streams.push_back(cudaStream);
    }
    return streams;
  }
};

} // namespace hip
} // namespace c10
