# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .wl_keyboard import WlKeyboard
from .wl_pointer import WlPointer
from .wl_touch import WlTouch


class WlSeat(Interface):
    """Group of input devices

    A seat is a group of keyboards, pointer and touch devices. This object is
    published as a global during start up, or when such a device is hot
    plugged.  A seat typically has a pointer and maintains a keyboard focus and
    a pointer focus.
    """

    name = "wl_seat"
    version = 8

    class capability(enum.IntFlag):
        pointer = 1
        keyboard = 2
        touch = 4

    class error(enum.IntEnum):
        missing_capability = 0


class WlSeatProxy(Proxy[WlSeat]):
    interface = WlSeat

    @WlSeat.request(
        Argument(ArgumentType.NewId, interface=WlPointer),
    )
    def get_pointer(self) -> Proxy[WlPointer]:
        """Return pointer object

        The ID provided will be initialized to the
        :class:`~pywayland.protocol.wayland.WlPointer` interface for this seat.

        This request only takes effect if the seat has the pointer capability,
        or has had the pointer capability in the past. It is a protocol
        violation to issue this request on a seat that has never had the
        pointer capability. The missing_capability error will be sent in this
        case.

        :returns:
            :class:`~pywayland.protocol.wayland.WlPointer` -- seat pointer
        """
        id = self._marshal_constructor(0, WlPointer)
        return id

    @WlSeat.request(
        Argument(ArgumentType.NewId, interface=WlKeyboard),
    )
    def get_keyboard(self) -> Proxy[WlKeyboard]:
        """Return keyboard object

        The ID provided will be initialized to the
        :class:`~pywayland.protocol.wayland.WlKeyboard` interface for this
        seat.

        This request only takes effect if the seat has the keyboard capability,
        or has had the keyboard capability in the past. It is a protocol
        violation to issue this request on a seat that has never had the
        keyboard capability. The missing_capability error will be sent in this
        case.

        :returns:
            :class:`~pywayland.protocol.wayland.WlKeyboard` -- seat keyboard
        """
        id = self._marshal_constructor(1, WlKeyboard)
        return id

    @WlSeat.request(
        Argument(ArgumentType.NewId, interface=WlTouch),
    )
    def get_touch(self) -> Proxy[WlTouch]:
        """Return touch object

        The ID provided will be initialized to the
        :class:`~pywayland.protocol.wayland.WlTouch` interface for this seat.

        This request only takes effect if the seat has the touch capability, or
        has had the touch capability in the past. It is a protocol violation to
        issue this request on a seat that has never had the touch capability.
        The missing_capability error will be sent in this case.

        :returns:
            :class:`~pywayland.protocol.wayland.WlTouch` -- seat touch
            interface
        """
        id = self._marshal_constructor(2, WlTouch)
        return id

    @WlSeat.request(version=5)
    def release(self) -> None:
        """Release the seat object

        Using this request a client can tell the server that it is not going to
        use the seat object anymore.
        """
        self._marshal(3)
        self._destroy()


class WlSeatResource(Resource):
    interface = WlSeat

    @WlSeat.event(
        Argument(ArgumentType.Uint),
    )
    def capabilities(self, capabilities: int) -> None:
        """Seat capabilities changed

        This is emitted whenever a seat gains or loses the pointer, keyboard or
        touch capabilities.  The argument is a capability enum containing the
        complete set of capabilities this seat has.

        When the pointer capability is added, a client may create a
        :class:`~pywayland.protocol.wayland.WlPointer` object using the
        :func:`WlSeat.get_pointer()` request. This object will receive pointer
        events until the capability is removed in the future.

        When the pointer capability is removed, a client should destroy the
        :class:`~pywayland.protocol.wayland.WlPointer` objects associated with
        the seat where the capability was removed, using the
        :func:`WlPointer.release()
        <pywayland.protocol.wayland.WlPointer.release>` request. No further
        pointer events will be received on these objects.

        In some compositors, if a seat regains the pointer capability and a
        client has a previously obtained
        :class:`~pywayland.protocol.wayland.WlPointer` object of version 4 or
        less, that object may start sending pointer events again. This behavior
        is considered a misinterpretation of the intended behavior and must not
        be relied upon by the client.
        :class:`~pywayland.protocol.wayland.WlPointer` objects of version 5 or
        later must not send events if created before the most recent event
        notifying the client of an added pointer capability.

        The above behavior also applies to
        :class:`~pywayland.protocol.wayland.WlKeyboard` and
        :class:`~pywayland.protocol.wayland.WlTouch` with the keyboard and
        touch capabilities, respectively.

        :param capabilities:
            capabilities of the seat
        :type capabilities:
            `ArgumentType.Uint`
        """
        self._post_event(0, capabilities)

    @WlSeat.event(
        Argument(ArgumentType.String),
        version=2,
    )
    def name(self, name: str) -> None:
        """Unique identifier for this seat

        In a multi-seat configuration the seat name can be used by clients to
        help identify which physical devices the seat represents.

        The seat name is a UTF-8 string with no convention defined for its
        contents. Each name is unique among all :class:`WlSeat` globals. The
        name is only guaranteed to be unique for the current compositor
        instance.

        The same seat names are used for all clients. Thus, the name can be
        shared across processes to refer to a specific :class:`WlSeat` global.

        The name event is sent after binding to the seat global. This event is
        only sent once per seat object, and the name does not change over the
        lifetime of the :class:`WlSeat` global.

        Compositors may re-use the same seat name if the :class:`WlSeat` global
        is destroyed and re-created later.

        :param name:
            seat identifier
        :type name:
            `ArgumentType.String`
        """
        self._post_event(1, name)


class WlSeatGlobal(Global):
    interface = WlSeat


WlSeat._gen_c()
WlSeat.proxy_class = WlSeatProxy
WlSeat.resource_class = WlSeatResource
WlSeat.global_class = WlSeatGlobal
