5051
((3) 0 () 15 ((q lib "file/gif.rkt") (q lib "file/tar.rkt") (q 14583 . 8) (q lib "file/ico.rkt") (q lib "file/unzip.rkt") (q lib "file/zip.rkt") (q 11451 . 4) (q lib "file/gzip.rkt") (q lib "file/convertible.rkt") (q lib "file/untar.rkt") (q lib "file/sha1.rkt") (q lib "file/cache.rkt") (q lib "file/glob.rkt") (q lib "file/resource.rkt") (q lib "file/gunzip.rkt")) () (h ! (equal) ((c def c (c (? . 3) q png-bytes->ico)) q (21462 . 3)) ((c def c (c (? . 0) q dimension?)) q (18190 . 3)) ((c def c (c (? . 0) q empty-gif-stream?)) q (18016 . 3)) ((c def c (c (? . 5) q zip->output)) q (6055 . 21)) ((c def c (c (? . 1) q tar-entry-attribs)) c (? . 2)) ((c def c (c (? . 1) q tar-entry-content)) c (? . 2)) ((c def c (c (? . 10) q sha1)) q (17285 . 5)) ((c def c (c (? . 1) q tar-entry-kind)) c (? . 2)) ((c def c (c (? . 3) q replace-icos)) q (20901 . 4)) ((c def c (c (? . 0) q gif-start)) q (18316 . 7)) ((c def c (c (? . 0) q gif-add-control)) q (19049 . 11)) ((c def c (c (? . 1) q tar-gzip)) q (13619 . 20)) ((c def c (c (? . 4) q path->zip-path)) q (11380 . 3)) ((c def c (c (? . 4) q zip-directory-contains?)) q (9603 . 4)) ((c def c (c (? . 3) q ico?)) q (20042 . 3)) ((c def c (c (? . 1) q tar-entry-size)) c (? . 2)) ((c def c (c (? . 4) q make-filesystem-entry-reader)) q (8652 . 13)) ((q def ((lib "file/untgz.rkt") untgz)) q (16464 . 16)) ((c def c (c (? . 8) q prop:convertible)) q (0 . 41)) ((c def c (c (? . 1) q tar->output)) q (12604 . 21)) ((c def c (c (? . 1) q tar)) q (11605 . 23)) ((c def c (c (? . 3) q replace-all-icos)) q (21003 . 4)) ((c def c (c (? . 3) q ico-format)) q (20323 . 3)) ((c def c (c (? . 13) q write-resource)) q (22053 . 14)) ((c def c (c (? . 12) q glob/c)) q (24633 . 2)) ((c def c (c (? . 0) q gif-add-loop-control)) q (19489 . 4)) ((c def c (c (? . 4) q zip-directory-includes-directory?)) q (9739 . 5)) ((c def c (c (? . 4) q read-zip-directory)) q (9349 . 3)) ((c def c (c (? . 5) q zip-verbose)) q (7128 . 4)) ((c def c (c (? . 3) q ico->png-bytes)) q (21187 . 3)) ((c def c (c (? . 4) q exn:fail:unzip:no-such-entry)) c (? . 6)) ((c def c (c (? . 0) q gif-end)) q (19737 . 3)) ((c def c (c (? . 3) q read-icos-from-exe)) q (20485 . 3)) ((c def c (c (? . 0) q gif-stream?)) q (17810 . 3)) ((c def c (c (? . 1) q struct:tar-entry)) c (? . 2)) ((c def c (c (? . 4) q call-with-unzip)) q (8356 . 7)) ((c def c (c (? . 4) q make-exn:fail:unzip:no-such-entry)) c (? . 6)) ((c def c (c (? . 7) q gzip)) q (3930 . 5)) ((c def c (c (? . 7) q gzip-through-ports)) q (4098 . 9)) ((c def c (c (? . 0) q image-or-control-ready-gif-stream?)) q (17936 . 3)) ((c def c (c (? . 8) q convertible?)) q (2185 . 3)) ((c def c (c (? . 9) q untar)) q (14944 . 24)) ((c def c (c (? . 9) q handle-tar-entry)) q (16033 . 11)) ((c def c (c (? . 7) q deflate)) q (4417 . 6)) ((c def c (c (? . 3) q write-icos)) q (20587 . 7)) ((c def c (c (? . 4) q unzip-entry)) q (9931 . 25)) ((c def c (c (? . 0) q gif-add-image)) q (18512 . 17)) ((c def c (c (? . 11) q cache-file)) q (22713 . 28)) ((c def c (c (? . 4) q exn:fail:unzip:no-such-entry-entry)) c (? . 6)) ((c def c (c (? . 14) q inflate)) q (4943 . 4)) ((c def c (c (? . 1) q tar-entry-path)) c (? . 2)) ((c def c (c (? . 3) q ico->argb)) q (21131 . 3)) ((c def c (c (? . 4) q zip-directory?)) q (9449 . 3)) ((c def c (c (? . 10) q hex-string->bytes)) q (17743 . 3)) ((c def c (c (? . 3) q ico-width)) q (20092 . 3)) ((c def c (c (? . 11) q cache-remove)) q (24109 . 11)) ((c def c (c (? . 3) q ico-depth)) q (20239 . 3)) ((c def c (c (? . 12) q in-glob)) q (24927 . 6)) ((c def c (c (? . 3) q ico-height)) q (20165 . 3)) ((c def c (c (? . 1) q tar-entry?)) c (? . 2)) ((q def ((lib "file/md5.rkt") md5)) q (17154 . 4)) ((c def c (c (? . 13) q get-resource)) q (21525 . 14)) ((c def c (c (? . 14) q gunzip-through-ports)) q (4842 . 4)) ((c def c (c (? . 4) q call-with-unzip-entry)) q (11211 . 5)) ((c def c (c (? . 8) q convert)) q (2243 . 41)) ((c def c (c (? . 5) q zip)) q (5031 . 20)) ((c def c (c (? . 0) q image-ready-gif-stream?)) q (17867 . 3)) ((c def c (c (? . 10) q bytes->hex-string)) q (17674 . 3)) ((c def c (c (? . 4) q unzip)) q (7214 . 22)) ((c def c (c (? . 1) q make-tar-entry)) c (? . 2)) ((c def c (c (? . 4) q struct:exn:fail:unzip:no-such-entry)) c (? . 6)) ((c def c (c (? . 12) q glob-match?)) q (25165 . 7)) ((c def c (c (? . 12) q glob)) q (24699 . 6)) ((c def c (c (? . 3) q read-icos)) q (20392 . 3)) ((c def c (c (? . 0) q gif-add-comment)) q (19614 . 4)) ((c def c (c (? . 0) q quantize)) q (19826 . 5)) ((c def c (c (? . 0) q gif-colormap?)) q (18079 . 3)) ((c def c (c (? . 12) q glob-quote)) q (25488 . 5)) ((c def c (c (? . 4) q zip-directory-entries)) q (9509 . 3)) ((c def c (c (? . 1) q tar-entry)) c (? . 2)) ((c def c (c (? . 12) q glob-capture-dotfiles?)) q (25598 . 5)) ((c def c (c (? . 0) q gif-state)) q (18246 . 3)) ((c def c (c (? . 3) q argb->ico)) q (21248 . 6)) ((c def c (c (? . 14) q gunzip)) q (4620 . 5)) ((c def c (c (? . 4) q exn:fail:unzip:no-such-entry?)) c (? . 6)) ((c def c (c (? . 0) q color?)) q (18138 . 3))))
value
prop:convertible
 : (struct-type-property/c
    (->i ([v convertible?] [request symbol?] [default default/c])
         [result
          (case request
            [(text)
             (or/c string? default/c)]
            [(gif-bytes
              png-bytes
              png@2x-bytes
              ps-bytes
              eps-bytes
              pdf-bytes
              svg-bytes)
             (or/c bytes? default/c)]
            [(png-bytes+bounds
              png@2x-bytes+bounds
              eps-bytes+bounds
              pdf-bytes+bounds)
             (or/c (list/c bytes?
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?)))
                   default/c)]
            [(png-bytes+bounds8
              png@2x-bytes+bounds8
              eps-bytes+bounds8
              pdf-bytes+bounds8)
             (or/c (list/c bytes?
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?))
                           (and/c real? (not/c negative?)))
                   default/c)]
            [else (or/c opaque-default/c any/c)])]))
procedure
(convertible? v) -> boolean?
  v : any/c
procedure
(convert v request [default])
 -> (case request
      [(text)
       (or/c string? default/c)]
      [(gif-bytes
        png-bytes
        png@2x-bytes
        ps-bytes
        eps-bytes
        pdf-bytes
        svg-bytes)
       (or/c bytes? default/c)]
      [(png-bytes+bounds
        png@2x-bytes+bounds
        eps-bytes+bounds
        pdf-bytes+bounds)
       (or/c (list/c bytes?
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?)))
             default/c)]
      [(png-bytes+bounds8
        png@2x-bytes+bounds8
        eps-bytes+bounds8
        pdf-bytes+bounds8)
       (or/c (list/c bytes?
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?))
                     (and/c real? (not/c negative?)))
             default/c)]
      [else (or/c opaque-default/c any/c)])
  v : convertible?
  request : symbol?
  default : any/c = #f
procedure
(gzip in-file [out-file]) -> void?
  in-file : path-string?
  out-file : path-string?
           = (path-add-extension in-file ".gz" #".")
procedure
(gzip-through-ports in                
                    out               
                    orig-filename     
                    timestamp)    -> void?
  in : input-port?
  out : output-port?
  orig-filename : (or/c string? false/c)
  timestamp : exact-integer?
procedure
(deflate in out) -> exact-nonnegative-integer?
                    exact-nonnegative-integer?
                    exact-nonnegative-integer?
  in : input-port?
  out : output-port?
procedure
(gunzip file [output-name-filter]) -> void?
  file : path-string?
  output-name-filter : (string? boolean? . -> . path-string?)
                     = (lambda (file archive-supplied?) file)
procedure
(gunzip-through-ports in out) -> void?
  in : input-port?
  out : output-port?
procedure
(inflate in out) -> void?
  in : input-port?
  out : output-port?
procedure
(zip  zip-file                                            
      path ...                                            
     [#:timestamp timestamp                               
      #:get-timestamp get-timestamp                       
      #:utc-timestamps? utc-timestamps?                   
      #:round-timestamps-down? round-timestamps-down?     
      #:path-prefix path-prefix                           
      #:system-type sys-type])                        -> void?
  zip-file : path-string?
  path : path-string?
  timestamp : (or/c #f exact-integer?) = #f
  get-timestamp : (path? . -> . exact-integer?)
                = (if timestamp
                      (lambda (p) timestamp)
                      file-or-directory-modify-seconds)
  utc-timestamps? : any/c = #f
  round-timestamps-down? : any/c = #f
  path-prefix : (or/c #f path-string?) = #f
  sys-type : symbol? = (system-type)
procedure
(zip->output  paths                                           
             [out                                             
              #:timestamp timestamp                           
              #:get-timestamp get-timestamp                   
              #:utc-timestamps? utc-timestamps?               
              #:round-timestamps-down? round-timestamps-down? 
              #:path-prefix path-prefix                       
              #:system-type sys-type])                        
 -> void?
  paths : (listof path-string?)
  out : output-port? = (current-output-port)
  timestamp : (or/c #f exact-integer?) = #f
  get-timestamp : (path? . -> . exact-integer?)
                = (if timestamp
                      (lambda (p) timestamp)
                      file-or-directory-modify-seconds)
  utc-timestamps? : any/c = #f
  round-timestamps-down? : any/c = #f
  path-prefix : (or/c #f path-string?) = #f
  sys-type : symbol? = (system-type)
parameter
(zip-verbose) -> boolean?
(zip-verbose on?) -> void?
  on? : any/c
procedure
(unzip  in                                              
       [entry-reader                                    
        #:must-unzip? must-unzip?                       
        #:preserve-attributes? preserve-attributes?     
        #:preserve-timestamps? preserve-timestamps?     
        #:utc-timestamps? utc-timestamps?])         -> void?
  in : (or/c path-string? input-port?)
  entry-reader : (cond
                   [preserve-attributes?
                    (bytes? boolean? input-port? (and/c hash? immutable?)
                            . -> . any)]
                   [preserve-timestamps?
                    (bytes? boolean? input-port? (or/c #f exact-integer?)
                            . -> . (or/c #f (-> any)))]
                   [else
                    (bytes? boolean? input-port? . -> . any)])
               = (make-filesystem-entry-reader)
  must-unzip? : any/c = #t
  preserve-attributes? : any/c = #f
  preserve-timestamps? : any/c = #f
  utc-timestamps? : any/c = #f
procedure
(call-with-unzip  in                              
                  proc                            
                 [#:must-unzip? must-unzip?]) -> any
  in : (or/c path-string? input-port?)
  proc : (-> path-string? any)
  must-unzip? : any/c = #t
procedure
(make-filesystem-entry-reader [#:dest dest-path          
                               #:strip-count strip-count 
                               #:permissive? permissive? 
                               #:exists exists])         
 -> ((bytes? boolean? input-port?) ((or/c hash? #f exact-integer?))
     . ->* . (or/c void? #f (-> void?)))
  dest-path : (or/c path-string? #f) = #f
  strip-count : exact-nonnegative-integer? = 0
  permissive? : any/c = #f
  exists : (or/c 'skip 'error 'replace 'truncate   = 'error
                 'truncate/replace 'append 'update
                 'can-update 'must-truncate)
procedure
(read-zip-directory in) -> zip-directory?
  in : (or/c path-string? input-port?)
procedure
(zip-directory? v) -> boolean?
  v : any/c
procedure
(zip-directory-entries zipdir) -> (listof bytes?)
  zipdir : zip-directory?
procedure
(zip-directory-contains? zipdir name) -> boolean?
  zipdir : zip-directory?
  name : (or/c bytes? path-string?)
procedure
(zip-directory-includes-directory? zipdir     
                                   name)  -> boolean?
  zipdir : zip-directory?
  name : (or/c bytes? path-string?)
procedure
(unzip-entry  in                                          
              zipdir                                      
              entry                                       
             [entry-reader                                
              #:preserve-attributes? preserve-attributes? 
              #:preserve-timestamps? preserve-timestamps? 
              #:utc-timestamps? utc-timestamps?])         
 -> (if preserve-attributes? void? (or/c #f (-> any)))
  in : (or/c path-string? input-port?)
  zipdir : zip-directory?
  entry : (or/c bytes? path-string?)
  entry-reader : (cond
                   [preserve-attributes?
                    (bytes? boolean? input-port? (and/c hash? immutable?)
                            . -> . any)]
                   [preserve-timestamps?
                    (bytes? boolean? input-port? (or/c #f exact-integer?)
                            . -> . any)]
                   [else
                    (bytes? boolean? input-port? . -> . any)])
               = (make-filesystem-entry-reader)
  preserve-attributes? : any/c = #f
  preserve-timestamps? : any/c = #f
  utc-timestamps? : any/c = #f
procedure
(call-with-unzip-entry in entry proc) -> any
  in : (or/c path-string? input-port?)
  entry : path-string?
  proc : (-> path-string? any)
procedure
(path->zip-path path) -> bytes?
  path : path-string?
struct
(struct exn:fail:unzip:no-such-entry exn:fail (entry)
    #:extra-constructor-name make-exn:fail:unzip:no-such-entry)
  entry : bytes?
procedure
(tar  tar-file                        
      path-or-entry ...               
     [#:follow-links? follow-links?   
      #:exists-ok? exists-ok?         
      #:format format                 
      #:path-prefix path-prefix       
      #:path-filter path-filter       
      #:timestamp timestamp           
      #:get-timestamp get-timestamp]) 
 -> exact-nonnegative-integer?
  tar-file : path-string?
  path-or-entry : (or/c path-string? tar-entry?)
  follow-links? : any/c = #f
  exists-ok? : any/c = #f
  format : (or/c 'pax 'gnu 'ustar) = 'pax
  path-prefix : (or/c #f path-string?) = #f
  path-filter : (or/c #f (path? . -> . any/c)) = #f
  timestamp : (or/c #f exact-integer?) = #f
  get-timestamp : (path? . -> . exact-integer?)
                = (if timestamp
                      (lambda (p) timestamp)
                      file-or-directory-modify-seconds)
procedure
(tar->output  paths-and-entries               
             [out                             
              #:follow-links? follow-links?   
              #:format format                 
              #:path-prefix path-prefix       
              #:path-filter path-filter       
              #:timestamp timestamp           
              #:get-timestamp get-timestamp]) 
 -> exact-nonnegative-integer?
  paths-and-entries : (listof (or/c path? tar-entry?))
  out : output-port? = (current-output-port)
  follow-links? : any/c = #f
  format : (or/c 'pax 'gnu 'ustar) = 'pax
  path-prefix : (or/c #f path-string?) = #f
  path-filter : (or/c #f (path? . -> . any/c)) = #f
  timestamp : (or/c #f exact-integer?) = #f
  get-timestamp : (path? . -> . exact-integer?)
                = (if timestamp
                      (lambda (p) timestamp)
                      file-or-directory-modify-seconds)
procedure
(tar-gzip  tar-file                            
           paths-and-entries ...               
          [#:follow-links? follow-links?       
           #:exists-ok? exists-ok?             
           #:format format                     
           #:path-prefix path-prefix           
           #:timestamp timestamp               
           #:get-timestamp get-timestamp]) -> void?
  tar-file : path-string?
  paths-and-entries : (and/c path-string? tar-entry?)
  follow-links? : any/c = #f
  exists-ok? : any/c = #f
  format : (or/c 'pax 'gnu 'ustar) = 'pax
  path-prefix : (or/c #f path-string?) = #f
  timestamp : (or/c #f exact-integer?) = #f
  get-timestamp : (path? . -> . exact-integer?)
                = (if timestamp
                      (lambda (p) timestamp)
                      file-or-directory-modify-seconds)
struct
(struct tar-entry (kind path content size attribs)
    #:extra-constructor-name make-tar-entry)
  kind : (or/c 'file 'directory 'link)
  path : (and/c path-string? relative-path?)
  content : (or/c input-port? (-> input-port?) #f path-string?)
  size : exact-nonnegative-integer?
  attribs : (hash/c symbol? any/c)
procedure
(untar  in                                
       [#:dest dest-path                  
        #:strip-count strip-count         
        #:permissive? permissive?         
        #:filter filter-proc              
        #:handle-entry handle-entry]) -> void?
  in : (or/c path-string? input-port?)
  dest-path : (or/c path-string? #f) = #f
  strip-count : exact-nonnegative-integer? = 0
  permissive? : any/c = #f
  filter-proc : (path? (or/c path? #f)
                 symbol? exact-integer? (or/c path? #f)
                 exact-nonnegative-integer?
                 exact-nonnegative-integer?
                 . -> . any/c)
              = (lambda args #t)
  handle-entry : ((or/c 'file 'directory 'link)
                  (and path? relative-path?)
                  (or/c input-port? #f path?)
                  exact-nonnegative-integer?
                  (hash/c symbol? any/c)
                  . -> . (listof (-> any)))
               = handle-tar-entry
procedure
(handle-tar-entry kind         
                  path         
                  content      
                  size         
                  attribs) -> (listof (-> any))
  kind : (or/c 'file 'directory 'link)
  path : (and path? relative-path?)
  content : (or/c input-port? #f path?)
  size : exact-nonnegative-integer?
  attribs : (hash/c symbol? any/c)
procedure
(untgz  in                            
       [#:dest dest-path              
        #:strip-count strip-count     
        #:permissive? permissive?     
        #:filter filter-proc])    -> void?
  in : (or/c path-string? input-port?)
  dest-path : (or/c path-string? #f) = #f
  strip-count : exact-nonnegative-integer? = 0
  permissive? : any/c = #f
  filter-proc : (path? (or/c path? #f)
                 symbol? exact-integer? (or/c path? #f)
                 exact-nonnegative-integer?
                 exact-nonnegative-integer?
                 . -> . any/c)
              = (lambda args #t)
procedure
(md5 in [hex-encode?]) -> bytes?
  in : (or/c input-port? bytes? string?)
  hex-encode? : boolean? = #t
procedure
(sha1 in [start end]) -> string?
  in : (or/c bytes? input-port?)
  start : exact-nonnegative-integer? = 0
  end : (or/c #f exact-nonnegative-integer?) = #f
procedure
(sha1-bytes in [start end]) -> bytes?
  in : (or/c bytes? input-port?)
  start : exact-nonnegative-integer? = 0
  end : (or/c #f exact-nonnegative-integer?) = #f
procedure
(bytes->hex-string bstr) -> string?
  bstr : bytes?
procedure
(hex-string->bytes str) -> bytes?
  str : string?
procedure
(gif-stream? v) -> boolean?
  v : any/c
procedure
(image-ready-gif-stream? v) -> boolean?
  v : any/c
procedure
(image-or-control-ready-gif-stream? v) -> boolean?
  v : any/c
procedure
(empty-gif-stream? v) -> boolean?
  v : any/c
procedure
(gif-colormap? v) -> boolean?
  v : any/c
procedure
(color? v) -> boolean?
  v : any/c
procedure
(dimension? v) -> boolean?
  v : any/c
procedure
(gif-state stream) -> symbol?
  stream : gif-stream?
procedure
(gif-start out w h bg-color cmap) -> gif-stream?
  out : output-port?
  w : dimension?
  h : dimension?
  bg-color : color?
  cmap : (or/c gif-colormap? #f)
procedure
(gif-add-image stream          
               left            
               top             
               width           
               height          
               interlaced?     
               cmap            
               bstr)       -> void?
  stream : image-ready-gif-stream?
  left : dimension?
  top : dimension?
  width : dimension?
  height : dimension?
  interlaced? : any/c
  cmap : (or/c gif-colormap? #f)
  bstr : bytes?
procedure
(gif-add-control stream              
                 disposal            
                 wait-for-input?     
                 delay               
                 transparent)    -> void?
  stream : image-or-control-ready-gif-stream?
  disposal : (or/c 'any 'keep 'restore-bg 'restore-prev)
  wait-for-input? : any/c
  delay : dimension?
  transparent : (or/c color? #f)
procedure
(gif-add-loop-control stream iteration) -> void?
  stream : empty-gif-stream?
  iteration : dimension?
procedure
(gif-add-comment stream bstr) -> void?
  stream : image-or-control-ready-gif-stream?
  bstr : bytes?
procedure
(gif-end stream) -> void?
  stream : image-or-control-ready-gif-stream?
procedure
(quantize bstr) -> bytes? gif-colormap? (or/c color? #f)
  bstr : (and/c bytes?
                (lambda (bstr)
                  (zero? (remainder (bytes-length bstr) 4))))
procedure
(ico? v) -> boolean?
  v : any/c
procedure
(ico-width ico) -> exact-positive-integer?
  ico : ico?
procedure
(ico-height ico) -> exact-positive-integer?
  ico : ico?
procedure
(ico-depth ico) -> (one-of/c 1 2 4 8 16 24 32)
  ico : ico?
procedure
(ico-format ico) -> (or/c 'bmp 'png)
  ico : ico?
procedure
(read-icos src) -> (listof ico?)
  src : (or/c path-string? input-port?)
procedure
(read-icos-from-exe src) -> (listof ico?)
  src : (or/c path-string? input-port?)
procedure
(write-icos icos dest [#:exists exists]) -> void?
  icos : (listof ico?)
  dest : (or/c path-string? output-port?)
  exists : (or/c 'error 'append 'update 'can-update = 'error
                 'replace 'truncate
                 'must-truncate 'truncate/replace)
procedure
(replace-icos icos dest) -> void?
  icos : (listof ico?)
  dest : path-string?
procedure
(replace-all-icos icos dest) -> void?
  icos : (listof ico?)
  dest : (or/c path-string? output-port?)
procedure
(ico->argb ico) -> bytes?
  ico : ico?
procedure
(ico->png-bytes ico) -> bytes?
  ico : ico?
procedure
(argb->ico width height bstr [#:depth depth]) -> ico?
  width : (integer-in 1 256)
  height : (integer-in 1 256)
  bstr : bytes?
  depth : (one-of/c 1 2 4 8 24 32) = 32
procedure
(png-bytes->ico bstr) -> ico?
  bstr : bytes?
procedure
(get-resource  section       
               entry         
              [value-box     
               file          
               #:type type]) 
 -> (or/c #f string? bytes? exact-integer? #t)
  section : string?
  entry : string?
  value-box : (or/c #f (box/c (or/c string? bytes? exact-integer?)))
            = #f
  file : (or/c #f path-string?) = #f
  type : (or/c 'string 'string/utf-16 'bytes 'bytes* 'integer)
       = derived-from-value-box
procedure
(write-resource  section                         
                 entry                           
                 value                           
                [file                            
                 #:type type                     
                 #:create-key? create-key?]) -> boolean?
  section : string?
  entry : string?
  value : (or/c string? bytes? exact-integer?)
  file : (or/c path-string? #f) = #f
  type : (or/c 'string 'expand-string 'bytes 'dword = 'string
               'bytes/string 'bytes/expand-string)
  create-key? : any/c = #f
procedure
(cache-file  dest-file                                 
            [#:exists-ok? exists-ok?]                  
             key                                       
             cache-dir                                 
             fetch                                     
            [#:notify-cache-use notify-cache-use       
             #:max-cache-files max-files               
             #:max-cache-size max-size                 
             #:evict-before? evict-before?             
             #:log-error-string log-error-string       
             #:log-debug-string log-debug-string]) -> void?
  dest-file : path-string?
  exists-ok? : any/c = #f
  key : (not/c #f)
  cache-dir : path-string?
  fetch : (-> any)
  notify-cache-use : (string? . -> . any) = void
  max-files : real? = 1024
  max-size : real? = (* 64 1024 1024)
  evict-before? : (hash? hash? . -> . boolean?)
                = (lambda (a b)
                    (< (hash-ref a 'modify-seconds)
                       (hash-ref b 'modify-seconds)))
  log-error-string : (string? . -> . any)
                   = (lambda (s) (log-error s))
  log-debug-string : (string? . -> . any)
                   = (lambda (s) (log-debug s))
procedure
(cache-remove  key                                       
               cache-dir                                 
              [#:log-error-string log-error-string       
               #:log-debug-string log-debug-string]) -> void?
  key : any/c
  cache-dir : path-string?
  log-error-string : (string? . -> . any)
                   = (lambda (s) (log-error s))
  log-debug-string : (string? . -> . any)
                   = (lambda (s) (log-debug s))
value
glob/c : (or/c path-string? (sequence/c path-string?))
procedure
(glob  pattern                                 
      [#:capture-dotfiles? capture-dotfiles?]) 
 -> (listof path-string?)
  pattern : glob/c
  capture-dotfiles? : boolean? = (glob-capture-dotfiles?)
procedure
(in-glob  pattern                                 
         [#:capture-dotfiles? capture-dotfiles?]) 
 -> (sequence/c path-string?)
  pattern : glob/c
  capture-dotfiles? : boolean? = (glob-capture-dotfiles?)
procedure
(glob-match?  pattern                                     
              path                                        
             [#:capture-dotfiles? capture-dotfiles?]) -> boolean?
  pattern : glob/c
  path : path-string?
  capture-dotfiles? : boolean? = (glob-capture-dotfiles?)
procedure
(glob-quote str) -> string?
  str : string?
(glob-quote path) -> path?
  path : path?
parameter
(glob-capture-dotfiles?) -> boolean?
(glob-capture-dotfiles? capture-dotfiles?) -> void?
  capture-dotfiles? : boolean?
 = #f
