/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/debug/ControlTree',['sap/ui/base/EventProvider','sap/ui/core/Element','sap/ui/core/UIArea','./Highlighter',"sap/ui/dom/getOwnerWindow","sap/base/Log"],function(E,a,U,H,g,L){"use strict";var C=E.extend("sap.ui.debug.ControlTree",{constructor:function(c,w,p,r){E.apply(this,arguments);this.oWindow=w;this.oDocument=w.document;this.oCore=c;this.oSelectedNode=null;this.oParentDomRef=p;this.oSelectionHighlighter=new H("sap-ui-testsuite-SelectionHighlighter");this.oHoverHighlighter=new H("sap-ui-testsuite-HoverHighlighter",true,'#c8f',1);this.onclick=C.prototype.onclick.bind(this);this.onmouseover=C.prototype.onmouseover.bind(this);this.onmouseout=C.prototype.onmouseout.bind(this);this.oParentDomRef.addEventListener("click",this.onclick);this.oParentDomRef.addEventListener("mouseover",this.onmouseover);this.oParentDomRef.addEventListener("mouseout",this.onmouseout);this.enableInplaceControlSelection();this.oCore.attachUIUpdated(this.renderDelayed,this);this.sSelectedNodeId="";this.sResourcePath=window.top.sap.ui.require.toUrl("")+"/";this.sTestResourcePath=this.sResourcePath+"../test-resources/";this.sSpaceUrl=this.sResourcePath+"sap/ui/debug/images/space.gif";this.sMinusUrl=this.sResourcePath+"sap/ui/debug/images/minus.gif";this.sPlusUrl=this.sResourcePath+"sap/ui/debug/images/plus.gif";this.sLinkUrl=this.sResourcePath+"sap/ui/debug/images/link.gif";}});C.M_EVENTS={SELECT:"SELECT"};C.prototype.exit=function(){document.removeEventListener("mouseover",this.selectControlInTree);this.oParentDomRef.removeEventListener("click",this.onclick);this.oParentDomRef.removeEventListener("mouseover",this.onmouseover);this.oParentDomRef.removeEventListener("mouseout",this.onmouseout);};C.prototype.renderDelayed=function(){if(this.oTimer){this.oWindow.clearTimeout(this.oTimer);}this.oTimer=this.oWindow.setTimeout(this.render.bind(this),0);};C.prototype.render=function(){var d=this.oParentDomRef;var u=null,o=this.oCore.mUIAreas;d.innerHTML="";for(var i in o){var u=o[i],D=this.createTreeNodeDomRef(u.getId(),0,"UIArea",this.sTestResourcePath+"sap/ui/core/images/controls/sap.ui.core.UIArea.gif");d.appendChild(D);var r=u.getContent();for(var i=0,l=r.length;i<l;i++){this.renderNode(d,r[i],1);}}};C.prototype.createTreeNodeDomRef=function(i,l,t,I){var d=this.oParentDomRef.ownerDocument.createElement("DIV");d.setAttribute("id","sap-debug-controltree-"+i);var s=t.substring(t.lastIndexOf(".")>-1?t.lastIndexOf(".")+1:0);d.innerHTML="<img src='"+this.sSpaceUrl+"' align='absmiddle'><img src='"+I+"' align='absmiddle'>&nbsp;<span>"+s+" - "+i+"</span>";d.firstChild.style="height:12px;width:12px;display:none;";d.firstChild.nextSibling.style="height:16px;width:16px;";d.style.overflow="hidden";d.style.whiteSpace="nowrap";d.style.textOverflow="ellipsis";d.style.paddingLeft=(l*16)+"px";d.style.height="20px";d.style.cursor="default";d.setAttribute("sap-type",t);d.setAttribute("sap-id",i);d.setAttribute("sap-expanded","true");d.setAttribute("sap-level",""+l);d.title=t+" - "+i;return d;};C.prototype.createLinkNode=function(p,i,l,t){var d=this.oParentDomRef.ownerDocument.createElement("DIV");d.setAttribute("id","sap-debug-controltreelink-"+i);var s=t?t.substring(t.lastIndexOf(".")>-1?t.lastIndexOf(".")+1:0):"";d.innerHTML="<img src='"+this.sSpaceUrl+"' align='absmiddle'><img src='"+this.sLinkUrl+"' align='absmiddle'>&nbsp;<span>"+(s?s+" - ":"")+i+"</span>";d.firstChild.style="height:12px;width:12px;display:none;";d.firstChild.nextSibling.style="height:12px;width:12px;";d.lastChild.style="color:#888;border-bottom:1px dotted #888;";d.style.overflow="hidden";d.style.whiteSpace="nowrap";d.style.textOverflow="ellipsis";d.style.paddingLeft=(l*16)+"px";d.style.height="20px";d.style.cursor="default";d.setAttribute("sap-type","Link");d.setAttribute("sap-id",i);d.setAttribute("sap-expanded","true");d.setAttribute("sap-level",""+l);d.title="Association to '"+i+"'";p.appendChild(d);return d;};C.prototype.renderNode=function(d,c,l){if(!c){return;}var m=c.getMetadata();var I=this.sTestResourcePath+m.getLibraryName().replace(/\./g,"/")+"/images/controls/"+m.getName()+".gif";var D=this.createTreeNodeDomRef(c.getId(),l,m.getName(),I);d.appendChild(D);var r=false;if(c.mAggregations){for(var n in c.mAggregations){r=true;var A=c.mAggregations[n];if(A&&A.length){for(var i=0;i<A.length;i++){var o=A[i];if(o instanceof a){this.renderNode(d,A[i],l+1);}}}else if(A instanceof a){this.renderNode(d,A,l+1);}}}if(c.mAssociations){for(var n in c.mAssociations){r=true;var b=c.mAssociations[n];if(Array.isArray(b)){for(var i=0;i<b.length;i++){var o=b[i];if(typeof o==="string"){this.createLinkNode(d,o,l+1);}}}else if(typeof b==="string"){this.createLinkNode(d,b,l+1);}}}if(r){var e=D.getElementsByTagName("IMG")[0];e.src=this.sMinusUrl;e.style.display="";}};C.prototype.onclick=function(e){var s=e.target;if(s.tagName=="IMG"){var p=s.parentNode,l=parseInt(p.getAttribute("sap-level")),n=p.nextSibling,b=p.getAttribute("sap-expanded")=="true";s=p.firstChild;if(n){var N=parseInt(n.getAttribute("sap-level"));while(n&&N>l){var o=n.getElementsByTagName("IMG")[0];if(b){n.style.display="none";n.setAttribute("sap-expanded","false");if(o&&o.src!==this.sSpaceUrl){o.src=this.sPlusUrl;}}else{n.style.display="block";n.setAttribute("sap-expanded","true");if(o&&o.src!==this.sSpaceUrl){o.src=this.sMinusUrl;}}n=n.nextSibling;if(n){N=parseInt(n.getAttribute("sap-level"));}}}if(b){s.src=this.sPlusUrl;p.setAttribute("sap-expanded","false");}else{s.src=this.sMinusUrl;p.setAttribute("sap-expanded","true");}}else{if(s.tagName!="SPAN"){s=s.getElementsByTagName("SPAN")[0];}var p=s.parentNode,i=p.getAttribute("sap-id"),c=this.oCore.byId(i),d=p.getAttribute("sap-type")==="Link"?"sap-debug-controltree-"+i:p.id;this.oSelectionHighlighter.hide();if(c instanceof a){this.oSelectionHighlighter.highlight(c.getDomRef());this.oHoverHighlighter.hide();}this.deselectNode(this.sSelectedNodeId);this.selectNode(d);}};C.prototype.onmouseover=function(e){var s=e.target;if(s.tagName=="SPAN"){this.oHoverHighlighter.highlight(this.getTargetDomRef(s.parentNode));}};C.prototype.onmouseout=function(e){var s=e.target;if(s.tagName=="SPAN"){if(this.getTargetDomRef(s.parentNode)){this.oHoverHighlighter.hide();}}};C.prototype.selectNode=function(i){if(!i){return;}var d=(g(this.oParentDomRef)||window).document.getElementById(i);if(!d){L.warning("Control with Id '"+i.substring(22)+"' not found in tree");return;}var c=d.getAttribute("sap-id");var s=d.getElementsByTagName("SPAN")[0];s.style.backgroundColor="#000066";s.style.color="#FFFFFF";this.sSelectedNodeId=i;this.fireEvent(C.M_EVENTS.SELECT,{id:i,controlId:c});};C.prototype.deselectNode=function(i){if(!i){return;}var d=(g(this.oParentDomRef)||window).document.getElementById(i);var s=d.getElementsByTagName("SPAN")[0];s.style.backgroundColor="transparent";s.style.color="#000000";this.sSelectedNodeId=i;};C.prototype.getTargetDomRef=function(t){var T=t.getAttribute("sap-type"),i=t.getAttribute("sap-id"),s=T==="UIArea"?this.oCore.getUIArea(i):this.oCore.byId(i);while(s instanceof a){var d=s.getDomRef();if(d){return d;}s=s.getParent();}if(s instanceof U){return s.getRootNode();}};C.prototype.enableInplaceControlSelection=function(){this.selectControlInTree=C.prototype.selectControlInTree.bind(this);document.addEventListener("mouseover",this.selectControlInTree);};C.prototype.selectControlInTree=function(e){if(e){if(e.ctrlKey&&e.shiftKey&&!e.altKey){var c=e.srcElement||e.target;while(c&&(!c.id||!this.oCore.byId(c.id))){c=c.parentNode;}if(c&&c.id&&this.oCore.byId(c.id)){this.oHoverHighlighter.highlight(c);}else{this.oHoverHighlighter.hide();}}else{this.oHoverHighlighter.hide();}}};return C;});sap.ui.predefine('sap/ui/debug/DebugEnv',['sap/ui/base/Interface','./ControlTree','./LogViewer','./PropertyList',"sap/base/Log","sap/ui/thirdparty/jquery"],function(I,C,L,P,a,q){"use strict";var D=function(){};D.prototype.startPlugin=function(c,o){this.oCore=c;this.oWindow=window;try{this.bRunsEmbedded=typeof window.top.testfwk==="undefined";a.info("Starting DebugEnv plugin ("+(this.bRunsEmbedded?"embedded":"testsuite")+")");if(!this.bRunsEmbedded||c.getConfiguration().getInspect()){this.init(o);}if(!this.bRunsEmbedded||c.getConfiguration().getTrace()){this.initLogger(a,o);}}catch(e){a.warning("DebugEnv plugin can not be started outside the Testsuite.");}};D.prototype.stopPlugin=function(){a.info("Stopping DebugEnv plugin.");this.oCore=null;};D.prototype.init=function(o){this.oControlTreeWindow=this.bRunsEmbedded?this.oWindow:(top.document.getElementById("sap-ui-ControlTreeWindow")||top.frames["sap-ui-ControlTreeWindow"]||top);this.oPropertyListWindow=this.bRunsEmbedded?this.oWindow:(top.document.getElementById("sap-ui-PropertyListWindow")||top.frames["sap-ui-PropertyListWindow"]||top);var r=sap.ui.getCore().getConfiguration().getRTL();var c=(this.oControlTreeWindow.document||this.oControlTreeWindow).querySelector("#sap-ui-ControlTreeRoot"),p=(this.oPropertyListWindow.document||this.oPropertyListWindow).querySelector("#sap-ui-PropertyWindowRoot");if(!c){c=this.oControlTreeWindow.document.createElement("DIV");c.setAttribute("id","sap-ui-ControlTreeRoot");c.setAttribute("tabindex",-1);c.style.position="absolute";c.style.fontFamily="Arial";c.style.fontSize="8pt";c.style.backgroundColor="white";c.style.color="black";c.style.border="1px solid gray";c.style.overflow="auto";c.style.zIndex="999999";c.style.top="1px";if(r){c.style.left="1px";}else{c.style.right="1px";}c.style.height="49%";c.style.width="200px";this.oControlTreeWindow.document.body.appendChild(c);}else{c.innerHTML="";}this.oControlTreeRoot=c;if(!p){p=this.oPropertyListWindow.document.createElement("DIV");p.setAttribute("id","sap-ui-PropertyWindowRoot");p.setAttribute("tabindex",-1);p.style.position="absolute";p.style.fontFamily="Arial";p.style.fontSize="8pt";p.style.backgroundColor="white";p.style.color="black";p.style.border="1px solid gray";p.style.overflow="auto";p.style.zIndex="99999";p.style.width="196px";p.style.height="49%";if(r){p.style.left="1px";}else{p.style.right="1px";}p.style.bottom="1px";this.oPropertyListWindow.document.body.appendChild(p);}else{p.innerHTML="";}this.oPropertyWindowRoot=p;this.oControlTree=new C(this.oCore,this.oWindow,c,this.bRunsEmbedded);this.oPropertyList=new P(this.oCore,this.oWindow,p);this.oControlTree.attachEvent(C.M_EVENTS.SELECT,this.oPropertyList.update,this.oPropertyList);if(!o){this.oControlTree.renderDelayed();}window.addEventListener("unload",function(e){this.oControlTree.exit();this.oPropertyList.exit();}.bind(this));};D.prototype.initLogger=function(l,o){this.oLogger=l;this.oLogger.setLogEntriesLimit(Infinity);if(!this.bRunsEmbedded){this.oTraceWindow=top.document.getElementById("sap-ui-TraceWindow");if(this.oTraceWindow){this.oTraceViewer=top.oLogViewer=new L(this.oTraceWindow,'sap-ui-TraceWindowRoot');}else{this.oTraceWindow=top.frames["sap-ui-TraceWindow"];this.oTraceViewer=this.oTraceWindow.oLogViewer=new L(this.oTraceWindow,'sap-ui-TraceWindowRoot');}this.oTraceViewer.sLogEntryClassPrefix="lvl";this.oTraceViewer.lock();}else{this.oTraceWindow=this.oWindow;this.oTraceViewer=new L(this.oTraceWindow,'sap-ui-TraceWindowRoot');}this.oLogger.addLogListener(this.oTraceViewer);this.oCore.attachUIUpdated(this.enableLogViewer,this);if(!o){var t=this;this.oTimer=setTimeout(function(){t.enableLogViewer();},0);}};D.prototype.enableLogViewer=function(){if(this.oTimer){clearTimeout(this.oTimer);this.oTimer=undefined;}this.oCore.detachUIUpdated(this.enableLogViewer,this);if(this.oTraceViewer){this.oTraceViewer.unlock();}};D.prototype.isRunningEmbedded=function(){return this.bRunsEmbedded;};D.prototype.isControlTreeShown=function(){return q(this.oControlTreeRoot).css("visibility")==="visible"||q(this.oControlTreeRoot).css("visibility")==="inherit";};D.prototype.showControlTree=function(){if(!this.oControlTreeRoot){this.init(false);}q(this.oControlTreeRoot).css("visibility","visible");};D.prototype.hideControlTree=function(){q(this.oControlTreeRoot).css("visibility","hidden");};D.prototype.isTraceWindowShown=function(){var l=this.oTraceWindow&&this.oTraceWindow.document.getElementById('sap-ui-TraceWindowRoot');return l&&(q(l).css("visibility")==="visible"||q(l).css("visibility")==="inherit");};D.prototype.showTraceWindow=function(){if(!this.oTraceWindow){this.initLogger(a,false);}var l=this.oTraceWindow&&this.oTraceWindow.document.getElementById('sap-ui-TraceWindowRoot');if(l){q(l).css("visibility","visible");}};D.prototype.hideTraceWindow=function(){var l=this.oTraceWindow&&this.oTraceWindow.document.getElementById('sap-ui-TraceWindowRoot');if(l){q(l).css("visibility","hidden");}};D.prototype.isPropertyListShown=function(){return q(this.oPropertyWindowRoot).css("visibility")==="visible"||q(this.oPropertyWindowRoot).css("visibility")==="inherit";};D.prototype.showPropertyList=function(){if(!this.oPropertyWindowRoot){this.init(false);}q(this.oPropertyWindowRoot).css("visibility","visible");};D.prototype.hidePropertyList=function(){q(this.oPropertyWindowRoot).css("visibility","hidden");};(function(){var t=new D();sap.ui.getCore().registerPlugin(t);var i=new I(t,["isRunningEmbedded","isControlTreeShown","showControlTree","hideControlTree","isTraceWindowShown","showTraceWindow","hideTraceWindow","isPropertyListShown","showPropertyList","hidePropertyList"]);D.getInstance=function(){return i;};}());return D;},true);sap.ui.predefine('sap/ui/debug/Highlighter',["sap/ui/thirdparty/jquery","sap/base/util/uid","sap/ui/dom/jquery/rect"],function(q,u){"use strict";var H=function(i,f,c,b){this.sId=i||u();this.bFilled=(f==true);this.sColor=c||'blue';if(isNaN(b)){this.iBorderWidth=2;}else if(b<=0){this.iBorderWidth=0;}else{this.iBorderWidth=b;}};H.prototype.highlight=function(d){if(!d||!d.parentNode){return;}var h=(this.sId?window.document.getElementById(this.sId):null);if(!h){h=d.ownerDocument.createElement("div");h.setAttribute("id",this.sId);h.style.position="absolute";h.style.border=this.iBorderWidth+"px solid "+this.sColor;h.style.display="none";h.style.margin="0px";h.style.padding="0px";if(this.bFilled){var f=d.ownerDocument.createElement("div");f.textContent="\u00a0";f.style.backgroundColor=this.sColor;f.style.opacity="0.2";f.style.height="100%";f.style.width="100%";h.appendChild(f);}d.ownerDocument.body.appendChild(h);}var r=q(d).rect();h.style.top=(r.top-this.iBorderWidth)+"px";h.style.left=(r.left-this.iBorderWidth)+"px";h.style.width=(r.width)+"px";h.style.height=(r.height)+"px";h.style.display="block";};H.prototype.hide=function(){var h=(this.sId?window.document.getElementById(this.sId):null);if(!h){return;}h.style.display="none";};return H;},true);sap.ui.predefine('sap/ui/debug/LogViewer',function(){"use strict";var L=function(w,r){this.oWindow=w;this.oDomNode=w.querySelector("#"+r);if(!this.oDomNode){var d=this.oWindow.document.createElement("DIV");d.setAttribute("id",r);d.style.overflow="auto";d.style.tabIndex="-1";d.style.position="absolute";d.style.bottom="0px";d.style.left="0px";d.style.right="202px";d.style.height="200px";d.style.border="1px solid gray";d.style.fontFamily="Arial monospaced for SAP,monospace";d.style.fontSize="11px";d.style.zIndex="999999";this.oWindow.document.body.appendChild(d);this.oDomNode=d;}this.iLogLevel=3;this.sLogEntryClassPrefix=undefined;this.clear();this.setFilter(L.NO_FILTER);};L.NO_FILTER=function(l){return true;};L.prototype.clear=function(){this.oDomNode.innerHTML="";};L.xmlEscape=function(t){t=t.replace(/\&/g,"&amp;");t=t.replace(/\</g,"&lt;");t=t.replace(/\"/g,"&quot;");return t;};L.prototype.addEntry=function(l){var d=this.oWindow.ownerDocument.createElement("div");if(this.sLogEntryClassPrefix){d.className=this.sLogEntryClassPrefix+l.level;}else{d.style.overflow="hidden";d.style.textOverflow="ellipsis";d.style.height="1.3em";d.style.width="100%";d.style.whiteSpace="noWrap";}var t=L.xmlEscape(l.time+"  "+l.message),T=this.oWindow.ownerDocument.createTextNode(t);d.appendChild(T);d.title=l.message;d.style.display=this.oFilter(t)?"":"none";this.oDomNode.appendChild(d);return d;};L.prototype.fillFromLogger=function(f){this.clear();this.iFirstEntry=f;if(!this.oLogger){return;}var a=this.oLogger.getLogEntries();for(var i=this.iFirstEntry,l=a.length;i<l;i++){if(a[i].level<=this.iLogLevel){this.addEntry(a[i]);}}this.scrollToBottom();};L.prototype.scrollToBottom=function(){this.oDomNode.scrollTop=this.oDomNode.scrollHeight;};L.prototype.truncate=function(){this.clear();this.fillFromLogger(this.oLogger.getLogEntries().length);};L.prototype.setFilter=function(f){this.oFilter=f=f||L.NO_FILTER;var c=this.oDomNode.childNodes;for(var i=0,l=c.length;i<l;i++){var t=c[i].innerText;if(!t){t=c[i].innerHTML;}c[i].style.display=f(t)?"":"none";}this.scrollToBottom();};L.prototype.setLogLevel=function(l){this.iLogLevel=l;if(this.oLogger){this.oLogger.setLevel(l);}this.fillFromLogger(this.iFirstEntry);};L.prototype.lock=function(){this.bLocked=true;};L.prototype.unlock=function(){this.bLocked=false;this.fillFromLogger(0);};L.prototype.onAttachToLog=function(l){this.oLogger=l;this.oLogger.setLevel(this.iLogLevel);if(!this.bLocked){this.fillFromLogger(0);}};L.prototype.onDetachFromLog=function(l){this.oLogger=undefined;this.fillFromLogger(0);};L.prototype.onLogEntry=function(l){if(!this.bLocked){var d=this.addEntry(l);if(d&&d.style.display!=='none'){this.scrollToBottom();}}};return L;},true);sap.ui.predefine('sap/ui/debug/PropertyList',['sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/core/Element','sap/ui/core/ElementMetadata','sap/base/util/isEmptyObject','sap/base/security/encodeXML','sap/ui/thirdparty/jquery','sap/ui/dom/jquery/rect'],function(D,E,a,b,c,e,q){"use strict";var P=E.extend("sap.ui.debug.PropertyList",{constructor:function(C,w,p){E.apply(this,arguments);this.oWindow=w;this.oParentDomRef=p;this.oCore=C;this.bEmbedded=window.top===w;var l=window.top.document.createElement("link");l.rel="stylesheet";l.href=window.top.sap.ui.require.toUrl("sap/ui/debug/PropertyList.css");window.top.document.head.appendChild(l);this.onchange=P.prototype.onchange.bind(this);p.addEventListener("change",this.onchange);this.onfocus=P.prototype.onfocus.bind(this);p.addEventListener("focusin",this.onfocus);this.onkeydown=P.prototype.onkeydown.bind(this);p.addEventListener("keydown",this.onkeydown);if(!this.bEmbedded){this.onmouseover=P.prototype.onmouseover.bind(this);p.addEventListener("mouseover",this.onmouseover);this.onmouseout=P.prototype.onmouseout.bind(this);p.addEventListener("mouseout",this.onmouseout);}}});P.prototype.exit=function(){this.oParentDomRef.removeEventListener("change",this.onchange);this.oParentDomRef.removeEventListener("focusin",this.onfocus);this.oParentDomRef.removeEventListener("keydown",this.onkeydown);if(!this.bEmbedded){this.oParentDomRef.removeEventListener("mouseover",this.onmouseover);this.oParentDomRef.removeEventListener("mouseout",this.onmouseout);}};P.prototype.update=function(p){var C=this.sControlId=p.getParameter("controlId");this.oParentDomRef.innerHTML="";var o=this.oCore.byId(C);if(!o){this.oParentDomRef.innerHTML="Please select a valid control";return;}var m=o.getMetadata(),h=[];h.push("<span data-sap-ui-quickhelp='"+this._calcHelpId(m)+"'>Type : "+m.getName()+"</span><br >");h.push("Id : "+o.getId()+"<br >");if(!this.bEmbedded){h.push("<div id='sap-ui-quickhelp' class='sapDbgQH'>Help</div>");}h.push("<div class='sapDbgSeparator'>&nbsp;</div>");h.push("<table class='sapDbgPropertyList' cellspacing='1'><tbody>");while(m instanceof b){var s=this.getPropertyLikeSettings(m);if(!c(s)){if(m!==o.getMetadata()){h.push("<tr><td class='sapDbgPLSubheader' colspan=\"2\">BaseType: ");h.push(m.getName());h.push("</td></tr>");}this.renderSettings(h,o,s);}m=m.getParent();}h.push("</tbody></table>");this.oParentDomRef.innerHTML=h.join("");this.mHelpDocs={};};P.prototype.getPropertyLikeSettings=function(m){var s={};Object.values(m.getProperties()).forEach(function(p){s[p.name]=p;});Object.values(m.getAggregations()).forEach(function(A){if(A.multiple===false&&A.altTypes&&A.altTypes.length&&D.getType(A.altTypes[0])!=null){s[A.name]=A;}});return s;};P.prototype.renderSettings=function(h,C,s){Object.values(s).forEach(function(S){var N=S.name,v=S.get(C),t=S.multiple===false?D.getType(S.altTypes[0]):S.getType();h.push("<tr><td>");h.push("<span data-sap-ui-quickhelp='",this._calcHelpId(S._oParent,N),"' >",N,'</span>');h.push("</td><td>");var T="";if(t.getPrimitiveType().getName()==="boolean"){h.push("<input type='checkbox' data-name='"+N+"' ");if(v==true){h.push("checked='checked'");}h.push(">");}else if(t.isEnumType()){var o=t.getEnumValues();h.push("<select data-name='"+N+"'>");for(var n in o){h.push("<option ");if(n===v){h.push(" selected ");}h.push("value='"+e(n)+"'>");h.push(e(n));h.push("</option>");}h.push("</select>");}else{var V='';if(v===null){V="class='sapDbgComplexValue'";v='(null)';}else if(v instanceof a){V="class='sapDbgComplexValue'";if(Array.isArray(v)){v=v.join(", ");}else{v=String(v);}T=' title="This aggregation currently references an Element. You can set a '+t.getName()+' value instead"';}h.push("<input type='text' "+V+" value='"+e(""+v)+"'"+T+" data-name='"+N+"'>");}h.push("</td></tr>");}.bind(this));};P.prototype.onkeydown=function(o){var s=o.target;if(o.keyCode==13&&s.tagName==="INPUT"&&s.type==="text"){this.applyChange(s);}};P.prototype.onchange=function(o){var s=o.target;if(s.tagName==="SELECT"||s.tagName==="INPUT"){this.applyChange(s);}};P.prototype.onfocus=function(o){var s=o.target;if(s.tagName==="INPUT"&&s.dataset.name){if(s.style.color==='#a5a5a5'){s.style.color='';s.value='';}}};P.prototype.applyChange=function(f){var C=this.oCore.byId(this.sControlId),n=f.dataset.name,s=C.getMetadata().getPropertyLikeSetting(n);if(s){var v=f.type==="checkbox"?String(f.checked):f.value,t=s.multiple!=null?D.getType(s.altTypes[0]):s.getType();if(t){var V=t.parseValue(v);if(t.isValid(V)&&V!=="(null)"){s.set(C,V);f.classList.remove("sapDbgComplexValue");}}}};P.prototype.showQuickHelp=function(s){if(this.oQuickHelpTimer){clearTimeout(this.oQuickHelpTimer);this.oQuickHelpTimer=undefined;}var t=this.oParentDomRef.ownerDocument.getElementById("sap-ui-quickhelp");if(t){this.sCurrentHelpId=s.getAttribute("data-sap-ui-quickhelp");var r=q(s).rect();t.style.left=(r.left+40+10)+"px";t.style.top=(r.top-40)+"px";t.style.display='block';t.style.opacity='0.2';if(this.mHelpDocs[this.sCurrentHelpId]){this.updateQuickHelp(this.mHelpDocs[this.sCurrentHelpId],2000);}else{t.innerHTML="<b>Quickhelp</b> for "+this.sCurrentHelpId+" is being retrieved...";this.sCurrentHelpDoc=this.sCurrentHelpId;this.sCurrentHelpDocPart=undefined;if(this.sCurrentHelpId.indexOf('#')>=0){this.sCurrentHelpDoc=this.sCurrentHelpId.substring(0,this.sCurrentHelpId.indexOf('#'));this.sCurrentHelpDocPart=this.sCurrentHelpId.substring(this.sCurrentHelpId.indexOf('#')+1);}var u=this.oWindow.jQuery.sap.getModulePath(this.sCurrentHelpDoc,".control");var d=this;q.ajax({url:u,dataType:'xml',error:function(x,f){d.receiveQuickHelp(undefined);},success:function(f){d.receiveQuickHelp(f);}});this.oQuickHelpTimer=setTimeout(function(){d.hideQuickHelp();},2000);}}};P.prototype.receiveQuickHelp=function(d){if(d){var C=d.getElementsByTagName("control")[0];if(C){var g=function(x,N){var r=[];var j=x.firstChild;while(j){if(N===j.nodeName){r.push(j);}j=j.nextSibling;}return r;};var n=g(C,"name");var N='';if(n[0]){N=n[0].text||n[0].textContent;}var f=g(C,"documentation");if(f[0]){if(N&&f[0]){var h=[];h.push("<div class='sapDbgQHClassTitle'>",N.replace('/','.'),"</div>");h.push("<div class='sapDbgQHDocPadding'>",f[0].text||f[0].textContent,"</div>");this.mHelpDocs[this.sCurrentHelpDoc]=h.join("");}}var p=g(C,"properties");if(p[0]){p=g(p[0],"property");}for(var i=0,l=p.length;i<l;i++){var o=p[i];var N=o.getAttribute("name");var t=o.getAttribute("type")||"string";var s=o.getAttribute("defaultValue")||"empty/undefined";var f=g(o,"documentation");if(N&&f[0]){var h=[];h.push("<div class='sapDbgQHSettingDoc'>",N,"</div>");h.push("<div class='sapDbgQHDocPadding'><i><strong>Type</strong></i>: ",t,"</div>");h.push("<div class='sapDbgQHDocPadding'>",f[0].text||f[0].textContent,"</div>");h.push("<div class='sapDbgQHDocPadding'><i><strong>Default Value</strong></i>: ",s,"</div>");this.mHelpDocs[this.sCurrentHelpDoc+"#"+N]=h.join("");}}var p=g(C,"aggregations");if(p[0]){p=g(p[0],"aggregation");}for(var i=0,l=p.length;i<l;i++){var o=p[i];var N=o.getAttribute("name");var t=o.getAttribute("type")||"sap.ui.core/Control";var s=o.getAttribute("defaultValue")||"empty/undefined";var f=g(o,"documentation");if(N&&f[0]&&!this.mHelpDocs[this.sCurrentHelpDoc+"#"+N]){var h=[];h.push("<div class='sapDbgQHSettingTitle'>",N,"</div>");h.push("<div class='sapDbgQHDocPadding'><i><strong>Type</strong></i>: ",t,"</div>");h.push("<div class='sapDbgQHDocPadding'>",f[0].text||f[0].textContent,"</div>");h.push("<div class='sapDbgQHDocPadding'><i><strong>Default Value</strong></i>: ",s,"</div>");this.mHelpDocs[this.sCurrentHelpDoc+"#"+N]=h.join("");}}}if(this.mHelpDocs[this.sCurrentHelpId]){this.updateQuickHelp(this.mHelpDocs[this.sCurrentHelpId],2000);}else{this.updateQuickHelp(undefined,0);}}else{this.updateQuickHelp(undefined,0);}};P.prototype.updateQuickHelp=function(n,t){if(this.oQuickHelpTimer){clearTimeout(this.oQuickHelpTimer);this.oQuickHelpTimer=undefined;}var T=this.oParentDomRef.ownerDocument.getElementById("sap-ui-quickhelp");if(T){if(!n){T.innerHTML="<i>No quick help...</i>";T.style.display='none';}else{T.innerHTML=n;this.oQuickHelpTimer=setTimeout(function(){this.hideQuickHelp();}.bind(this),t);}}};P.prototype.hideQuickHelp=function(){var t=this.oParentDomRef.ownerDocument.getElementById("sap-ui-quickhelp");if(t){t.style.display='none';}this.bMovedOverTooltip=false;};P.prototype._calcHelpId=function(m,n){var h=m.getName();if(n){h=h+"#"+n;}return h;};P.prototype._isChildOfQuickHelp=function(d){while(d){if(d.id==="sap-ui-quickhelp"){return true;}d=d.parentNode;}return false;};P.prototype.onmouseover=function(o){var s=o.target;if(this._isChildOfQuickHelp(s)){if(this.oQuickHelpTimer){clearTimeout(this.oQuickHelpTimer);this.oQuickHelpTimer=undefined;}this.bMovedOverTooltip=true;var t=this.oParentDomRef.ownerDocument.getElementById("sap-ui-quickhelp");if(t){t.style.opacity='';}}else if(s.getAttribute("data-sap-ui-quickhelp")){this.showQuickHelp(s);}};P.prototype.onmouseout=function(o){var s=o.target;if(this._isChildOfQuickHelp(s)){if(this.oQuickHelpTimer){clearTimeout(this.oQuickHelpTimer);this.oQuickHelpTimer=undefined;}this.bMovedOverTooltip=false;this.oQuickHelpTimer=setTimeout(function(){this.hideQuickHelp();}.bind(this),50);}else if(s.getAttribute("data-sap-ui-quickhelp")){if(this.oQuickHelpTimer){clearTimeout(this.oQuickHelpTimer);this.oQuickHelpTimer=undefined;}if(!this.bMovedOverTooltip){this.oQuickHelpTimer=setTimeout(function(){this.hideQuickHelp();}.bind(this),800);}}};return P;});sap.ui.requireSync("sap/ui/debug/DebugEnv");
