/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/NavContainer","sap/ui/core/Configuration","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem',"./FlexibleColumnLayoutRenderer","sap/base/Log","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/core/InvisibleMessage"],function(q,l,c,D,R,C,m,B,N,a,P,b,F,L,d,e,f,I){"use strict";var g=l.LayoutType;var h=c.InvisibleMessageMode;var j=C.extend("sap.f.FlexibleColumnLayout",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},layout:{type:"sap.f.LayoutType",defaultValue:g.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.BackgroundDesign.Transparent},restoreFocusOnBackNavigation:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},landmarkInfo:{type:"sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo",multiple:false},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},columnResize:{parameters:{beginColumn:{type:"boolean"},midColumn:{type:"boolean"},endColumn:{type:"boolean"}}}}}});j.DEFAULT_COLUMN_LABELS={"FirstColumn":"FCL_BEGIN_COLUMN_REGION_TEXT","MiddleColumn":"FCL_MID_COLUMN_REGION_TEXT","LastColumn":"FCL_END_COLUMN_REGION_TEXT"};j.COLUMN_RESIZING_ANIMATION_DURATION=560;j.PINNED_COLUMN_CLASS_NAME="sapFFCLPinnedColumn";j.COLUMN_ORDER=["begin","mid","end"];j.NAVIGATION_ARROW_WIDTH=b.toPx("1rem");j.prototype.init=function(){this._iWidth=0;this._oColumnFocusInfo={begin:{},mid:{},end:{}};this._initNavContainers();this._initButtons();this._oLayoutHistory=new k();this._oAnimationEndListener=new A();this._oRenderedColumnPagesBoolMap={};this._oColumnWidthInfo={begin:0,mid:0,end:0};this._oInvisibleMessage=null;};j.prototype._announceMessage=function(r){var t=j._getResourceBundle().getText(r);if(this._oInvisibleMessage){this._oInvisibleMessage.announce(t,h.Polite);}};j.prototype._onNavContainerRendered=function(E){var o=E.srcControl,H=o.getPages().length>0,i=this._hasAnyColumnPagesRendered();this._setColumnPagesRendered(o.getId(),H);if(this._hasAnyColumnPagesRendered()!==i){this._hideShowArrows();}};j.prototype._createNavContainer=function(s){var i=s.charAt(0).toUpperCase()+s.slice(1);var n=new N(this.getId()+"-"+s+"ColumnNav",{autoFocus:this.getAutoFocus(),navigate:function(E){this._handleNavigationEvent(E,false,s);}.bind(this),afterNavigate:function(E){this._handleNavigationEvent(E,true,s);}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+i+"Column"]()});n.addDelegate({"onAfterRendering":this._onNavContainerRendered},this);this["_"+s+'ColumnFocusOutDelegate']={onfocusout:function(E){this._oColumnFocusInfo[s]=E.target;}};n.addEventDelegate(this["_"+s+'ColumnFocusOutDelegate'],this);return n;};j.prototype._formatLandmarkInfo=function(o,s){var i=null;if(o){i=o["get"+s+"Label"]();}return{role:"region",label:i||j._getResourceBundle().getText(j.DEFAULT_COLUMN_LABELS[s])};};j.prototype._handleNavigationEvent=function(E,i,s){var n,o;if(i){n="after"+(s.charAt(0).toUpperCase()+s.slice(1))+"ColumnNavigate";}else{n=s+"ColumnNavigate";}o=this.fireEvent(n,E.mParameters,true);if(!o){E.preventDefault();}};j.prototype._getColumnByStringName=function(s){if(s==='end'){return this._getEndColumn();}else if(s==='mid'){return this._getMidColumn();}else{return this._getBeginColumn();}};j.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav");};j.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav");};j.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav");};j.prototype._flushColumnContent=function(s){var o=this.getAggregation("_"+s+"ColumnNav"),r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(this._$columns[s].find(".sapFFCLColumnContent")[0],undefined,true);r.destroy();};j.prototype.setLayout=function(n){n=this.validateProperty("layout",n);var s=this.getLayout();if(s===n){return this;}var r=this.setProperty("layout",n,true);this._oLayoutHistory.addEntry(n);this._hideShowArrows();this._resizeColumns();return r;};j.prototype.setAutoFocus=function(n){n=this.validateProperty("autoFocus",n);var i=this.getAutoFocus();if(i===n){return this;}this._getNavContainers().forEach(function(o){o.setAutoFocus(n);});return this.setProperty("autoFocus",n,true);};j.prototype.onBeforeRendering=function(){if(!this._oInvisibleMessage){this._oInvisibleMessage=I.getInstance();}this._deregisterResizeHandler();this._oAnimationEndListener.cancelAll();};j.prototype.onAfterRendering=function(){this._measureControlWidth();this._registerResizeHandler();this._cacheDOMElements();this._hideShowArrows();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);};j.prototype._restoreFocusToColumn=function(s){var E=this._oColumnFocusInfo[s];if(!E||e(E)){E=this._getFirstFocusableElement(s);}q(E).trigger("focus");};j.prototype._getFirstFocusableElement=function(s){var o=this._getColumnByStringName(s),i=o.getCurrentPage();if(i){return i.$().firstFocusableDomRef();}return null;};j.prototype._isFocusInSomeOfThePreviousColumns=function(){var i=j.COLUMN_ORDER.indexOf(this._sPreviuosLastVisibleColumn)-1,o;for(;i>=0;i--){o=this._getColumnByStringName(j.COLUMN_ORDER[i]);if(o&&o._isFocusInControl(o)){return true;}}return false;};j.prototype._getControlWidth=function(){if(this._iWidth===0){this._measureControlWidth();}return this._iWidth;};j.prototype._measureControlWidth=function(){if(this.$().is(":visible")){this._iWidth=this.$().width();}else{this._iWidth=0;}};j.prototype.exit=function(){this._removeNavContainersFocusOutDelegate();this._oRenderedColumnPagesBoolMap=null;this._oColumnFocusInfo=null;this._deregisterResizeHandler();this._handleEvent(q.Event("Destroy"));};j.prototype._removeNavContainersFocusOutDelegate=function(){j.COLUMN_ORDER.forEach(function(s){this._getColumnByStringName(s).removeEventDelegate(this["_"+s+"ColumnFocusOutDelegate"]);},this);};j.prototype._registerResizeHandler=function(){d(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};j.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};j.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true);};j.prototype._getNavContainers=function(){return[this._getBeginColumn(),this._getMidColumn(),this._getEndColumn()];};j.prototype._initButtons=function(){var o=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",tooltip:j._getResourceBundle().getText("FCL_BEGIN_COLUMN_BACK_ARROW"),type:"Transparent",press:function(){this._onArrowClick("left");this._announceMessage("FCL_MIDDLE_COLUMN_EXPANDED_MESSAGE");}.bind(this)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",o,true);var M=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",tooltip:j._getResourceBundle().getText("FCL_MID_COLUMN_FORWARD_ARROW"),type:"Transparent",press:function(){this._onArrowClick("right");this._announceMessage("FCL_FIRST_COLUMN_EXPANDED_MESSAGE");}.bind(this)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",M,true);var i=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",tooltip:j._getResourceBundle().getText("FCL_MID_COLUMN_BACK_ARROW"),type:"Transparent",press:function(){this._onArrowClick("left");this._announceMessage("FCL_LAST_COLUMN_EXPANDED_MESSAGE");}.bind(this)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",i,true);var E=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",tooltip:j._getResourceBundle().getText("FCL_END_COLUMN_FORWARD_ARROW"),type:"Transparent",press:function(){this._onArrowClick("right");this._announceMessage("FCL_MIDDLE_COLUMN_EXPANDED_MESSAGE");}.bind(this)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",E,true);};j.prototype._cacheDOMElements=function(){this._cacheColumns();if(!D.system.phone){this._cacheArrows();}};j.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};};j.prototype._cacheArrows=function(){this._oColumnSeparatorArrows={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};j.prototype._getVisibleColumnsCount=function(){return j.COLUMN_ORDER.filter(function(s){return this._getColumnSize(s)>0;},this).length;};j.prototype._getVisibleArrowsCount=function(){if(!this._oColumnSeparatorArrows){return 0;}return Object.keys(this._oColumnSeparatorArrows).filter(function(s){return this._oColumnSeparatorArrows[s].data("visible");},this).length;};j.prototype._getTotalColumnsWidth=function(H){var s=this._getVisibleArrowsCount();if(H){s++;}return this._getControlWidth()-s*j.NAVIGATION_ARROW_WIDTH;};j.prototype._resizeColumns=function(){var p,i,n=j.COLUMN_ORDER.slice(),r=sap.ui.getCore().getConfiguration().getRTL(),s=sap.ui.getCore().getConfiguration().getAnimationMode(),H=s!==a.AnimationMode.none&&s!==a.AnimationMode.minimal,o,v,t,u,w,x,y,z={};if(!this.isActive()){return;}v=this._getVisibleColumnsCount();if(v===0){return;}u=this.getLayout();t=this._getMaxColumnsCountForLayout(u,j.DESKTOP_BREAKPOINT);w=n[t-1];y=this.getRestoreFocusOnBackNavigation()&&this._isNavigatingBackward(w)&&!this._isFocusInSomeOfThePreviousColumns();x=(v===3)&&(u===g.ThreeColumnsEndExpanded);i=this._getTotalColumnsWidth(x);if(H){n.forEach(function(E){var S=this._shouldConcealColumn(t,E),G=this._shouldRevealColumn(t,E===w),J=this._$columns[E];J.toggleClass(j.PINNED_COLUMN_CLASS_NAME,S||G);},this);n.forEach(function(E){z[E]=this._oAnimationEndListener.isWaitingForColumnResizeEnd(this._$columns[E]);},this);this._oAnimationEndListener.cancelAll();}n.forEach(function(E){var G=this._$columns[E],J=G.get(0),K,M,S,O,Q,T,U;p=this._getColumnSize(E);K=Math.round(i*(p/100));if([100,0].indexOf(p)!==-1){M=p+"%";}else{M=K+"px";}U={previousAnimationCompleted:!z[G],iNewWidth:K,shouldRestoreFocus:y&&(E===w),hidden:p===0&&this._oColumnWidthInfo[E]===0};if(H){S=this._shouldRevealColumn(t,E===w);O=this._shouldConcealColumn(t,E);Q=S||O;U=f(U,{hasAnimations:true,shouldConcealColumn:O,pinned:Q});T=this._canResizeColumnWithAnimation(E,U);}if(!O){G.toggleClass("sapFFCLColumnActive",p>0);}G.toggleClass("sapFFCLColumnInset",x&&(E==="mid"));G.removeClass("sapFFCLColumnHidden");G.removeClass("sapFFCLColumnOnlyActive");G.removeClass("sapFFCLColumnLastActive");G.removeClass("sapFFCLColumnFirstActive");if(T){R.suspend(J);this._oAnimationEndListener.waitForColumnResizeEnd(G).then(function(){R.resume(J);}).catch(function(){R.resume(J);});}if(!O){G.width(M);}else{this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(function(){G.width(M);}).catch(function(){});}if(T||Q){this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(this._afterColumnResize.bind(this,E,U)).catch(function(){});}else{this._afterColumnResize(E,U);}if(!D.system.phone){this._updateColumnContextualSettings(E,K);this._updateColumnCSSClasses(E,K);}},this);o=n.filter(function(E){return this._getColumnSize(E)>0;},this);if(r){n.reverse();}if(o.length===1){this._$columns[o[0]].addClass("sapFFCLColumnOnlyActive");}if(o.length>1){this._$columns[o[0]].addClass("sapFFCLColumnFirstActive");this._$columns[o[o.length-1]].addClass("sapFFCLColumnLastActive");}this._storePreviousResizingInfo(t,w);};j.prototype._afterColumnResize=function(s,o){var i=this._$columns[s],S=o.shouldConcealColumn,n=o.iNewWidth,p=o.shouldRestoreFocus;i.toggleClass(j.PINNED_COLUMN_CLASS_NAME,false);if(S){i.removeClass("sapFFCLColumnActive");}i.toggleClass("sapFFCLColumnHidden",n===0);this._cacheColumnWidth(s,n);if(p){this._restoreFocusToColumn(s);}};j.prototype._getColumnWidth=function(s){var o=this._$columns[s].get(0),i=o.style.width,n=parseInt(i),p;if(/px$/.test(i)){return n;}p=/%$/.test(i);if(p&&(n===100)){return this._getControlWidth();}if(p&&(n===0)){return 0;}return o.offsetWidth;};j.prototype._cacheColumnWidth=function(s,n){var E;if(this._oColumnWidthInfo[s]!==n){E={};j.COLUMN_ORDER.forEach(function(i){E[i+"Column"]=i===s;});this.fireColumnResize(E);}this._oColumnWidthInfo[s]=n;};j.prototype._storePreviousResizingInfo=function(v,s){var o=this.getLayout();this._iPreviousVisibleColumnsCount=v;this._bWasFullScreen=o===g.MidColumnFullScreen||o===g.EndColumnFullScreen;this._sPreviuosLastVisibleColumn=s;};j.prototype._isNavigatingBackward=function(s){return this._bWasFullScreen||j.COLUMN_ORDER.indexOf(this._sPreviuosLastVisibleColumn)>j.COLUMN_ORDER.indexOf(s);};j.prototype._shouldRevealColumn=function(v,i){return(v>this._iPreviousVisibleColumnsCount)&&!this._bWasFullScreen&&i;};j.prototype._shouldConcealColumn=function(v,s){return(v<this._iPreviousVisibleColumnsCount&&s===this._sPreviuosLastVisibleColumn&&!this._bWasFullScreen&&this._getColumnSize(s)===0);};j.prototype._canResizeColumnWithAnimation=function(s,o){var i,n,p=o.iNewWidth,H=o.hasAnimations,r=o.pinned,t=o.hidden,w=!o.previousAnimationCompleted;if(!H||r||t){return false;}i=this._$columns[s];if(w){return i.width()!==p;}n=!i.get(0).style.width;if(n){return false;}return this._getColumnWidth(s)!==p;};j.prototype._propagateContextualSettings=function(){};j.prototype._updateColumnContextualSettings=function(s,w){var o,i;o=this.getAggregation("_"+s+"ColumnNav");if(!o){return;}i=o._getContextualSettings();if(!i||i.contextualWidth!==w){o._applyContextualSettings({contextualWidth:w});}};j.prototype._updateColumnCSSClasses=function(s,w){var n="";this._$columns[s].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide";}else{n="ExtraWide";}this._$columns[s].addClass("sapUiContainer-"+n);};j.prototype._getColumnSize=function(s){var i=this.getLayout(),n=this._getColumnWidthDistributionForLayout(i),S=n.split("/"),M={begin:0,mid:1,end:2},o=S[M[s]];return parseInt(o);};j.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth());};j.prototype._getMaxColumnsCountForWidth=function(w){if(w>=j.DESKTOP_BREAKPOINT){return 3;}if(w>=j.TABLET_BREAKPOINT&&w<j.DESKTOP_BREAKPOINT){return 2;}if(w>0){return 1;}return 0;};j.prototype._getMaxColumnsCountForLayout=function(s,w){var i=this._getMaxColumnsCountForWidth(w),n=this._getColumnWidthDistributionForLayout(s,false,i),S=n.split("/"),M={begin:0,mid:1,end:2},o,p,r=0;Object.keys(M).forEach(function(t){o=S[M[t]];p=parseInt(o);if(p){r++;}});return r;};j.prototype._onResize=function(E){var o=E.oldSize.width,n=E.size.width,O,M;this._iWidth=n;if(n===0){return;}O=this._getMaxColumnsCountForWidth(o);M=this._getMaxColumnsCountForWidth(n);this._resizeColumns();if(M!==O){this._hideShowArrows();this._fireStateChange(false,true);}};j.prototype._setColumnPagesRendered=function(i,H){this._oRenderedColumnPagesBoolMap[i]=H;};j.prototype._hasAnyColumnPagesRendered=function(){return Object.keys(this._oRenderedColumnPagesBoolMap).some(function(K){return this._oRenderedColumnPagesBoolMap[K];},this);};j.prototype._onArrowClick=function(s){var i=this.getLayout(),n=typeof j.SHIFT_TARGETS[i]!=="undefined"&&typeof j.SHIFT_TARGETS[i][s]!=="undefined",o;d(n,"An invalid layout was used for determining arrow behavior");o=n?j.SHIFT_TARGETS[i][s]:g.OneColumn;this.setLayout(o);if(j.ARROWS_NAMES[o][s]!==j.ARROWS_NAMES[i][s]&&n){var O=s==='right'?'left':'right';this._oColumnSeparatorArrows[j.ARROWS_NAMES[o][O]].trigger("focus");}this._fireStateChange(true,false);};j.prototype._hideShowArrows=function(){var s=this.getLayout(),M={},n=[],i,o;if(!this.isActive()||D.system.phone){return;}i=this.getMaxColumnsCount();if(i>1){M[g.TwoColumnsBeginExpanded]=["beginBack"];M[g.TwoColumnsMidExpanded]=["midForward"];M[g.ThreeColumnsMidExpanded]=["midForward","midBack"];M[g.ThreeColumnsEndExpanded]=["endForward"];M[g.ThreeColumnsMidExpandedEndHidden]=["midForward","midBack"];M[g.ThreeColumnsBeginExpandedEndHidden]=["beginBack"];if(typeof M[s]==="object"){n=M[s];}}o=this._hasAnyColumnPagesRendered();Object.keys(this._oColumnSeparatorArrows).forEach(function(p){this._toggleButton(p,n.indexOf(p)!==-1,o);},this);};j.prototype._toggleButton=function(s,S,r){this._oColumnSeparatorArrows[s].toggle(S&&r);this._oColumnSeparatorArrows[s].data("visible",S);};j.prototype._fireStateChange=function(i,n){if(this._getControlWidth()===0){return;}this.fireStateChange({isNavigationArrow:i,isResize:n,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()});};j.prototype.setInitialBeginColumnPage=function(p){this._getBeginColumn().setInitialPage(p);this.setAssociation('initialBeginColumnPage',p,true);return this;};j.prototype.setInitialMidColumnPage=function(p){this._getMidColumn().setInitialPage(p);this.setAssociation('initialMidColumnPage',p,true);return this;};j.prototype.setInitialEndColumnPage=function(p){this._getEndColumn().setInitialPage(p);this.setAssociation('initialEndColumnPage',p,true);return this;};j.prototype.to=function(p,t,o,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().to(p,t,o,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().to(p,t,o,T);}else{this._getEndColumn().to(p,t,o,T);}return this;};j.prototype.backToPage=function(p,o,t){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().backToPage(p,o,t);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().backToPage(p,o,t);}else{this._getEndColumn().backToPage(p,o,t);}return this;};j.prototype._safeBackToPage=function(p,t,i,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn()._safeBackToPage(p,t,i,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn()._safeBackToPage(p,t,i,T);}else{this._getEndColumn()._safeBackToPage(p,t,i,T);}};j.prototype.toBeginColumnPage=function(p,t,o,T){this._getBeginColumn().to(p,t,o,T);return this;};j.prototype.toMidColumnPage=function(p,t,o,T){this._getMidColumn().to(p,t,o,T);return this;};j.prototype.toEndColumnPage=function(p,t,o,T){this._getEndColumn().to(p,t,o,T);return this;};j.prototype.backBeginColumn=function(i,t){return this._getBeginColumn().back(i,t);};j.prototype.backMidColumn=function(i,t){return this._getMidColumn().back(i,t);};j.prototype.backEndColumn=function(i,t){return this._getEndColumn().back(i,t);};j.prototype.backBeginColumnToPage=function(p,i,t){return this._getBeginColumn().backToPage(p,i,t);};j.prototype.backMidColumnToPage=function(p,i,t){return this._getMidColumn().backToPage(p,i,t);};j.prototype.backEndColumnToPage=function(p,i,t){return this._getEndColumn().backToPage(p,i,t);};j.prototype.backToTopBeginColumn=function(o,t){this._getBeginColumn().backToTop(o,t);return this;};j.prototype.backToTopMidColumn=function(o,t){this._getMidColumn().backToTop(o,t);return this;};j.prototype.backToTopEndColumn=function(o,t){this._getEndColumn().backToTop(o,t);return this;};j.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage();};j.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage();};j.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage();};j.prototype.setDefaultTransitionNameBeginColumn=function(t){this.setProperty("defaultTransitionNameBeginColumn",t,true);this._getBeginColumn().setDefaultTransitionName(t);return this;};j.prototype.setDefaultTransitionNameMidColumn=function(t){this.setProperty("defaultTransitionNameMidColumn",t,true);this._getMidColumn().setDefaultTransitionName(t);return this;};j.prototype.setDefaultTransitionNameEndColumn=function(t){this.setProperty("defaultTransitionNameEndColumn",t,true);this._getEndColumn().setDefaultTransitionName(t);return this;};j.prototype._getLayoutHistory=function(){return this._oLayoutHistory;};j.prototype._getColumnWidthDistributionForLayout=function(s,i,M){var o={},r;M||(M=this.getMaxColumnsCount());if(M===0){r="0/0/0";}else{o[g.OneColumn]="100/0/0";o[g.MidColumnFullScreen]="0/100/0";o[g.EndColumnFullScreen]="0/0/100";if(M===1){o[g.TwoColumnsBeginExpanded]="0/100/0";o[g.TwoColumnsMidExpanded]="0/100/0";o[g.ThreeColumnsMidExpanded]="0/0/100";o[g.ThreeColumnsEndExpanded]="0/0/100";o[g.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[g.ThreeColumnsBeginExpandedEndHidden]="0/0/100";}else{o[g.TwoColumnsBeginExpanded]="67/33/0";o[g.TwoColumnsMidExpanded]="33/67/0";o[g.ThreeColumnsMidExpanded]=M===2?"0/67/33":"25/50/25";o[g.ThreeColumnsEndExpanded]=M===2?"0/33/67":"25/25/50";o[g.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[g.ThreeColumnsBeginExpandedEndHidden]="67/33/0";}r=o[s];}if(i){r=r.split("/").map(function(n){return parseInt(n);});}return r;};j.DESKTOP_BREAKPOINT=1280;j.TABLET_BREAKPOINT=960;j.ARROWS_NAMES={TwoColumnsBeginExpanded:{"left":"beginBack"},TwoColumnsMidExpanded:{"right":"midForward"},ThreeColumnsMidExpanded:{"left":"midBack","right":"midForward"},ThreeColumnsEndExpanded:{"right":"endForward"},ThreeColumnsMidExpandedEndHidden:{"left":"midBack","right":"midForward"},ThreeColumnsBeginExpandedEndHidden:{"left":"beginBack"}};j._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};j.SHIFT_TARGETS={TwoColumnsBeginExpanded:{"left":g.TwoColumnsMidExpanded},TwoColumnsMidExpanded:{"right":g.TwoColumnsBeginExpanded},ThreeColumnsMidExpanded:{"left":g.ThreeColumnsEndExpanded,"right":g.ThreeColumnsMidExpandedEndHidden},ThreeColumnsEndExpanded:{"right":g.ThreeColumnsMidExpanded},ThreeColumnsMidExpandedEndHidden:{"left":g.ThreeColumnsMidExpanded,"right":g.ThreeColumnsBeginExpandedEndHidden},ThreeColumnsBeginExpandedEndHidden:{"left":g.ThreeColumnsMidExpandedEndHidden}};j.prototype.showPlaceholder=function(s){if(!sap.ui.getCore().getConfiguration().getPlaceholder()){return;}switch(s&&s.aggregation){case"beginColumnPages":return this.getAggregation("_beginColumnNav").showPlaceholder(s);case"midColumnPages":return this.getAggregation("_midColumnNav").showPlaceholder(s);default:return this.getAggregation("_endColumnNav").showPlaceholder(s);}};j.prototype.hidePlaceholder=function(s){switch(s.aggregation){case"beginColumnPages":this.getAggregation("_beginColumnNav").hidePlaceholder(s);break;case"midColumnPages":this.getAggregation("_midColumnNav").hidePlaceholder(s);break;default:this.getAggregation("_endColumnNav").hidePlaceholder(s);}};j.prototype.needPlaceholder=function(s,o){var i;switch(s){case"beginColumnPages":i=this.getAggregation("_beginColumnNav");break;case"midColumnPages":i=this.getAggregation("_midColumnNav");break;default:i=this.getAggregation("_endColumnNav");}return!o||(i.getCurrentPage()!==o);};function k(){this._aLayoutHistory=[];}k.prototype.addEntry=function(s){if(typeof s!=="undefined"){this._aLayoutHistory.push(s);}};k.prototype.getClosestEntryThatMatches=function(n){var i;for(i=this._aLayoutHistory.length-1;i>=0;i--){if(n.indexOf(this._aLayoutHistory[i])!==-1){return this._aLayoutHistory[i];}}};function A(){this._oListeners={};this._aPendingPromises=[];this._oPendingPromises={};this._oCancelPromises={};this._oPendingPromiseAll=null;}A.prototype.waitForColumnResizeEnd=function($){var i=$.get(0).id,p;if(!this._oPendingPromises[i]){p=new Promise(function(r,n){L.debug("FlexibleColumnLayout","wait for column "+i+" to resize");this._attachTransitionEnd($,function(){L.debug("FlexibleColumnLayout","completed column "+i+" resize");this._cleanUp($);r();}.bind(this));this._oCancelPromises[i]={cancel:function(){L.debug("FlexibleColumnLayout","cancel column "+i+" resize");this._cleanUp($);n();}.bind(this)};}.bind(this));this._aPendingPromises.push(p);this._oPendingPromises[i]=p;}return this._oPendingPromises[i];};A.prototype.waitForAllColumnsResizeEnd=function(){if(!this._oPendingPromiseAll){this._oPendingPromiseAll=new Promise(function(r,i){this.iTimer=setTimeout(function(){Promise.all(this._aPendingPromises).then(function(){L.debug("FlexibleColumnLayout","completed all columns resize");r();},0).catch(function(){i();});this.iTimer=null;}.bind(this));}.bind(this));}return this._oPendingPromiseAll;};A.prototype.isWaitingForColumnResizeEnd=function($){var i=$.get(0).id;return!!this._oListeners[i];};A.prototype.cancelAll=function(){Object.keys(this._oCancelPromises).forEach(function(i){this._oCancelPromises[i].cancel();},this);this._oPendingPromises={};this._aPendingPromises=[];this._oCancelPromises={};this._oPendingPromiseAll=null;if(this.iTimer){clearTimeout(this.iTimer);this.iTimer=null;}L.debug("FlexibleColumnLayout","detached all listeners for columns resize");};A.prototype._attachTransitionEnd=function($,i){var s=$.get(0).id;if(!this._oListeners[s]){$.on("webkitTransitionEnd transitionend",i);this._oListeners[s]=i;}};A.prototype._detachTransitionEnd=function($){var i=$.get(0).id;if(this._oListeners[i]){$.off("webkitTransitionEnd transitionend",this._oListeners[i]);this._oListeners[i]=null;}};A.prototype._cleanUp=function($){if($.length){var i=$.get(0).id;this._detachTransitionEnd($);delete this._oPendingPromises[i];delete this._oCancelPromises[i];}};return j;});
