/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./delegate/GridItemNavigation","./GridListRenderer","./GridNavigationMatrix","./library","sap/m/ListBase","sap/ui/base/ManagedObjectObserver","sap/ui/core/Core","sap/ui/Device","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/layout/cssgrid/GridLayoutBase"],function(G,a,b,l,L,M,C,D,c,d){"use strict";var N=l.NavigationDirection;var e=L.extend("sap.f.GridList",{metadata:{library:"sap.f",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable","sap.f.dnd.IGridDroppable"],aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false}},events:{borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}}}});e.prototype.init=function(){L.prototype.init.apply(this,arguments);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._addGridLayoutDelegate();this._oGridObserver=new M(e.prototype._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});};e.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null;}L.prototype.exit.apply(this,arguments);};e.prototype.onAfterPageLoaded=function(){L.prototype.onAfterPageLoaded.apply(this,arguments);if(this._oItemNavigation){this._oItemNavigation.resetFocusPosition();}};e.prototype.onItemNavigationBorderReached=function(p){var g=this.getGrowingInfo();if(p.direction===N.Down&&g&&g.actual!==g.total){return;}this.fireEvent("borderReached",p);};e.prototype.getGridDomRefs=function(){return[this.getItemsContainerDomRef()];};e.prototype.focusItemByDirection=function(s,r,i){this._oItemNavigation.focusItemByDirection(this,s,r,i);};e.prototype.getNavigationMatrix=function(){if(!C.isThemeApplied()){return null;}var i=this.getItems().reduce(function(A,I){if(I.getVisible()){A.push(I.getDomRef());}return A;},[]);return b.create(this.getItemsContainerDomRef(),i,this._getActiveLayoutSizes());};e.prototype.getGridLayoutConfiguration=e.prototype.getCustomLayout;e.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}if(!this._oItemNavigation){this._oItemNavigation=new G();this._oItemNavigation.setCycling(false).setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]}).setFocusedIndex(0);this.addDelegate(this._oItemNavigation);this._setItemNavigationTabIndex(0);}L.prototype._startItemNavigation.apply(this,arguments);};e.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new c();this.addEventDelegate(this.oGridLayoutDelegate,this);}};e.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeEventDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null;}};e.prototype._onGridChange=function(o){var f;if(o.name!=="items"||!o.child){return;}if(o.mutation==="insert"){f=!o.child.isA("sap.ui.core.HTML");o.child.addDelegate(this._oItemDelegate,f,o.child);}else if(o.mutation==="remove"){o.child.removeEventDelegate(this._oItemDelegate,o.child);}};e.prototype._onAfterItemRendering=function(){d.setItemStyles(this);};e.prototype.updateItems=function(){L.prototype.updateItems.apply(this,arguments);this.invalidate();};e.prototype.onLayoutDataChange=function(E){d.setItemStyles(E.srcControl);};e.prototype._getActiveLayoutSizes=function(){var g=this.getItemsContainerDomRef(),m=window.getComputedStyle(g);return{gap:parseFloat(m.rowGap),rows:m.gridTemplateRows.split(/\s+/),columns:m.gridTemplateColumns.split(/\s+/)};};return e;});
