/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/library","sap/m/Text","sap/ui/events/KeyCodes","sap/f/ProductSwitchItemRenderer"],function(C,I,l,T,K,P){"use strict";var a=l.TextAlign;var b=C.extend("sap.f.ProductSwitchItem",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",defaultValue:null},title:{type:"string",defaultValue:null},subTitle:{type:"string",defaultValue:null},targetSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{_icon:{type:"sap.ui.core.Icon",visibility:"hidden",multiple:false},_title:{type:"sap.m.Text",visibility:"hidden",multiple:false}}}});b.prototype.init=function(){this._bSpaceEnterPressed=false;this._bEscapeShiftKeyPress=false;};b.prototype.setTitle=function(t){this.setProperty("title",t);this._getTitle().setText(t);return this;};b.prototype.setSrc=function(s){this.setProperty("src",s);this._getIcon().setSrc(s);return this;};b.prototype.setSubTitle=function(s){this.setProperty("subTitle",s);this._getTitle().setMaxLines(s?1:2);return this;};b.prototype._getIcon=function(){var i=this.getAggregation("_icon");if(!i){i=new I();if(this.getSrc()){i.setSrc(this.getSrc());}this.setAggregation("_icon",i);}return i;};b.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({text:this.getTitle(),maxLines:2,textAlign:a.Initial}).addStyleClass("sapFPSItemMainTitle").addStyleClass("sapFPSItemTitle");this.setAggregation("_title",t);}return t;};b.prototype._getProductSwitch=function(){return this.getParent().getParent();};b.prototype.onkeyup=function(e){if((e.keyCode===K.SPACE&&!this._bEscapeShiftKeyPress)){this.fireEvent("_itemPress");}if(e.keyCode===K.SPACE||e.keyCode===K.ENTER){this._bSpaceEnterPressed=false;this._bEscapeShiftKeyPress=false;}};b.prototype.ontap=function(){this.fireEvent("_itemPress");};b.prototype.onkeydown=function(e){if((e.keyCode===K.ESCAPE||e.keyCode===K.SHIFT)&&this._bSpaceEnterPressed){this._bEscapeShiftKeyPress=true;}if(e.keyCode===K.SPACE||e.keyCode===K.ENTER){this._bSpaceEnterPressed=true;if(e.keyCode===K.ENTER&&!this._bEscapeShiftKeyPress){this.fireEvent("_itemPress");}e.preventDefault();}};return b;});
