/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseHeader","./NumericIndicators","sap/m/Text","sap/f/cards/NumericHeaderRenderer","sap/ui/core/Core"],function(B,N,T,a,C){"use strict";var b=B.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{"type":"string",group:"Appearance"},subtitle:{"type":"string",group:"Appearance"},statusText:{type:"string",defaultValue:""},unitOfMeasurement:{"type":"string",group:"Data"},number:{"type":"string",group:"Data"},scale:{"type":"string",group:"Data"},trend:{"type":"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{"type":"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{"type":"string",group:"Appearance"},sideIndicatorsAlignment:{"type":"sap.f.cards.NumericHeaderSideIndicatorsAlignment",group:"Appearance",defaultValue:"Begin"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true,forwarding:{getter:"_getNumericIndicators",aggregation:"sideIndicators"}},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_numericIndicators:{type:"sap.f.cards.NumericIndicators",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:a});b.prototype.init=function(){B.prototype.init.apply(this,arguments);this._oRb=C.getLibraryResourceBundle("sap.f");this.data("sap-ui-fastnavgroup","true",true);};b.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._oRb=null;};b.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};b.prototype.setSubtitle=function(v){this.setProperty("subtitle",v,true);this._getSubtitle().setText(v);return this;};b.prototype.setUnitOfMeasurement=function(v){this.setProperty("unitOfMeasurement",v,true);this._getUnitOfMeasurement().setText(v);return this;};b.prototype.setDetails=function(v){this.setProperty("details",v,true);this._getDetails().setText(v);return this;};b.prototype.setNumber=function(v){this.setProperty("number",v);this._getNumericIndicators().setNumber(v);return this;};b.prototype.setScale=function(v){this.setProperty("scale",v,true);this._getNumericIndicators().setScale(v);return this;};b.prototype.setTrend=function(v){this.setProperty("trend",v,true);this._getNumericIndicators().setTrend(v);return this;};b.prototype.setState=function(v){this.setProperty("state",v,true);this._getNumericIndicators().setState(v);return this;};b.prototype.setSideIndicatorsAlignment=function(v){this.setProperty("sideIndicatorsAlignment",v,true);this._getNumericIndicators().setSideIndicatorsAlignment(v);return this;};b.prototype._getTitle=function(){var c=this.getAggregation("_title");if(!c){c=new T({id:this.getId()+"-title",wrapping:true,maxLines:3});this.setAggregation("_title",c);}return c;};b.prototype._getSubtitle=function(){var c=this.getAggregation("_subtitle");if(!c){c=new T({id:this.getId()+"-subtitle",wrapping:true,maxLines:2});this.setAggregation("_subtitle",c);}return c;};b.prototype._getUnitOfMeasurement=function(){var c=this.getAggregation("_unitOfMeasurement");if(!c){c=new T({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",c);}return c;};b.prototype._getDetails=function(){var c=this.getAggregation("_details");if(!c){c=new T({id:this.getId()+"-details",wrapping:false});this.setAggregation("_details",c);}return c;};b.prototype._getNumericIndicators=function(){var c=this.getAggregation("_numericIndicators");if(!c){c=new N();this.setAggregation("_numericIndicators",c);}return c;};b.prototype.ontap=function(e){var s=e.srcControl;if(s&&s.getId().indexOf("overflowButton")>-1){return;}this.firePress();};b.prototype.onsapselect=function(){this.firePress();};b.prototype._getAriaLabelledBy=function(){var c="",t="",s="",S="",u=this._getUnitOfMeasurement().getId(),m="",d=this._getSideIndicatorIds(),D="",i;if(this.getParent()&&this.getParent()._ariaText){c=this.getParent()._ariaText.getId();}if(this.getTitle()){t=this._getTitle().getId();}if(this.getSubtitle()){s=this._getSubtitle().getId();}if(this.getStatusText()){S=this.getId()+"-status";}if(this.getDetails()){D=this._getDetails().getId();}if(this.getNumber()||this.getScale()){m=this._getNumericIndicators()._getMainIndicator().getId();}i=c+" "+t+" "+s+" "+S+" "+u+" "+m+" "+d+" "+D;return i.replace(/ {2,}/g,' ').trim();};b.prototype._getSideIndicatorIds=function(){return this.getSideIndicators().map(function(s){return s.getId();}).join(" ");};b.prototype.isLoading=function(){return false;};b.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");B.prototype.attachEvent.apply(this,m);this.invalidate();return this;};b.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");B.prototype.detachEvent.apply(this,m);this.invalidate();return this;};b.prototype._isInsideGridContainer=function(){var p=this.getParent();if(!p){return false;}p=p.getParent();if(!p){return false;}return p.isA("sap.f.GridContainer");};return b;});
