/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/Device','./ActionSheetRenderer','./Button',"sap/ui/thirdparty/jquery"],function(D,P,l,C,I,a,b,A,B,q){"use strict";var c=l.ButtonType;var d=l.DialogType;var e=l.PlacementType;var f=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:e.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"}});f.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);this._actionSelected=null;};f.prototype.exit=function(){b.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};f.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};f.prototype._setItemNavigation=function(){var g=this._getAllButtons(),h=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<g.length;i++){if(g[i].getEnabled()&&g[i].getVisible()){h.push(g[i].getFocusDomRef());}}if(this._oCancelButton){h.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(h);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}};f.prototype.onmousedown=function(E){if(E.srcControl.isA("sap.m.Button")&&this.getButtons().indexOf(E.srcControl)!==-1){this._actionSelected=E.srcControl;}};f.prototype.onBeforeRendering=function(){var t,p;this._clearItemNavigation();t=this.getTitle();if(this._parent&&!this.isPropertyInitial("title")&&this._parent.getTitle()!==t){if(b.system.phone){this._parent.setTitle(t);this._parent.setShowHeader(!!t);}if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}p=this.getPlacement();if(this._parent&&!b.system.phone&&!this.isPropertyInitial("placement")&&this._parent.setPlacement()!==p){this._parent.setPlacement(p);}};f.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};f.prototype.sapfocusleave=function(){this.close();};f.prototype.openBy=function(o){var t=this;if(!this._parent){var O=this.getParent();if(O){this.setParent(null);}if(!b.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t._onAfterClose(t._actionSelected);t._actionSelected=null;},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");this._parent._setAriaRoleApplication(true);}else{this._parent=new D({title:this.getTitle(),type:d.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(E){t.fireBeforeClose({origin:E.getParameter("origin")});},afterClose:function(E){t._actionSelected=E.getParameter("origin");t._onAfterClose(t._actionSelected);t._actionSelected=null;b.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined);}if(!b.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(b.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){D.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(O){O.addDependent(this._parent);}}if(!b.system.phone){this._parent.openBy(o);}else{this._parent.open();b.resize.attachHandler(this._fnOrientationChange);}};f.prototype.close=function(){if(this._parent){this._parent.close();}};f.prototype.isOpen=function(){return!!this._parent&&this._parent.isOpen();};f.prototype._createCancelButton=function(){if(!this._oCancelButton){var s=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new B(this.getId()+'-cancelBtn',{text:s,type:c.Reject,press:function(){if(b.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(b.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};f.prototype._getCancelButton=function(){if(b.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};f.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};f.prototype._preProcessActionButton=function(o){var t=o.getType();if(t!==c.Accept&&t!==c.Reject){o.setType(c.Transparent);}o.addStyleClass("sapMBtnInverted");if(!o.getIcon()){o.addStyleClass("sapMActionSheetButtonNoIcon");}o.addStyleClass("sapMActionSheetButton");this._parent&&this._parent.invalidate();return this;};f.prototype._buttonSelected=function(){if(b.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};f.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};f.prototype._addAriaHiddenTexts=function(o){var s=o.getId(),i;if(sap.ui.getCore().getConfiguration().getAccessibility()){i=new a(s+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",i,false);o.addAriaDescribedBy(i.getId());}};f.prototype._removeAriaHiddenTexts=function(o){o.getAriaDescribedBy().forEach(function(i){var g=sap.ui.getCore().byId(i);if(g instanceof a&&i.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",g,false);o.removeAriaDescribedBy(g);g.destroy();}},this);};f.prototype.addButton=function(o){this.addAggregation("buttons",o,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};f.prototype.insertButton=function(o,i){this.insertAggregation("buttons",o,i,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};f.prototype.removeButton=function(o){var r=this.removeAggregation("buttons",o,false);if(r){r.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(r);}return r;};f.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,o){o.detachPress(t._buttonSelected,t);t._removeAriaHiddenTexts(o);});return r;};f.prototype.clone=function(){var g=this.getButtons();for(var i=0;i<g.length;i++){g[i].detachPress(this._buttonSelected,this);}var o=C.prototype.clone.apply(this,arguments);for(var j=0;j<g.length;j++){g[j].attachPress(this._buttonSelected,this);}return o;};f.prototype._getAllButtons=function(){return this.getButtons();};f.prototype.getPopupHiddenLabelId=function(){return a.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS");};f.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};f.prototype._onAfterClose=function(o){this.fireAfterClose({origin:o});};return f;});
