/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Bar","./InstanceManager","./AssociativeOverflowToolbar","./ToolbarSpacer","./Title","./library","sap/m/Image","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/RenderManager","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/theming/Parameters","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/Device","sap/ui/core/library","sap/ui/events/KeyCodes","./TitlePropagationSupport","./DialogRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/units/Rem","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,a,l,b,C,c,P,S,R,d,f,g,h,D,j,K,k,m,L,q,n,o,p){"use strict";var O=j.OpenState;var r=l.DialogType;var s=l.DialogRoleType;var V=j.ValueState;var t=j.TitleLevel;var u=l.TitleAlignment;var v=n.getConfiguration().getAnimationMode();var U=v!==o.AnimationMode.none&&v!==o.AnimationMode.minimal;var w=U?300:10;var x=17;var y=p.toPx(1);var H=5;var z=g.get({name:"_sap_m_Dialog_VerticalMargin",callback:function(e){z=parseFloat(e);}});if(z){z=parseFloat(z);}else{z=3;}var E=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:r.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"function",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:s.Dialog,visibility:"hidden"},closeOnNavigation:{type:"boolean",group:"Behavior",defaultValue:true},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:u.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});h.call(E.prototype,{header:{suffix:"header"},subHeader:{selector:".sapMDialogSubHeader .sapMIBar"},content:{selector:".sapMDialogScrollCont"},footer:{suffix:"footer"}});k.call(E.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});E._bPaddingByDefault=(n.getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);E._initIcons=function(){if(E._mIcons){return;}E._mIcons={};E._mIcons[V.Success]=c.getIconURI("sys-enter-2");E._mIcons[V.Warning]=c.getIconURI("alert");E._mIcons[V.Error]=c.getIconURI("error");E._mIcons[V.Information]=c.getIconURI("information");};E.prototype.init=function(){var e=this;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=n.getConfiguration().getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");this.oPopup.setModal(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(i,G){e._setDimensions();e._adjustScrollingPane();if(e._oManuallySetPosition){i.at={left:e._oManuallySetPosition.x,top:e._oManuallySetPosition.y};}else{i.at=e._calcPosition();}e._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,i);e._registerContentResizeHandler();};if(E._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();};E.prototype.onBeforeRendering=function(){var e=this._getAnyHeader();if(!E._bPaddingByDefault&&this.hasStyleClass("sapUiPopupWithPadding")){L.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Dialog");}if(this._hasSingleScrollableContent()){this.setVerticalScrolling(false);this.setHorizontalScrolling(false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}if(this._oScroller){this._oScroller.setVertical(this.getVerticalScrolling());this._oScroller.setHorizontal(this.getHorizontalScrolling());}this._createToolbarButtons();if(n.getConfiguration().getAccessibility()&&this.getState()!=V.None){var i=new d({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",i);this.addAriaLabelledBy(i.getId());}if(e&&e.setTitleAlignment){e.setProperty("titleAlignment",this.getTitleAlignment(),true);}if(e&&this._getTitles(e).length===0){e._setRootAccessibilityRole("heading");e._setRootAriaLevel("2");}};E.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}};E.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};E.prototype.open=function(){var e=this.oPopup;e.setInitialFocusId(this.getId());var i=e.getOpenState();switch(i){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();e.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;e.setContent(this);e.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};E.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var e=this.oPopup;var i=this.oPopup.getOpenState();if(!(i===O.CLOSED||i===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});e.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;e.close();this._deregisterContentResizeHandler();}return this;};E.prototype.isOpen=function(){return!!this.oPopup&&this.oPopup.isOpen();};E.prototype.setIcon=function(i){this._bHasCustomIcon=true;return this.setProperty("icon",i);};E.prototype.setState=function(e){var i;this.setProperty("state",e);if(this._bHasCustomIcon){return this;}if(e===V.None){i="";}else{E._initIcons();i=E._mIcons[e];}this.setProperty("icon",i);return this;};E.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};E.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};E.prototype.onfocusin=function(e){var i=e.target;if(i.id===this.getId()+"-firstfe"){var G=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(G){G.focus();}}else if(i.id===this.getId()+"-lastfe"){var J=this._getFocusableHeader()||(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(J){J.focus();}}};E.prototype._getPromiseWrapper=function(){var e=this;return{reject:function(){e.currentPromise.reject();},resolve:function(){e.currentPromise.resolve();}};};E.prototype.onsapescape=function(e){var i=this.getEscapeHandler(),G={},J=this;if(this._isSpaceOrEnterPressed){return;}if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof i==='function'){new Promise(function(M,N){G.resolve=M;G.reject=N;J.currentPromise=G;i(J._getPromiseWrapper());}).then(function(M){J.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};E.prototype.onkeyup=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=false;}};E.prototype.onkeydown=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=true;}this._handleKeyboardDragResize(e);};E.prototype._handleKeyboardDragResize=function(e){if(e.target!==this._getFocusableHeader()||[K.ARROW_LEFT,K.ARROW_RIGHT,K.ARROW_UP,K.ARROW_DOWN].indexOf(e.keyCode)===-1){return;}if((!this.getResizable()&&e.shiftKey)||(!this.getDraggable()&&!e.shiftKey)){return;}var $=this._$dialog,i=this.getDomRef().getBoundingClientRect(),G={left:i.x,top:i.y},J=this._getAreaDimensions(),M=$.width(),N=$.height(),Q=$.outerHeight(true),W=e.shiftKey,X,Y;this._bDisableRepositioning=true;$.addClass('sapDialogDisableTransition');if(W){this._oManuallySetSize=true;this.$('cont').height('').width('');}switch(e.keyCode){case K.ARROW_LEFT:if(W){M-=y;}else{G.left-=y;}break;case K.ARROW_RIGHT:if(W){M+=y;}else{G.left+=y;}break;case K.ARROW_UP:if(W){N-=y;}else{G.top-=y;}break;case K.ARROW_DOWN:if(W){N+=y;}else{G.top+=y;}break;}if(W){Y=J.bottom-G.top-Q+N;if(e.keyCode===K.ARROW_DOWN){Y-=y;}X={width:Math.min(M,J.right-G.left),height:Math.min(N,Y)};}else{X={left:Math.min(Math.max(J.left,G.left),J.right-M),top:Math.min(Math.max(J.top,G.top),J.bottom-Q)};}$.css(X);};E.prototype._isSpaceOrEnter=function(e){var i=e.which||e.keyCode;return i==K.SPACE||i==K.ENTER;};E.prototype._openAnimation=function($,i,e){$.addClass("sapMDialogOpen");setTimeout(e,w);};E.prototype._closeAnimation=function($,i,e){$.removeClass("sapMDialogOpen");setTimeout(e,w);};E.prototype._setDimensions=function(){var $=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&D.system.phone,M=this.getType()===r.Message,G={};if(!e){if(!this._oManuallySetSize){G.width=this.getContentWidth()||undefined;G.height=this.getContentHeight()||undefined;}else{G.width=this._oManuallySetSize.width;G.height=this._oManuallySetSize.height;}}if(G.width=='auto'){G.width=undefined;}if(G.height=='auto'){G.height=undefined;}if((e&&!M)||(i)){this.$().addClass('sapMDialogStretched');}$.css(G);if(!this._oManuallySetSize&&!this._bDisableRepositioning){this._positionDialog();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};E.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};E.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i=this.getContentWidth(),M=this._calcMaxSizes().maxWidth;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(D.system.desktop&&!D.browser.chrome){var G=e.width()+"x"+e.height(),J=$.css("min-width")!==$.css("width");if(G!==this._iLastWidthAndHeightWithScroll&&J){if(this._hasVerticalScrollbar()&&(!i||i=='auto')&&!this.getStretch()&&e.width()<M){$.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":x});this._iLastWidthAndHeightWithScroll=G;}else{$.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null;}}}if(!this._oManuallySetSize&&!this._bDisableRepositioning){this._positionDialog();}};E.prototype._hasVerticalScrollbar=function(){var $=this.$('cont');return $[0].clientHeight<$[0].scrollHeight;};E.prototype._positionDialog=function(){var $=this.$();$.css(this._calcMaxSizes());$.css(this._calcPosition());};E.prototype._calcPosition=function(){var e=this._getAreaDimensions(),$=this.$(),i,G,J;if(D.system.phone&&this.getStretch()){i=0;G=0;}else if(this.getStretch()){i=this._percentOfSize(e.width,H);G=this._percentOfSize(e.height,z);}else{i=(e.width-$.outerWidth())/2;G=(e.height-$.outerHeight())/2;}J={top:Math.round(e.top+G)};J[this._bRTL?"right":"left"]=Math.round(e.left+i);return J;};E.prototype._calcMaxSizes=function(){var e=this._getAreaDimensions(),$=this.$(),i=$.find(".sapMDialogTitle").height()||0,G=$.find(".sapMDialogSubHeader").height()||0,J=$.find("footer").height()||0,M=i+G+J,N,Q;if(D.system.phone&&this.getStretch()){Q=e.width;N=e.height-M;}else{Q=this._percentOfSize(e.width,100-2*H);N=this._percentOfSize(e.height,100-2*z)-M;}if(N<parseInt($.css("min-height"))){L.error("Height of Within Area is not enough to fit dialog");}if(Q<parseInt($.css("min-width"))){L.error("Width of Within Area is not enough to fit dialog");}return{maxWidth:Math.floor(Q),maxHeight:Math.floor(N)};};E.prototype._getAreaDimensions=function(){var W=P.getWithinAreaDomRef(),e;if(W===window){e={left:0,top:0,width:W.innerWidth,height:W.innerHeight};}else{var i=W.getBoundingClientRect(),$=q(W);e={left:i.left+parseFloat($.css("border-left-width")),top:i.top+parseFloat($.css("border-top-width")),width:W.clientWidth,height:W.clientHeight};}e.right=e.left+e.width;e.bottom=e.top+e.height;return e;};E.prototype._percentOfSize=function(i,e){return Math.round(i*e/100);};E.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header",{titleAlignment:this.getTitleAlignment()});this.setAggregation("_header",this._header);}};E.prototype._applyTitleToHeader=function(){var e=this.getProperty("title");if(this._headerTitle){this._headerTitle.setText(e);}else{this._headerTitle=new a(this.getId()+"-title",{text:e,level:t.H2}).addStyleClass("sapMDialogTitle");this._header.addContentMiddle(this._headerTitle);}};E.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){return true;}return false;};E.prototype._getFocusDomRef=function(){var i=this.getInitialFocus();if(i){return document.getElementById(i);}return this._getFocusableHeader()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElement()||this._getFirstVisibleButtonDomRef()||this.getDomRef();};E.prototype._getFirstVisibleButtonDomRef=function(){var e=this.getBeginButton(),G=this.getEndButton(),J=this.getButtons(),M;if(e&&e.getVisible()){M=e.getDomRef();}else if(G&&G.getVisible()){M=G.getDomRef();}else if(J&&J.length>0){for(var i=0;i<J.length;i++){if(J[i].getVisible()){M=J[i].getDomRef();break;}}}return M;};E.prototype._getFocusableHeader=function(){if(!this._isDraggableOrResizable()){return null;}return this.$().find('header.sapMDialogTitle')[0];};E.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');return $.firstFocusableDomRef();};E.prototype._getFirstFocusableContentElement=function(){var $=this.$("cont");return $.firstFocusableDomRef();};E.prototype._setInitialFocus=function(){var e=this._getFocusDomRef(),i;if(e&&e.id){i=n.byId(e.id);}if(i){if(i.getVisible&&!i.getVisible()){this.focus();return;}e=i.getFocusDomRef();}if(!e){this.setInitialFocus("");e=this._getFocusDomRef();}if(!this.getInitialFocus()){this.setAssociation('initialFocus',e?e.id:this.getId(),true);}if(D.system.desktop||(e&&!/input|textarea|select/i.test(e.tagName))){if(e){e.focus();}}else{this.focus();}};E.prototype.getScrollDelegate=function(){return this._oScroller;};E.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};E.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){return e;}else{var i=this.getShowHeader();if(!i){return null;}this._createHeader();this._applyTitleToHeader();this._applyIconToHeader();return this._header;}};E.prototype._deregisterResizeHandler=function(){var W=P.getWithinAreaDomRef();if(W===window){D.resize.detachHandler(this._onResize,this);}else{f.deregister(this._withinResizeListenerId);this._withinResizeListenerId=null;}};E.prototype._registerResizeHandler=function(){var W=P.getWithinAreaDomRef();if(W===window){D.resize.attachHandler(this._onResize,this);}else{this._withinResizeListenerId=f.register(W,this._onResize.bind(this));}this._onResize();};E.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){f.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};E.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=f.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};E.prototype._attachHandler=function(e){var i=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){i._oCloseTrigger=this;},onkeyup:function(){i._oCloseTrigger=this;},onkeydown:function(){i._oCloseTrigger=this;}};}if(e){e.addDelegate(this._oButtonDelegate,true,e);}};E.prototype._createToolbarButtons=function(){var e=this._getToolbar();var i=this.getButtons();var G=this.getBeginButton();var J=this.getEndButton(),M=this,N=[G,J];N.forEach(function(Q){if(Q&&M._oButtonDelegate){Q.removeDelegate(M._oButtonDelegate);}});e.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}e.addContent(this._toolbarSpacer);N.forEach(function(Q){M._attachHandler(Q);});if(i&&i.length){i.forEach(function(Q){e.addContent(Q);});}else{if(G){e.addContent(G);}if(J){e.addContent(J);}}};E.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===r.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}}},false,this);this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};E.prototype.getValueStateString=function(e){var i=n.getLibraryResourceBundle("sap.m");switch(e){case(V.Success):return i.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return i.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return i.getText("LIST_ITEM_STATE_ERROR");case(V.Information):return i.getText("LIST_ITEM_STATE_INFORMATION");default:return"";}};E.prototype._isDraggableOrResizable=function(){return!this.getStretch()&&(this.getDraggable()||this.getResizable());};E.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(i){e.setProperty("visible",i);this.invalidate();}.bind(this);}return this;};E.prototype.setLeftButton=function(e){if(typeof e==="string"){e=n.byId(e);}this.setBeginButton(e);return this.setAssociation("leftButton",e);};E.prototype.setRightButton=function(e){if(typeof e==="string"){e=n.byId(e);}this.setEndButton(e);return this.setAssociation("rightButton",e);};E.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null;};E.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};E.prototype.setBeginButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogBeginButton");}return this.setAggregation("beginButton",e);};E.prototype.setEndButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogEndButton");}return this.setAggregation("endButton",e);};E.prototype.getAggregation=function(e,i,G){var J=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==='buttons'&&J&&J.length===0){this.getBeginButton()&&J.push(this.getBeginButton());this.getEndButton()&&J.push(this.getEndButton());}return J;};E.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),i=this.getAssociation("ariaLabelledBy",[]).slice();var G=this.getSubHeader();if(G){var J=this._getTitles(G);if(J.length){i=J.map(function(N){return N.getId();}).concat(i);}}if(e){var M=this._getTitles(e);if(M.length){i=M.map(function(N){return N.getId();}).concat(i);}else{i.unshift(e.getId());}}return i;};E.prototype._applyIconToHeader=function(){var i=this.getIcon();if(!i){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}return;}if(!this._iconImage){this._iconImage=c.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},b).addStyleClass("sapMDialogIcon");this._header.insertAggregation("contentMiddle",this._iconImage,0);}this._iconImage.setSrc(i);};E.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};E.prototype.invalidate=function(e){if(this.isOpen()){C.prototype.invalidate.call(this,e);}};function F(e){var $=q(e);var i=$.control(0);if($.parents('.sapMDialogSection').length){return false;}if(!i||i.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}if(D.system.desktop){E.prototype.ondblclick=function(e){if(F(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);$.css({height:'100%'});}};E.prototype.onmousedown=function(e){if(e.which===3){return;}if(!this._isDraggableOrResizable()){return;}var i;var G=this;var $=q(document);var J=q(e.target);var M=J.hasClass('sapMDialogResizeHandler')&&this.getResizable();var N=function(e1){i=i?clearTimeout(i):setTimeout(function(){e1();},0);};var Q=this._getAreaDimensions();var W=this.getDomRef().getBoundingClientRect();var X={x:e.clientX,y:e.clientY,width:G._$dialog.width(),height:G._$dialog.height(),outerHeight:G._$dialog.outerHeight(),position:{x:W.x,y:W.y}};var Y;function Z(){var e1=G.$(),f1=G.$('cont'),g1,h1;$.off("mouseup",Z);$.off("mousemove",Y);if(M){G._$dialog.removeClass('sapMDialogResizing');g1=parseInt(e1.height());h1=parseInt(e1.css("border-top-width"))+parseInt(e1.css("border-bottom-width"));f1.height(g1+h1);}}if(F(e.target)&&this.getDraggable()||M){G._bDisableRepositioning=true;G._$dialog.addClass('sapDialogDisableTransition');}if(F(e.target)&&this.getDraggable()){Y=function(e1){e1.preventDefault();if(e1.buttons===0){Z();return;}N(function(){G._bDisableRepositioning=true;G._oManuallySetPosition={x:Math.max(Q.left,Math.min(e1.clientX-e.clientX+X.position.x,Q.right-X.width)),y:Math.max(Q.top,Math.min(e1.clientY-e.clientY+X.position.y,Q.bottom-X.outerHeight))};G._$dialog.css({top:G._oManuallySetPosition.y,left:G._oManuallySetPosition.x,right:G._bRTL?"":undefined});});};}else if(M){G._$dialog.addClass('sapMDialogResizing');var _={};var a1=parseInt(G._$dialog.css('min-width'));var b1=X.x+X.width-a1;var c1=J.width()-e.offsetX;var d1=J.height()-e.offsetY;Y=function(e1){N(function(){G._bDisableRepositioning=true;G.$('cont').height('').width('');if(e1.clientY+d1>Q.bottom){e1.clientY=Q.bottom-d1;}if(e1.clientX+c1>Q.right){e1.clientX=Q.right-c1;}G._oManuallySetSize={width:X.width+e1.clientX-X.x,height:X.height+e1.clientY-X.y};if(G._bRTL){_.left=Math.min(Math.max(e1.clientX,0),b1);G._oManuallySetSize.width=X.width+X.x-Math.max(e1.clientX,0);}_.width=G._oManuallySetSize.width;_.height=G._oManuallySetSize.height;G._$dialog.css(_);});};}else{return;}$.on("mousemove",Y);$.on("mouseup",Z);e.stopPropagation();};}E.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};E.prototype._getTitles=function(e){return e.findAggregatedObjects(true,function(i){return i.isA("sap.m.Title");});};return E;});
