/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Element','./Label','./StepInput','sap/ui/unified/Calendar','sap/ui/unified/DateRange','sap/ui/unified/calendar/MonthPicker'],function(E,L,S,C,D,M){"use strict";var a=E.extend("sap.m.DynamicDateOption",{metadata:{library:"sap.m",properties:{key:{type:"string"},valueTypes:{type:"string[]",multiple:true}}}});a.prototype.getText=function(c){return this.getKey();};a.prototype.getValueHelpUITypes=function(c){throw new Error("Need implementation for method getValueHelpUITypes. Option: "+this.getKey());};a.prototype.createValueHelpUI=function(c,f){var v=c.getValue();var p=this.getValueHelpUITypes(c);var b=[];var I;if(!c.aControlsByParameters){c.aControlsByParameters={};}c.aControlsByParameters[this.getKey()]=[];for(var i=0;i<p.length;i++){if(p[i].getText()){b.push(new L({text:p[i].getText(),width:"100%"}));}I=this._createControl(i,p[i].getType(),v,f);b.push(I);c.aControlsByParameters[this.getKey()].push(I);}return b;};a.prototype.validateValueHelpUI=function(c){var p=this.getValueHelpUITypes();for(var i=0;i<p.length;i++){var I=c.aControlsByParameters[this.getKey()][i];switch(p[i].getType()){case"int":if(I._isLessThanMin(I.getValue())||I._isMoreThanMax(I.getValue())){return false;}break;case"month":case"date":case"daterange":if(!I.getSelectedDates()||I.getSelectedDates().length==0){return false;}break;}}return true;};a.prototype.getValueHelpOutput=function(c){var p=this.getValueHelpUITypes(),r={},o;r.operator=this.getKey();r.values=[];for(var i=0;i<p.length;i++){var I=c.aControlsByParameters[this.getKey()][i];switch(p[i].getType()){case"int":o=I.getValue();break;case"month":case"date":if(!I.getSelectedDates().length){return null;}o=I.getSelectedDates()[0].getStartDate();break;case"daterange":if(!I.getSelectedDates().length){return null;}var e=I.getSelectedDates()[0].getEndDate()||I.getSelectedDates()[0].getStartDate();o=[I.getSelectedDates()[0].getStartDate(),e];break;}if(Array.isArray(o)){r.values=Array.prototype.concat.apply(r.values,o);}else{o&&r.values.push(o);}}return r;};a.prototype.getGroup=function(){return 0;};a.prototype.getGroupHeader=function(){var g=(this.getGroup()>-1&&this.getGroup()<7)?this.getGroup():0;return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DDR_OPTIONS_GROUP_"+g);};a.prototype.format=function(v){throw new Error("Need implementation for method format. Option: "+this.getKey());};a.prototype.parse=function(v){throw new Error("Need implementation for method parse. Option: "+this.getKey());};a.prototype.toDates=function(v){throw new Error("Need implementation for method toDates. Option: "+this.getKey());};a.prototype.enhanceFormattedValue=function(){return false;};a.prototype._createControl=function(i,u,v,c){var I;switch(u){case"int":I=this._createIntegerControl(v,i,c);break;case"date":I=this._createDateControl(v,i,c);break;case"daterange":I=this._createDateRangeControl(v,i,c);break;case"month":I=this._createMonthControl(v,i,c);break;}return I;};a.prototype._createIntegerControl=function(v,i,c){var o=new S({width:"120px"});if(v&&this.getKey()===v.operator){o.setValue(v.values[i]);}if(c instanceof Function){o.attachChange(function(){c(this);},this);}return o;};a.prototype._createDateControl=function(v,i,c){var o=new C({width:"100%"});if(v&&this.getKey()===v.operator){o.addSelectedDate(new D({startDate:v.values[i]}));}if(c instanceof Function){o.attachSelect(function(){c(this);},this);}return o;};a.prototype._createDateRangeControl=function(v,i,c){var o=new C({intervalSelection:true,width:"100%"});if(v&&this.getKey()===v.operator){o.addSelectedDate(new D({startDate:v.values[i],endDate:v.values[i+1]}));}if(c instanceof Function){o.attachSelect(function(){c(this);},this);}return o;};a.prototype._createMonthControl=function(v,i,c){var o=new M(),d=new Date(),m=(v&&this.getKey()===v.operator)?v.values[i]:d.getMonth();o.setMonth(m);o.addSelectedDate(new D({startDate:d}));if(c instanceof Function){o.attachSelect(function(){c(this);},this);}return o;};return a;});
