/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/InvisibleText','sap/ui/core/Element','sap/ui/core/Control','sap/ui/core/ListItem','sap/ui/core/library',"sap/ui/core/Renderer",'sap/ui/core/message/MessageMixin','sap/m/DynamicDateFormat','sap/m/DynamicDateUtil','sap/ui/core/IconPool','sap/ui/core/Icon',"sap/ui/core/LabelEnablement",'sap/ui/core/format/DateFormat','sap/ui/base/ManagedObjectObserver','sap/ui/Device','./Label','./GroupHeaderListItem','./StandardListItem','./StandardListItemRenderer','./Button','./List','./Input','./InputRenderer','./Toolbar','./ResponsivePopover','./Page','./NavContainer','./DynamicDateRangeRenderer','./StandardDynamicDateOption','sap/ui/dom/jquery/Focusable','./library'],function(I,E,C,L,c,R,M,D,d,e,f,g,h,i,j,k,G,S,l,B,m,n,p,T,q,P,N,r,s,F,t){"use strict";var V=c.ValueState,u=t.ToolbarDesign,v=t.ToolbarStyle,w=t.ListType,x=t.ListMode,y=t.ListSeparators,z=sap.ui.getCore().getLibraryResourceBundle("sap.m");var A=C.extend("sap.m.DynamicDateRange",{metadata:{library:"sap.m",properties:{value:{type:"object"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},required:{type:"boolean",group:"Misc",defaultValue:false},enableGroupHeaders:{type:"boolean",group:"Behavior",defaultValue:true},formatter:{type:"object"},options:{type:"string[]",group:"Behavior",defaultValue:["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","FROM","TO","YEARTODATE","DATETOYEAR","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR"]}},aggregations:{_input:{type:"sap.m.Input",multiple:false,visibility:"hidden"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"object"},valid:{type:"boolean"}}}}},renderer:r});M.call(A.prototype);A.prototype.init=function(){this._oInput=new J(this.getId()+"-input",{showValueHelp:true,valueHelpIconSrc:e.getIconURI("sap-icon://check-availability"),valueHelpRequest:this._toggleOpen.bind(this),showSuggestion:true,suggest:this._handleSuggest.bind(this)});this._oListItemDelegate=undefined;this._onBeforeInputRenderingDelegate={onBeforeRendering:function(){this._oInput._getValueHelpIcon().setVisible(true);}};this._oInput._getValueHelpIcon().setTooltip(z.getText("INPUT_VALUEHELP_BUTTON"));this._oInput.addDelegate(this._onBeforeInputRenderingDelegate,this);this.setAggregation("_input",this._oInput,false);this._oInput._setControlOrigin(this);this._oInput.attachChange(this._handleInputChange,this);this.oValueObserver=new i(function(){delete this.oBoundValueFormatter;}.bind(this));this.oValueObserver.observe(this,{bindings:["value"]});};A.prototype.exit=function(){this._oInput.removeDelegate(this._onBeforeInputRenderingDelegate);this._onBeforeInputRenderingDelegate=undefined;this.oValueObserver.destroy();this._infoDatesFooter=undefined;this.aInputControls=undefined;this._removeAllListItemDelegates();};A.prototype._removeAllListItemDelegates=function(){if(this._oOptionsList){this._oOptionsList.getItems().forEach(function(o){o.removeDelegate(this._oListItemDelegate);},this);}};A.prototype.onBeforeRendering=function(){this._updateInputValue(this.getValue());this._oInput.setEditable(this.getEditable());this._oInput.setEnabled(this.getEnabled());this._oInput.setRequired(this.getRequired());this._oInput.setName(this.getName());this._oInput.setWidth(this.getWidth());this._oInput.setPlaceholder(this.getPlaceholder());this._oInput.setValueState(this.getValueState());this._oInput.setValueStateText(this.getValueStateText());};A.prototype.setValue=function(o){o=this._substitudeValue(o);this.setProperty("value",o);this._updateInputValue(o);return this;};A.prototype._toggleOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){this._closePopup();}else{this.open();}};A.prototype.open=function(){if(this.getEditable()&&this.getEnabled()){this._createPopup();this._createPopupContent();if(!this._oListItemDelegate){this._oListItemDelegate={onsapshow:this._closePopup.bind(this),onsaphide:this._closePopup.bind(this)};}this._removeAllListItemDelegates();this._oOptionsList.destroyAggregation("items");this._collectValueHelpItems(this._getOptions(),true).map(function(o){if(typeof(o)==="string"){return this._createHeaderListItem(o);}return this._createListItem(o);},this).forEach(function(o){o.addDelegate(this._oListItemDelegate,this);this._oOptionsList.addItem(o);},this);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._openPopup();}};A.prototype.addOption=function(a){var o=this.getOptions();if(o.indexOf(a)===-1){o.push(a);}this.setOptions(o);};A.prototype.getFocusDomRef=function(){return this.getAggregation("_input")&&this.getAggregation("_input").getFocusDomRef();};A.prototype._updateInputValue=function(o){var a;if(o&&o.operator!=="PARSEERROR"){a=this._enhanceInputValue(this._formatValue(o),o);this._oInput.setValue(a);}};A.prototype._handleSuggest=function(o){if(this._oPopup&&this._oPopup.isOpen()){this._closePopup();}var Q=o.getParameter("suggestValue");this._oInput.removeAllSuggestionItems();var a=this._getOptions().filter(function(O){var U={operator:O.getKey(),values:[]},W=O.getValueHelpUITypes(this);if(W.length&&W[0].getType()){return false;}var X=d.getOption(U.operator).format(U,this._getFormatter()).toLowerCase();var Y=X.indexOf(Q.toLowerCase());return Y===0||(Y>0&&X[Y-1]===" ");},this);this._collectValueHelpItems(a,true).forEach(function(O){if(O.getKey){var U={operator:O.getKey(),values:[]};this._addSuggestionItem(U);}else{this._addSuggestionGroupItem(O);}},this);var b=Q.match(/\d+/);if(!b){return;}a=this._getOptions().filter(function(O){return O.getValueHelpUITypes(this).length===1&&O.getValueHelpUITypes(this)[0].getType()==="int";},this);this._collectValueHelpItems(a,false).forEach(function(O){if(O.getKey){var U={operator:O.getKey(),values:[parseInt(b[0])]};this._addSuggestionItem(U);}else{this._addSuggestionGroupItem(O);}},this);};A.prototype._getOptions=function(){var O=this.getOptions();var a=O.map(function(b){return d.getOption(b);},this);return a.filter(function(o){return!!o;});};A.prototype._getDatesLabelFormatter=function(){if(!this._oDatesLabelFormatter){var o=Object.create(this._getFormatter()._dateFormatter.oFormatOptions);o.interval=true;this._oDatesLabelFormatter=h.getInstance(o);}return this._oDatesLabelFormatter;};A.prototype._destroyInputControls=function(){if(!this.aInputControls){return;}this.aInputControls.forEach(function(o){o.destroy();});this.aInputControls=undefined;};A.prototype._addSuggestionItem=function(o){var a=d.toDates(o);var b=new L({text:d.getOption(o.operator).format(o,this._getFormatter()),additionalText:this._getDatesLabelFormatter().format(a)});this._oInput.addSuggestionItem(b);};A.prototype._addSuggestionGroupItem=function(a){this._oInput.addSuggestionItemGroup({text:a});};A.prototype._handleInputChange=function(o){var a=o.getParameter("value");var b=this._parseValue(this._stripValue(a));var O=this.getValue();var Q=a.trim()===""||!!b;if(!Q){this.setValue({operator:"PARSEERROR",values:[z.getText("DDR_WRONG_VALUE"),a]});}else{this.setValue(b);}this.fireChange({value:this.getValue(),prevValue:O,valid:Q});};A.prototype._enhanceInputValue=function(a,o){if(d.getOption(o.operator).enhanceFormattedValue()||(o.operator==="LASTDAYS"&&o.values[0]<=1)||(o.operator==="NEXTDAYS"&&o.values[0]<=1)){return a+" ("+this._toDatesString(o)+")";}return a;};A.prototype._stripValue=function(a){var o=a.indexOf("(");var b=a.lastIndexOf(")");var O=a;if(o!==-1&&b!==-1&&o<b){O=a.slice(0,o)+a.slice(b+1);O=O.trim();}return O;};A.prototype._toDatesString=function(o){return this._getDatesLabelFormatter().format(d.toDates(o));};A.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new q(this.getId()+"-RP",{contentHeight:'470px',contentWidth:_(this.getDomRef())?'272px':'320px',showCloseButton:false,showArrow:false,showHeader:false,placement:t.PlacementType.VerticalPreferedBottom,ariaLabelledBy:[I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")]});this._oPopup.addStyleClass("sapMDDRPopover");if(j.system.phone){this._oPopup.addStyleClass("sapUiNoContentPadding");}else{this._oPopup._oControl._getSingleNavContent=function(){return null;};}this._oPopup.attachAfterOpen(function(){var o=this._oNavContainer.getPages()[0];this._applyNavContainerPageFocus(o);this.invalidate();},this);this._oPopup.attachAfterClose(function(){this._setFooterVisibility(false);this.invalidate();},this);this._oPopup.setBeginButton(new B({type:t.ButtonType.Emphasized,text:z.getText("DYNAMIC_DATE_RANGE_CONFIRM"),press:this._applyValue.bind(this)}));this._oPopup.setEndButton(new B({text:z.getText("DYNAMIC_DATE_RANGE_CANCEL"),press:this._closePopup.bind(this)}));this._setFooterVisibility(false);this._oPopup._getPopup().setAutoClose(true);this.setAggregation("_popup",this._oPopup,true);}};A.prototype._collectValueHelpItems=function(o,O){var Q;var U;var W=[];var X=o;var Y=d.getStandardKeys();X.sort(function(a,b){var Z=a.getGroup()-b.getGroup();if(Z){return Z;}return Y.indexOf(a.getKey())-Y.indexOf(b.getKey());});if(O){X=X.reduce(function(a,b){if(s.LastXKeys.indexOf(b.getKey())!==-1){if(Q){return a;}Q=true;}if(s.NextXKeys.indexOf(b.getKey())!==-1){if(U){return a;}U=true;}a.push(b);return a;},[]);}if(this.getEnableGroupHeaders()){X=X.reduce(function(a,b){var Z=b.getGroupHeader();if(W.indexOf(Z)===-1){W.push(Z);a.push(Z);}a.push(b);return a;},[]);}return X;};A.prototype._createListItem=function(o){var b=this._isFixedOption(o);return new K(this.getId()+"-option-"+o.getKey(),{type:b?w.Active:w.Navigation,title:o.getText(this),wrapping:true,optionKey:o.getKey(),press:this._handleOptionPress.bind(this)});};A.prototype._createHeaderListItem=function(a){var o=new G();o.setTitle(a);o._bGroupHeader=true;return o;};A.prototype._handleOptionPress=function(o){var O=o.getSource().getOptionKey(),a=d.getOption(O);this._oSelectedOption=a;if(this._isFixedOption(a)){this._applyValue();}else{var b=this._createInfoDatesFooter();this._destroyInputControls();this.aInputControls=a.createValueHelpUI(this,this._updateInternalControls.bind(this));var Q=this._oNavContainer.getPages()[1];Q.removeAllContent();this.aInputControls.forEach(function(U){Q.addContent(U);});Q.setFooter(b);Q.setTitle(a.getText(this));this._setFooterVisibility(true);this._updateInternalControls(a);this._oNavContainer.to(Q);}};A.prototype._isFixedOption=function(o){return!o.getValueHelpUITypes(this).length;};A.prototype._createInfoDatesFooter=function(){this._infoDatesFooter=new T({design:u.Info,style:v.Clear,content:[new k({text:z.getText("DDR_INFO_DATES_EMPTY_HINT")})]});return this._infoDatesFooter;};A.prototype._getDatesLabel=function(){return this._infoDatesFooter.getContent()[0];};A.prototype._updateDatesLabel=function(){var o=this._oSelectedOption.getValueHelpOutput(this),a,b;if(!o||!o.operator||!d.getOption(o.operator)){return;}a=d.toDates(o);if(a){b=this._getDatesLabelFormatter().format(a);this._getDatesLabel().setText(z.getText("DDR_INFO_DATES",[b]));}};A.prototype._setApplyButtonEnabled=function(b){if(!this._oPopup){return;}var a=this._oPopup.getBeginButton();if(a.getVisible()){a.setEnabled(b);}};A.prototype._updateInternalControls=function(o){var b=o.validateValueHelpUI(this);if(b){this._updateDatesLabel();}this._setApplyButtonEnabled(b);};A.prototype._setFooterVisibility=function(b){var o;if(!this._oPopup){return;}o=this._oPopup.getAggregation("_popup");if(j.system.phone){this._oPopup.getBeginButton().setVisible(b);}else{o.getFooter().setVisible(b);}o.invalidate();return this;};A.prototype._createPopupContent=function(){var o=new P({showHeader:false,showNavButton:false}),a=new P({showHeader:true,showNavButton:true}).addStyleClass("sapMDynamicDateRangePopover");a.attachNavButtonPress(function(){this._setFooterVisibility(false);this._oNavContainer.back();},this);if(j.system.phone){o.setShowHeader(true);o.setTitle(this._getOptionsPageTitleText());}if(!this._oOptionsList){this._oOptionsList=new m({showSeparators:y.None,mode:x.None});}if(!this._oNavContainer){this._oNavContainer=new N({autoFocus:false});this._oNavContainer.addPage(o);this._oNavContainer.setInitialPage(o);this._oNavContainer.addPage(a);this._oNavContainer.attachAfterNavigate(this._navContainerAfterNavigate,this);this._oPopup.addContent(this._oNavContainer);}this._oNavContainer.getPages()[0].removeAllContent();this._oNavContainer.getPages()[0].addContent(this._oOptionsList);return this._oOptionsList;};A.prototype._applyNavContainerPageFocus=function(o){var a=this.getValue(),O=this._oNavContainer.getPages()[0],b;if(o===O&&a){b=this._oOptionsList.getItems().find(function(Q){return Q.isA("sap.m.DynamicDateRangeListItem")&&(Q.getOptionKey()===a.operator);});}if(!b){b=jQuery(o.getDomRef().querySelector("section")).firstFocusableDomRef();}b.focus();this._reApplyFocusToElement(o,a);};A.prototype._reApplyFocusToElement=function(o,a){};A.prototype._getOptionsPageTitleText=function(){return g.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(a,b){var o=E.registry.get(b);return a+" "+(o.getText?o.getText():"");},"").trim();};A.prototype._navContainerAfterNavigate=function(o){var O=this._oNavContainer.getPages()[1],a=o.getParameters()["to"];if(a===O){this.aInputControls.forEach(function(b){if(jQuery(b.getDomRef()).firstFocusableDomRef()){b.addAriaLabelledBy(a.getAggregation("_internalHeader"));if(!this._isCalendarBasedControl(b)&&b.addAriaDescribedBy){b.addAriaDescribedBy(a.getFooter().getContent()[0]);}}},this);}if(this._oPopup&&this._oPopup.isOpen()){this._applyNavContainerPageFocus(a);}else{this.focus();}};A.prototype._isCalendarBasedControl=function(o){return o.isA("sap.ui.unified.Calendar")||o.isA("sap.ui.unified.calendar.CustomMonthPicker")||o.isA("sap.ui.unified.calendar.MonthPicker")||o.isA("sap.ui.unified.calendar.YearPicker")||o.isA("sap.ui.unified.calendar.YearRangePicker")||o.isA("sap.ui.unified.calendar.Month");};A.prototype._openPopup=function(){if(!this._oPopup){return;}this._oPopup._getPopup().setAutoCloseAreas([this._oInput.getDomRef()]);this._oPopup.openBy(this._oInput);};A.prototype._applyValue=function(){this._oOutput=this._oSelectedOption.getValueHelpOutput(this);var a=this.getValue();this.setValue(this._oOutput);this.fireChange({prevValue:a,value:this.getValue(),valid:true});this._closePopup();};A.prototype._closePopup=function(){this._setFooterVisibility(false);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._oPopup.close();};A.prototype._getFormatter=function(){var o=this.getFormatter(),b;if(o){return o;}if(this.oBoundValueFormatter){return this.oBoundValueFormatter;}b=this.getBinding("value");if(b&&b.getType()){this.oBoundValueFormatter=D.getInstance(b.getType().oFormatOptions);return this.oBoundValueFormatter;}if(!this.oDefaultFormatter){this.oDefaultFormatter=D.getInstance();}return this.oDefaultFormatter;};A.prototype._formatValue=function(o){return d.getOption(o.operator).format(o,this._getFormatter());};A.prototype._parseValue=function(a){var b=d.parse(a,this._getFormatter(),this.getOptions()).filter(function(o){return this.getOptions().indexOf(o.operator)!==-1;},this);return b.length?b[0]:null;};A.prototype._substitudeValue=function(o){var a,b,O;if(!o||!o.operator||!o.values){return o;}a=o.operator;b=o.values;if(a==="LASTDAYS"&&b[0]===1){O={operator:"YESTERDAY",values:[]};}else if(a==="NEXTDAYS"&&b[0]===1){O={operator:"TOMORROW",values:[]};}else if((a==="LASTDAYS"||a==="NEXTDAYS")&&b[0]===0){O={operator:"TODAY",values:[]};}return O?O:o;};var H=R.extend(p);H.apiVersion=2;H.getAriaRole=function(o){return"combobox";};H.writeInnerAttributes=function(o,a){o.attr("type","text");};H.getAccessibilityState=function(o){var a=p.getAccessibilityState(o),b=o._getControlOrigin(),O=b.getAriaLabelledBy(),Q=g.getReferencingLabels(b),U=b.getAriaDescribedBy().join(" "),W;W=Q.concat(O).join(" ");if(U){a.describedby=U;}if(W){a.labelledby=W;}a.roledescription=z.getText("ACC_CTR_TYPE_DYNAMIC_DATE_RANGE");a.role=this.getAriaRole();a.expanded=b._oPopup?b._oPopup.isOpen():false;a.haspopup=c.aria.HasPopup.ListBox.toLowerCase();a.autocomplete="list";a.controls=b._oPopup&&b._oPopup.getDomRef()?b._oPopup.getDomRef().id:undefined;return a;};var J=n.extend("sap.m.internal.DynamicDateRangeInput",{metadata:{library:"sap.m"},renderer:H});J.prototype._setControlOrigin=function(o){this._oOriginControl=o;return this._oOriginControl;};J.prototype._getControlOrigin=function(){return this._oOriginControl;};J.prototype.preventChangeOnFocusLeave=function(o){return this.bFocusoutDueRendering;};J.prototype.shouldSuggetionsPopoverOpenOnMobile=function(o){var b=o.srcControl instanceof f;return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&!b&&(!this._bClearButtonPressed);};var K=S.extend("sap.m.DynamicDateRangeListItem",{metadata:{library:"sap.m",properties:{optionKey:{type:"string",group:"Misc",defaultValue:null}}},renderer:l});K.prototype.getNavigationControl=function(){var o=S.prototype.getNavigationControl.apply(this,arguments),b=["SPECIFICMONTH","DATE","DATERANGE","FROM","TO"].includes(this.getOptionKey()),a=b?e.getIconURI("appointment-2"):e.getIconURI("slim-arrow-right");if(b){o.addStyleClass("sapMDDRDateOption");}o.setSrc(a);return o;};function _(o){var a=o;while(a&&a.classList){if(a.classList.contains("sapUiSizeCompact")){return true;}a=a.parentNode;}return false;}return A;});
