/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Renderer','sap/ui/core/Core','sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/core/LabelEnablement','sap/ui/Device'],function(R,C,c,V,L,D){"use strict";var T=c.TextDirection;var a=c.ValueState;var I={apiVersion:2};I.render=function(r,o){var v=o.getValueState(),t=o.getTextDirection(),s=R.getTextAlign(o.getTextAlign(),t),A=sap.ui.getCore().getConfiguration().getAccessibility(),b=o.getAggregation("_beginIcon")||[],e=o.getAggregation("_endIcon")||[],d,f;r.openStart("div",o);this.addOuterStyles(r,o);this.addControlWidth(r,o);r.class("sapMInputBase");this.addPaddingClass(r,o);this.addCursorClass(r,o);this.addOuterClasses(r,o);if(!o.getEnabled()){r.class("sapMInputBaseDisabled");}if(!o.getEditable()){r.class("sapMInputBaseReadonly");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){r.class("sapMInputBaseState");}if(b.length){d=b.filter(function(i){return i.getVisible();});d.length&&r.class("sapMInputBaseHasBeginIcons");}if(e.length){f=e.filter(function(i){return i.getVisible();});f.length&&r.class("sapMInputBaseHasEndIcons");}this.writeOuterAttributes(r,o);var g=o.getTooltip_AsString();if(g){r.attr("title",g);}r.openEnd();r.openStart("div",o.getId()+"-content");r.class("sapMInputBaseContentWrapper");if(!o.getEnabled()){r.class("sapMInputBaseDisabledWrapper");}else if(!o.getEditable()){r.class("sapMInputBaseReadonlyWrapper");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){this.addValueStateClasses(r,o);}this.addWrapperStyles(r,o);r.openEnd();if(b.length){this.writeIcons(r,b);}this.prependInnerContent(r,o);this.openInputTag(r,o);if(o.getName()){r.attr("name",o.getName());}if(!o.bShowLabelAsPlaceholder&&o._getPlaceholder()){r.attr("placeholder",o._getPlaceholder());}if(o.getMaxLength&&o.getMaxLength()>0){r.attr("maxlength",o.getMaxLength());}if(!o.getEnabled()){r.attr("disabled","disabled");}else if(!o.getEditable()){r.attr("readonly","readonly");}if(t!=T.Inherit){r.attr("dir",t.toLowerCase());}this.writeInnerValue(r,o);if(A){this.writeAccessibilityState(r,o);}if(D.browser.mozilla){if(g){r.attr("x-moz-errormessage",g);}else{r.attr("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,o);r.class("sapMInputBaseInner");this.addInnerClasses(r,o);r.style("text-align",s);this.addInnerStyles(r,o);this.endInputTag(r,o);this.writeInnerContent(r,o);this.closeInputTag(r,o);if(e.length){this.writeIcons(r,e);}r.close("div");this.writeDecorations(r,o);if(A){this.renderAriaLabelledBy(r,o);this.renderAriaDescribedBy(r,o);this.renderValueStateAccDom(r,o);}r.close("div");};I.getAriaRole=function(o){return"textbox";};I.getAriaLabelledBy=function(o){if(this.getLabelledByAnnouncement(o)){return o.getId()+"-labelledby";}};I.getLabelledByAnnouncement=function(o){return"";};I.renderAriaLabelledBy=function(r,o){var A=this.getLabelledByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-labelledby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};I.getAriaDescribedBy=function(o){if(this.getDescribedByAnnouncement(o)){return o.getId()+"-describedby";}};I.getDescribedByAnnouncement=function(o){return"";};I.renderAriaDescribedBy=function(r,o){var A=this.getDescribedByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-describedby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};I.renderValueStateAccDom=function(r,o){var v=o.getValueState();if(v===a.None||!o.getEditable()||!o.getEnabled()){return;}var f=o.getAggregation("_invisibleFormattedValueStateText");var s;s=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+v.toUpperCase());r.openStart("div",o.getValueStateMessageId()+"-sr").class("sapUiPseudoInvisibleText");r.openEnd().text(s).text(" ");if(f){r.renderControl(f);}else{r.text(o.getValueStateText()||V.getAdditionalText(o));}r.close("div");};I.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),r=this.getAriaRole(o),v=o.getValueStateMessageId()+"-sr",m={};if(r){m.role=r;}if(o.getValueState()===a.Error&&o.getEditable()&&o.getEnabled()){m.invalid=true;m.errormessage=v;}else if(o.getValueState()!==a.None&&o.getEditable()&&o.getEnabled()){s=s?v+" "+s:v;}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}m.disabled=null;m.readonly=null;return m;};I.writeAccessibilityState=function(r,o){r.accessibilityState(o,this.getAccessibilityState(o));};I.openInputTag=function(r,o){r.voidStart("input",o.getId()+"-"+this.getInnerSuffix());};I.endInputTag=function(r,o){r.voidEnd();};I.writeInnerValue=function(r,o){r.attr("value",o.getValue());};I.addCursorClass=function(r,o){};I.addPaddingClass=function(r,o){r.class("sapMInputBaseHeightMargin");};I.addOuterStyles=function(r,o){};I.addControlWidth=function(r,o){if(!o.getProperty('width')){r.class("sapMInputBaseNoWidth");}r.style("width",o.getWidth());};I.addOuterClasses=function(r,o){};I.writeOuterAttributes=function(r,o){};I.addInnerStyles=function(r,o){};I.addWrapperStyles=function(r,o){r.style("width","100%");};I.addInnerClasses=function(r,o){};I.writeInnerAttributes=function(r,o){};I.prependInnerContent=function(r,o){};I.writeInnerContent=function(r,o){};I.writeIcons=function(r,i){r.openStart("div").attr("tabindex","-1").class("sapMInputBaseIconContainer").openEnd();i.forEach(r.renderControl,r);r.close("div");};I.writeDecorations=function(r,o){};I.closeInputTag=function(r,o){};I.addPlaceholderStyles=function(r,o){};I.addPlaceholderClasses=function(r,o){};I.addValueStateClasses=function(r,o){r.class("sapMInputBaseContentWrapperState");r.class("sapMInputBaseContentWrapper"+o.getValueState());};I.getInnerSuffix=function(){return"inner";};return I;},true);
