/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Item','sap/ui/base/ManagedObjectObserver'],function(l,I,M){"use strict";var a=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"string"},methodName:{type:"string"},methodParams:{type:"object"}}}}}});a.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';a.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};a.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};a.prototype.setAggregation=function(A,o,s){I.prototype.setAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"set",methodParams:{item:o}});return this;};a.prototype.addAggregation=function(A,o,s){var v=this._getVisualControl(),V;I.prototype.addAggregation.apply(this,arguments);if(A==='customData'&&v){V=sap.ui.getCore().byId(v);this._addCustomData(V,o);}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"add",methodParams:{item:o}});return this;};a.prototype.insertAggregation=function(A,o,i,s){var v=this._getVisualControl(),V;I.prototype.insertAggregation.apply(this,arguments);if(A==='customData'&&v){V=sap.ui.getCore().byId(v);V.insertCustomData(o.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX),i);this._observeCustomDataChanges(o);}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"insert",methodParams:{item:o,index:i}});return this;};a.prototype.removeAggregation=function(A,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);if(A==="customData"){if(this.getCustomData().length===1){this._disconnectAndDestroyCustomDataObserver();}else if(o&&this._oCustomDataObserver){this._oCustomDataObserver.unobserve(o,{properties:["value"]});}}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"remove",methodParams:{item:O}});return O;};a.prototype.removeAllAggregation=function(A,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);if(A==='customData'){this._disconnectAndDestroyCustomDataObserver();}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"removeall",methodParams:{items:o}});return o;};a.prototype.destroyAggregation=function(A,s){if(A==='customData'){this._disconnectAndDestroyCustomDataObserver();}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};a.prototype.destroy=function(){var v=sap.ui.getCore().byId(this._getVisualControl());if(v){v.destroy();}return I.prototype.destroy.apply(this,arguments);};a.prototype._addCustomData=function(v,c){v.addCustomData(c.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{bCloneChildren:false,bCloneBindings:true}));this._observeCustomDataChanges(c);};a.prototype._observeCustomDataChanges=function(c){this._getCustomDataObserver().observe(c,{properties:["value"]});};a.prototype._customDataObserverCallbackFunction=function(c){sap.ui.getCore().byId(c.object.getId()+"-"+a.UNIFIED_MENU_ITEMS_ID_SUFFIX).setValue(c.current);};a.prototype._getCustomDataObserver=function(){if(!this._oCustomDataObserver){this._oCustomDataObserver=new M(this._customDataObserverCallbackFunction);}return this._oCustomDataObserver;};a.prototype._disconnectAndDestroyCustomDataObserver=function(){if(this._oCustomDataObserver){this._oCustomDataObserver.disconnect();this._oCustomDataObserver.destroy();this._oCustomDataObserver=null;}};a.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};a.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};a.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};a.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};a.prototype._getVisualChild=function(){return this._sVisualChild;};a.prototype._getVisualParent=function(){return this._sVisualParent;};a.prototype._getVisualControl=function(){return this._sVisualControl;};return a;});
