/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/Renderer','sap/ui/core/library',"sap/ui/core/LabelEnablement","sap/ui/events/KeyCodes",'./ObjectNumberRenderer'],function(l,C,R,c,L,K,O){"use strict";var T=c.TextAlign;var a=c.TextDirection;var V=c.ValueState;var E=l.EmptyIndicatorMode;var b=C.extend("sap.m.ObjectNumber",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectNumber.designtime",properties:{number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null,deprecated:true},emphasized:{type:"boolean",group:"Appearance",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:V.None},unit:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},active:{type:"boolean",group:"Misc",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:false},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:E.Off}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{press:{}},dnd:{draggable:true,droppable:false}}});b.prototype._getStateText=function(){var s=this.getState(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return r.getText("OBJECTNUMBER_ARIA_VALUE_STATE_"+s.toUpperCase(),[],true);};b.prototype.getAccessibilityInfo=function(){var s="";if(this.getState()!==V.None){s=this._getStateText();}return{description:(this.getNumber()+" "+this.getUnit()+" "+s).trim()};};b.prototype.ontap=function(e){if(this._isClickable(e)){this.firePress();}};b.prototype.ontouchstart=function(e){if(this._isClickable(e)){e.setMarked();}};b.prototype._activeState=function(){this.addStyleClass("sapMObjectNumberPressed");};b.prototype._inactiveState=function(){this.removeStyleClass("sapMObjectNumberPressed");};b.prototype.onkeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){e.setMarked();this._activeState();if(e.which===K.ENTER){this.firePress();}else{e.preventDefault();this._bPressedSpace=true;}}else if(this._bPressedSpace){if(e.which===K.SHIFT||e.which===K.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveState();}else{e.preventDefault();}}};b.prototype.onkeyup=function(e){if(e.which===K.ENTER){e.setMarked();this._inactiveState();}else if(e.which===K.SPACE){if(!this._bPressedEscapeOrShift){e.setMarked();this.firePress();this._inactiveState();}else{this._bPressedEscapeOrShift=false;}this._bPressedSpace=false;}else if(e.which===K.ESCAPE){this._bPressedSpace=false;}};b.prototype._isActive=function(){return this.getActive()&&(this.getNumber().trim()||this.getUnit().trim());};b.prototype._isClickable=function(e){var s=e.target.id;return this._isActive()&&(s===this.getId()+"-link"||s===this.getId()+"-number"||s===this.getId()+"-unit");};b.prototype._hasExternalLabelling=function(){return this.getAriaLabelledBy().length>0||L.getReferencingLabels(this).length>0;};b.prototype._generateSelfLabellingIds=function(){var i=this.getId(),r="";if(this.getNumber()){r+=i+"-number ";}if(this.getUnit()){r+=i+"-unit ";}if(this.getEmphasized()){r+=i+"-emphasized ";}if(this.getState()!==V.None){r+=i+"-state";}return r.trim();};return b;});
