/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Bar','./Button','./InstanceManager','./library','./Title','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/theming/Parameters','sap/ui/Device',"sap/ui/core/util/ResponsivePaddingsEnablement",'sap/ui/core/library','sap/ui/core/Element','sap/ui/core/ResizeHandler','./PopoverRenderer',"sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/dom/getScrollbarSize","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/control"],function(B,a,I,l,T,C,P,S,b,D,R,c,E,d,f,g,q,h,K,L){"use strict";var i=l.PopupHelper;var O=c.OpenState;var j=l.PlacementType;var k=l.TitleAlignment;var m=C.extend("sap.m.Popover",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Behavior",defaultValue:j.Right},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},title:{type:"string",group:"Appearance",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},offsetX:{type:"int",group:"Appearance",defaultValue:0},offsetY:{type:"int",group:"Appearance",defaultValue:0},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentMinWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enableScrolling:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},bounce:{type:"boolean",group:"Behavior",defaultValue:null,deprecated:true},resizable:{type:"boolean",group:"Dimension",defaultValue:false},ariaModal:{type:"boolean",group:"Misc",defaultValue:true,visibility:"hidden"},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:k.Auto},ariaRoleApplication:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.ui.core.Control",multiple:false},subHeader:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},beginButton:{type:"sap.ui.core.Control",multiple:false},endButton:{type:"sap.ui.core.Control",multiple:false}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}}},designtime:"sap/m/designtime/Popover.designtime"}});m._bIOS7=D.os.ios&&D.os.version>=7&&D.os.version<8&&D.browser.name==="sf";R.call(m.prototype,{header:{suffix:"intHeader"},subHeader:{selector:".sapMPopoverSubHeader .sapMIBar"},content:{suffix:"cont"},footer:{selector:".sapMPopoverFooter .sapMIBar"}});m.prototype.init=function(){this._arrowOffsetThreshold=4;this._marginTopInit=false;this._marginTop=48;this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._minDimensions={width:100,height:32};this._initialWindowDimensions={};this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setAutoClose(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this._placements=[j.Top,j.Right,j.Bottom,j.Left,j.Vertical,j.Horizontal,j.Auto,j.VerticalPreferedTop,j.VerticalPreferedBottom,j.HorizontalPreferedLeft,j.HorizontalPreferedRight,j.VerticalPreferredTop,j.VerticalPreferredBottom,j.HorizontalPreferredLeft,j.HorizontalPreferredRight,j.PreferredRightOrFlip,j.PreferredLeftOrFlip,j.PreferredTopOrFlip,j.PreferredBottomOrFlip];this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];this._offsets=["0 -18","18 0","0 18","-18 0"];this._arrowOffset=18;this._followOfTolerance=32;this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer"];this._fnAdjustPositionAndArrow=q.proxy(this._adjustPositionAndArrow,this);this._fnOrientationChange=q.proxy(this._onOrientationChange,this);this._fnFollowOf=q.proxy(function(e){var o=e.lastOfRect,r=e.currentOfRect;if(!D.system.desktop||(Math.abs(o.top-r.top)<=this._followOfTolerance&&Math.abs(o.left-r.left)<=this._followOfTolerance)||(Math.abs(o.top+o.height-r.top-r.height)<=this._followOfTolerance&&Math.abs(o.left+o.width-r.left-r.width)<=this._followOfTolerance)){this.oPopup._applyPosition(this.oPopup._oLastPosition,true);}else{this.close();}},this);this.setFollowOf(true);this._initResponsivePaddingsEnablement();this._oRestoreFocusDelegate={onBeforeRendering:function(){var A=q(document.activeElement),o=A.control(0);this._sFocusControlId=o&&o.getId();},onAfterRendering:function(){if(this._sFocusControlId&&!g(this.getDomRef(),document.activeElement)){sap.ui.getCore().byId(this._sFocusControlId).focus();}}};var t=this;this.oPopup._applyPosition=function(p,F){var e=this.getOpenState(),o;if(e===O.CLOSING||e===O.CLOSED){return;}if(F){t._storeScrollPosition();}t._clearCSSStyles();var n=t._placements.indexOf(t.getPlacement());if(n>3&&!t._bPosCalced){t._calcPlacement();return;}t._bPosCalced=false;if(t._oOpenBy instanceof E){p.of=t._getOpenByDomRef();}if(!p.of){L.warning("sap.m.Popover: in function applyPosition, the openBy element doesn't have any DOM output. "+t);return;}if(!g(document.documentElement,p.of)&&p.of.id){o=q(document.getElementById(p.of.id));if(o){p.of=o;}else{L.warning("sap.m.Popover: in function applyPosition, the openBy element's DOM is already detached from DOM tree and can't be found again by the same id. "+t);return;}}var r=q(p.of).rect();var $=q(t.getWithinAreaDomRef());if(F&&$.height()==t._initialWindowDimensions.height&&(r.top+r.height<=0||r.top>=$.height()||r.left+r.width<=0||r.left>=$.width())){t.close();return;}var s=t.getDomRef("scroll");if(!D.system.desktop){q(window).scrollLeft(0);}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._fnAdjustPositionAndArrow();t._restoreScrollPosition();t._registerContentResizeHandler(s);};this.oPopup.close=function(e){var n=typeof e==="boolean";var o=t.oPopup.getOpenState();var p=t._oOpenBy&&t._oOpenBy.getDomRef&&!!t._oOpenBy.getDomRef();if(e!==true&&(this.touchEnabled||!(this._isFocusInsidePopup()&&p))&&this.isOpen()&&!(o===O.CLOSED||o===O.CLOSING)){t.fireBeforeClose({openBy:t._oOpenBy});}t._deregisterContentResizeHandler();P.prototype.close.apply(this,n?[]:arguments);t.removeDelegate(t._oRestoreFocusDelegate);};};m.prototype.getWithinAreaDomRef=function(){return P.getWithinAreaDomRef();};m.prototype.onBeforeRendering=function(){var n,p,$,H=this.getHorizontalScrolling(),v=this.getVerticalScrolling(),e=!H||this.isPropertyInitial("horizontalScrolling"),V=!v||this.isPropertyInitial("verticalScrolling"),o=this.getCustomHeader()||this._internalHeader;if(this.hasStyleClass("sapUiPopupWithPadding")){L.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Popover");}if(!this._initialWindowDimensions.width||!this._initialWindowDimensions.height){$=q(this.getWithinAreaDomRef());this._initialWindowDimensions={width:$.width(),height:$.height()};}this._hasSingleScrollableContent();if(!H&&!v){this._forceDisableScrolling=true;}else if(e&&V&&this._singleScrollableContent){this._forceDisableScrolling=true;L.info("VerticalScrolling and horizontalScrolling in sap.m.Popover with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else{this._forceDisableScrolling=false;}if(!this._forceDisableScrolling){if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:H,vertical:v});}else{this._oScroller.setHorizontal(H);this._oScroller.setVertical(v);}}if(this._bContentChanged){this._bContentChanged=false;n=this._getSingleNavContent();p=this._getSinglePageContent();if(n&&!this.getModal()&&!D.system.phone&&!q.sap.simulateMobileOnDesktop){n.attachEvent("afterNavigate",function(r){var s=this.getDomRef();if(s){var F=this.$().firstFocusableDomRef()||s;F.focus();}},this);}if(n||p){p=p||n.getCurrentPage();if(p&&p._getAnyHeader){this.addStyleClass("sapMPopoverWithHeaderCont");}if(n){n.attachEvent("navigate",function(r){var s=r.getParameter("to");if(s instanceof C&&s.isA("sap.m.Page")){this.$().toggleClass("sapMPopoverWithHeaderCont",!!s._getAnyHeader());}},this);}}}this._setHeaderTitle();if(!D.system.desktop){this.setResizable(false);}if(o&&o.getTitleAlignment){o.setProperty("titleAlignment",this.getTitleAlignment(),true);}};m.prototype.onAfterRendering=function(){var $,e,n;if(!this._marginTopInit&&this.getShowArrow()){this._marginTop=2;if(this._oOpenBy){$=q(this._getOpenByDomRef());if(!($.closest("header.sapMIBar").length>0)){e=$.closest(".sapMPage");if(e.length>0){n=e.children("header.sapMIBar");if(n.length>0){this._marginTop+=n.outerHeight();}}}this._marginTopInit=true;}}};m.prototype.exit=function(){this._deregisterContentResizeHandler();D.resize.detachHandler(this._fnOrientationChange);I.removePopoverInstance(this);this.removeDelegate(this._oRestoreFocusDelegate);this._oRestoreFocusDelegate=null;if(this.oPopup){this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._internalHeader){this._internalHeader.destroy();this._internalHeader=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}};m.prototype.openBy=function(o,s){var p=this.oPopup,e=this.oPopup.getOpenState(),F=this._getInitialFocusId(),n,r,t,u;n=(o.getDomRef&&o.getDomRef())||o;u=q(n).closest(".sapUiSizeCompact");t=b.get({name:"_sap_m_Popover_ForceCompactArrowOffset"})||"true";t=t==="true";this._bSizeCompact=l._bSizeCompact||!!u.length||this.hasStyleClass("sapUiSizeCompact");this._bUseCompactArrow=this._bSizeCompact||t;this._adaptPositionParams();if(e===O.OPEN||e===O.OPENING){if(this._oOpenBy===o){return this;}else{var v=function(){p.detachClosed(v,this);this.openBy(o);};p.attachClosed(v,this);this._oPreviousFocus=null;this.close();return this;}}if(!o){return this;}if(D.support.touch){D.resize.attachHandler(this._fnOrientationChange);}if(!this._oOpenBy||o!==this._oOpenBy){this._oOpenBy=o;}this.fireBeforeOpen({openBy:this._oOpenBy});p.attachOpened(this._handleOpened,this);p.attachClosed(this._handleClosed,this);p.setInitialFocusId(F);r=this._placements.indexOf(this.getPlacement());if(r>-1){n=this._getOpenByDomRef();if(!n){L.error("sap.m.Popover id = "+this.getId()+": is opened by a control which isn't rendered yet.");return this;}p.setAutoCloseAreas([o]);p.setContent(this);if(r<=3){p.setPosition(this._myPositions[r],this._atPositions[r],n,this._calcOffset(this._offsets[r]),"fit");}else{p._oPosition.of=n;}var w=this;var x=function(){if(p.bIsDestroyed){return;}if(p.getOpenState()===O.CLOSING){if(w._sOpenTimeout){clearTimeout(w._sOpenTimeout);w._sOpenTimeout=null;}w._sOpenTimeout=setTimeout(x,150);}else{w._oPreviousFocus=P.getCurrentFocusInfo();p.open();w.addDelegate(w._oRestoreFocusDelegate,w);if(!s){I.addPopoverInstance(w);}}};x();}else{L.error(this.getPlacement()+"is not a valid value! It can only be top, right, bottom or left");}return this;};m.prototype.close=function(){var e=this.oPopup.getOpenState(),s,A;if(e===O.CLOSED||e===O.CLOSING){return this;}this.fireBeforeClose({openBy:this._oOpenBy});this.oPopup.close(true);if(this._oPreviousFocus){A=document.activeElement||{};s=(this._oPreviousFocus.sFocusId===sap.ui.getCore().getCurrentFocusedControlId())||(this._oPreviousFocus.sFocusId===A.id);if(!s){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;}}return this;};m.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};m.prototype.setFollowOf=function(v){if(v){this.oPopup.setFollowOf(this._fnFollowOf);}else{this.oPopup.setFollowOf(false);}return this;};m.prototype._clearCSSStyles=function(){if(!this.getDomRef()){return;}var s=this.getDomRef().style,$=this.$("cont"),e=$.children(".sapMPopoverScroll"),o=$[0].style,n=e[0].style,p=this.getContentWidth(),r=this.getContentHeight(),t=this.$("arrow"),w,W,u=q(this.getWithinAreaDomRef());if(p.indexOf("%")>0){w=u.width();p=i.calcPercentageSize(p,w);}if(r.indexOf("%")>0){W=u.height();r=i.calcPercentageSize(r,W);}o.width=p||"";o.height=r||"";o.maxWidth="";o.maxHeight="";s.left="";s.right="";s.top="";s.bottom="";s.width="";s.height="";s.overflow="";n.width="";n.display="";t.removeClass("sapMPopoverArrRight sapMPopoverArrLeft sapMPopoverArrDown sapMPopoverArrUp sapMPopoverCrossArr sapMPopoverFooterAlignArr sapMPopoverHeaderAlignArr sapContrast sapContrastPlus");t.css({left:"",top:""});};m.prototype._onOrientationChange=function(){var e=(this.oPopup&&this.oPopup.getOpenState())||{};if(e!==O.OPEN){return;}this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._includeScrollWidth();};m.prototype._includeScrollWidth=function(){var s=this.getContentWidth(),$=this.$(),M=Math.floor(window.innerWidth*0.9),e=this.$('cont');if(!e[0]){return;}if(D.system.desktop&&!D.browser.chrome){var H=e[0].clientHeight<e[0].scrollHeight;if(H&&(!s||s==='auto')&&e.width()<M){$.addClass("sapMPopoverVerticalScrollIncluded");}else{$.removeClass("sapMPopoverVerticalScrollIncluded");}}};m.prototype._handleOpened=function(){var t=this;this.oPopup.detachOpened(this._handleOpened,this);this._repositionOffset();if(!D.support.touch){setTimeout(function(){!t.bIsDestroyed&&D.resize.attachHandler(t._fnOrientationChange);},0);}var F=this._getInitialFocusId(),o=sap.ui.getCore().byId(F),e=(F?window.document.getElementById(F):null);if(o&&o.getFocusDomRef()){o.getFocusDomRef().focus();}else if(!o&&e){e.focus();}this.fireAfterOpen({openBy:this._oOpenBy});};m.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);D.resize.detachHandler(this._fnOrientationChange);I.removePopoverInstance(this);if(!this.oPopup._bModal&&!D.system.desktop&&document.activeElement&&!q(document.activeElement).is(":visible")){document.activeElement.blur();}this.fireAfterClose({openBy:this._oOpenBy});};m.prototype.onfocusin=function(e){var s=e.target,$=this.$(),F=this.getId()+"-firstfe",M=this.getId()+"-middlefe",n=this.getId()+"-lastfe";if(s.id===F){var o=$.lastFocusableDomRef();if(o){o.focus();}else{document.getElementById(M).focus();}}else if(s.id===n){var p=$.firstFocusableDomRef();if(p){p.focus();}else{document.getElementById(M).focus();}}};m.prototype.onkeydown=function(e){var o=K,n=e.which||e.keyCode,A=e.altKey;this._isSpacePressed=this._isSpacePressed||o.SPACE===n;if((!this._isSpacePressed&&n===o.ESCAPE)||(A&&n===o.F4)){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this.close();e.stopPropagation();e.preventDefault();}};m.prototype.onkeyup=function(e){var o=K,n=e.which||e.keyCode;if(o.SPACE===n){this._isSpacePressed=false;}};m.prototype.onmousedown=function(o){var r=sap.ui.getCore().getConfiguration().getRTL();if(!o.target.classList||!o.target.classList.contains("sapMPopoverResizeHandle")){return;}var $=q(document);var n=this.$();var t=this;n.addClass('sapMPopoverResizing');o.preventDefault();o.stopPropagation();var p={x:o.pageX,y:o.pageY,width:n.width(),height:n.height()};$.on("mousemove.sapMPopover",function(e){var w,s;if(r){w=p.width+p.x-e.pageX;s=p.height+(p.y-e.pageY);}else{w=p.width+e.pageX-p.x;s=p.height+(p.y-e.pageY);}t.setContentWidth(Math.max(w,t._minDimensions.width)+'px');t.setContentHeight(Math.max(s,t._minDimensions.height)+'px');});$.on("mouseup.sapMPopover",function(){n.removeClass("sapMPopoverResizing");$.off("mouseup.sapMPopover, mousemove.sapMPopover");});};m.prototype._hasSingleNavContent=function(){return!!this._getSingleNavContent();};m.prototype._getSingleNavContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA("sap.m.NavContainer")){return e[0];}else{return null;}};m.prototype._getSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA("sap.m.Page")){return e[0];}else{return null;}};m.prototype._hasSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA("sap.m.Page")){return true;}else{return false;}};m.prototype._hasSingleScrollableContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){this._singleScrollableContent=true;}else{this._singleScrollableContent=false;}};m.prototype._getOffsetX=function(){var F=this.getPlacement(),e=0;if(this._bHorizontalFlip){var p=this._getOpenByDomRef();var H=p!==undefined;var n=H?p.getBoundingClientRect().width:0;e=F===j.PreferredRightOrFlip?Math.abs(n):-Math.abs(n);}var r=sap.ui.getCore().getConfiguration().getRTL();var o=e*(r?-1:1)+this.getOffsetX()*(r?-1:1);return o;};m.prototype._getOffsetY=function(){var F=this.getPlacement(),e=0;if(this._bVerticalFlip){var p=this._getOpenByDomRef();var H=p!==undefined;var n=H?p.getBoundingClientRect().height:0;e=F==="PreferredTopOrFlip"?-Math.abs(n):Math.abs(n);}return e+this.getOffsetY();};m.prototype._calcOffset=function(o){var e=this._getOffsetX(),n=this._getOffsetY();var p=o.split(" ");var o=(parseInt(p[0])+e)+" "+(parseInt(p[1])+n);return o;};m.prototype._calcPlacement=function(){var p=this.getPlacement();var o=this._getOpenByDomRef();switch(p){case j.Auto:this._calcAuto();break;case j.Vertical:case j.VerticalPreferedTop:case j.VerticalPreferredTop:case j.VerticalPreferedBottom:case j.VerticalPreferredBottom:case j.PreferredTopOrFlip:case j.PreferredBottomOrFlip:this._calcVertical();break;case j.Horizontal:case j.HorizontalPreferedLeft:case j.HorizontalPreferredLeft:case j.HorizontalPreferedRight:case j.HorizontalPreferredRight:case j.PreferredRightOrFlip:case j.PreferredLeftOrFlip:this._calcHorizontal();break;}this._bPosCalced=true;var e=this._placements.indexOf(this._oCalcedPos);this.oPopup.setPosition(this._myPositions[e],this._atPositions[e],o,this._calcOffset(this._offsets[e]),"fit");};m.prototype._getDocHeight=function(){var e=document.body,n=document.documentElement,w=this.getWithinAreaDomRef(),o=(w!==window)?q(w).offset():{top:0};return o.top+Math.max(e.scrollHeight,e.offsetHeight,n.clientHeight,n.offsetHeight);};m.prototype._calcVertical=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=this.getPlacement()===j.VerticalPreferedTop||this.getPlacement()===j.VerticalPreferredTop;var e=this.getPlacement()===j.VerticalPreferedBottom||this.getPlacement()===j.VerticalPreferredBottom;var n=this.getPlacement()===j.PreferredTopOrFlip;var o=this.getPlacement()===j.PreferredBottomOrFlip;var r=H?$[0].getBoundingClientRect().top:0;var s=H?$[0].getBoundingClientRect().height:0;var t=this._getOffsetY();var u=r-this._marginTop+t;var v=this.$().outerHeight();var w=this._getDocHeight()-($.offset().top+s+this._marginBottom+t);if(p&&u>v+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=j.Top;}else if(n){if(u>v+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=j.Top;}else{this._bVerticalFlip=true;this._oCalcedPos=j.Bottom;}}else if(e&&w>v+this._arrowOffset){this._oCalcedPos=j.Bottom;this._bVerticalFlip=false;}else if(o){if(w>v+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=j.Bottom;}else{this._bVerticalFlip=true;this._oCalcedPos=j.Top;}}else if(u>w){this._oCalcedPos=j.Top;}else{this._oCalcedPos=j.Bottom;}};m.prototype._calcHorizontal=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=this.getPlacement()===j.HorizontalPreferedLeft||this.getPlacement()===j.HorizontalPreferredLeft;var e=this.getPlacement()===j.HorizontalPreferedRight||this.getPlacement()===j.HorizontalPreferredRight;var n=H?$[0].getBoundingClientRect().left:0;var o=H?$[0].getBoundingClientRect().width:0;var r=this._getOffsetX();var s=n-this._marginLeft+r;var t=n+o;var u=q(this.getWithinAreaDomRef());var v=u.width()-t-this._marginRight-r;var w=this.$().outerWidth();var x=this.getPlacement()===j.PreferredLeftOrFlip;var y=this.getPlacement()===j.PreferredRightOrFlip;var z=sap.ui.getCore().getConfiguration().getRTL();if(p&&s>w+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=z?j.Right:j.Left;}else if(x){if(s>w+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=z?j.Right:j.Left;}else{this._bHorizontalFlip=true;this._oCalcedPos=z?j.Left:j.Right;}}else if(e&&v>w+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=z?j.Left:j.Right;}else if(y){if(v>w+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=z?j.Left:j.Right;}else{this._bHorizontalFlip=true;this._oCalcedPos=z?j.Right:j.Left;}}else if(s>v){this._oCalcedPos=z?j.Right:j.Left;}else{this._oCalcedPos=z?j.Left:j.Right;}};m.prototype._calcAuto=function(){var $=q(this.getWithinAreaDomRef());if($.width()>$.height()){if(this._checkHorizontal()){this._calcHorizontal();}else if(this._checkVertical()){this._calcVertical();}else{this._calcBestPos();}}else{if(this._checkVertical()){this._calcVertical();}else if(this._checkHorizontal()){this._calcHorizontal();}else{this._calcBestPos();}}};m.prototype._checkHorizontal=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=H?$[0].getBoundingClientRect().left:0;var e=H?$[0].getBoundingClientRect().width:0;var o=this._getOffsetX();var n=p-this._marginLeft+o;var r=p+e;var s=q(this.getWithinAreaDomRef());var t=s.width()-r-this._marginRight-o;var u=this.$();var w=u.outerWidth()+this._arrowOffset;if((w<=n)||(w<=t)){return true;}};m.prototype._checkVertical=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=H?$[0].getBoundingClientRect().top:0;var e=H?$[0].getBoundingClientRect().height:0;var o=this._getOffsetY();var t=p-this._marginTop+o;var n=this._getDocHeight()-$.offset().top-e-this._marginBottom-o;var r=this.$();var s=r.outerHeight()+this._arrowOffset;if((s<=t)||(s<=n)){return true;}};m.prototype._calcBestPos=function(){var $=this.$();var H=$.outerHeight();var w=$.outerWidth();var r=sap.ui.getCore().getConfiguration().getRTL();var e=q(this._getOpenByDomRef());var n=e[0]!==undefined;var p=n?e[0].getBoundingClientRect().left:0;var o=n?e[0].getBoundingClientRect().top:0;var s=n?e[0].getBoundingClientRect().width:0;var t=n?e[0].getBoundingClientRect().height:0;var u=this._getOffsetX();var v=this._getOffsetY();var x=o-this._marginTop+v;var y=this._getDocHeight()-e.offset().top-t-this._marginBottom-v;var z=p-this._marginLeft+u;var A=p+s;var F=q(this.getWithinAreaDomRef());var G=F.width()-A-this._marginRight-u;var J=H*w;var M;var N;if((F.height()-this._marginTop-this._marginBottom)>=H){M=H;}else{M=F.height()-this._marginTop-this._marginBottom;}if((F.width()-this._marginLeft-this._marginRight)>=w){N=w;}else{N=F.width()-this._marginLeft-this._marginRight;}var Q=(M*(z))/J;var U=(M*(G))/J;var V=(N*(x))/J;var W=(N*(y))/J;var X=Math.max(Q,U);var Y=Math.max(V,W);if(X>Y){if(X===Q){this._oCalcedPos=r?j.Right:j.Left;}else if(X===U){this._oCalcedPos=r?j.Left:j.Right;}}else if(Y>X){if(Y===V){this._oCalcedPos=j.Top;}else if(Y===W){this._oCalcedPos=j.Bottom;}}else if(Y===X){if(F.height()>F.width()){if(Y===V){this._oCalcedPos=j.Top;}else if(Y===W){this._oCalcedPos=j.Bottom;}}else{if(X===Q){this._oCalcedPos=r?j.Right:j.Left;}else if(X===U){this._oCalcedPos=r?j.Left:j.Right;}}}};m.outerWidth=function(e,n){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().width;}return q(e).outerWidth(!!n);};m.outerHeight=function(e,n){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().height;}return q(e).outerHeight(!!n);};m.prototype._getPositionParams=function($,e,n,o){var p=window.getComputedStyle($[0]),r=window.getComputedStyle(n[0]),s=q(window),t=this.getDomRef().clientHeight!==this.getDomRef().scrollHeight?h().width:0,u=q(this.getWithinAreaDomRef()),w=(u[0]!==window)?u.offset():{top:0,left:0},v={};v._$popover=$;v._$parent=q(this._getOpenByDomRef());v._$arrow=e;v._$content=n;v._$scrollArea=o;v._$header=$.children(".sapMPopoverHeader");v._$subHeader=$.children(".sapMPopoverSubHeader");v._$footer=$.children(".sapMPopoverFooter");v._fWindowTop=s.scrollTop();v._fWindowRight=s.width();v._fWindowBottom=(m._bIOS7&&D.orientation.landscape&&window.innerHeight)?window.innerHeight:s.height();v._fWindowLeft=s.scrollLeft();v._fWindowWidth=window.innerWidth;v._fWindowHeight=window.innerHeight;v._fWithinAreaWidth=Math.min(u.outerWidth(),v._fWindowWidth);v._fWithinAreaHeight=Math.min(u.outerHeight(),v._fWindowHeight);v._fDocumentWidth=v._fWindowLeft+v._fWindowRight;v._fDocumentHeight=v._fWindowTop+v._fWindowBottom;v._fArrowHeight=e.outerHeight(true);v._fPopoverWidth=m.outerWidth($[0]);v._fPopoverInnerWidth=v._$scrollArea?(v._$scrollArea.width()+t):0;v._fPopoverHeight=m.outerHeight($[0]);v._fHeaderHeight=v._$header.length>0?v._$header.outerHeight(true):0;v._fSubHeaderHeight=v._$subHeader.length>0?v._$subHeader.outerHeight(true):0;v._fFooterHeight=v._$footer.length>0?v._$footer.outerHeight(true):0;v._fPopoverOffset=$.offset();v._fPopoverOffsetX=this._getOffsetX();v._fPopoverOffsetY=this._getOffsetY();v._fPopoverMarginTop=v._fWindowTop+this._marginTop+w.top;v._fPopoverMarginLeft=v._fWindowLeft+this._marginLeft+w.left;v._fPopoverMarginRight=v._fWindowWidth-w.left-v._fWithinAreaWidth+this._marginRight;v._fPopoverMarginBottom=v._fWindowHeight-w.top-v._fWithinAreaHeight+this._marginBottom;v._fPopoverBorderTop=parseFloat(p.borderTopWidth);v._fPopoverBorderRight=parseFloat(p.borderRightWidth);v._fPopoverBorderBottom=parseFloat(p.borderBottomWidth);v._fPopoverBorderLeft=parseFloat(p.borderLeftWidth);v._fContentMarginTop=parseFloat(r.marginTop);v._fContentMarginBottom=parseFloat(r.marginBottom);return v;};m.prototype._recalculateMargins=function(s,p){var n;var r=sap.ui.getCore().getConfiguration().getRTL();switch(s){case j.Left:if(r){p._fPopoverMarginLeft=p._$parent.offset().left+m.outerWidth(p._$parent[0],false)+this._arrowOffset-p._fPopoverOffsetX;}else{p._fPopoverMarginRight=p._fWindowWidth-p._$parent.offset().left+this._arrowOffset-p._fPopoverOffsetX;}break;case j.Right:if(r){p._fPopoverMarginRight=p._fWindowWidth-m.outerWidth(p._$parent[0],false)-p._$parent.offset().left+this._arrowOffset;}else{p._fPopoverMarginLeft=p._$parent.offset().left+m.outerWidth(p._$parent[0],false)+this._arrowOffset+p._fPopoverOffsetX;}break;case j.Top:n=p._fWindowHeight-p._$parent.offset().top+this._arrowOffset-p._fPopoverOffsetY;p._fPopoverMarginBottom=n>p._fPopoverMarginBottom?n:p._fPopoverMarginBottom;break;case j.Bottom:p._fPopoverMarginTop=p._$parent.offset().top+m.outerHeight(p._$parent[0],false)+this._arrowOffset+p._fPopoverOffsetY;break;}return p;};m.prototype._getPopoverPositionCss=function(p){var e,r,t,n,o=p._fDocumentWidth-p._fPopoverOffset.left-p._fPopoverWidth,s=p._fDocumentHeight-p._fPopoverOffset.top-p._fPopoverHeight,u=(p._fDocumentWidth-p._fPopoverMarginRight-p._fPopoverMarginLeft)<p._fPopoverWidth,v=(p._fDocumentHeight-p._fPopoverMarginTop-p._fPopoverMarginBottom)<p._fPopoverHeight,w=p._fPopoverOffset.left<p._fPopoverMarginLeft,x=this.getVerticalScrolling()&&(p._fPopoverWidth!==p._fPopoverInnerWidth)?h().width:0,y=o<(p._fPopoverMarginRight+x),z=p._fPopoverOffset.top<p._fPopoverMarginTop,A=s<p._fPopoverMarginBottom,F=sap.ui.getCore().getConfiguration().getRTL();if(u){e=p._fPopoverMarginLeft;r=p._fPopoverMarginRight;}else{if(w){e=p._fPopoverMarginLeft;if(F){r="";}}else if(y){r=p._fPopoverMarginRight;e="";}}if(v){t=p._fPopoverMarginTop;n=p._fPopoverMarginBottom;}else{if(z){t=p._fPopoverMarginTop;}else if(A){n=p._fPopoverMarginBottom;t="";}}var G={top:t,bottom:n-p._fWindowTop,left:e,right:typeof r==="number"?r-p._fWindowLeft:r};return G;};m.prototype._getContentDimensionsCss=function(p){var o={},A=p._$content.height(),M=this._getMaxContentWidth(p),e=this._getMaxContentHeight(p);e=Math.max(e,0);o["max-width"]=M+"px";if(this.getContentHeight()||(A>e)){o["height"]=Math.min(e,A)+"px";}else{o["height"]="";o["max-height"]=e+"px";}return o;};m.prototype._getMaxContentWidth=function(p){var e=p._fPopoverBorderLeft+p._fPopoverBorderRight;return p._fDocumentWidth-p._fPopoverMarginLeft-p._fPopoverMarginRight-e;};m.prototype._getMaxContentHeight=function(p){var e=p._fHeaderHeight+p._fSubHeaderHeight+p._fFooterHeight+p._fContentMarginTop+p._fContentMarginBottom+p._fPopoverBorderTop+p._fPopoverBorderBottom;return p._fDocumentHeight-p._fPopoverMarginTop-p._fPopoverMarginBottom-e;};m.prototype._isHorizontalScrollbarNeeded=function(p){return this.getHorizontalScrolling()&&(p._$scrollArea.outerWidth(true)<=p._$content.width());};m.prototype._getArrowOffsetCss=function(s,p){var e,r=sap.ui.getCore().getConfiguration().getRTL();p._fPopoverWidth=p._$popover.outerWidth();p._fPopoverHeight=p._$popover.outerHeight();if(s===j.Left||s===j.Right){e=p._$parent.offset().top-p._$popover.offset().top-p._fPopoverBorderTop+p._fPopoverOffsetY+0.5*(m.outerHeight(p._$parent[0],false)-p._$arrow.outerHeight(false));e=Math.max(e,this._arrowOffsetThreshold);e=Math.min(e,p._fPopoverHeight-this._arrowOffsetThreshold-p._$arrow.outerHeight());return{"top":e};}else if(s===j.Top||s===j.Bottom){if(r){e=p._$popover.offset().left+m.outerWidth(p._$popover[0],false)-(p._$parent.offset().left+m.outerWidth(p._$parent[0],false))+p._fPopoverBorderRight+p._fPopoverOffsetX+0.5*(m.outerWidth(p._$parent[0],false)-p._$arrow.outerWidth(false));e=Math.max(e,this._arrowOffsetThreshold);e=Math.min(e,p._fPopoverWidth-this._arrowOffsetThreshold-p._$arrow.outerWidth(false));return{"right":e};}else{e=p._$parent.offset().left-p._$popover.offset().left-p._fPopoverBorderLeft+p._fPopoverOffsetX+0.5*(m.outerWidth(p._$parent[0],false)-p._$arrow.outerWidth(false));e=Math.max(e,this._arrowOffsetThreshold);e=Math.min(e,p._fPopoverWidth-this._arrowOffsetThreshold-p._$arrow.outerWidth(false));return{"left":e};}}};m.prototype._getArrowPositionCssClass=function(s){switch(s){case j.Left:return"sapMPopoverArrRight";case j.Right:return"sapMPopoverArrLeft";case j.Top:return"sapMPopoverArrDown";case j.Bottom:return"sapMPopoverArrUp";}};m.prototype._getArrowStyleCssClass=function(p){var A=p._$arrow.position(),F=p._$footer.position(),n=this._getSingleNavContent(),o=this._getSinglePageContent(),e=0;if(n||o){o=o||n.getCurrentPage();if(o){e=o._getAnyHeader().$().outerHeight();}}if((A.top+p._fArrowHeight)<(p._fHeaderHeight+p._fSubHeaderHeight)||((A.top+p._fArrowHeight)<e)){return"sapMPopoverHeaderAlignArr";}else if((A.top<(p._fHeaderHeight+p._fSubHeaderHeight))||(A.top<e)||(p._$footer.length&&((A.top+p._fArrowHeight)>F.top)&&(A.top<F.top))){return"sapMPopoverCrossArr";}else if(p._$footer.length&&(A.top>F.top)){return"sapMPopoverFooterAlignArr";}};m.prototype._getCalculatedPlacement=function(){return this._oCalcedPos||this.getPlacement();};m.prototype._adjustPositionAndArrow=function(){var e=this.oPopup.getOpenState();if(!(e===O.OPEN||e===O.OPENING)){return;}this._beforeAdjustPositionAndArrowHook();var $=this.$(),n=this.$("arrow"),o=this.$("cont"),p=this.$("scroll"),s=this._getCalculatedPlacement(),r=this._getPositionParams($,n,o,p);r=this._recalculateMargins(s,r);var t=this._getPopoverPositionCss(r),u=this._getContentDimensionsCss(r),H=this._isHorizontalScrollbarNeeded(r);$.css(t);o.css(u);if(H){p.css("display","block");}if(this.getShowArrow()){var A=this._getArrowOffsetCss(s,r),v=this._getArrowPositionCssClass(s),w,U;n.removeAttr("style");n.css(A);n.addClass(v);if(s===j.Top&&r._$footer&&r._$footer.length){U=true;}if(s===j.Left||s===j.Right){w=this._getArrowStyleCssClass(r);if(w){n.addClass(w);if(w==="sapMPopoverFooterAlignArr"){U=true;}}}if(U){n.addClass("sapContrast sapContrastPlus");}$.css("overflow","visible");}this._afterAdjustPositionAndArrowHook();};m.prototype._adaptPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=18;this._offsets=["0 -18","18 0","0 18","-18 0"];if(this._bUseCompactArrow){this._arrowOffset=9;this._offsets=["0 -9","9 0","0 9","-9 0"];}this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"];}};m.prototype._afterAdjustPositionAndArrowHook=function(){};m.prototype._beforeAdjustPositionAndArrowHook=function(){};m.prototype._isPopupElement=function(o){var p=this._getOpenByDomRef();return!!(q(o).closest(sap.ui.getCore().getStaticAreaRef()).length)||!!(q(o).closest(p).length);};m.prototype._getAnyHeader=function(){if(this.getCustomHeader()){return this.getCustomHeader();}else{if(this.getShowHeader()){this._createInternalHeader();return this._internalHeader;}}};m.prototype._createInternalHeader=function(){if(!this._internalHeader){var t=this;this._internalHeader=new B(this.getId()+"-intHeader",{titleAlignment:this.getTitleAlignment()});this.setAggregation("_internalHeader",this._internalHeader);this._internalHeader.addEventDelegate({onAfterRendering:function(){t._restoreFocus();}});return true;}else{return false;}};m.prototype._animation=function(A,r){var t=null;var e=function(){r.off("webkitTransitionEnd transitionend");clearTimeout(t);setTimeout(function(){A();});};r.on("webkitTransitionEnd transitionend",e);t=setTimeout(e,this._getAnimationDuration());};m.prototype._getAnimationDuration=function(){return 300;};m.prototype._openAnimation=function(r,e,o){var t=this;setTimeout(function(){r.css("display","block");t._includeScrollWidth();t._animation(function(){if(!t.oPopup||t.oPopup.getOpenState()!==O.OPENING){return;}o();},r);},D.browser.firefox?50:0);};m.prototype._closeAnimation=function(r,e,n){r.addClass("sapMPopoverTransparent");this._animation(function(){n();r.removeClass("sapMPopoverTransparent");},r);};m.prototype._getInitialFocusId=function(){return this.getInitialFocus()||this._getFirstVisibleButtonId()||this._getFirstFocusableContentElementId()||this.getId();};m.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),s="";if(o&&o.getVisible()&&o.getEnabled()){s=o.getId();}else if(e&&e.getVisible()&&e.getEnabled()){s=e.getId();}return s;};m.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};m.prototype._restoreFocus=function(){if(this.isOpen()){var F=this._getInitialFocusId(),o=sap.ui.getCore().byId(F),e=(F?window.document.getElementById(F):null);if(o&&o.getFocusDomRef()){o.getFocusDomRef().focus();}else if(!o&&e){e.focus();}}};m.prototype._registerContentResizeHandler=function(s){if(!this._sResizeListenerId){this._sResizeListenerId=d.register(s||this.getDomRef("scroll"),this._fnOrientationChange);}};m.prototype._deregisterContentResizeHandler=function(){if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}};m.prototype._storeScrollPosition=function(){var $=this.$("cont");if($.length>0){this._oScrollPosDesktop={x:$.scrollLeft(),y:$.scrollTop()};}};m.prototype._restoreScrollPosition=function(){if(!this._oScrollPosDesktop){return;}var $=this.$("cont");if($.length>0){$.scrollLeft(this._oScrollPosDesktop.x).scrollTop(this._oScrollPosDesktop.y);this._oScrollPosDesktop=null;}};m.prototype._repositionOffset=function(){var e=this.oPopup.getOpenState(),o,p;if(!(e===O.OPEN)){return this;}o=this.oPopup._oLastPosition;p=this._placements.indexOf(this.getPlacement());if(p===-1){return this;}if(p<4){o.offset=this._calcOffset(this._offsets[p]);this.oPopup._applyPosition(o);}else{this._calcPlacement();}return this;};m.prototype._getOpenByDomRef=function(){if(!this._oOpenBy){return null;}if(this._oOpenBy instanceof E){return(this._oOpenBy.getPopupAnchorDomRef&&this._oOpenBy.getPopupAnchorDomRef())||this._oOpenBy.getFocusDomRef();}else{return this._oOpenBy;}};m.prototype._getAccessibilityOptions=function(){var A,e={},H=this._getAnyHeader(),o=this.getCustomHeader();e.role="dialog";e.modal=this.getProperty("ariaModal");if(!this.getShowHeader()||!H||!H.getVisible()){return e;}var n=o?o.getId():this.getHeaderTitle().getId();A=Array.prototype.concat(n,this.getAssociation("ariaLabelledBy",[]));e.labelledby=A.join(' ');return e;};m.prototype._setHeaderTitle=function(){if(!this._headerTitle){this._headerTitle=new T(this.getId()+"-title",{text:this.getTitle(),level:"H2"});this._createInternalHeader();this._internalHeader.addContentMiddle(this._headerTitle);return;}if(this._headerTitle.getText()!==this.getTitle()){this._headerTitle.setText(this.getTitle());}};m.prototype.getHeaderTitle=function(){return this._headerTitle;};m.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._bVerticalFlip=false;this._bHorizontalFlip=false;var e=this._placements.indexOf(p);if(e<=3){this._oCalcedPos=p;}return this;};m.prototype.setBeginButton=function(o){var e=this.getBeginButton();if(e===o){return this;}this._createInternalHeader();this._beginButton=o;if(o){if(e){this._internalHeader.removeAggregation("contentLeft",e,true);}this._internalHeader.addAggregation("contentLeft",o);}else{this._internalHeader.removeContentLeft(e);}return this;};m.prototype.setEndButton=function(o){var e=this.getEndButton();if(e===o){return this;}this._createInternalHeader();this._endButton=o;if(o){if(e){this._internalHeader.removeAggregation("contentRight",e,true);}this._internalHeader.insertAggregation("contentRight",o,1,true);this._internalHeader.invalidate();}else{this._internalHeader.removeContentRight(e);}return this;};m.prototype.setLeftButton=function(v){if(!(v instanceof a)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};m.prototype.setRightButton=function(v){if(!(v instanceof a)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};m.prototype.setModal=function(M,s){if(M===this.getModal()){return this;}this.oPopup.setModal(M,("sapMPopoverBLayer "+(s||"")).trim());this.setProperty("modal",M,true);return this;};m.prototype.setEnableScrolling=function(v){this.setHorizontalScrolling(v);this.setVerticalScrolling(v);this.setProperty("enableScrolling",v);return this;};m.prototype._setAriaModal=function(v){return this.setProperty("ariaModal",v);};m.prototype.getScrollDelegate=function(){return this._oScroller;};m.prototype._setAriaRoleApplication=function(v){return this.setProperty("ariaRoleApplication",v);};m.prototype.setAggregation=function(A,o,s){if(A==="beginButton"||A==="endButton"){var F="set"+A.charAt(0).toUpperCase()+A.slice(1);return this[F](o);}else{return C.prototype.setAggregation.apply(this,arguments);}};m.prototype.getAggregation=function(A,o){if(A==="beginButton"||A==="endButton"){var s=this["_"+A];return s||o||null;}else{return C.prototype.getAggregation.apply(this,arguments);}};m.prototype.destroyAggregation=function(A,s){var o=q(document.activeElement).control(0);if(A==="beginButton"||A==="endButton"){var e=this["_"+A];if(e){e.destroy();this["_"+A]=null;}}else{C.prototype.destroyAggregation.apply(this,arguments);}o&&o.getDomRef()?o.focus():this.focus();return this;};m.prototype.invalidate=function(o){if(this.isOpen()){C.prototype.invalidate.apply(this,arguments);}return this;};m.prototype.addAggregation=function(A,o,s){if(A==="content"){this._bContentChanged=true;}C.prototype.addAggregation.apply(this,arguments);};m.prototype._getAllContent=function(){return this.getContent();};m.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};return m;});
