/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./SinglePlanningCalendarUtilities','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/Locale','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/date/UniversalDate','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/unified/library','sap/ui/unified/CalendarAppointment','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateTypeRange','sap/ui/events/KeyCodes','./SinglePlanningCalendarGridRenderer','sap/ui/core/delegate/ItemNavigation',"sap/ui/thirdparty/jquery",'./PlanningCalendarLegend'],function(S,C,L,a,I,D,U,b,c,d,u,e,f,g,h,k,K,l,m,q,P){"use strict";var R=4.3125,n=3,B=2.125,o=1.5625,H=3600000/2,O=60*1000,p=0.4375,F=0,r=24;var s=C.extend("sap.m.SinglePlanningCalendarGrid",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},startHour:{type:"int",group:"Data",defaultValue:0},endHour:{type:"int",group:"Data",defaultValue:24},fullDay:{type:"boolean",group:"Data",defaultValue:true},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsResize:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsCreate:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",dnd:{draggable:true}},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},_columnHeaders:{type:"sap.ui.unified.calendar.DatesRow",multiple:false,visibility:"hidden"},_intervalPlaceholders:{type:"sap.m.SinglePlanningCalendarGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}},_blockersPlaceholders:{type:"sap.m.SinglePlanningCalendarGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true,associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.m.PlanningCalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"}}},appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},copy:{type:"boolean"}}},appointmentResize:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"}}},appointmentCreate:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},cellPress:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}}}}});s.prototype.init=function(){var i=new Date(),j=new f(this.getId()+"-columnHeaders",{showDayNamesLine:false,showWeekNumbers:false,startDate:i}).addStyleClass("sapMSinglePCColumnHeader"),w=(60-i.getSeconds())*1000,T=this._getCoreLocaleData().getTimePattern("medium");j._setAriaRole("columnheader");this.setAggregation("_columnHeaders",j);this.setStartDate(i);this._setColumns(7);this._configureBlockersDragAndDrop();this._configureAppointmentsDragAndDrop();this._configureAppointmentsResize();this._configureAppointmentsCreate();this._oUnifiedRB=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatStartEndInfoAria=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+T});this._oFormatAriaFullDayCell=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY"});this._sLegendId=undefined;setTimeout(this._updateRowHeaderAndNowMarker.bind(this),w);};s.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};s.prototype.onBeforeRendering=function(){var A=this._createAppointmentsMap(this.getAppointments()),i=this.getStartDate(),j=g.fromLocalJSDate(i),w=this._getColumns();this._oVisibleAppointments=this._calculateVisibleAppointments(A.appointments,this.getStartDate(),w);this._oAppointmentsToRender=this._calculateAppointmentsLevelsAndWidth(this._oVisibleAppointments);this._aVisibleBlockers=this._calculateVisibleBlockers(A.blockers,j,w);this._oBlockersToRender=this._calculateBlockersLevelsAndWidth(this._aVisibleBlockers);if(this._iOldColumns!==w||this._oOldStartDate!==i){this._createBlockersDndPlaceholders(i,w);this._createAppointmentsDndPlaceholders(i,w);}};s.prototype.onmousedown=function(E){var i=E.target.classList;this._isResizeHandleBottomMouseDownTarget=i.contains("sapMSinglePCAppResizeHandleBottom");this._isResizeHandleTopMouseDownTarget=i.contains("sapMSinglePCAppResizeHandleTop");};s.prototype._isResizingPerformed=function(){return this._isResizeHandleBottomMouseDownTarget||this._isResizeHandleTopMouseDownTarget;};s.prototype._configureBlockersDragAndDrop=function(){this.addDragDropConfig(new d({sourceAggregation:"appointments",targetAggregation:"_blockersPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsDragAndDrop()){E.preventDefault();return false;}var i=function(){var $=q(".sapMSinglePCOverlay");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");});q(document).one("dragend",function(){$.removeClass("sapMSinglePCOverlayDragging");});};i();}.bind(this),dragEnter:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),j=i.getDropControl(),w=this.isAllDayAppointment(A.getStartDate(),A.getEndDate()),x=function(){var $=q(i.getIndicator()),y=A.$().outerHeight(),z=A.$().outerWidth(),G=j.$().closest(".sapMSinglePCBlockersColumns").get(0).getBoundingClientRect(),J=j.getDomRef().getBoundingClientRect(),M=(J.left+z)-(G.left+G.width);if(w){$.css("min-height",y);$.css("min-width",Math.min(z,z-M));}else{$.css("min-height",i.getDropControl().$().outerHeight());$.css("min-width",i.getDropControl().$().outerWidth());}};if(!i.getIndicator()){setTimeout(x,0);}else{x();}}.bind(this),drop:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),j=i.getDropControl(),w=j.getDate().getJSDate(),x,y=E.getParameter("browserEvent"),z=(y.metaKey||y.ctrlKey),G=this.isAllDayAppointment(A.getStartDate(),A.getEndDate());x=new Date(w);if(G){x.setMilliseconds(A.getEndDate().getTime()-A.getStartDate().getTime());}this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(G&&A.getStartDate().getTime()===w.getTime()){return;}this.fireAppointmentDrop({appointment:A,startDate:w,endDate:x,copy:z});}.bind(this)}));};s.prototype._configureAppointmentsDragAndDrop=function(){this.addDragDropConfig(new d({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsDragAndDrop()||this._isResizingPerformed()){E.preventDefault();return false;}var i=function(){var $=q(".sapMSinglePCOverlay");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");});q(document).one("dragend",function(){$.removeClass("sapMSinglePCOverlayDragging");});};i();}.bind(this),dragEnter:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),j=i.getDropControl(),w=this.isAllDayAppointment(A.getStartDate(),A.getEndDate()),x=function(){var $=q(i.getIndicator()),y=A.$().outerHeight(),G=j.$().closest(".sapMSinglePCColumn").get(0).getBoundingClientRect(),z=i.getDropControl().getDomRef().getBoundingClientRect(),J=(z.top+y)-(G.top+G.height);if(w){$.css("min-height",2*i.getDropControl().$().outerHeight());}else{$.css("min-height",Math.min(y,y-J));}};if(!i.getIndicator()){setTimeout(x,0);}else{x();}}.bind(this),drop:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),j=i.getDropControl(),w=j.getDate().getJSDate(),x,y=E.getParameter("browserEvent"),z=(y.metaKey||y.ctrlKey),G=this.isAllDayAppointment(A.getStartDate(),A.getEndDate());x=new Date(w);if(G){x.setHours(x.getHours()+1);}else{x.setMilliseconds(A.getEndDate().getTime()-A.getStartDate().getTime());}this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(!G&&A.getStartDate().getTime()===w.getTime()){return;}this.fireAppointmentDrop({appointment:A,startDate:w,endDate:x,copy:z});}.bind(this)}));};s.prototype._configureAppointmentsResize=function(){var i=new d({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsResize()||!this._isResizingPerformed()){E.preventDefault();return;}var j=E.getParameter("dragSession"),w=j.getDragControl(),x=E.getParameter("browserEvent")&&E.getParameter("browserEvent").target||null;w._sAppointmentPartSuffix=x&&x.id?x.id.replace(w.getId()+"-",""):"";var $=this.$().find(".sapMSinglePCOverlay"),y=q(j.getIndicator()),z=w.$();if(this._isResizeHandleBottomMouseDownTarget){j.setComplexData("bottomHandle","true");}if(this._isResizeHandleTopMouseDownTarget){j.setComplexData("topHandle","true");}y.addClass("sapUiDnDIndicatorHide");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");},0);q(document).one("dragend",function(){var A=j.getComplexData("appointmentStartingBoundaries");$.removeClass("sapMSinglePCOverlayDragging");y.removeClass("sapUiDnDIndicatorHide");z.css({top:A.top,height:A.height,"z-index":"auto",opacity:1});});E.getParameter("browserEvent").dataTransfer.setDragImage(t(),0,0);}.bind(this),dragEnter:function(E){var j=E.getParameter("dragSession"),A=j.getDragControl().$().get(0),w=j.getDropControl().getDomRef(),x=j.getComplexData("appointmentStartingBoundaries"),y=function(){var $=q(j.getIndicator());$.addClass("sapUiDnDIndicatorHide");},T,z,G,V,J;if(!x){x={top:A.offsetTop,bottom:A.offsetTop+A.getBoundingClientRect().height,height:A.getBoundingClientRect().height};j.setComplexData("appointmentStartingBoundaries",x);}V=j.getData("bottomHandle")?x.top:x.bottom;T=Math.min(V,w.offsetTop);z=Math.max(V,w.offsetTop+w.getBoundingClientRect().height);G=z-T;J={top:T,height:G,"z-index":1,opacity:0.8};j.getDragControl().$().css(J);if(!j.getIndicator()){setTimeout(y,0);}else{y();}},drop:function(E){var j=E.getParameter("dragSession"),A=j.getDragControl(),w=this.indexOfAggregation("_intervalPlaceholders",j.getDropControl()),x=j.getComplexData("appointmentStartingBoundaries"),y;y=this._calcResizeNewHoursAppPos(A.getStartDate(),A.getEndDate(),w,j.getComplexData("bottomHandle"));this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");q(j.getIndicator()).removeClass("sapUiDnDIndicatorHide");A.$().css({top:x.top,height:x.height,"z-index":"auto",opacity:1});if(A.getEndDate().getTime()===y.endDate.getTime()&&A.getStartDate().getTime()===y.startDate.getTime()){return;}this.fireAppointmentResize({appointment:A,startDate:y.startDate,endDate:y.endDate});}.bind(this)});this.addDragDropConfig(i);};s.prototype._configureAppointmentsCreate=function(){this.addDragDropConfig(new d({targetAggregation:"_intervalPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsCreate()){E.preventDefault();return;}var i=E.getParameter("browserEvent");var $=this.$().find(".sapMSinglePCOverlay");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");});q(document).one("dragend",function(){$.removeClass("sapMSinglePCOverlayDragging");q(".sapUiAppCreate").remove();q(".sapUiDnDDragging").removeClass("sapUiDnDDragging");});i.dataTransfer.setDragImage(t(),0,0);var G=E.getParameter("target"),j=G.getAggregation("_intervalPlaceholders"),w=j[0].getDomRef().getBoundingClientRect(),x=w.height,y=Math.floor((w.top-G.getDomRef().getBoundingClientRect().top)/x),z=E.getParameter("dragSession"),A=Math.floor(i.offsetY/x)-y,J,M;if(this._iColumns===1){J=A;}else{var N=64,Q=2,T=Math.floor(j[0].getDomRef().getBoundingClientRect().width)-Q,V=Math.floor(Math.floor((i.offsetX-N))/T),W=j.length/this._iColumns;J=A+((V)*W);}if(J<0){J=0;}M=j[J].getDomRef().getBoundingClientRect();z.setComplexData("startingRectsDropArea",{top:Math.ceil(A*x),left:M.left});z.setComplexData("startingDropDate",j[J].getDate());}.bind(this),dragEnter:function(E){var i=E.getParameter("dragSession"),j=i.getDropControl(),w=j.getDomRef(),x=w.offsetHeight,y=w.offsetTop,z=y,A=w.getBoundingClientRect().left,G=A,J=j.$().parents(".sapMSinglePCColumn").get(0),$=q(".sapUiAppCreate");if(!$.get(0)){$=q("<div></div>").addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");$.appendTo(J);}q(".sapUiDnDDragging").removeClass("sapUiDnDDragging");if(!i.getComplexData("startingRectsDropArea")){i.setComplexData("startingRectsDropArea",{top:y,left:A});i.setComplexData("startingDropDate",j.getDate());}else{z=i.getComplexData("startingRectsDropArea").top;G=i.getComplexData("startingRectsDropArea").left;}if(A!==G){E.preventDefault();return false;}j.$().closest(".sapMSinglePCColumn").find(".sapMSinglePCAppointments").addClass("sapUiDnDDragging");$.css({top:Math.min(z,y)+2,height:Math.abs(z-y)+x-4,left:3,right:3,"z-index":2});i.setIndicatorConfig({display:"none"});},drop:function(E){var i=E.getParameter("dragSession"),j=i.getDropControl(),T=30*60*1000,w=i.getComplexData("startingDropDate").getTime(),x=j.getDate().getJSDate().getTime(),y=Math.min(w,x),z=Math.max(w,x)+T;this.fireAppointmentCreate({startDate:new Date(y),endDate:new Date(z)});q(".sapUiAppCreate").remove();q(".sapUiDnDDragging").removeClass("sapUiDnDDragging");}.bind(this)}));};s.prototype._calcResizeNewHoursAppPos=function(A,i,j,w){var M=30*60*1000,x=this.getAggregation("_intervalPlaceholders")[j].getDate().getTime(),y=x+M,V=w?A.getTime():i.getTime(),z=Math.min(V,x),E=Math.max(V,y);return{startDate:new Date(z),endDate:new Date(E)};};s.prototype._adjustAppointmentsHeightforCompact=function(i,j,w,x){var A,y,z,E,G,J,M,N,Q=this._getRowHeight(),T=0;if(this._oAppointmentsToRender[i]){this._oAppointmentsToRender[i].oAppointmentsList.getIterator().forEach(function(V){A=V.getData();y=this.getDomRef().querySelector("#"+A.getId()+"-"+x+"_"+T);z=A.getStartDate();E=A.getEndDate();M=j.getTime()>z.getTime();N=w.getTime()<E.getTime();G=M?0:this._calculateTopPosition(z);J=N?0:this._calculateBottomPosition(E);y.style["top"]=G+"rem";y.style["bottom"]=J+"rem";y.querySelector(".sapUiCalendarApp").style["minHeight"]=(Q/2-0.1875)+"rem";++T;}.bind(this));}};s.prototype._adjustBlockersHeightforCompact=function(){var M=this._getBlockersToRender().iMaxlevel,i=(M+1)*this._getBlockerRowHeight(),j=this._getColumns()===1?i+p:i,w=this._getBlockerRowHeight();if(M>0){j=j+0.1875;}this.$().find(".sapMSinglePCBlockersColumns").css("height",j+"rem");this._oBlockersToRender.oBlockersList.getIterator().forEach(function(x){x.getData().$().css("top",(w*x.level+0.0625)+"rem");});};s.prototype._adjustBlockersHeightforCozy=function(){var M=this._getBlockersToRender()&&this._getBlockersToRender().iMaxlevel,i;if(this._getColumns()===1){i=(M+1)*this._getBlockerRowHeight();this.$().find(".sapMSinglePCBlockersColumns").css("height",(i+p)+"rem");}};s.prototype.onAfterRendering=function(){var j=this._getColumns(),w=this.getStartDate(),x=this._getRowHeight();if(x===n){for(var i=0;i<j;i++){var y=new g(w.getFullYear(),w.getMonth(),w.getDate()+i),z=this._getDateFormatter().format(y.toLocalJSDate()),A=new U(y.getYear(),y.getMonth(),y.getDate(),this._getVisibleStartHour()),E=new U(y.getYear(),y.getMonth(),y.getDate(),this._getVisibleEndHour(),59,59);this._adjustAppointmentsHeightforCompact(z,A,E,i);}this._adjustBlockersHeightforCompact();}else{this._adjustBlockersHeightforCozy();}this._updateRowHeaderAndNowMarker();_.call(this);};s.prototype._appFocusHandler=function(E,i){var T=sap.ui.getCore().byId(E.target.id)||this._findSrcControl(E);if(T&&T.isA("sap.ui.unified.CalendarAppointment")){this.fireAppointmentSelect({appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)});this._focusCellWithKeyboard(T,i);E.preventDefault();}};s.prototype._cellFocusHandler=function(E,i){var G=E.target,j=this._getDateFormatter(),w;if(G.classList.contains("sapMSinglePCRow")||G.classList.contains("sapMSinglePCBlockersColumn")){w=j.parse(G.getAttribute("data-sap-start-date"));if(this._isBorderReached(w,i)){this.fireEvent("borderReached",{startDate:w,next:i===K.ARROW_RIGHT,fullDay:G.classList.contains("sapMSinglePCBlockersColumn")});}}};s.prototype.onsapup=function(E){this._appFocusHandler(E,K.ARROW_UP);};s.prototype.onsapdown=function(E){this._appFocusHandler(E,K.ARROW_DOWN);};s.prototype.onsapright=function(E){this._appFocusHandler(E,K.ARROW_RIGHT);this._cellFocusHandler(E,K.ARROW_RIGHT);};s.prototype.onsapleft=function(E){this._appFocusHandler(E,K.ARROW_LEFT);this._cellFocusHandler(E,K.ARROW_LEFT);};s.prototype.setStartDate=function(i){this._oOldStartDate=this.getStartDate();this.getAggregation("_columnHeaders").setStartDate(i);return this.setProperty("startDate",i);};s.prototype.applyFocusInfo=function(w){var V=this._getVisibleBlockers(),x=this._getVisibleAppointments(),y=Object.keys(x),z,i,j;if(this._sSelectedAppointment){this._sSelectedAppointment.focus();return this;}for(i=0;i<V.length;++i){if(V[i].getId()===w.id){V[i].focus();return this;}}for(i=0;i<y.length;++i){z=x[y[i]];for(j=0;j<z.length;++j){if(z[j].getId()===w.id){z[j].focus();return this;}}}return this;};s.prototype.getSelectedAppointments=function(){return this.getAppointments().filter(function(A){return A.getSelected();});};s.prototype._toggleAppointmentSelection=function(A,j){var w=[],x=A&&A.getDomRef(),y,z,i;if(j){y=this.getAppointments();for(i=0,z=y.length;i<z;i++){if((!A||y[i].getId()!==A.getId())&&y[i].getSelected()){y[i].setProperty("selected",false);w.push(y[i]);}}}if(A){A.setProperty("selected",!A.getSelected());w.push(A);this._sSelectedAppointment=A.getSelected()&&x?A:undefined;}else{this._sSelectedAppointment=undefined;}return w;};s.prototype._isBorderReached=function(i,j){var G=g.fromLocalJSDate(this.getStartDate()),w=new g(G.getYear(),G.getMonth(),G.getDate()+this._getColumns()-1),T=g.fromLocalJSDate(i),x=j===K.ARROW_LEFT&&T.isSame(G),y=j===K.ARROW_RIGHT&&T.isSame(w);return x||y;};s.prototype._focusCellWithKeyboard=function(A,i){var j=this.isAllDayAppointment(A.getStartDate(),A.getEndDate()),w=this._getDateFormatter(),x=new Date(A.getStartDate().getFullYear(),A.getStartDate().getMonth(),A.getStartDate().getDate(),A.getStartDate().getHours()),G=new Date(this.getStartDate().getFullYear(),this.getStartDate().getMonth(),this.getStartDate().getDate(),this.getStartDate().getHours());if(x<G){x=G;}if(this._isBorderReached(x,i)){this.fireEvent("borderReached",{startDate:x,next:i===K.ARROW_RIGHT,fullDay:j});return;}switch(i){case K.ARROW_UP:if(!j){x.setHours(x.getHours()-1);}break;case K.ARROW_DOWN:if(!j){x.setHours(x.getHours()+1);}break;case K.ARROW_LEFT:x.setDate(x.getDate()-1);break;case K.ARROW_RIGHT:x.setDate(x.getDate()+1);break;default:}if(j&&i!==K.ARROW_DOWN){q("[data-sap-start-date='"+w.format(x)+"'].sapMSinglePCBlockersColumn").trigger("focus");}else{q("[data-sap-start-date='"+w.format(x)+"'].sapMSinglePCRow").trigger("focus");}};s.prototype.ontap=function(E){this._fireSelectionEvent(E);};s.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this._fireSelectionEvent(E);E.preventDefault();}};s.prototype._findSrcControl=function(E){var $=E.target,i=$.parentElement,A;if(!i){return E.srcControl;}else if(i.classList.contains("sapUiCalendarRowApps")){A=i.getAttribute("data-sap-ui-related");}else{A=$.getAttribute("data-sap-ui-related");}return this.getAppointments().find(function(j){return j.sId===A;});};s.prototype._fireSelectionEvent=function(E){var i=this._findSrcControl(E),G=E.target;if(E.target.classList.contains("sapMSinglePCRow")||E.target.classList.contains("sapMSinglePCBlockersColumn")){this.fireEvent("cellPress",{startDate:this._getDateFormatter().parse(G.getAttribute("data-sap-start-date")),endDate:this._getDateFormatter().parse(G.getAttribute("data-sap-end-date"))});this.fireAppointmentSelect({appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)});}else if(i&&i.isA("sap.ui.unified.CalendarAppointment")){if(G.parentElement&&G.parentElement.getAttribute("id")){var T=G.parentElement.getAttribute("id");var j=G.parentElement.getAttribute("data-sap-ui-related");var w=T.replace(j+"-","");i._setAppointmentPartSuffix(w);}this.fireAppointmentSelect({appointment:i,appointments:this._toggleAppointmentSelection(i,!(E.ctrlKey||E.metaKey))});}};s.prototype._getVisibleStartHour=function(){return(this.getFullDay()||!this.getStartHour())?F:this.getStartHour();};s.prototype._getVisibleEndHour=function(){return((this.getFullDay()||!this.getEndHour())?r:this.getEndHour())-1;};s.prototype._isVisibleHour=function(i){var j=this.getStartHour(),E=this.getEndHour();if(!this.getStartHour()){j=F;}if(!this.getEndHour()){E=r;}if(j>E){return j<=i||i<E;}return j<=i&&i<E;};s.prototype._shouldHideRowHeader=function(i){var j=new Date().getHours(),w=h._areCurrentMinutesLessThan(15)&&j===i,x=h._areCurrentMinutesMoreThan(45)&&j===i-1;return w||x;};s.prototype._parseDateStringAndHours=function(i,j){var w=this._getDateFormatter().parse(i);if(j){w.setHours(j);}return w;};s.prototype._getDateFormatter=function(){if(!(this._oDateFormat instanceof D)){this._oDateFormat=D.getDateTimeInstance({pattern:"YYYYMMdd-HHmm"});}return this._oDateFormat;};s.prototype._formatTimeAsString=function(i){var j=this._getHoursPattern()+":mm",w=D.getDateTimeInstance({pattern:j},new a(this._getCoreLocaleId()));return w.format(i);};s.prototype._addAMPM=function(i){var A=this._getAMPMFormat();return" "+A.format(i);};s.prototype._calculateTopPosition=function(i){var j=i.getHours()-this._getVisibleStartHour(),M=i.getMinutes(),w=this._getRowHeight();return(w*j)+(w/60)*M;};s.prototype._calculateBottomPosition=function(i){var j=this._getVisibleEndHour()+1-i.getHours(),M=i.getMinutes(),w=this._getRowHeight();return(w*j)-(w/60)*M;};s.prototype._updateRowHeaderAndNowMarker=function(){var i=new Date();this._updateNowMarker(i);this._updateRowHeaders(i);setTimeout(this._updateRowHeaderAndNowMarker.bind(this),O);};s.prototype._updateNowMarker=function(i){var $=this.$("nowMarker"),j=this.$("nowMarkerText"),w=this.$("nowMarkerAMPM"),x=!this._isVisibleHour(i.getHours());$.toggleClass("sapMSinglePCNowMarkerHidden",x);$.css("top",this._calculateTopPosition(i)+"rem");j.text(this._formatTimeAsString(i));w.text(this._addAMPM(i));j.append(w);};s.prototype._updateRowHeaders=function(i){var $=this.$(),j=i.getHours(),N=j+1;$.find(".sapMSinglePCRowHeader").removeClass("sapMSinglePCRowHeaderHidden");if(this._shouldHideRowHeader(j)){$.find(".sapMSinglePCRowHeader"+j).addClass("sapMSinglePCRowHeaderHidden");}else if(this._shouldHideRowHeader(N)){$.find(".sapMSinglePCRowHeader"+N).addClass("sapMSinglePCRowHeaderHidden");}};s.prototype._createAppointmentsMap=function(A){var i=this;return A.reduce(function(M,j){var w=j.getStartDate(),x=j.getEndDate(),y,z,E;if(!w||!x){return M;}if(!i.isAllDayAppointment(w,x)){y=g.fromLocalJSDate(w);z=g.fromLocalJSDate(x);while(y.isSameOrBefore(z)){E=i._getDateFormatter().format(y.toLocalJSDate());if(!M.appointments[E]){M.appointments[E]=[];}M.appointments[E].push(j);y.setDate(y.getDate()+1);}}else{M.blockers.push(j);}return M;},{appointments:{},blockers:[]});};s.prototype._calculateVisibleAppointments=function(A,j,w){var V={},x,y,z;for(var i=0;i<w;i++){x=new g(j.getFullYear(),j.getMonth(),j.getDate()+i);y=this._getDateFormatter().format(x.toLocalJSDate());z=this._isAppointmentFitInVisibleHours(x);if(A[y]){V[y]=A[y].filter(z,this).sort(this._sortAppointmentsByStartHourCallBack);}}return V;};s.prototype._isAppointmentFitInVisibleHours=function(i){return function(A){var j=A.getStartDate().getTime(),w=A.getEndDate().getTime(),x=(new U(i.getYear(),i.getMonth(),i.getDate(),this._getVisibleStartHour())).getTime(),y=(new U(i.getYear(),i.getMonth(),i.getDate(),this._getVisibleEndHour(),59,59)).getTime();var z=j<x&&w>y,E=j>=x&&j<y,G=w>x&&w<=y;return z||E||G;};};s.prototype._calculateAppointmentsLevelsAndWidth=function(V){var i=this;return Object.keys(V).reduce(function(A,j){var M=0,w=new S.list(),x=V[j];x.forEach(function(y){var z=new S.node(y),E=y.getStartDate().getTime();if(w.getSize()===0){w.add(z);return;}w.getIterator().forEach(function(G){var J=true,N=G.getData(),Q=N.getStartDate().getTime(),T=N.getEndDate().getTime(),W=T-Q;if(W<H){T=T+(H-W);}if(E>=Q&&E<T){z.level++;M=Math.max(M,z.level);}if(G.next&&G.next.level===z.level){J=false;}if(E>=T&&J){this.interrupt();}});w.insertAfterLevel(z.level,z);});A[j]={oAppointmentsList:i._calculateAppointmentsWidth(w),iMaxLevel:M};return A;},{});};s.prototype._calculateAppointmentsWidth=function(A){A.getIterator().forEach(function(i){var j=i.getData(),w=i.level,x=i.level,y=j.getStartDate().getTime(),z=j.getEndDate().getTime(),E=z-y;if(E<H){z=z+(H-E);}new S.iterator(A).forEach(function(G){var J=G.getData(),M=G.level,N=J.getStartDate().getTime(),Q=J.getEndDate().getTime(),T=Q-N;if(T<H){Q=Q+(H-T);}if(x>=M){return;}if(y>=N&&y<Q||z>N&&z<Q||y<=N&&z>=Q){i.width=M-x;this.interrupt();return;}if(w<M){w=M;i.width++;}});});return A;};s.prototype._calculateVisibleBlockers=function(i,j,w){var x=new g(j.getYear(),j.getMonth(),j.getDate()+w-1),y=this._isBlockerVisible(j,x);return i.filter(y).sort(this._sortAppointmentsByStartHourCallBack);};s.prototype._isBlockerVisible=function(V,i){return function(A){var j=g.fromLocalJSDate(A.getStartDate()),w=g.fromLocalJSDate(A.getEndDate());var x=j.isBefore(V)&&w.isAfter(i),y=h._isBetween(j,V,i,true),E=h._isBetween(w,V,i,true);return x||y||E;};};s.prototype._calculateBlockersLevelsAndWidth=function(V){var M=0,i=new S.list();V.forEach(function(j){var w=new S.node(j),x=g.fromLocalJSDate(j.getStartDate()),y=g.fromLocalJSDate(j.getEndDate());w.width=h._daysBetween(y,x);if(i.getSize()===0){i.add(w);return;}i.getIterator().forEach(function(z){var A=true,E=z.getData(),G=g.fromLocalJSDate(E.getStartDate()),J=g.fromLocalJSDate(E.getEndDate());if(x.isSameOrAfter(G)&&x.isSameOrBefore(J)){w.level++;M=Math.max(M,w.level);}if(z.next&&z.next.level===w.level){A=false;}if(x.isSameOrAfter(J)&&A){this.interrupt();}});i.insertAfterLevel(w.level,w);},this);return{oBlockersList:i,iMaxlevel:M};};s.prototype._sortAppointmentsByStartHourCallBack=function(A,i){return A.getStartDate().getTime()-i.getStartDate().getTime()||i.getEndDate().getTime()-A.getEndDate().getTime();};s.prototype._getVisibleAppointments=function(){return this._oVisibleAppointments;};s.prototype._getAppointmentsToRender=function(){return this._oAppointmentsToRender;};s.prototype._getVisibleBlockers=function(){return this._aVisibleBlockers;};s.prototype._getBlockersToRender=function(){return this._oBlockersToRender;};s.prototype._setColumns=function(i){this._iOldColumns=this._iColumns;this._iColumns=i;this.getAggregation("_columnHeaders").setDays(i);this.invalidate();return this;};s.prototype._getColumns=function(){return this._iColumns;};s.prototype._getRowHeight=function(){return this._isCompact()?n:R;};s.prototype._getBlockerRowHeight=function(){return this._isCompact()?o:B;};s.prototype._isCompact=function(){var i=this.getDomRef();while(i&&i.classList){if(i.classList.contains("sapUiSizeCompact")){return true;}i=i.parentNode;}return false;};s.prototype._getCoreLocaleId=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};s.prototype._getCoreLocaleData=function(){var i,j;if(!this._oLocaleData){i=this._getCoreLocaleId();j=new a(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;};s.prototype._hasAMPM=function(){var i=this._getCoreLocaleData();return i.getTimePattern("short").search("a")>=0;};s.prototype._getHoursFormat=function(){var i=this._getCoreLocaleId();if(!this._oHoursFormat||this._oHoursFormat.oLocale.toString()!==i){var j=new a(i),w=this._getHoursPattern();this._oHoursFormat=D.getTimeInstance({pattern:w},j);}return this._oHoursFormat;};s.prototype._getHoursPattern=function(){return this._hasAMPM()?"h":"H";};s.prototype._getAMPMFormat=function(){var i=this._getCoreLocaleId(),j=new a(i);if(!this._oAMPMFormat||this._oAMPMFormat.oLocale.toString()!==i){this._oAMPMFormat=D.getTimeInstance({pattern:"a"},j);}return this._oAMPMFormat;};s.prototype._getColumnHeaders=function(){return this.getAggregation("_columnHeaders");};s.prototype._getAppointmentAnnouncementInfo=function(A){var i=this._oUnifiedRB.getText("CALENDAR_START_TIME"),E=this._oUnifiedRB.getText("CALENDAR_END_TIME"),j=this._oFormatStartEndInfoAria.format(A.getStartDate()),w=this._oFormatStartEndInfoAria.format(A.getEndDate()),x=i+": "+j+"; "+E+": "+w;return x+"; "+P.findLegendItemForItem(sap.ui.getCore().byId(this._sLegendId),A);};s.prototype.enhanceAccessibilityState=function(i,A){if(i.getId()===this._getColumnHeaders().getId()){A.labelledby=I.getStaticId("sap.m","PLANNINGCALENDAR_DAYS");}};s.prototype._getCellStartEndInfo=function(i,E){var j=this._oUnifiedRB.getText("CALENDAR_START_TIME"),w=this._oUnifiedRB.getText("CALENDAR_END_TIME"),x=!E;if(x){return j+": "+this._oFormatAriaFullDayCell.format(i)+"; ";}return j+": "+this._oFormatStartEndInfoAria.format(i)+"; "+w+": "+this._oFormatStartEndInfoAria.format(E);};s.prototype.isAllDayAppointment=function(A,i){return h._isMidnight(A)&&h._isMidnight(i);};s.prototype._createBlockersDndPlaceholders=function(j,w){this.destroyAggregation("_blockersPlaceholders");for(var i=0;i<w;i++){var x=new U(j.getFullYear(),j.getMonth(),j.getDate()+i);var y=new v({date:x});this.addAggregation("_blockersPlaceholders",y,true);}};s.prototype._createAppointmentsDndPlaceholders=function(w,x){var y=this._getVisibleStartHour(),E=this._getVisibleEndHour();this._dndPlaceholdersMap={};this.destroyAggregation("_intervalPlaceholders");for(var i=0;i<x;i++){var z=new g(w.getFullYear(),w.getMonth(),w.getDate()+i);if(!this._dndPlaceholdersMap[z]){this._dndPlaceholdersMap[z]=[];}for(var j=y;j<=E;j++){var A=this._dndPlaceholdersMap[z],Y=z.getYear(),M=z.getMonth(),G=z.getDate();A.push(this._createAppointmentsDndPlaceHolder(new U(Y,M,G,j)));A.push(this._createAppointmentsDndPlaceHolder(new U(Y,M,G,j,30)));}}};s.prototype._createAppointmentsDndPlaceHolder=function(i){var j=new v({date:i});this.addAggregation("_intervalPlaceholders",j,true);return j;};s.prototype._getSpecialDates=function(){var j=this.getSpecialDates();for(var i=0;i<j.length;i++){var N=j[i].getSecondaryType()===u.CalendarDayType.NonWorking&&j[i].getType()!==u.CalendarDayType.NonWorking;if(N){var w=new k();w.setType(u.CalendarDayType.NonWorking);w.setStartDate(j[i].getStartDate());if(j[i].getEndDate()){w.setEndDate(j[i].getEndDate());}j.push(w);}}return j;};function t(){var $=q("<span></span>").addClass("sapUiCalAppResizeGhost");$.appendTo(document.body);setTimeout(function(){$.remove();},0);return $.get(0);}var v=C.extend("sap.m.SinglePlanningCalendarGrid._internal.IntervalPlaceholder",{metadata:{library:"sap.m",properties:{date:{type:"object",group:"Data"}}},renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j).class("sapMSinglePCPlaceholder").openEnd().close("div");}}});function _(){var i=this.getDomRef(),j=this.$().find(".sapMSinglePCBlockersColumn").toArray();this._aGridCells=Array.prototype.concat(j);for(var w=0;w<=this._getVisibleEndHour();++w){j=this.$().find("div[data-sap-hour='"+w+"']").toArray();this._aGridCells=this._aGridCells.concat(j);}if(!this._oItemNavigation){this._oItemNavigation=new m();this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(i);this._oItemNavigation.setItemDomRefs(this._aGridCells);this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});this._oItemNavigation.setTableMode(true,true).setColumns(this._getColumns());this._oItemNavigation.setPageSize(this._aGridCells.length);}return s;});
