/*!
* OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./library','./SliderUtilities','./SliderTooltipBase','sap/ui/core/Control','sap/ui/core/library','sap/ui/core/Core','./delegate/ValueStateMessage','sap/ui/core/ValueStateSupport',"sap/ui/core/InvisibleMessage",'./SliderTooltipRenderer'],function(L,S,a,C,c,b,V,d,I,e){"use strict";var f=c.ValueState;var g=c.InvisibleMessageMode;var h=a.extend("sap.m.SliderTooltip",{metadata:{library:"sap.m",properties:{value:{type:"float",group:"Data",defaultValue:0,bindable:"bindable"},min:{type:"float",group:"Data",defaultValue:0},max:{type:"float",group:"Data",defaultValue:100},editable:{type:"boolean",defaultValue:false},step:{type:"float",group:"Data",defaultValue:1},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:f.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"float"}}}}}});h.prototype.init=function(){this._oValueStateMessage=new V(this);this._fLastValidValue=0;};h.prototype.exit=function(){if(this.oInvisibleMessage){this.oInvisibleMessage.destroy();this.oInvisibleMessage=null;}};h.prototype.onBeforeRendering=function(){a.prototype.setValue.call(this,this.getValue());if(!this.oInvisibleMessage){this.oInvisibleMessage=I.getInstance();}};h.prototype.onAfterRendering=function(){var A=!this.getEditable()?"add":"remove";if(this.getDomRef()){this.getFocusDomRef().classList[A](S.CONSTANTS.TOOLTIP_CLASS+"NotEditable");}};h.prototype.getValueStateText=function(){return"";};h.prototype.getFocusDomRef=function(){return this.getDomRef("input");};h.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};h.prototype.sliderValueChanged=function(v){if(this.getDomRef()){this.getFocusDomRef().value=v;}this._fLastValidValue=v;this.setValueState(f.None);};h.prototype.setValueState=function(v){var D=this.getDomRef(),i=this.getFocusDomRef(),E,o;v=this.validateProperty("valueState",v);E=D&&(v===f.Error);o=D&&E;this.setProperty("valueState",v,true);this._oValueStateMessage[o?"open":"close"]();if(i){D.classList[E?"add":"remove"](S.CONSTANTS.TOOLTIP_CLASS+"ErrorState");i[E?"setAttribute":"removeAttribute"]("aria-invalid",E);i[o?"setAttribute":"removeAttribute"]("aria-errormessage",this.getId()+"-message");this._invisibleMessageAnnouncement(v);}return this;};h.prototype._invisibleMessageAnnouncement=function(v,o){if(v!==f.Error){return;}var r=b.getLibraryResourceBundle("sap.m"),s,i;s=r.getText("INPUTBASE_VALUE_STATE_"+v.toUpperCase());i=s+" "+d.getAdditionalText(this);this.oInvisibleMessage.announce(i,g.Assertive);this._bInvisibleMessageUpdated=true;};h.prototype.onfocusout=function(E){var v=parseFloat(this.getFocusDomRef().value);this._validateValue(v);if(this._bInvisibleMessageUpdated){document.getElementById(this.oInvisibleMessage.getId()+"-assertive").textContent="";this._bInvisibleMessageUpdated=false;}};h.prototype.onsapenter=function(E){var v=parseFloat(this.getFocusDomRef().value);this._validateValue(v);};h.prototype.onsapescape=function(E){this.sliderValueChanged(this._fLastValidValue);this.setValueState(f.None);};h.prototype._validateValue=function(v){if(this._isValueValid(v)){this.sliderValueChanged(v);this.fireChange({value:v});}else{this.setValueState(f.Error);}};h.prototype._isValueValid=function(v){return!(isNaN(v)||v<this.getMin()||v>this.getMax());};return h;});
